/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.links;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.sighting.Link;
import com.scythebill.birdlist.model.util.DirtyImpl;
import com.scythebill.birdlist.ui.components.ChipsTextPanel;
import com.scythebill.birdlist.ui.components.TextLink;
import com.scythebill.birdlist.ui.components.links.LinkDrops;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public abstract class LinksListPanel<L extends Link>
extends JPanel
implements FontManager.FontsUpdatedListener {
    protected final DirtyImpl dirty;
    private final FontManager fontManager;
    private final FileDialogs fileDialogs;
    private final LinkDropPanel dropPanel;
    private ChipsTextPanel<L> linkChipsPanel;
    private List<L> links = Lists.newArrayList();
    private JScrollPane linkChipsScrollPane;
    private final LinkClickedListener<L> linkClickedListener;

    public LinksListPanel(FontManager fontManager, FileDialogs fileDialogs, LinkClickedListener<L> linkClickedListener) {
        this.fontManager = fontManager;
        this.fileDialogs = fileDialogs;
        this.linkClickedListener = linkClickedListener;
        this.dirty = new DirtyImpl(false);
        this.dropPanel = new LinkDropPanel();
        this.dropPanel.addActionListener(e -> this.openFile());
        this.rebuildUI();
    }

    public void setLinks(List<L> links) {
        this.links = new ArrayList<L>(links.size());
        for (int i = 0; i < links.size(); ++i) {
            try {
                this.links.add(i, ((Link)links.get(i)).clone());
                continue;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.rebuildUI();
        this.fontManager.applyTo(this);
        this.dirty.setDirty(false);
    }

    public List<L> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.rebuildUI();
        if (this.fontManager != null) {
            this.fontManager.applyTo(this);
        }
    }

    protected List<L> beforeAddLinks(ImmutableList<L> newLinks) {
        return newLinks;
    }

    private void addLinks(List<L> newLinks) {
        if ((newLinks = this.beforeAddLinks(ImmutableList.copyOf(newLinks))).isEmpty()) {
            return;
        }
        ImmutableList<L> oldLinks = ImmutableList.copyOf(this.links);
        this.links.addAll(newLinks);
        this.dirty.setDirty(true);
        this.firePropertyChange("links", oldLinks, this.links);
        this.rebuildUI();
        this.fontManager.applyTo(this);
    }

    public DirtyImpl getDirty() {
        return this.dirty;
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        if (this.linkChipsPanel.getChips().isEmpty()) {
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.dropPanel, -2, -2, Short.MAX_VALUE));
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.dropPanel, GroupLayout.Alignment.CENTER, -2, -2, Short.MAX_VALUE));
        } else {
            GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
            verticalGroup.addComponent(this.linkChipsScrollPane, fontManager.scale(40), fontManager.scale(90), Short.MAX_VALUE);
            verticalGroup.addComponent(this.dropPanel, -2, -2, -2);
            layout.setVerticalGroup(verticalGroup);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.dropPanel, GroupLayout.Alignment.CENTER, -2, -2, Short.MAX_VALUE).addComponent(this.linkChipsScrollPane, GroupLayout.Alignment.CENTER, -2, -2, Short.MAX_VALUE));
        }
        this.setLayout(layout);
    }

    protected abstract Messages.Name dragLinkName();

    protected abstract Messages.Name chooseLinkName();

    protected abstract Messages.Name linkFileName();

    protected abstract L newLink(URI var1);

    protected abstract L newLink(File var1);

    private void openFile() {
        File file = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getMessage(this.chooseLinkName()), new FileFilter(){

            @Override
            public String getDescription() {
                return Messages.getMessage(LinksListPanel.this.linkFileName());
            }

            @Override
            public boolean accept(File f) {
                return true;
            }
        }, FilePreferences.FileType.OTHER);
        if (file != null) {
            this.addLinks(ImmutableList.of(this.newLink(file)));
        }
    }

    private TextLink newTextLink(L link) {
        Object name = ((Link)link).getDisplayName();
        boolean showToolTip = false;
        if (((String)name).length() > 20) {
            name = ((String)name).substring(0, 19) + "\u2026";
            showToolTip = true;
        }
        TextLink label = new TextLink((String)name);
        if (showToolTip) {
            label.setToolTipText(((Link)link).getDisplayName());
        }
        if (((Link)link).isFileBased()) {
            label.setToolTipText(((Link)link).toFile().getAbsolutePath());
        }
        if (this.linkClickedListener != null && this.linkClickedListener.isSupported(link)) {
            label.addActionListener(e -> this.linkClickedListener.linkClicked((Link)link));
        } else {
            label.setEnabled(false);
        }
        return label;
    }

    private void rebuildUI() {
        if (this.links == null) {
            return;
        }
        this.linkChipsPanel = this.newChipsTextPanel();
        this.linkChipsPanel.addChipEditedListener(new ChipsTextPanel.ChipEditedListener<L>(){

            @Override
            public void chipEdited(L chip, String newText) {
                ((Link)chip).setName(newText);
                LinksListPanel.this.dirty.setDirty(true);
            }
        });
        this.linkChipsPanel.addAllChips(this.links);
        this.linkChipsPanel.addChipsChangedListener(() -> {
            ImmutableList<L> oldLinks = ImmutableList.copyOf(this.links);
            this.links = Lists.newArrayList(this.linkChipsPanel.getChips());
            this.dirty.setDirty(true);
            this.firePropertyChange("links", oldLinks, this.getLinks());
            this.fontManager.applyTo(this);
        });
        this.linkChipsPanel.addChipEditedListener(new ChipsTextPanel.ChipEditedListener<L>(){

            @Override
            public void chipEdited(L chip, String newText) {
                ((Link)chip).setName(newText);
                LinksListPanel.this.dirty.setDirty(true);
            }
        });
        this.linkChipsScrollPane = new JScrollPane(this.linkChipsPanel, 20, 31);
        this.removeAll();
    }

    protected ChipsTextPanel<L> newChipsTextPanel() {
        ChipsTextPanel panel = new ChipsTextPanel<L>(Link::getDisplayName, this.fontManager){

            @Override
            protected Component toComponent(L link, String chipText) {
                return LinksListPanel.this.newTextLink(link);
            }
        };
        panel.setScaledWidth(250);
        panel.makeEditable();
        return panel;
    }

    public static interface LinkClickedListener<L extends Link> {
        public void linkClicked(L var1);

        public boolean isSupported(L var1);
    }

    class LinkDropPanel
    extends TextLink {
        LinkDropPanel() {
            super(Messages.getMessage(LinksListPanel.this.dragLinkName()));
            this.setVerticalTextPosition(3);
            this.setVerticalAlignment(3);
            new LinkDrops<L>(){

                @Override
                protected void setDragOverBorder() {
                    LinkDropPanel.this.setFocusedBorder();
                }

                @Override
                protected void setDefaultBorder() {
                    LinkDropPanel.this.setDefaultBorder();
                }

                @Override
                protected void addLinks(List<L> links) {
                    LinksListPanel.this.addLinks(links);
                }

                @Override
                protected L newLink(URI uri) {
                    return LinksListPanel.this.newLink(uri);
                }

                @Override
                protected L newLink(File file) {
                    return LinksListPanel.this.newLink(file);
                }
            }.activate(this);
        }
    }
}

