/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.links;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.scythebill.birdlist.model.sighting.Link;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public abstract class LinkDrops<L extends Link> {
    private static final DataFlavor URL_FLAVOR = LinkDrops.newDataFlavor("application/x-java-url; class=java.net.URL");
    public static final DataFlavor URI_LIST_FLAVOR = LinkDrops.newDataFlavor("text/uri-list; class=java.lang.String");
    private static final Logger logger = Logger.getLogger(LinkDrops.class.getName());

    public void activate(JComponent component) {
        Listener listener = new Listener();
        DropTarget dropTarget = new DropTarget(component, 3, listener, true);
        component.setDropTarget(dropTarget);
        dropTarget.setActive(true);
    }

    protected abstract void setDragOverBorder();

    protected abstract void setDefaultBorder();

    protected abstract void addLinks(List<L> var1);

    protected abstract L newLink(URI var1);

    protected abstract L newLink(File var1);

    private static DataFlavor newDataFlavor(String mimeType) {
        try {
            return new DataFlavor(mimeType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private class Listener
    implements DropTargetListener {
        private Listener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (this.getSupportedDataFlavor(dtde.getCurrentDataFlavors()) != null) {
                if ((dtde.getDropAction() & 2) != 0) {
                    dtde.acceptDrag(2);
                    LinkDrops.this.setDragOverBorder();
                }
            } else {
                dtde.rejectDrag();
            }
        }

        private DataFlavor getSupportedDataFlavor(DataFlavor[] currentDataFlavors) {
            DataFlavor urlFlavor = null;
            for (DataFlavor flavor : currentDataFlavors) {
                if (flavor.isFlavorJavaFileListType()) {
                    return flavor;
                }
                if (flavor.equals(URI_LIST_FLAVOR)) {
                    urlFlavor = flavor;
                }
                if (urlFlavor != null || !flavor.equals(URL_FLAVOR)) continue;
                urlFlavor = flavor;
            }
            return urlFlavor;
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            LinkDrops.this.setDefaultBorder();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Object data;
            LinkDrops.this.setDefaultBorder();
            DataFlavor supportedDataFlavor = this.getSupportedDataFlavor(dtde.getCurrentDataFlavors());
            if (supportedDataFlavor == null) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(dtde.getDropAction());
            try {
                data = dtde.getTransferable().getTransferData(supportedDataFlavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidDnDOperationException e) {
                data = null;
            }
            boolean success = false;
            if (data == null) {
                if (supportedDataFlavor.equals(URL_FLAVOR) || supportedDataFlavor.equals(URI_LIST_FLAVOR)) {
                    DataFlavor flavor = DataFlavor.getTextPlainUnicodeFlavor();
                    if (dtde.getTransferable().isDataFlavorSupported(flavor)) {
                        try {
                            String text = CharStreams.toString(flavor.getReaderForText(dtde.getTransferable()));
                            data = supportedDataFlavor.equals(URL_FLAVOR) ? new URL(text) : text;
                        }
                        catch (UnsupportedFlavorException | IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                if (data == null) {
                    dtde.dropComplete(false);
                    throw new IllegalStateException("Could not get data of type " + supportedDataFlavor.getMimeType());
                }
            }
            if (supportedDataFlavor.isFlavorJavaFileListType()) {
                List files = (List)data;
                LinkDrops.this.addLinks(Lists.transform(files, f -> LinkDrops.this.newLink((File)f)));
                success = true;
            } else if (supportedDataFlavor.equals(URI_LIST_FLAVOR)) {
                List<String> uris = Splitter.on(CharMatcher.anyOf("\r\n")).omitEmptyStrings().splitToList((String)data);
                ArrayList links = new ArrayList();
                for (String uri : uris) {
                    if (uri.startsWith("#")) continue;
                    try {
                        links.add(LinkDrops.this.newLink(new URI(uri)));
                    }
                    catch (URISyntaxException e) {
                        logger.log(Level.WARNING, String.format("Could not parse %s", uri), e);
                    }
                    if (links.isEmpty()) continue;
                    LinkDrops.this.addLinks(links);
                    success = true;
                }
            } else if (supportedDataFlavor.equals(URL_FLAVOR)) {
                URL url = (URL)data;
                try {
                    LinkDrops.this.addLinks(ImmutableList.of(LinkDrops.this.newLink(url.toURI())));
                    success = true;
                }
                catch (URISyntaxException e) {
                    logger.log(Level.WARNING, String.format("Could not parse %s", url), e);
                }
            }
            dtde.dropComplete(success);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }
}

