/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.links;

import com.scythebill.birdlist.model.sighting.Link;
import com.scythebill.birdlist.ui.components.links.LinksListPanel;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;

public abstract class DefaultLinkClickedListener<L extends Link>
implements LinksListPanel.LinkClickedListener<L> {
    private static final Logger logger = Logger.getLogger(DefaultLinkClickedListener.class.getName());
    private final Alerts alerts;
    private final Component parentObject;
    private final FileDialogs fileDialogs;

    public DefaultLinkClickedListener(Component parentObject, FileDialogs fileDialogs, Alerts alerts) {
        this.parentObject = parentObject;
        this.fileDialogs = fileDialogs;
        this.alerts = alerts;
    }

    @Override
    public void linkClicked(L link) {
        if (((Link)link).isFileBased()) {
            if (Desktop.isDesktopSupported() && (Desktop.getDesktop().isSupported(Desktop.Action.EDIT) || Desktop.getDesktop().isSupported(Desktop.Action.OPEN))) {
                try {
                    this.openFile(link);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not open " + ((Link)link).toFile(), e);
                }
            }
        } else {
            this.openUrl((Link)link);
        }
    }

    @Override
    public boolean isSupported(Link photo) {
        if (photo.isFileBased()) {
            return this.isFileSupported();
        }
        return this.isUrlSupported();
    }

    private boolean isFileSupported() {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        return Desktop.getDesktop().isSupported(Desktop.Action.EDIT) || Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    private boolean isUrlSupported() {
        return DesktopUtils.isBrowseSupported();
    }

    private void openFile(L link) throws IOException {
        if (!this.isFileSupported()) {
            return;
        }
        try {
            Desktop.getDesktop().open(((Link)link).toFile().getAbsoluteFile());
        }
        catch (IllegalArgumentException e) {
            this.tryToFixFile(link);
        }
    }

    private void tryToFixFile(L link) {
        if (this.alerts.showOkCancel((Object)this.parentObject, Messages.Name.FILE_NOT_FOUND, this.shouldFindFileMessage(), ((Link)link).getDisplayName()) != 0) {
            return;
        }
        File file = this.fileDialogs.openFile(UIUtils.findFrame(this.parentObject), Messages.getFormattedMessage(Messages.Name.LOOKING_FOR_FORMAT, ((Link)link).getDisplayName()), new FileFilter(){

            @Override
            public String getDescription() {
                return "Any file";
            }

            @Override
            public boolean accept(File f) {
                return true;
            }
        }, FilePreferences.FileType.OTHER);
        if (file == null) {
            return;
        }
        L newLink = this.newLink(file);
        this.replaceLink(link, newLink);
    }

    protected abstract Messages.Name shouldFindFileMessage();

    protected abstract L newLink(File var1);

    protected abstract void replaceLink(L var1, L var2);

    private void openUrl(Link link) {
        if (!this.isUrlSupported()) {
            return;
        }
        DesktopUtils.openUrlInBrowser(link.getUri(), this.alerts);
    }
}

