/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.links;

import com.scythebill.birdlist.model.sighting.Link;
import com.scythebill.birdlist.ui.components.links.LinksListPanel;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import java.awt.Desktop;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicLinkClickedListener<L extends Link>
implements LinksListPanel.LinkClickedListener<L> {
    private static final Logger logger = Logger.getLogger(BasicLinkClickedListener.class.getName());
    private final Alerts alerts;

    public BasicLinkClickedListener(Alerts alerts) {
        this.alerts = alerts;
    }

    @Override
    public void linkClicked(L link) {
        if (((Link)link).isFileBased()) {
            if (Desktop.isDesktopSupported() && (Desktop.getDesktop().isSupported(Desktop.Action.EDIT) || Desktop.getDesktop().isSupported(Desktop.Action.OPEN))) {
                try {
                    this.openFile(link);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not open " + ((Link)link).toFile(), e);
                }
            }
        } else {
            this.openUrl((Link)link);
        }
    }

    @Override
    public boolean isSupported(Link photo) {
        if (photo.isFileBased()) {
            return this.isFileSupported();
        }
        return this.isUrlSupported();
    }

    private boolean isFileSupported() {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        return Desktop.getDesktop().isSupported(Desktop.Action.EDIT) || Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    private boolean isUrlSupported() {
        return DesktopUtils.isBrowseSupported();
    }

    private void openFile(L link) throws IOException {
        if (!this.isFileSupported()) {
            return;
        }
        try {
            Desktop.getDesktop().open(((Link)link).toFile().getAbsoluteFile());
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "Could not open " + ((Link)link).toFile(), e);
        }
    }

    private void openUrl(Link link) {
        if (!this.isUrlSupported()) {
            return;
        }
        DesktopUtils.openUrlInBrowser(link.getUri(), this.alerts);
    }
}

