/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.browser;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.scythebill.birdlist.ui.components.browser.BrowserCellRenderer;
import com.scythebill.birdlist.ui.components.browser.BrowserPreviewRenderer;
import com.scythebill.birdlist.ui.components.browser.BrowserUI;
import com.scythebill.birdlist.ui.components.browser.DefaultColumnCellRenderer;
import com.scythebill.birdlist.ui.components.browser.QuaquaBrowserUI;
import com.scythebill.birdlist.ui.components.browser.QuaquaScrollPaneLayout;
import com.scythebill.birdlist.ui.components.browser.SizeConstrainedPanel;
import com.scythebill.birdlist.ui.util.Icons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class JBrowser
extends JComponent
implements Scrollable {
    private static final String uiClassID = "BrowserUI";
    private TreePath expandedPath;
    private int fixedCellWidth = 175;
    private int minimumCellWidth = 150;
    private TreeModel treeModel;
    protected transient TreeSelectionModel selectionModel;
    private transient SelectionModeUpdater selectionModeUpdater = new SelectionModeUpdater();
    private transient TreeSelectionUpdater treeSelectionUpdater = new TreeSelectionUpdater();
    private TreeRootHandler treeRootHandler = new TreeRootHandler();
    private transient ColumnMouseListener columnMouseListener = new ColumnMouseListener();
    private transient ColumnKeyListener columnKeyListener = new ColumnKeyListener();
    private transient ColumnFocusListener columnFocusListener = new ColumnFocusListener();
    private ListCellRenderer cellRenderer;
    private BrowserPreviewRenderer previewRenderer;
    private JScrollPane previewColumn;
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String PREVIEW_RENDERER_PROPERTY = "previewRenderer";
    public static final String TREE_MODEL_PROPERTY = "model";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String FIXED_CELL_WIDTH_PROPERTY = "fixedCellWidth";
    public static final String FIXED_CELL_HEIGHT_PROPERTY = "fixedCellHeight";
    public static final String MINIMUM_CELL_WIDTH_PROPERTY = "minimumCellWidth";
    public static final String COLUMNS_RESIZABLE_PROPERTY = "columnsResizable";
    private Object prototypeCellValue;
    private boolean isShowCellTips;
    private Point cellTipOrigin = new Point(0, 1);
    private boolean dragEnabled;
    private boolean columnsResizable = true;
    private int fixedCellHeight = -1;
    private JList focusedList;
    private Timer visibleFocusTimer;
    private static final Set<Integer> IGNORED_KEY_CODES = ImmutableSet.of(Integer.valueOf(18), Integer.valueOf(17), Integer.valueOf(157));

    public JBrowser() {
        this(JBrowser.getDefaultTreeModel());
    }

    public JBrowser(TreeNode root) {
        this(root, false);
    }

    public JBrowser(TreeNode root, boolean asksAllowsChildren) {
        this(new DefaultTreeModel(root, asksAllowsChildren));
    }

    public JBrowser(TreeModel newModel) {
        this.initComponents();
        this.selectionModel = new DefaultTreeSelectionModel();
        this.selectionModel.setSelectionMode(1);
        this.selectionModel.addPropertyChangeListener(this.selectionModeUpdater);
        this.selectionModel.addTreeSelectionListener(this.treeSelectionUpdater);
        this.visibleFocusTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBrowser.this.scrollFocusIntoView();
            }
        });
        this.visibleFocusTimer.setRepeats(false);
        this.visibleFocusTimer.setCoalesce(true);
        this.setOpaque(true);
        this.updateUI();
        this.setModel(newModel);
        this.setFocusable(false);
    }

    @Override
    public BrowserUI getUI() {
        return (BrowserUI)this.ui;
    }

    public void setUI(BrowserUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI(new QuaquaBrowserUI());
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setPrototypeCellValue(Object prototypeCellValue) {
        this.prototypeCellValue = prototypeCellValue;
    }

    public void setDragEnabled(boolean b) {
        if (b && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = b;
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.getColumnList(i).setDragEnabled(b);
        }
    }

    @Override
    public void setTransferHandler(TransferHandler newValue) {
        super.setTransferHandler(newValue);
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.getColumnList(i).setTransferHandler(newValue);
        }
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    protected static TreeModel getDefaultTreeModel() {
        return new DefaultTreeModel(new DefaultMutableTreeNode(""));
    }

    protected static TreeModel createTreeModel(Object value) {
        DefaultMutableTreeNode root;
        if (value instanceof Object[] || value instanceof Hashtable || value instanceof Vector) {
            root = new DefaultMutableTreeNode("root");
            JTree.DynamicUtilTreeNode.createChildren(root, value);
        } else {
            root = new JTree.DynamicUtilTreeNode((Object)"root", value);
        }
        return new DefaultTreeModel(root, false);
    }

    private void expandRoot() {
        this.selectionModel.clearSelection();
        this.expandPath(new TreePath(this.treeModel.getRoot()));
    }

    public TreePath getClosestPathForLocation(int x, int y) {
        Component c = this.getComponentAt(x, y);
        if (c != null && c instanceof JScrollPane && (c = c.getComponentAt(x -= c.getX(), y -= c.getY())) != null && c instanceof JViewport && (c = c.getComponentAt(x -= c.getX(), y -= c.getY())) != null && c instanceof JList) {
            JList l = (JList)c;
            ColumnListModel m = (ColumnListModel)l.getModel();
            int index = l.locationToIndex(new Point(x -= c.getX(), y -= c.getY()));
            if (index != -1) {
                return m.path.pathByAddingChild(m.getElementAt(index));
            }
        }
        return null;
    }

    public Rectangle getPathBounds(TreePath path) {
        if (path.getPathCount() <= 1) {
            return null;
        }
        if (path.getPathCount() - 1 <= this.getListColumnCount()) {
            JList list = this.getColumnList(path.getPathCount() - 2);
            int index = path.getPathCount() > 1 ? this.treeModel.getIndexOfChild(path.getPathComponent(path.getPathCount() - 2), path.getLastPathComponent()) : this.treeModel.getIndexOfChild(null, path.getLastPathComponent());
            if (list.getParent() == null || list.getParent().getParent() == null) {
                return null;
            }
            Rectangle bounds = list.getCellBounds(index, index);
            if (bounds == null) {
                return null;
            }
            bounds.x += list.getLocation().x + list.getParent().getLocation().x + list.getParent().getParent().getLocation().x;
            bounds.y += list.getLocation().y + list.getParent().getLocation().y + list.getParent().getParent().getLocation().y;
            return bounds;
        }
        return null;
    }

    public void setShowCellTips(boolean newValue) {
        boolean oldValue = this.isShowCellTips;
        if (oldValue != newValue) {
            this.isShowCellTips = newValue;
            String tipText = newValue ? "cell tip" : null;
            int n = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.getColumnList(i).setToolTipText(tipText);
            }
            this.firePropertyChange("showCellTips", oldValue, newValue);
        }
    }

    public boolean isShowCellTips() {
        return this.isShowCellTips;
    }

    public void setShowCellTipOrigin(Point newValue) {
        Point oldValue = this.cellTipOrigin;
        this.cellTipOrigin = newValue == null ? new Point(0, 0) : (Point)newValue.clone();
        this.firePropertyChange("cellTipOrigin", oldValue, newValue);
    }

    public Point getCellTipOrigin() {
        return (Point)this.cellTipOrigin.clone();
    }

    public boolean isPathSelected(TreePath path) {
        TreePath[] selectionPaths = this.getSelectionPaths();
        for (int i = 0; i < selectionPaths.length; ++i) {
            if (!selectionPaths[i].equals(path)) continue;
            return true;
        }
        return false;
    }

    public void addSelectionPath(TreePath path) {
        for (int i = 0; i < path.getPathCount(); ++i) {
            int index;
            JList columnList = this.getColumnList(i);
            if (columnList.isSelectedIndex(index = this.treeModel.getIndexOfChild(i == 0 ? null : path.getPathComponent(i - 1), path.getPathComponent(i)))) continue;
            if (i < path.getPathCount() - 1) {
                columnList.setSelectionInterval(index, index);
                continue;
            }
            columnList.addSelectionInterval(index, index);
        }
    }

    public void ensurePathIsVisible(TreePath path) {
        TreePath selectionPath = this.selectionModel.getSelectionPath();
        if (selectionPath != null && (path.isDescendant(selectionPath) || selectionPath.isDescendant(path))) {
            if (!this.isValid()) {
                this.setSize(this.getPreferredSize());
                this.doLayout();
            }
            for (int i = 0; i < path.getPathCount() - 1 && i < this.getListColumnCount(); ++i) {
                JList columnList = this.getColumnList(i);
                int index0 = columnList.getSelectedIndex();
                Rectangle bounds = columnList.getCellBounds(index0, index0);
                if (index0 == -1 || bounds == null) continue;
                columnList.scrollRectToVisible(bounds);
            }
            Component component = this.getComponent(this.getColumnCount() - 1);
            if (component != null && component.getBounds() != null) {
                this.scrollRectToVisible(component.getBounds());
            }
        }
    }

    public void setSelectionPath(TreePath path) {
        this.selectionModel.setSelectionPath(path);
    }

    public void removeSelectionPath(TreePath path) {
        if (path.getPathCount() <= this.getListColumnCount()) {
            JList columnList = this.getColumnList(path.getPathCount() - 1);
            int index = this.treeModel.getIndexOfChild(path.getPathComponent(path.getPathCount() - 2), path.getLastPathComponent());
            columnList.removeSelectionInterval(index, index);
        }
    }

    public TreePath getPathForLocation(int x, int y) {
        return this.getClosestPathForLocation(x, y);
    }

    public void clearSelection() {
        this.setSelectionPath(new TreePath(this.treeModel.getRoot()));
    }

    public void setFixedCellWidth(int width) {
        int oldValue = this.fixedCellWidth;
        this.fixedCellWidth = width;
        for (int i = 0; i < this.getListColumnCount(); ++i) {
            this.getColumnList(i).setFixedCellWidth(width);
        }
        if (this.previewColumn != null) {
            SizeConstrainedPanel p = (SizeConstrainedPanel)this.previewColumn.getViewport().getView();
            p.setPreferredWidth(width);
        }
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.firePropertyChange(FIXED_CELL_WIDTH_PROPERTY, oldValue, this.fixedCellWidth);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setMinimumCellWidth(int newValue) {
        int oldValue = this.minimumCellWidth;
        this.minimumCellWidth = newValue;
        this.firePropertyChange(MINIMUM_CELL_WIDTH_PROPERTY, oldValue, newValue);
    }

    public int getMinimumCellWidth() {
        return this.minimumCellWidth;
    }

    public void setColumnWidth(int column, int width) {
        JList l = this.getColumnList(column);
        l.setFixedCellWidth(width);
        l.revalidate();
        this.revalidate();
    }

    public int getColumnWidth(int column) {
        return this.getColumnList(column).getFixedCellWidth();
    }

    public int getPreferredColumnWidth(int column) {
        JList l = this.getColumnList(column);
        l.setFixedCellWidth(-1);
        int width = l.getPreferredSize().width;
        l.setFixedCellWidth(this.fixedCellWidth);
        return width;
    }

    public void setPreviewColumnWidth(int width) {
        if (this.previewColumn == null) {
            return;
        }
        SizeConstrainedPanel p = (SizeConstrainedPanel)this.previewColumn.getViewport().getView();
        p.setPreferredWidth(width);
        this.revalidate();
    }

    public int getPreviewColumnWidth() {
        if (this.previewColumn == null) {
            return this.getFixedCellWidth();
        }
        SizeConstrainedPanel p = (SizeConstrainedPanel)this.previewColumn.getViewport().getView();
        return p.getPreferredSize().width;
    }

    public void setColumnsResizable(boolean newValue) {
        boolean oldValue = this.columnsResizable;
        this.columnsResizable = newValue;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component handle;
            Component c = this.getComponent(i);
            if (!(c instanceof JScrollPane) || !((handle = ((JScrollPane)c).getCorner("LOWER_RIGHT_CORNER")) instanceof SizeHandle)) continue;
            handle.setVisible(newValue);
        }
        this.firePropertyChange(COLUMNS_RESIZABLE_PROPERTY, oldValue, newValue);
    }

    public boolean isColumnsResizable() {
        return this.columnsResizable;
    }

    public void setFixedCellHeight(int fixedCellHeight) {
        int oldValue = this.fixedCellHeight;
        this.fixedCellHeight = fixedCellHeight;
        for (int i = 0; i < this.getListColumnCount(); ++i) {
            this.getColumnList(i).setFixedCellHeight(fixedCellHeight);
        }
        this.firePropertyChange(FIXED_CELL_HEIGHT_PROPERTY, oldValue, fixedCellHeight);
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setColumnCellRenderer(ListCellRenderer cellRenderer) {
        ListCellRenderer oldValue = this.cellRenderer;
        this.cellRenderer = cellRenderer;
        for (int i = 0; i < this.getListColumnCount(); ++i) {
            this.getColumnList(i).setCellRenderer(cellRenderer);
        }
        this.firePropertyChange(CELL_RENDERER_PROPERTY, oldValue, cellRenderer);
    }

    public ListCellRenderer getColumnCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(BrowserCellRenderer cellRenderer) {
        BrowserCellRenderer oldValue = this.getCellRenderer();
        if (cellRenderer != null) {
            this.setColumnCellRenderer(new BrowserCellRendererWrapper(cellRenderer));
        } else {
            this.setColumnCellRenderer(new DefaultColumnCellRenderer(this));
        }
        this.firePropertyChange(CELL_RENDERER_PROPERTY, oldValue, cellRenderer);
    }

    public BrowserCellRenderer getCellRenderer() {
        return this.cellRenderer instanceof BrowserCellRendererWrapper ? ((BrowserCellRendererWrapper)this.cellRenderer).browserCellRenderer : null;
    }

    public void setPreviewRenderer(BrowserPreviewRenderer newValue) {
        BrowserPreviewRenderer oldValue = this.previewRenderer;
        this.previewRenderer = newValue;
        if (newValue == null) {
            if (this.previewColumn != null) {
                this.remove(this.previewColumn);
                this.previewColumn = null;
            }
        } else {
            if (this.previewColumn == null) {
                SizeConstrainedPanel p = new SizeConstrainedPanel();
                p.setPreferredWidth(this.fixedCellWidth);
                this.previewColumn = new JScrollPane(p, 22, 31);
                this.previewColumn.setBorder(null);
                SizeHandle sizeHandle = new SizeHandle(-1);
                sizeHandle.setVisible(this.isColumnsResizable());
                this.previewColumn.setCorner("LOWER_RIGHT_CORNER", sizeHandle);
                this.previewColumn.setLayout(new BrowserScrollPaneLayout());
                this.previewColumn.setFocusable(false);
                this.previewColumn.getHorizontalScrollBar().setFocusable(false);
                this.previewColumn.getVerticalScrollBar().setFocusable(false);
                if (this.getDropTarget() != null) {
                    new DropTarget(this.previewColumn, this.getDropTarget().getDefaultActions(), this.getDropTarget());
                    new DropTarget(p, this.getDropTarget().getDefaultActions(), this.getDropTarget());
                }
            }
            this.updatePreviewColumn();
        }
        this.firePropertyChange(PREVIEW_RENDERER_PROPERTY, oldValue, newValue);
    }

    private int getColumnCount() {
        return this.getComponentCount();
    }

    private int getListColumnCount() {
        int count = this.getComponentCount();
        if (this.previewColumn != null && this.previewColumn.getParent() == this) {
            return count - 1;
        }
        return count;
    }

    @Override
    public void setDropTarget(DropTarget t) {
        super.setDropTarget(t);
        if (t != null) {
            int n = this.getListColumnCount();
            for (int i = 0; i < n; ++i) {
                new DropTarget(this.getColumnList(i), t.getDefaultActions(), t);
            }
            if (this.previewColumn != null) {
                new DropTarget(this.previewColumn, t.getDefaultActions(), t);
                new DropTarget(this.previewColumn.getViewport().getView(), t.getDefaultActions(), t);
            }
        }
    }

    private JList getColumnList(int column) {
        return (JList)((JScrollPane)this.getComponent(column)).getViewport().getView();
    }

    private ColumnListModel getColumnListModel(int column) {
        return (ColumnListModel)((JList)((JScrollPane)this.getComponent(column)).getViewport().getView()).getModel();
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public void setSelectionModel(TreeSelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException();
        }
        TreeSelectionModel oldValue = this.selectionModel;
        if (this.selectionModel != null) {
            this.selectionModel.removeTreeSelectionListener(this.treeSelectionUpdater);
            this.selectionModel.removePropertyChangeListener(this.selectionModeUpdater);
        }
        if (this.accessibleContext != null) {
            this.selectionModel.removeTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
            selectionModel.addTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
        }
        this.selectionModel = selectionModel;
        this.selectionModel.addTreeSelectionListener(this.treeSelectionUpdater);
        this.selectionModel.addPropertyChangeListener(this.selectionModeUpdater);
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, oldValue, this.selectionModel);
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionModel.setSelectionMode(selectionMode);
    }

    public TreePath getSelectionPath() {
        if (this.getListColumnCount() == 0) {
            return null;
        }
        JList list = this.getColumnList(this.getListColumnCount() - 1);
        ColumnListModel m = this.getColumnListModel(this.getListColumnCount() - 1);
        int i = list.getSelectedIndex();
        Object pathComponent = i == -1 || i >= m.getSize() ? null : list.getSelectedValue();
        return pathComponent == null ? m.path : m.path.pathByAddingChild(pathComponent);
    }

    public TreePath[] getSelectionPaths() {
        return this.getSelectionModel().getSelectionPaths();
    }

    public void setSelectionPaths(TreePath[] paths) {
        this.getSelectionModel().setSelectionPaths(paths);
    }

    @Override
    public synchronized KeyListener[] getKeyListeners() {
        return (KeyListener[])this.getListeners(KeyListener.class);
    }

    public void updatePreviewColumn() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JBrowser.this.previewColumn != null) {
                    SizeConstrainedPanel p = (SizeConstrainedPanel)JBrowser.this.previewColumn.getViewport().getView();
                    TreePath[] paths = JBrowser.this.getSelectionPaths();
                    if (!JBrowser.this.usePreviewColumn(paths)) {
                        JBrowser.this.remove(JBrowser.this.previewColumn);
                    } else {
                        p.removeAll();
                        p.add(JBrowser.this.previewRenderer.getPreviewRendererComponent(JBrowser.this, paths));
                        JBrowser.this.setPreviewColumnWidth(JBrowser.this.getPreviewColumnWidth());
                        JBrowser.this.add(JBrowser.this.previewColumn);
                    }
                }
            }
        });
    }

    protected boolean usePreviewColumn(TreePath[] paths) {
        if (paths == null || paths.length == 0) {
            return false;
        }
        if (paths.length == 1) {
            return this.treeModel.isLeaf(paths[0].getLastPathComponent());
        }
        return true;
    }

    public Component getPreviewRendererComponent() {
        if (this.previewColumn == null) {
            return null;
        }
        if (!this.previewColumn.isShowing()) {
            return null;
        }
        SizeConstrainedPanel p = (SizeConstrainedPanel)this.previewColumn.getViewport().getView();
        if (!p.isShowing() || p.getComponentCount() == 0) {
            return null;
        }
        return p.getComponent(0);
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.listenerList.add(TreeSelectionListener.class, tsl);
    }

    public void removeTreeSelectionListener(TreeSelectionListener tsl) {
        this.listenerList.remove(TreeSelectionListener.class, tsl);
    }

    protected void fireValueChanged(TreeSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeSelectionListener.class) continue;
            ((TreeSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setModel(TreeModel newModel) {
        TreeModel oldModel = this.treeModel;
        if (oldModel != null) {
            oldModel.removeTreeModelListener(this.treeRootHandler);
        }
        this.treeModel = newModel;
        if (newModel != null) {
            newModel.addTreeModelListener(this.treeRootHandler);
        }
        for (int i = this.getListColumnCount() - 1; i >= 0; --i) {
            this.removeLastListColumn();
        }
        if (this.treeModel != null) {
            this.expandedPath = null;
            this.expandRoot();
        }
        this.firePropertyChange(TREE_MODEL_PROPERTY, oldModel, this.treeModel);
    }

    private void expandPath(TreePath path) {
        int newColumnCount;
        int oldColumnCount;
        boolean newPathIsLeaf;
        boolean oldPathIsLeaf = this.expandedPath == null || this.treeModel.isLeaf(this.expandedPath.getLastPathComponent());
        boolean bl = newPathIsLeaf = path == null || this.treeModel.isLeaf(path.getLastPathComponent());
        int n = this.expandedPath == null ? 0 : (oldColumnCount = this.expandedPath.getPathCount() - (oldPathIsLeaf ? 1 : 0));
        int n2 = path == null ? 0 : (newColumnCount = path.getPathCount() - (newPathIsLeaf ? 1 : 0));
        if (this.expandedPath == null || !this.expandedPath.equals(path)) {
            if (oldColumnCount == newColumnCount && oldColumnCount == this.getListColumnCount()) {
                p = null;
                for (int i = 0; i < newColumnCount; ++i) {
                    p = p == null ? new TreePath(path.getPathComponent(0)) : p.pathByAddingChild(path.getPathComponent(i));
                    JList l = this.getColumnList(i);
                    ColumnListModel m = (ColumnListModel)l.getModel();
                    m.setPath(p);
                }
            } else {
                for (int i = this.getListColumnCount() - 1; i >= newColumnCount; --i) {
                    if (this.getColumnList(i).isFocusOwner()) {
                        this.removeColumn(i > 0 ? i - 1 : i);
                        continue;
                    }
                    this.removeColumn(i);
                }
                p = null;
                int n3 = this.getListColumnCount();
                for (int i = 0; i < n3; ++i) {
                    p = p == null ? new TreePath(path.getPathComponent(0)) : p.pathByAddingChild(path.getPathComponent(i));
                    JList l = this.getColumnList(i);
                    ColumnListModel m = (ColumnListModel)l.getModel();
                    m.setPath(p);
                }
                List<Object> components = Arrays.asList(path.getPath());
                for (int i = this.getListColumnCount(); i < newColumnCount; ++i) {
                    this.addColumn(new TreePath(components.subList(0, i + 1).toArray()));
                }
            }
            this.expandedPath = path;
            for (int i = 0; i < path.getPathCount() - 1; ++i) {
                this.getColumnList(i).setSelectedIndex(this.treeModel.getIndexOfChild(path.getPathComponent(i), path.getPathComponent(i + 1)));
            }
        }
    }

    protected void addColumn(TreePath path) {
        JList l = new JList(new ColumnListModel(path, this.treeModel)){

            @Override
            public String getToolTipText(MouseEvent event) {
                Rectangle cellBounds;
                Point mouseLocation = event.getPoint();
                int index = this.locationToIndex(mouseLocation);
                if (index != -1 && (cellBounds = this.getCellBounds(index, index)).contains(mouseLocation)) {
                    Object value = this.getModel().getElementAt(index);
                    Component renderer = this.getCellRenderer().getListCellRendererComponent(this, value, index, false, false);
                    if (renderer.getPreferredSize().width > this.getWidth()) {
                        return JBrowser.this.convertValueToText(value, false, false, false, index, false);
                    }
                }
                return null;
            }

            @Override
            public Point getToolTipLocation(MouseEvent event) {
                Rectangle cellBounds;
                Point mouseLocation = event.getPoint();
                int index = this.locationToIndex(mouseLocation);
                if (index != -1 && (cellBounds = this.getCellBounds(index, index)).contains(mouseLocation)) {
                    Object value = this.getModel().getElementAt(index);
                    Component renderer = this.getCellRenderer().getListCellRendererComponent(this, value, index, false, false);
                    if (renderer.getPreferredSize().width > this.getWidth()) {
                        Point location = cellBounds.getLocation();
                        location.x += JBrowser.this.cellTipOrigin.x;
                        location.y += JBrowser.this.cellTipOrigin.y;
                        return location;
                    }
                }
                return null;
            }
        };
        if (this.isShowCellTips) {
            l.setToolTipText("cell tip");
        }
        if (this.getDropTarget() != null) {
            new DropTarget(l, this.getDropTarget().getDefaultActions(), this.getDropTarget());
        }
        if (this.cellRenderer != null) {
            l.setCellRenderer(this.cellRenderer);
        }
        if (this.prototypeCellValue != null) {
            l.setPrototypeCellValue(this.prototypeCellValue);
        }
        l.setSelectionModel(new ColumnSelectionModel());
        l.setSelectionMode(switch (this.selectionModel.getSelectionMode()) {
            case 2 -> 1;
            case 4 -> 2;
            default -> 0;
        });
        l.addMouseListener(this.columnMouseListener);
        l.addKeyListener(this.columnKeyListener);
        l.addFocusListener(this.columnFocusListener);
        l.setFixedCellWidth(this.fixedCellWidth);
        l.setDragEnabled(this.getDragEnabled());
        l.setTransferHandler(this.getTransferHandler());
        if (this.fixedCellHeight > 0) {
            l.setFixedCellHeight(this.fixedCellHeight);
        }
        JScrollPane sp = new JScrollPane(l, 22, 31);
        sp.setBorder(null);
        SizeHandle sizeHandle = new SizeHandle(path.getPathCount() - 1);
        sizeHandle.setVisible(this.isColumnsResizable());
        sp.setCorner("LOWER_RIGHT_CORNER", new SizeHandle(path.getPathCount() - 1));
        sp.setLayout(new BrowserScrollPaneLayout());
        sp.setFocusable(false);
        sp.getVerticalScrollBar().setFocusable(false);
        sp.getHorizontalScrollBar().setFocusable(false);
        this.add((Component)sp, this.getListColumnCount());
    }

    protected void removeLastListColumn() {
        this.removeColumn(this.getListColumnCount() - 1);
    }

    protected void removeColumn(int columnIndex) {
        JList l = this.getColumnList(columnIndex);
        JScrollPane sp = (JScrollPane)this.getComponent(columnIndex);
        Rectangle bounds = sp.getBounds();
        sp.remove(l);
        this.remove(sp);
        if (l.hasFocus()) {
            this.putClientProperty("Quaqua.drawFocusBorder", Boolean.FALSE);
            this.repaintParentBorder();
        }
        l.removeMouseListener(this.columnMouseListener);
        l.removeKeyListener(this.columnKeyListener);
        l.removeFocusListener(this.columnFocusListener);
        ((ColumnListModel)l.getModel()).dispose();
        this.revalidate();
        this.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    private void initComponents() {
        this.setLayout(new BrowserLayout());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = new Dimension();
        if (this.getComponentCount() == 0) {
            JScrollPane dummyColumn = new JScrollPane();
            JList<Object> list = new JList<Object>();
            list.setPrototypeCellValue(this.prototypeCellValue);
            dummyColumn.setViewportView(list);
            size.setSize(dummyColumn.getPreferredSize());
            size.width *= 2;
        } else {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Dimension componentSize = this.getComponent(i).getPreferredSize();
                size.height = Math.max(size.height, componentSize.height);
                size.width += componentSize.width;
            }
        }
        return size;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int increment;
        block11: {
            Component[] components;
            block10: {
                components = this.getComponents();
                increment = 0;
                if (direction <= 0) break block10;
                switch (orientation) {
                    case 0: {
                        for (int i = components.length - 1; i >= 0; --i) {
                            Rectangle cbounds = components[i].getBounds();
                            if (cbounds.x + cbounds.width <= visibleRect.x + visibleRect.width) continue;
                            increment = cbounds.x + cbounds.width - visibleRect.x - visibleRect.width;
                        }
                        break block11;
                    }
                    case 1: {
                        increment = 10;
                    }
                }
                break block11;
            }
            switch (orientation) {
                case 0: {
                    for (int i = 0; i < components.length; ++i) {
                        Rectangle cbounds = components[i].getBounds();
                        if (cbounds.x >= visibleRect.x) continue;
                        increment = visibleRect.x - cbounds.x;
                    }
                    break;
                }
                case 1: {
                    increment = 10;
                }
            }
        }
        return increment;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int increment;
        block12: {
            Component[] components;
            block11: {
                components = this.getComponents();
                increment = 0;
                if (direction <= 0) break block11;
                switch (orientation) {
                    case 0: {
                        for (int i = components.length - 1; i >= 0; --i) {
                            Rectangle cbounds = components[i].getBounds();
                            if (cbounds.x > visibleRect.x) {
                                increment = cbounds.x - visibleRect.x;
                                continue;
                            }
                            if (cbounds.x + cbounds.width <= visibleRect.x + visibleRect.width) continue;
                            increment = cbounds.x - visibleRect.x;
                        }
                        break block12;
                    }
                    case 1: {
                        increment = 10;
                    }
                }
                break block12;
            }
            switch (orientation) {
                case 0: {
                    for (int i = 0; i < components.length; ++i) {
                        Rectangle cbounds = components[i].getBounds();
                        if (cbounds.x + cbounds.width >= visibleRect.x) continue;
                        increment = visibleRect.x - cbounds.x;
                    }
                    if (increment != 0) break;
                    increment = visibleRect.x - components[0].getBounds().x;
                    break;
                }
                case 1: {
                    increment = 10;
                }
            }
        }
        return increment;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
    }

    @Override
    public void removeNotify() {
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    protected void unconfigureEnclosingScrollPane() {
    }

    @Override
    public void requestFocus() {
        TreePath tp = this.getSelectionPath();
        if (tp != null && tp.getPathCount() > 1) {
            this.getColumnList(tp.getPathCount() - 2).requestFocus();
        } else {
            this.getColumnList(this.getListColumnCount() - 1).requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.getListColumnCount() == 0) {
            return false;
        }
        TreePath tp = this.getSelectionPath();
        if (tp != null && tp.getPathCount() > 1) {
            return this.getColumnList(tp.getPathCount() - 2).requestFocusInWindow();
        }
        return this.getColumnList(this.getListColumnCount() - 1).requestFocusInWindow();
    }

    private void repaintParentBorder() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            parent = parent.getParent();
            Insets insets = ((JComponent)parent).getInsets();
            Dimension size = parent.getSize();
            parent.repaint(0, 0, size.width, insets.top);
            parent.repaint(0, size.height - insets.bottom, size.width, insets.bottom);
            parent.repaint(0, insets.top, insets.left, size.height - insets.top - insets.bottom);
            parent.repaint(size.width - insets.right, insets.top, insets.right, size.height - insets.top - insets.bottom);
        }
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String sValue;
        if (value != null && (sValue = value.toString()) != null) {
            return sValue;
        }
        return "";
    }

    private TreePath maybeExtendPath(TreePath selectionPath) {
        return selectionPath;
    }

    public void scrollListSelectionsIntoView() {
        for (int i = 0; i < this.getListColumnCount(); ++i) {
            JList list = this.getColumnList(i);
            int selectedIndex = list.getSelectedIndex();
            if (selectedIndex <= 0) continue;
            Rectangle cellBounds = list.getCellBounds(selectedIndex, selectedIndex + 1);
            list.scrollRectToVisible(cellBounds);
        }
    }

    private void scrollFocusIntoView() {
        int focusedComponentIndex = this.getComponentCount() - 1;
        if (this.focusedList != null) {
            for (int i = 0; i < this.getListColumnCount(); ++i) {
                if (this.focusedList != this.getColumnList(i)) continue;
                focusedComponentIndex = i;
                break;
            }
        }
        if (focusedComponentIndex >= 0) {
            Rectangle bounds = this.getComponent(focusedComponentIndex).getBounds();
            if (focusedComponentIndex < this.getComponentCount() - 1) {
                Rectangle rightBounds = this.getComponent(focusedComponentIndex + 1).getBounds();
                bounds.width += rightBounds.width;
            }
            this.scrollRectToVisible(bounds);
            this.getComponent(focusedComponentIndex).repaint();
        }
    }

    private void updateExpandedState(JList columnList) {
        ColumnListModel columnModel = (ColumnListModel)columnList.getModel();
        TreePath columnPath = columnModel.path;
        int[] selectedIndices = columnList.getSelectedIndices();
        if (selectedIndices.length == 0) {
            TreePath leadPath = columnModel.path;
            this.selectionModel.setSelectionPath(leadPath);
        } else if (selectedIndices.length == 1) {
            TreePath leadPath = columnPath.pathByAddingChild(columnList.getSelectedValue());
            this.selectionModel.setSelectionPath(this.maybeExtendPath(leadPath));
        } else {
            int leadSelectionIndex = columnList.getLeadSelectionIndex();
            if (leadSelectionIndex < 0 || leadSelectionIndex >= columnModel.getSize()) {
                TreePath[] paths = new TreePath[selectedIndices.length];
                for (int i = 0; i < selectedIndices.length; ++i) {
                    paths[i] = columnModel.path.pathByAddingChild(columnModel.getElementAt(selectedIndices[i]));
                }
                this.selectionModel.setSelectionPaths(paths);
            } else {
                TreePath leadPath = columnPath.pathByAddingChild(columnModel.getElementAt(leadSelectionIndex));
                TreePath[] paths = new TreePath[selectedIndices.length];
                int leadPathIndex = -1;
                for (int i = 0; i < selectedIndices.length; ++i) {
                    paths[i] = columnModel.path.pathByAddingChild(columnModel.getElementAt(selectedIndices[i]));
                    if (!paths[i].equals(leadPath)) continue;
                    leadPathIndex = i;
                }
                if (leadPathIndex != -1) {
                    paths[leadPathIndex] = paths[paths.length - 1];
                    paths[paths.length - 1] = leadPath;
                }
                this.selectionModel.setSelectionPaths(paths);
            }
        }
    }

    private class SelectionModeUpdater
    implements Serializable,
    PropertyChangeListener {
        private SelectionModeUpdater() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selectionMode")) {
                int selectionMode = switch (JBrowser.this.selectionModel.getSelectionMode()) {
                    case 2 -> 1;
                    case 4 -> 2;
                    default -> 0;
                };
                for (int i = 0; i < JBrowser.this.getListColumnCount(); ++i) {
                    JBrowser.this.getColumnList(i).getSelectionModel().setSelectionMode(selectionMode);
                }
            }
        }
    }

    private class TreeSelectionUpdater
    implements Serializable,
    TreeSelectionListener {
        private TreeSelectionUpdater() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            switch (JBrowser.this.selectionModel.getSelectionCount()) {
                case 0: {
                    JBrowser.this.expandPath(new TreePath(JBrowser.this.treeModel.getRoot()));
                    JBrowser.this.updatePreviewColumn();
                    break;
                }
                case 1: {
                    TreePath selectionPath = JBrowser.this.selectionModel.getSelectionPath();
                    JBrowser.this.expandPath(selectionPath);
                    if (!JBrowser.this.treeModel.isLeaf(selectionPath.getLastPathComponent())) {
                        JBrowser.this.getColumnList(JBrowser.this.getListColumnCount() - 1).clearSelection();
                    }
                    JBrowser.this.updatePreviewColumn();
                    break;
                }
                default: {
                    TreePath leadSelectionPath = JBrowser.this.selectionModel.getLeadSelectionPath();
                    TreePath parentPath = leadSelectionPath.getParentPath();
                    JBrowser.this.expandPath(parentPath);
                    JList list = JBrowser.this.getColumnList(parentPath.getPathCount() - 1);
                    TreePath[] selectionPaths = JBrowser.this.selectionModel.getSelectionPaths();
                    int[] indices = new int[selectionPaths.length];
                    int leadPathIndex = -1;
                    for (int i = 0; i < selectionPaths.length; ++i) {
                        indices[i] = JBrowser.this.treeModel.getIndexOfChild(parentPath.getLastPathComponent(), selectionPaths[i].getLastPathComponent());
                        if (!selectionPaths[i].equals(leadSelectionPath)) continue;
                        leadPathIndex = i;
                    }
                    int swap = indices[leadPathIndex];
                    indices[leadPathIndex] = indices[indices.length - 1];
                    indices[indices.length - 1] = swap;
                    int leadSelectionIndex = list.getLeadSelectionIndex();
                    int anchorSelectionIndex = list.getAnchorSelectionIndex();
                    list.setSelectedIndices(indices);
                    if (!Ints.contains(indices, leadSelectionIndex)) {
                        leadSelectionIndex = indices[indices.length - 1];
                    }
                    if (!Ints.contains(indices, anchorSelectionIndex)) {
                        anchorSelectionIndex = indices[0];
                    }
                    list.getSelectionModel().setAnchorSelectionIndex(anchorSelectionIndex);
                    JBrowser.this.updatePreviewColumn();
                    break;
                }
            }
            if (JBrowser.this.getParent() != null) {
                JBrowser.this.getParent().validate();
            }
            JBrowser.this.visibleFocusTimer.restart();
            if (JBrowser.this.listenerList.getListenerCount(TreeSelectionListener.class) != 0) {
                TreeSelectionEvent newE = (TreeSelectionEvent)evt.cloneWithSource(JBrowser.this);
                JBrowser.this.fireValueChanged(newE);
            }
        }
    }

    private class TreeRootHandler
    implements TreeModelListener {
        private TreeRootHandler() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            JBrowser.this.treeSelectionUpdater.valueChanged(new TreeSelectionEvent((Object)JBrowser.this, e.getTreePath(), true, JBrowser.this.getSelectionModel().getLeadSelectionPath(), JBrowser.this.getSelectionModel().getLeadSelectionPath()));
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            if (e.getPath().length == 1) {
                for (int i = JBrowser.this.getListColumnCount() - 1; i >= 0; --i) {
                    JBrowser.this.removeLastListColumn();
                }
                JBrowser.this.expandedPath = null;
                JBrowser.this.expandRoot();
                JBrowser.this.setSelectionPath(e.getTreePath());
            }
        }
    }

    private class ColumnMouseListener
    extends MouseAdapter {
        private ColumnMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            JList columnList = (JList)evt.getComponent();
            EventListener[] listeners = JBrowser.this.getListeners(MouseListener.class);
            if (listeners.length > 0) {
                int x = evt.getX();
                int y = evt.getY();
                for (Container c = columnList; c != JBrowser.this; c = c.getParent()) {
                    x += ((Component)c).getX();
                    y += ((Component)c).getY();
                }
                MouseEvent refiredEvent = new MouseEvent(JBrowser.this, evt.getID(), evt.getWhen(), evt.getModifiersEx(), x, y, evt.getClickCount(), evt.isPopupTrigger());
                for (int i = 0; i < listeners.length; ++i) {
                    ((MouseListener)listeners[i]).mouseReleased(refiredEvent);
                }
            }
            SwingUtilities.invokeLater(() -> JBrowser.this.updateExpandedState(columnList));
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            JList columnList = (JList)evt.getComponent();
            EventListener[] listeners = JBrowser.this.getListeners(MouseListener.class);
            if (listeners.length > 0) {
                int x = evt.getX();
                int y = evt.getY();
                for (Container c = columnList; c != JBrowser.this; c = c.getParent()) {
                    x += ((Component)c).getX();
                    y += ((Component)c).getY();
                }
                MouseEvent refiredEvent = new MouseEvent(JBrowser.this, evt.getID(), evt.getWhen(), evt.getModifiersEx(), x, y, evt.getClickCount(), evt.isPopupTrigger());
                for (int i = 0; i < listeners.length; ++i) {
                    ((MouseListener)listeners[i]).mouseClicked(refiredEvent);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            JList columnList = (JList)evt.getComponent();
            EventListener[] listeners = JBrowser.this.getListeners(MouseListener.class);
            if (listeners.length > 0) {
                int x = evt.getX();
                int y = evt.getY();
                for (Container c = columnList; c != JBrowser.this; c = c.getParent()) {
                    x += ((Component)c).getX();
                    y += ((Component)c).getY();
                }
                MouseEvent refiredEvent = new MouseEvent(JBrowser.this, evt.getID(), evt.getWhen(), evt.getModifiersEx(), x, y, evt.getClickCount(), evt.isPopupTrigger());
                for (int i = 0; i < listeners.length; ++i) {
                    ((MouseListener)listeners[i]).mousePressed(refiredEvent);
                }
            }
        }
    }

    private class ColumnKeyListener
    implements KeyListener {
        private ColumnKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            int i;
            JList columnList = (JList)evt.getComponent();
            ColumnListModel columnModel = (ColumnListModel)columnList.getModel();
            TreePath columnPath = columnModel.path;
            if (evt.getKeyCode() == 37) {
                if (columnPath.getPathCount() > 1) {
                    evt.consume();
                    columnList.clearSelection();
                    JList parentColumnList = JBrowser.this.getColumnList(columnPath.getPathCount() - 2);
                    JBrowser.this.selectionModel.setSelectionPath(columnPath);
                    parentColumnList.requestFocus();
                }
            } else if (evt.getKeyCode() == 39) {
                JComponent childColumnList = null;
                if (JBrowser.this.focusedList != null) {
                    for (i = 0; i < JBrowser.this.getListColumnCount() - 1; ++i) {
                        if (JBrowser.this.focusedList != JBrowser.this.getColumnList(i)) continue;
                        childColumnList = JBrowser.this.getColumnList(i + 1);
                        break;
                    }
                }
                if (childColumnList == null) {
                    childColumnList = JBrowser.this.getColumnList(JBrowser.this.getListColumnCount() - 1);
                }
                childColumnList.requestFocus();
                if (((JList)childColumnList).getModel().getSize() != 0) {
                    evt.consume();
                    ((JList)childColumnList).setSelectedIndex(0);
                    TreePath selectionPath = ((ColumnListModel)((JList)childColumnList).getModel()).path.pathByAddingChild(((JList)childColumnList).getSelectedValue());
                    JBrowser.this.selectionModel.setSelectionPath(JBrowser.this.maybeExtendPath(selectionPath));
                }
            } else if ((evt.getModifiersEx() & 0x380) == 0 && !IGNORED_KEY_CODES.contains(evt.getKeyCode())) {
                int[] selectedIndices = columnList.getSelectedIndices();
                if (selectedIndices.length == 0) {
                    leadPath = columnModel.path;
                    JBrowser.this.selectionModel.setSelectionPath(leadPath);
                    if (JBrowser.this.getListColumnCount() > 1) {
                        JBrowser.this.getColumnList(JBrowser.this.getListColumnCount() - 2).requestFocus();
                    }
                } else if (selectedIndices.length == 1) {
                    leadPath = columnPath.pathByAddingChild(columnList.getSelectedValue());
                    JBrowser.this.selectionModel.setSelectionPath(JBrowser.this.maybeExtendPath(leadPath));
                } else {
                    leadPath = columnPath.pathByAddingChild(columnModel.getElementAt(columnList.getLeadSelectionIndex()));
                    TreePath[] paths = new TreePath[selectedIndices.length];
                    int leadPathIndex = -1;
                    for (int i2 = 0; i2 < selectedIndices.length; ++i2) {
                        paths[i2] = columnModel.path.pathByAddingChild(columnModel.getElementAt(selectedIndices[i2]));
                        if (!paths[i2].equals(leadPath)) continue;
                        leadPathIndex = i2;
                    }
                    paths[leadPathIndex] = paths[paths.length - 1];
                    paths[paths.length - 1] = leadPath;
                    JBrowser.this.selectionModel.setSelectionPaths(paths);
                }
            } else {
                SwingUtilities.invokeLater(() -> JBrowser.this.updateExpandedState(columnList));
            }
            if (!evt.isConsumed()) {
                KeyListener[] kl = JBrowser.this.getKeyListeners();
                for (i = 0; i < kl.length; ++i) {
                    kl[i].keyReleased(evt);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            if (!evt.isConsumed()) {
                KeyListener[] kl = JBrowser.this.getKeyListeners();
                for (int i = 0; i < kl.length; ++i) {
                    kl[i].keyTyped(evt);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (!evt.isConsumed()) {
                KeyListener[] kl = JBrowser.this.getKeyListeners();
                for (int i = 0; i < kl.length; ++i) {
                    kl[i].keyPressed(evt);
                }
            }
        }
    }

    private class ColumnFocusListener
    implements FocusListener {
        private ColumnFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JBrowser.this.putClientProperty("Quaqua.drawFocusBorder", Boolean.TRUE);
            JBrowser.this.repaintParentBorder();
            JBrowser.this.focusedList = (JList)e.getComponent();
            JBrowser.this.visibleFocusTimer.restart();
        }

        @Override
        public void focusLost(FocusEvent e) {
            JBrowser.this.putClientProperty("Quaqua.drawFocusBorder", Boolean.FALSE);
            JBrowser.this.repaintParentBorder();
        }
    }

    private class ColumnListModel
    extends AbstractListModel
    implements TreeModelListener {
        private TreePath path;
        private TreeModel model;
        private int size;

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('{');
            int n = this.getSize();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(this.getElementAt(i));
            }
            buf.append("} #");
            buf.append(this.hashCode());
            return buf.toString();
        }

        public ColumnListModel(TreePath path, TreeModel model) {
            this.path = path;
            this.model = model;
            model.addTreeModelListener(this);
            this.updateSize();
        }

        public void setPath(TreePath newValue) {
            if (newValue != this.path) {
                int oldSize = this.getSize();
                this.path = newValue;
                this.updateSize();
                int newSize = this.getSize();
                if (Math.min(oldSize, newSize) > 0) {
                    this.fireContentsChanged(this, Math.min(oldSize, newSize), Math.min(oldSize, newSize));
                }
                if (newSize < oldSize) {
                    this.fireIntervalRemoved(this, newSize, oldSize - 1);
                } else if (newSize > oldSize) {
                    this.fireIntervalAdded(this, oldSize, newSize - 1);
                }
            }
        }

        public void dispose() {
            this.model.removeTreeModelListener(this);
        }

        @Override
        public int getSize() {
            return this.size;
        }

        private void updateSize() {
            this.size = this.model.getChildCount(this.path.getLastPathComponent());
        }

        @Override
        public Object getElementAt(int row) {
            return this.model.getChild(this.path.getLastPathComponent(), row);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (e.getTreePath().equals(this.path)) {
                int[] indices = e.getChildIndices();
                this.fireContentsChanged(this, indices[0], indices[indices.length - 1]);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            if (e.getTreePath().equals(this.path)) {
                int end;
                this.updateSize();
                int[] indices = e.getChildIndices();
                Arrays.sort(indices);
                int start = 0;
                do {
                    int startIndex = indices[start];
                    for (end = start + 1; end < indices.length && indices[end] == startIndex + end - start; ++end) {
                    }
                    this.fireIntervalAdded(this, startIndex, indices[end - 1]);
                } while ((start = end) < indices.length);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (e.getTreePath().equals(this.path)) {
                int end;
                this.updateSize();
                int[] indices = (int[])e.getChildIndices().clone();
                Arrays.sort(indices);
                int start = 0;
                int offset = 0;
                do {
                    int startIndex = indices[start];
                    for (end = start + 1; end < indices.length && indices[end] == startIndex + end - start; ++end) {
                    }
                    this.fireIntervalRemoved(this, startIndex - offset, indices[end - 1] - offset);
                    offset += indices[end - 1] - startIndex + 1;
                } while ((start = end) < indices.length);
                if (JBrowser.this.selectionModel.getSelectionCount() > 0) {
                    TreePath[] selectionPaths = JBrowser.this.selectionModel.getSelectionPaths();
                    Object[] removedChildren = e.getChildren();
                    for (int i = 0; i < removedChildren.length; ++i) {
                        TreePath removedPath = e.getTreePath().pathByAddingChild(removedChildren[i]);
                        for (int j = 0; j < selectionPaths.length; ++j) {
                            if (!removedPath.isDescendant(selectionPaths[j])) continue;
                            selectionPaths[j] = e.getTreePath();
                        }
                    }
                    JBrowser.this.setSelectionPaths(selectionPaths);
                }
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreePath changedPath = e.getTreePath();
            if (changedPath.equals(this.path) || this.path.getPathCount() == 1 && changedPath.getPathCount() == 1) {
                int oldSize = this.getSize();
                this.path = changedPath;
                this.updateSize();
                int newSize = this.getSize();
                this.path = changedPath;
                int diff = newSize - oldSize;
                if (diff < 0) {
                    if (newSize > 0) {
                        this.fireContentsChanged(this, 0, newSize - 1);
                    }
                    this.fireIntervalRemoved(this, newSize, oldSize - 1);
                } else if (diff > 0) {
                    if (oldSize > 0) {
                        this.fireContentsChanged(this, 0, oldSize - 1);
                    }
                    this.fireIntervalAdded(this, oldSize, newSize - 1);
                } else {
                    this.fireContentsChanged(this, 0, oldSize - 1);
                }
                JBrowser.this.setSelectionPath(changedPath);
            }
        }
    }

    protected class SizeHandle
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        protected int column;
        protected int startMouseX;
        protected int startWidth;
        private int gripDotCount;
        private int gripDotSize;
        private int gripGap;
        private Color gripColor;
        private static final int WIDTH = 11;
        private static final int HEIGHT = 22;

        public SizeHandle(int column) {
            this.column = column;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setOpaque(true);
            this.updateUI();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(11, 22);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.gripDotCount = UIManager.getInt("SplitPaneDivider.gripDotCount");
            this.gripDotSize = UIManager.getInt("SplitPaneDivider.gripDotSize");
            this.gripGap = UIManager.getInt("SplitPaneDivider.gripGap");
            this.gripColor = UIManager.getColor("SplitPaneDivider.gripColor");
            this.setBackground(UIManager.getColor("ScrollBar.track"));
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g);
            g.setColor(this.gripColor);
            FlatUIUtils.resetRenderingHints(g, oldRenderingHints);
            FlatUIUtils.paintGrip(g, 0, 0, 11, 22, false, this.gripDotCount, this.gripDotSize, this.gripGap, true);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.startMouseX >= 0) {
                int mouseX = this.toScreenX(e.getPoint());
                int difX = mouseX - this.startMouseX;
                if (this.column < 0) {
                    JBrowser.this.setPreviewColumnWidth(Math.max(this.startWidth + difX, JBrowser.this.getMinimumCellWidth()));
                } else {
                    JBrowser.this.setColumnWidth(this.column, Math.max(this.startWidth + difX, JBrowser.this.getMinimumCellWidth()));
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && this.column >= 0) {
                JBrowser.this.setColumnWidth(this.column, Math.max(JBrowser.this.minimumCellWidth, JBrowser.this.getPreferredColumnWidth(this.column)));
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startMouseX = this.toScreenX(e.getPoint());
            this.startWidth = this.column < 0 ? JBrowser.this.getPreviewColumnWidth() : JBrowser.this.getColumnWidth(this.column);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.startMouseX >= 0) {
                int mouseX = this.toScreenX(e.getPoint());
                int difX = mouseX - this.startMouseX;
                if (this.column < 0) {
                    JBrowser.this.setPreviewColumnWidth(Math.max(this.startWidth + difX, JBrowser.this.getMinimumCellWidth()));
                } else {
                    JBrowser.this.setColumnWidth(this.column, Math.max(this.startWidth + difX, JBrowser.this.getMinimumCellWidth()));
                }
            }
            this.startMouseX = -1;
        }

        private int toScreenX(Point p) {
            SwingUtilities.convertPointToScreen(p, this);
            return p.x;
        }
    }

    private class BrowserCellRendererWrapper
    extends JPanel
    implements ListCellRenderer {
        private BrowserCellRenderer browserCellRenderer;
        private Component browserCellRendererComponent;
        private JLabel arrowLabel;
        private EmptyBorder noFocusBorder;
        protected Icon expandedIcon = null;
        protected Icon selectedExpandedIcon = null;
        protected Icon focusedSelectedExpandedIcon = null;

        public BrowserCellRendererWrapper(BrowserCellRenderer treeCellRenderer) {
            this.browserCellRenderer = treeCellRenderer;
            this.selectedExpandedIcon = UIManager.getIcon("Browser.selectedExpandedIcon");
            this.expandedIcon = FlatLaf.isLafDark() ? Icons.getDarkerIcon(this, this.selectedExpandedIcon) : UIManager.getIcon("Browser.expandedIcon");
            this.focusedSelectedExpandedIcon = UIManager.getIcon("Browser.focusedSelectedExpandedIcon");
            this.noFocusBorder = new EmptyBorder(this.getFocusedBorder().getBorderInsets(this));
            this.setLayout(new BorderLayout());
            this.arrowLabel = new JLabel(){

                @Override
                public void validate() {
                }

                @Override
                public void revalidate() {
                }

                @Override
                public void repaint(long tm, int x, int y, int width, int height) {
                }

                @Override
                public void repaint(Rectangle r) {
                }

                @Override
                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                    if ("text".equals(propertyName)) {
                        super.firePropertyChange(propertyName, oldValue, newValue);
                    }
                }

                @Override
                public void firePropertyChange(String propertyName, short oldValue, short newValue) {
                }

                @Override
                public void firePropertyChange(String propertyName, int oldValue, int newValue) {
                }

                @Override
                public void firePropertyChange(String propertyName, long oldValue, long newValue) {
                }

                @Override
                public void firePropertyChange(String propertyName, float oldValue, float newValue) {
                }

                @Override
                public void firePropertyChange(String propertyName, double oldValue, double newValue) {
                }

                @Override
                public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
                }
            };
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
            this.arrowLabel.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
            this.arrowLabel.setIcon(this.expandedIcon);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            boolean isFocused = list.isFocusOwner();
            boolean isLeaf = JBrowser.this.getModel().isLeaf(value);
            if (isSelected) {
                Color background = !isFocused && UIManager.getColor("List.selectionInactiveBackground") != null ? UIManager.getColor("List.selectionInactiveBackground") : list.getSelectionBackground();
                this.setBackground(background);
                Color foreground = !isFocused && UIManager.getColor("List.selectionInactiveForeground") != null ? UIManager.getColor("List.selectionInactiveForeground") : list.getSelectionForeground();
                this.arrowLabel.setForeground(foreground);
                this.arrowLabel.setIcon(isFocused ? this.focusedSelectedExpandedIcon : this.selectedExpandedIcon);
            } else {
                this.setBackground(list.getBackground());
                Color foreground = list.getForeground();
                this.arrowLabel.setForeground(foreground);
                this.arrowLabel.setIcon(this.expandedIcon);
            }
            this.arrowLabel.setVisible(!isLeaf);
            boolean isExpanded = false;
            int n = JBrowser.this.expandedPath.getPathCount();
            for (int i = 0; i < n; ++i) {
                if (JBrowser.this.expandedPath.getPathComponent(i) != value) continue;
                isExpanded = true;
                break;
            }
            this.browserCellRendererComponent = this.browserCellRenderer.getBrowserCellRendererComponent(JBrowser.this, value, isSelected, isExpanded, isLeaf, index, isFocused && isSelected);
            this.removeAll();
            this.add(this.browserCellRendererComponent, "Center");
            this.add((Component)this.arrowLabel, "East");
            Border cellBorder = cellHasFocus ? this.getFocusedBorder() : this.noFocusBorder;
            this.setBorder(cellBorder);
            return this;
        }

        private Border getFocusedBorder() {
            return new FixNullBorderInsetsBug(UIManager.getBorder("List.focusCellHighlightBorder"));
        }

        @Override
        public void setFont(Font newValue) {
            super.setFont(newValue);
            if (this.browserCellRendererComponent != null) {
                this.browserCellRendererComponent.setFont(newValue);
            }
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    protected static class BrowserScrollPaneLayout
    extends QuaquaScrollPaneLayout {
        protected BrowserScrollPaneLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean hsbVisible;
            super.layoutContainer(parent);
            boolean cornerVisible = this.lowerRight != null && this.lowerRight.isVisible();
            boolean vsbVisible = this.vsb != null && this.vsb.isVisible();
            boolean bl = hsbVisible = this.hsb != null && this.hsb.isVisible();
            if (cornerVisible && vsbVisible && !hsbVisible) {
                Dimension cornerDim = this.lowerRight.getPreferredSize();
                Dimension vsbDim = this.vsb.getSize();
                this.vsb.setSize(vsbDim.width, vsbDim.height - cornerDim.height);
                this.lowerRight.setBounds(this.vsb.getX(), this.vsb.getY() + this.vsb.getHeight(), vsbDim.width, cornerDim.height);
            }
        }
    }

    private static class ColumnSelectionModel
    implements ListSelectionModel,
    Cloneable,
    Serializable {
        private static final int MIN = -1;
        private static final int MAX = Integer.MAX_VALUE;
        private int selectionMode = 2;
        private int minIndex = Integer.MAX_VALUE;
        private int maxIndex = -1;
        private int anchorIndex = -1;
        private int leadIndex = -1;
        private int firstAdjustedIndex = Integer.MAX_VALUE;
        private int lastAdjustedIndex = -1;
        private boolean isAdjusting = false;
        private int firstChangedIndex = Integer.MAX_VALUE;
        private int lastChangedIndex = -1;
        private BitSet value = new BitSet(32);
        protected EventListenerList listenerList = new EventListenerList();
        protected boolean leadAnchorNotificationEnabled = true;

        private ColumnSelectionModel() {
        }

        @Override
        public int getMinSelectionIndex() {
            return this.isSelectionEmpty() ? -1 : this.minIndex;
        }

        @Override
        public int getMaxSelectionIndex() {
            return this.maxIndex;
        }

        @Override
        public boolean getValueIsAdjusting() {
            return this.isAdjusting;
        }

        @Override
        public int getSelectionMode() {
            return this.selectionMode;
        }

        @Override
        public void setSelectionMode(int selectionMode) {
            switch (selectionMode) {
                case 0: 
                case 1: 
                case 2: {
                    this.selectionMode = selectionMode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid selectionMode");
                }
            }
        }

        @Override
        public boolean isSelectedIndex(int index) {
            return index < this.minIndex || index > this.maxIndex ? false : this.value.get(index);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.minIndex > this.maxIndex;
        }

        @Override
        public void addListSelectionListener(ListSelectionListener l) {
            this.listenerList.add(ListSelectionListener.class, l);
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener l) {
            this.listenerList.remove(ListSelectionListener.class, l);
        }

        protected void fireValueChanged(boolean isAdjusting) {
            if (this.lastChangedIndex == -1) {
                return;
            }
            int oldFirstChangedIndex = this.firstChangedIndex;
            int oldLastChangedIndex = this.lastChangedIndex;
            this.firstChangedIndex = Integer.MAX_VALUE;
            this.lastChangedIndex = -1;
            this.fireValueChanged(oldFirstChangedIndex, oldLastChangedIndex, isAdjusting);
        }

        protected void fireValueChanged(int firstIndex, int lastIndex) {
            this.fireValueChanged(firstIndex, lastIndex, this.getValueIsAdjusting());
        }

        protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
            Object[] listeners = this.listenerList.getListenerList();
            ListSelectionEvent e = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListSelectionListener.class) continue;
                if (e == null) {
                    e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
                }
                ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
            }
        }

        private void fireValueChanged() {
            if (this.lastAdjustedIndex == -1) {
                return;
            }
            if (this.getValueIsAdjusting()) {
                this.firstChangedIndex = Math.min(this.firstChangedIndex, this.firstAdjustedIndex);
                this.lastChangedIndex = Math.max(this.lastChangedIndex, this.lastAdjustedIndex);
            }
            int oldFirstAdjustedIndex = this.firstAdjustedIndex;
            int oldLastAdjustedIndex = this.lastAdjustedIndex;
            this.firstAdjustedIndex = Integer.MAX_VALUE;
            this.lastAdjustedIndex = -1;
            this.fireValueChanged(oldFirstAdjustedIndex, oldLastAdjustedIndex);
        }

        private void markAsDirty(int r) {
            this.firstAdjustedIndex = Math.min(this.firstAdjustedIndex, r);
            this.lastAdjustedIndex = Math.max(this.lastAdjustedIndex, r);
        }

        private void set(int r) {
            if (this.value.get(r)) {
                return;
            }
            this.value.set(r);
            this.markAsDirty(r);
            this.minIndex = Math.min(this.minIndex, r);
            this.maxIndex = Math.max(this.maxIndex, r);
        }

        private void clear(int r) {
            if (!this.value.get(r)) {
                return;
            }
            this.value.clear(r);
            this.markAsDirty(r);
            if (r == this.minIndex) {
                ++this.minIndex;
                while (this.minIndex <= this.maxIndex && !this.value.get(this.minIndex)) {
                    ++this.minIndex;
                }
            }
            if (r == this.maxIndex) {
                --this.maxIndex;
                while (this.minIndex <= this.maxIndex && !this.value.get(this.maxIndex)) {
                    --this.maxIndex;
                }
            }
            if (this.isSelectionEmpty()) {
                this.minIndex = Integer.MAX_VALUE;
                this.maxIndex = -1;
            }
        }

        private void updateLeadAnchorIndices(int anchorIndex, int leadIndex) {
            if (this.leadAnchorNotificationEnabled) {
                if (this.anchorIndex != anchorIndex) {
                    if (this.anchorIndex != -1) {
                        this.markAsDirty(this.anchorIndex);
                    }
                    this.markAsDirty(anchorIndex);
                }
                if (this.leadIndex != leadIndex) {
                    if (this.leadIndex != -1) {
                        this.markAsDirty(this.leadIndex);
                    }
                    this.markAsDirty(leadIndex);
                }
            }
            this.anchorIndex = anchorIndex;
            this.leadIndex = leadIndex;
        }

        private boolean contains(int a, int b, int i) {
            return i >= a && i <= b;
        }

        private void changeSelection(int clearMin, int clearMax, int setMin, int setMax, boolean clearFirst) {
            for (int i = Math.min(setMin, clearMin); i <= Math.max(setMax, clearMax); ++i) {
                boolean shouldClear = this.contains(clearMin, clearMax, i);
                boolean shouldSet = this.contains(setMin, setMax, i);
                if (shouldSet && shouldClear) {
                    if (clearFirst) {
                        shouldClear = false;
                    } else {
                        shouldSet = false;
                    }
                }
                if (shouldSet) {
                    this.set(i);
                }
                if (!shouldClear) continue;
                this.clear(i);
            }
            this.fireValueChanged();
        }

        private void changeSelection(int clearMin, int clearMax, int setMin, int setMax) {
            this.changeSelection(clearMin, clearMax, setMin, setMax, true);
        }

        @Override
        public void clearSelection() {
            this.removeSelectionInterval(this.minIndex, this.maxIndex);
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (index0 == -1 || index1 == -1) {
                return;
            }
            if (this.getSelectionMode() == 0) {
                index0 = index1;
            }
            this.updateLeadAnchorIndices(index0, index1);
            int clearMin = this.minIndex;
            int clearMax = this.maxIndex;
            int setMin = Math.min(index0, index1);
            int setMax = Math.max(index0, index1);
            this.changeSelection(clearMin, clearMax, setMin, setMax);
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            if (index0 == -1 || index1 == -1) {
                return;
            }
            if (this.getSelectionMode() != 2) {
                this.setSelectionInterval(index0, index1);
                return;
            }
            this.updateLeadAnchorIndices(index0, index1);
            int clearMin = Integer.MAX_VALUE;
            int clearMax = -1;
            int setMin = Math.min(index0, index1);
            int setMax = Math.max(index0, index1);
            this.changeSelection(clearMin, clearMax, setMin, setMax);
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            if (index0 == -1 || index1 == -1) {
                return;
            }
            this.updateLeadAnchorIndices(index0, index1);
            int clearMin = Math.min(index0, index1);
            int clearMax = Math.max(index0, index1);
            int setMin = Integer.MAX_VALUE;
            int setMax = -1;
            if (this.getSelectionMode() != 2 && clearMin > this.minIndex && clearMax < this.maxIndex) {
                clearMax = this.maxIndex;
            }
            this.changeSelection(clearMin, clearMax, setMin, setMax);
        }

        private void setState(int index, boolean state) {
            if (state) {
                this.set(index);
            } else {
                this.clear(index);
            }
        }

        @Override
        public void insertIndexInterval(int index, int length, boolean before) {
            if (length < 0) {
                throw new IllegalArgumentException("Length < 0: " + length);
            }
            if (index < 0) {
                throw new IllegalArgumentException("Index < 0: " + index);
            }
            if (length == 0) {
                return;
            }
            int insMinIndex = before ? index : index + 1;
            int insMaxIndex = insMinIndex + length - 1;
            for (int i = this.maxIndex; i >= insMinIndex; --i) {
                this.setState(i + length, this.value.get(i));
            }
            boolean setInsertedValues = false;
            for (int i = insMinIndex; i <= insMaxIndex; ++i) {
                this.setState(i, setInsertedValues);
            }
            if (index <= this.leadIndex) {
                this.leadIndex += length;
            }
            this.fireValueChanged();
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
            int rmMinIndex = Math.min(index0, index1);
            int rmMaxIndex = Math.max(index0, index1);
            int gapLength = rmMaxIndex - rmMinIndex + 1;
            for (int i = rmMinIndex; i <= this.maxIndex; ++i) {
                this.setState(i, this.value.get(i + gapLength));
            }
            if (this.leadIndex >= index1) {
                this.leadIndex = this.leadIndex - (index1 - index0) - 1;
            } else if (this.leadIndex >= index0) {
                this.leadIndex = index0;
            }
            this.fireValueChanged();
        }

        @Override
        public void setValueIsAdjusting(boolean isAdjusting) {
            if (isAdjusting != this.isAdjusting) {
                this.isAdjusting = isAdjusting;
                this.fireValueChanged(isAdjusting);
            }
        }

        public String toString() {
            String s = (this.getValueIsAdjusting() ? "~" : "=") + this.value.toString();
            return this.getClass().getName() + " " + Integer.toString(this.hashCode()) + " " + s;
        }

        public Object clone() throws CloneNotSupportedException {
            ColumnSelectionModel clone = (ColumnSelectionModel)super.clone();
            clone.value = (BitSet)this.value.clone();
            clone.listenerList = new EventListenerList();
            return clone;
        }

        @Override
        public int getAnchorSelectionIndex() {
            return this.anchorIndex;
        }

        @Override
        public int getLeadSelectionIndex() {
            return this.leadIndex;
        }

        @Override
        public void setAnchorSelectionIndex(int anchorIndex) {
            this.updateLeadAnchorIndices(anchorIndex, this.leadIndex);
            this.anchorIndex = anchorIndex;
            this.fireValueChanged();
        }

        @Override
        public void setLeadSelectionIndex(int leadIndex) {
            int anchorIndex = this.anchorIndex;
            if (anchorIndex == -1 || leadIndex == -1) {
                return;
            }
            if (this.leadIndex == -1) {
                this.leadIndex = leadIndex;
            }
            boolean shouldSelect = this.value.get(this.anchorIndex);
            if (this.getSelectionMode() == 0) {
                anchorIndex = leadIndex;
                shouldSelect = true;
            }
            int oldMin = Math.min(this.anchorIndex, this.leadIndex);
            int oldMax = Math.max(this.anchorIndex, this.leadIndex);
            int newMin = Math.min(anchorIndex, leadIndex);
            int newMax = Math.max(anchorIndex, leadIndex);
            this.updateLeadAnchorIndices(anchorIndex, leadIndex);
            if (shouldSelect) {
                this.changeSelection(oldMin, oldMax, newMin, newMax);
            } else {
                this.changeSelection(newMin, newMax, oldMin, oldMax, false);
            }
        }
    }

    protected static class BrowserLayout
    implements LayoutManager {
        private int preferredWidth = 0;
        private int preferredHeight = 0;
        private boolean sizeUnknown = true;

        protected BrowserLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        private void setSizes(Container parent) {
            int nComps = parent.getComponentCount();
            Dimension d = null;
            this.preferredWidth = 0;
            this.preferredHeight = 0;
            for (int i = 0; i < nComps; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                d = c.getPreferredSize();
                this.preferredWidth += d.width;
                this.preferredHeight = Math.max(this.preferredHeight, d.height);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            this.setSizes(parent);
            Insets insets = parent.getInsets();
            dim.width = this.preferredWidth + insets.left + insets.right;
            dim.height = this.preferredHeight + insets.top + insets.bottom;
            this.sizeUnknown = false;
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int maxHeight = parent.getHeight() - (insets.top + insets.bottom);
            int nComps = parent.getComponentCount();
            int previousWidth = 0;
            int x = insets.left;
            int y = insets.top;
            if (this.sizeUnknown) {
                this.setSizes(parent);
            }
            for (int i = 0; i < nComps; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getPreferredSize();
                d.height = maxHeight;
                c.setBounds(x += previousWidth, y, d.width, d.height);
                previousWidth = d.width;
            }
        }
    }

    private static class FixNullBorderInsetsBug
    implements Border {
        private final Border border;

        public FixNullBorderInsetsBug(Border border) {
            this.border = border;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets borderInsets = this.border.getBorderInsets(c);
            if (borderInsets == null) {
                borderInsets = new Insets(0, 0, 0, 0);
            }
            return borderInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return this.border.isBorderOpaque();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.border.paintBorder(c, g, x, y, width, height);
        }
    }
}

