/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.browser;

import com.formdev.flatlaf.FlatLaf;
import com.scythebill.birdlist.ui.components.browser.JBrowser;
import com.scythebill.birdlist.ui.util.Icons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class DefaultColumnCellRenderer
implements ListCellRenderer {
    private JPanel panel;
    private JLabel textLabel;
    private JLabel arrowLabel;
    private EmptyBorder noFocusBorder;
    private JBrowser browser;
    protected Icon expandedIcon = null;
    protected Icon selectedExpandedIcon = null;
    protected Icon focusedSelectedExpandedIcon = null;
    protected Icon expandingIcon = null;

    public DefaultColumnCellRenderer(JBrowser browser) {
        this.browser = browser;
        this.selectedExpandedIcon = UIManager.getIcon("Browser.selectedExpandedIcon");
        this.expandedIcon = FlatLaf.isLafDark() ? Icons.getDarkerIcon(browser, this.selectedExpandedIcon) : UIManager.getIcon("Browser.expandedIcon");
        this.focusedSelectedExpandedIcon = UIManager.getIcon("Browser.focusedSelectedExpandedIcon");
        if (this.expandedIcon == null) {
            // empty if block
        }
        this.noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        this.panel = new JPanel(new BorderLayout()){

            @Override
            public void revalidate() {
            }

            @Override
            public void repaint(long tm, int x, int y, int width, int height) {
            }

            @Override
            public void repaint(Rectangle r) {
            }

            @Override
            protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, short oldValue, short newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, int oldValue, int newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, long oldValue, long newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, float oldValue, float newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, double oldValue, double newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
            }
        };
        this.textLabel = new JLabel(){

            @Override
            public void validate() {
            }

            @Override
            public void revalidate() {
            }

            @Override
            public void repaint(long tm, int x, int y, int width, int height) {
            }

            @Override
            public void repaint(Rectangle r) {
            }

            @Override
            protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                if ("text".equals(propertyName)) {
                    super.firePropertyChange(propertyName, oldValue, newValue);
                }
            }

            @Override
            public void firePropertyChange(String propertyName, short oldValue, short newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, int oldValue, int newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, long oldValue, long newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, float oldValue, float newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, double oldValue, double newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
            }
        };
        this.arrowLabel = new JLabel(){

            @Override
            public void validate() {
            }

            @Override
            public void revalidate() {
            }

            @Override
            public void repaint(long tm, int x, int y, int width, int height) {
            }

            @Override
            public void repaint(Rectangle r) {
            }

            @Override
            protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                if ("text".equals(propertyName)) {
                    super.firePropertyChange(propertyName, oldValue, newValue);
                }
            }

            @Override
            public void firePropertyChange(String propertyName, short oldValue, short newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, int oldValue, int newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, long oldValue, long newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, float oldValue, float newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, double oldValue, double newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
            }
        };
        this.panel.setOpaque(true);
        this.panel.setBorder(this.noFocusBorder);
        this.textLabel.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        this.arrowLabel.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        this.panel.add((Component)this.textLabel, "Center");
        this.arrowLabel.setIcon(this.expandedIcon);
        this.panel.add((Component)this.arrowLabel, "East");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        boolean isFocused = list.isFocusOwner();
        if (isSelected) {
            this.panel.setBackground(list.getSelectionBackground());
            Color foreground = !isFocused && UIManager.getColor("List.inactiveSelectionForeground") != null ? UIManager.getColor("List.inactiveSelectionForeground") : list.getSelectionForeground();
            this.textLabel.setForeground(foreground);
            this.arrowLabel.setForeground(foreground);
            this.arrowLabel.setIcon(isFocused ? this.focusedSelectedExpandedIcon : this.selectedExpandedIcon);
        } else {
            this.panel.setBackground(list.getBackground());
            Color foreground = list.getForeground();
            this.textLabel.setForeground(foreground);
            this.arrowLabel.setForeground(foreground);
            this.arrowLabel.setIcon(this.expandedIcon);
        }
        this.textLabel.setText(value == null ? "null" : value.toString());
        this.arrowLabel.setVisible(!this.browser.getModel().isLeaf(value));
        this.textLabel.setEnabled(list.isEnabled());
        this.textLabel.setFont(list.getFont());
        this.panel.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
        return this.panel;
    }

    public static class UIResource
    extends DefaultColumnCellRenderer
    implements javax.swing.plaf.UIResource {
        public UIResource(JBrowser browser) {
            super(browser);
        }
    }
}

