/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.text.NumberFormatter;

public final class YearFormatter
extends NumberFormatter {
    public YearFormatter() {
        super(new DecimalFormat("00"));
        this.setValueClass(Integer.class);
        this.setMinimum(Integer.valueOf(0));
        this.setMaximum(Integer.valueOf(2100));
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        if (Strings.isNullOrEmpty(text)) {
            return null;
        }
        Integer value = (Integer)super.stringToValue(text);
        if (value != null && value >= 0 && value < 100) {
            value = value < 50 ? Integer.valueOf(value + 2000) : Integer.valueOf(value + 1900);
        }
        return value;
    }
}

