/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.query.SyntheticLocations;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;

public class WherePanelIndexers
implements ToString<Object> {
    private final LocationSet locations;
    private final PredefinedLocations predefinedLocations;
    private String nullName;
    private Indexer<Object> primaryIndexer;
    private Indexer<Object> secondaryIndexer;
    private SyntheticLocations syntheticLocations;

    public WherePanelIndexers(LocationSet locations, @Nullable PredefinedLocations predefinedLocations, boolean addNullName, @Nullable String nullName, Predicate<Location> locationFilter, @Nullable SyntheticLocations syntheticLocations) {
        this.locations = locations;
        this.predefinedLocations = predefinedLocations;
        this.syntheticLocations = syntheticLocations;
        this.nullName = MoreObjects.firstNonNull(nullName, Messages.getMessage(Messages.Name.WORLD_TEXT));
        this.primaryIndexer = this.createIndexer(addNullName, locationFilter);
        this.secondaryIndexer = this.createSecondaryIndexer(locationFilter);
    }

    public void reindex(boolean addNullName, Predicate<Location> locationFilter) {
        this.primaryIndexer = this.createIndexer(addNullName, locationFilter);
        this.secondaryIndexer = this.createSecondaryIndexer(locationFilter);
    }

    public void configureIndexer(IndexerPanel<Object> indexerPanel) {
        indexerPanel.removeAllIndexerGroups();
        indexerPanel.addIndexerGroup(this, this.primaryIndexer);
        indexerPanel.addIndexerGroup(this, this.secondaryIndexer);
    }

    private Indexer<Object> createIndexer(boolean addNullName, Predicate<Location> locationFilter) {
        Indexer<Object> index = new Indexer<Object>();
        index.setAlternateIndexEntries(LocationIdToString.ALTERNATE_INDEX_ENTRIES);
        for (Location loc : this.locations.rootLocations()) {
            this.addToLocationIndex(index, loc, locationFilter);
        }
        if (this.syntheticLocations != null) {
            for (SyntheticLocation location : this.syntheticLocations.locations()) {
                if (!locationFilter.apply(location)) continue;
                index.add(location.getDisplayName(), location);
            }
        }
        if (addNullName) {
            index.add(this.nullName, null);
        }
        return index;
    }

    private Indexer<Object> createSecondaryIndexer(Predicate<Location> locationFilter) {
        Indexer<Object> index = new Indexer<Object>(8);
        index.setAlternateIndexEntries(LocationIdToString.ALTERNATE_INDEX_ENTRIES);
        for (Location loc : this.locations.rootLocations()) {
            this.addSecondaryToLocationIndex(index, loc, locationFilter);
        }
        return index;
    }

    @Override
    public String getString(Object obj) {
        if (obj instanceof IndexedPredefinedLocation) {
            IndexedPredefinedLocation indexed = (IndexedPredefinedLocation)obj;
            return this.nameOfPredefinedLocation(indexed);
        }
        if (obj instanceof SyntheticLocation) {
            SyntheticLocation synthetic = (SyntheticLocation)obj;
            return synthetic.getDisplayName();
        }
        String id = (String)obj;
        String syntheticName = this.getSyntheticName(id);
        if (syntheticName != null) {
            return syntheticName;
        }
        Location loc = this.locations.getLocation(id);
        return LocationIdToString.getString(this.locations, id, true, loc);
    }

    private String nameOfPredefinedLocation(IndexedPredefinedLocation indexed) {
        if (indexed.predefinedLocation.getType() == Location.Type.county) {
            return String.format("%s (%s)", indexed.predefinedLocation.getName(), Messages.getMessage(Messages.Name.LOCATION_TYPE_COUNTY));
        }
        return indexed.predefinedLocation.getName();
    }

    @Override
    public String getPreviewString(Object obj) {
        if (obj instanceof IndexedPredefinedLocation) {
            IndexedPredefinedLocation indexed = (IndexedPredefinedLocation)obj;
            return String.format("%s, %s", this.nameOfPredefinedLocation(indexed), LocationIdToString.getString(this.locations, indexed.parent.getId(), true, null));
        }
        if (obj instanceof SyntheticLocation) {
            SyntheticLocation synthetic = (SyntheticLocation)obj;
            return synthetic.getDisplayName();
        }
        String id = (String)obj;
        String syntheticName = this.getSyntheticName(id);
        if (syntheticName != null) {
            return syntheticName;
        }
        return LocationIdToString.getString(this.locations, id, true, null);
    }

    @Nullable
    private String getSyntheticName(String id) {
        if (id == null) {
            return this.nullName;
        }
        return null;
    }

    private void addToLocationIndex(Indexer<Object> index, Location loc, Predicate<Location> locationFilter) {
        if (locationFilter.apply(loc)) {
            index.add(loc.getDisplayName(), loc.getId());
        }
        for (Location child : loc.contents()) {
            this.addToLocationIndex(index, child, locationFilter);
        }
    }

    private void addSecondaryToLocationIndex(Indexer<Object> index, Location loc, Predicate<Location> locationFilter) {
        if (locationFilter.apply(loc)) {
            if (!loc.getModelName().equals(loc.getDisplayName())) {
                index.add(loc.getModelName(), loc.getId());
                if (loc.getParent() != null && loc.getType() != Location.Type.country) {
                    index.add(loc.getModelName() + " " + loc.getParent().getModelName(), loc.getId());
                }
            }
            if (loc.getParent() != null && loc.getType() != Location.Type.country) {
                index.add(loc.getDisplayName() + " " + loc.getParent().getDisplayName(), loc.getId());
            }
        }
        for (Location child : loc.contents()) {
            this.addSecondaryToLocationIndex(index, child, locationFilter);
        }
        if (this.predefinedLocations != null) {
            for (PredefinedLocations.PredefinedLocation predefinedLocation : this.predefinedLocations.getPredefinedLocations(loc)) {
                if (this.locations.getLocationByCode(predefinedLocation.getCode()) != null || !locationFilter.apply(predefinedLocation.create(this.locations, loc))) continue;
                IndexedPredefinedLocation indexed = new IndexedPredefinedLocation(loc, predefinedLocation);
                String name = predefinedLocation.getName();
                index.add(name, indexed);
                index.add(name + " " + loc.getDisplayName(), indexed);
            }
        }
    }

    public void remove(Location oldLocation) {
        Preconditions.checkState(oldLocation.getId() != null);
        this.primaryIndexer.remove(oldLocation.getDisplayName(), oldLocation.getId());
        if (oldLocation.getParent() != null && oldLocation.getType() != Location.Type.country) {
            this.secondaryIndexer.remove(oldLocation.getDisplayName() + " " + oldLocation.getParent().getDisplayName(), oldLocation.getId());
        }
        if (!oldLocation.getModelName().equals(oldLocation.getDisplayName())) {
            this.secondaryIndexer.remove(oldLocation.getModelName(), oldLocation.getId());
            if (oldLocation.getParent() != null && oldLocation.getType() != Location.Type.country) {
                this.secondaryIndexer.remove(oldLocation.getModelName() + " " + oldLocation.getParent().getModelName(), oldLocation.getId());
            }
        }
    }

    public void add(Location newLocation) {
        this.primaryIndexer.add(newLocation.getDisplayName(), newLocation.getId());
        if (newLocation.getParent() != null && newLocation.getType() != Location.Type.country) {
            this.secondaryIndexer.add(newLocation.getDisplayName() + " " + newLocation.getParent().getDisplayName(), newLocation.getId());
        }
        if (!newLocation.getModelName().equals(newLocation.getDisplayName())) {
            this.secondaryIndexer.add(newLocation.getModelName(), newLocation.getId());
            if (newLocation.getParent() != null && newLocation.getType() != Location.Type.country) {
                this.secondaryIndexer.add(newLocation.getModelName() + " " + newLocation.getParent().getModelName(), newLocation.getId());
            }
        }
    }

    public static Location toLocation(LocationSet locations, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IndexedPredefinedLocation) {
            IndexedPredefinedLocation indexed = (IndexedPredefinedLocation)obj;
            Location maybeAddedByNow = locations.getLocationByCode(indexed.predefinedLocation.getCode());
            if (maybeAddedByNow != null) {
                return maybeAddedByNow;
            }
            return indexed.predefinedLocation.create(locations, indexed.parent);
        }
        if (obj instanceof SyntheticLocation) {
            SyntheticLocation synthetic = (SyntheticLocation)obj;
            return synthetic;
        }
        String id = (String)obj;
        return locations.getLocation(id);
    }

    public Object toIndexerObject(Location location) {
        if (location.getId() != null) {
            return location.getId();
        }
        Location parent = location.getParent();
        if (parent == null) {
            return null;
        }
        PredefinedLocations.PredefinedLocation predefinedLocation = this.predefinedLocations.getPredefinedLocationChildThatHasNotBeenCreatedYet(this.locations, parent, location.getModelName());
        if (predefinedLocation == null) {
            return null;
        }
        return new IndexedPredefinedLocation(parent, predefinedLocation);
    }

    public Collection<Object> getMatches(String name) {
        return this.primaryIndexer.find(name);
    }

    public Object toIndexerObject(String locationId) {
        return locationId;
    }

    static class IndexedPredefinedLocation {
        final Location parent;
        final PredefinedLocations.PredefinedLocation predefinedLocation;

        public IndexedPredefinedLocation(Location parent, PredefinedLocations.PredefinedLocation predefinedLocation) {
            this.parent = parent;
            this.predefinedLocation = predefinedLocation;
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.predefinedLocation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexedPredefinedLocation)) {
                return false;
            }
            IndexedPredefinedLocation that = (IndexedPredefinedLocation)o;
            return Objects.equals(this.parent, that.parent) && Objects.equals(this.predefinedLocation, that.predefinedLocation);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("parent", this.parent).add("predefinedLocation", this.predefinedLocation).toString();
        }
    }
}

