/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.util.DirtyImpl;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.NewLocationDialog;
import com.scythebill.birdlist.ui.components.WherePanelIndexers;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.LocationScorer;
import com.scythebill.birdlist.ui.util.OpenMapUrl;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nullable;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WherePanel
extends JPanel {
    private IndexerPanel<Object> whereIndexerPanel;
    private JLabel whereLabel;
    private final ReportSet reportSet;
    private final PredefinedLocations predefinedLocations;
    private final NewLocationDialog newLocationDialog;
    private JButton newLocation;
    private Location where;
    private DirtyImpl dirty = new DirtyImpl(false);
    private String nullName;
    private WherePanelIndexers whereIndexers;
    private JLabel latLongIcon;
    private static final ImageIcon latLongOriginalSize = new ImageIcon(WherePanel.class.getResource("latlong.png"));
    private final OpenMapUrl openMapUrl;
    private final LocationScorer locationScorer;

    @Inject
    public WherePanel(ReportSet reportSet, NewLocationDialog newLocationDialog, PredefinedLocations predefinedLocations, LocationScorer locationScorer, OpenMapUrl openMapUrl) {
        this(reportSet, newLocationDialog, predefinedLocations, openMapUrl, locationScorer, null);
    }

    public WherePanel(ReportSet reportSet, NewLocationDialog newLocationDialog, PredefinedLocations predefinedLocations, OpenMapUrl openMapUrl, LocationScorer locationScorer, String nullName) {
        this.reportSet = reportSet;
        this.newLocationDialog = newLocationDialog;
        this.predefinedLocations = predefinedLocations;
        this.locationScorer = locationScorer;
        this.nullName = nullName;
        this.openMapUrl = openMapUrl;
        this.initGUI();
        this.hookUpContents();
    }

    public void setWhereLayoutStrategy(IndexerPanel.LayoutStrategy layoutStrategy) {
        this.whereIndexerPanel.setLayoutStrategy(layoutStrategy);
    }

    private void hookUpContents() {
        this.updateIdToString(this.nullName);
        if (this.locationScorer != null) {
            this.whereIndexerPanel.setOrdering(this.locationScorer.ordering());
        }
        this.whereIndexerPanel.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Location location = WherePanelIndexers.toLocation(WherePanel.this.reportSet.getLocations(), event.getNewValue());
                if (location == null) {
                    WherePanel.this.setWhereImpl(null);
                    WherePanel.this.newLocation.setEnabled(!WherePanel.this.whereIndexerPanel.getTextValue().isEmpty());
                } else {
                    WherePanel.this.setWhereImpl(location);
                    WherePanel.this.newLocation.setEnabled(false);
                }
            }
        });
        this.whereIndexerPanel.getTextComponent().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                WherePanel.this.fireWhereTextChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                WherePanel.this.fireWhereTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                WherePanel.this.fireWhereTextChanged();
            }
        });
        this.newLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewLocationDialog.LocationReceiver locationReceiver = new NewLocationDialog.LocationReceiver(){

                    @Override
                    public boolean locationAvailable(Location location) {
                        WherePanel.this.reportSet.getLocations().ensureAdded(location);
                        WherePanel.this.setWhere(location);
                        return true;
                    }
                };
                WherePanel.this.newLocationDialog.newLocation(WherePanel.this.whereIndexerPanel.getTextValue(), SwingUtilities.getWindowAncestor(WherePanel.this), locationReceiver);
            }
        });
        this.latLongIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Location location = WherePanel.this.getWhere();
                if (location == null || !location.getLatLong().isPresent()) {
                    return;
                }
                WherePanel.this.openMapUrl.openLatLong(location.getLatLong().get());
                e.consume();
            }
        });
        this.fireWhereTextChanged();
    }

    private void updateIdToString(@Nullable String nullName) {
        this.whereIndexers = new WherePanelIndexers(this.reportSet.getLocations(), this.predefinedLocations, true, nullName, Predicates.alwaysTrue(), null);
        this.whereIndexers.configureIndexer(this.whereIndexerPanel);
    }

    public DirtyImpl getDirty() {
        return this.dirty;
    }

    public void setWhere(Location location) {
        Preconditions.checkArgument(location == null || location.getId() != null);
        this.setWhereImpl(location);
        this.whereIndexerPanel.setValue(location == null ? null : location.getId());
    }

    public Location getWhere() {
        return this.where;
    }

    protected void setWhereImpl(Location location) {
        if (this.where != location) {
            String name;
            Location oldWhere = this.where;
            String string = name = location == null ? "" : location.getDisplayName();
            if (!this.whereIndexerPanel.getTextValue().equals(name) && location != null && location.getId() != null) {
                this.whereIndexerPanel.setValue(location.getId());
            }
            this.where = location;
            this.latLongIcon.setVisible(location != null && location.getLatLong().isPresent());
            this.firePropertyChange("where", oldWhere, this.where);
            this.dirty.setDirty(true);
        }
    }

    public void shown() {
        this.whereIndexerPanel.requestFocusInWindow();
    }

    private void initGUI() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.setPreferredSize(new Dimension(400, 300));
        this.whereIndexerPanel = new IndexerPanel();
        this.whereIndexerPanel.setPreviewText(Messages.Name.START_TYPING_A_LOCATION);
        this.whereLabel = new JLabel();
        this.whereLabel.setText(Messages.getMessage(Messages.Name.WHERE_QUESTION));
        this.newLocation = new JButton();
        this.newLocation.setText(Messages.getMessage(Messages.Name.CHOOSE_NEW_LOCATION));
        this.latLongIcon = new JLabel(new ImageIcon(latLongOriginalSize.getImage().getScaledInstance(18, 18, 4)));
        this.latLongIcon.setVisible(false);
        this.latLongIcon.setCursor(Cursor.getPredefinedCursor(12));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.whereLabel).addGroup(layout.createSequentialGroup().addComponent(this.whereIndexerPanel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.latLongIcon, -2, -2, -2)).addGroup(layout.createSequentialGroup().addGap(20).addComponent(this.newLocation)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.whereLabel, -2, -2, -2).addGroup(layout.createBaselineGroup(false, false).addComponent(this.whereIndexerPanel, -2, -2, -2).addComponent(this.latLongIcon, GroupLayout.Alignment.CENTER, -2, -2, -2)).addComponent(this.newLocation, -2, -2, -2));
    }

    public void setEditable(boolean editable) {
        this.whereIndexerPanel.setEditable(editable);
        this.newLocation.setVisible(editable);
    }

    public void setLayoutStrategy(IndexerPanel.LayoutStrategy layout) {
        this.whereIndexerPanel.setLayoutStrategy(layout);
    }

    private void fireWhereTextChanged() {
        if (this.whereIndexerPanel.getValue() == null) {
            this.newLocation.setEnabled(!this.whereIndexerPanel.getTextValue().isEmpty());
        }
    }
}

