/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Strings;
import com.scythebill.birdlist.model.util.DirtyImpl;
import com.scythebill.birdlist.ui.components.DatePanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.joda.time.ReadablePartial;

public class WhenPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private DatePanel whenPanel;
    private JLabel whenLabel;
    private DirtyImpl dirty = new DirtyImpl(false);
    private JLabel whenClarificationLabel;

    public WhenPanel(FontManager fontManager) {
        this.initGUI();
        this.hookUpContents();
        fontManager.applyTo(this);
    }

    private void hookUpContents() {
        this.whenPanel.addPropertyChangeListener("value", evt -> {
            this.firePropertyChange("when", evt.getOldValue(), evt.getNewValue());
            this.dirty.setDirty(true);
        });
    }

    public DirtyImpl getDirty() {
        return this.dirty;
    }

    public ReadablePartial getWhen() {
        return this.whenPanel.getValue();
    }

    public void setWhen(ReadablePartial partial) {
        this.whenPanel.setValue(partial);
    }

    private void initGUI() {
        this.whenLabel = new JLabel();
        this.whenLabel.setText(Messages.getMessage(Messages.Name.WHEN_QUESTION));
        this.whenClarificationLabel = new JLabel();
        this.whenClarificationLabel.putClientProperty("birdlist.plainLabel", true);
        this.whenClarificationLabel.setVisible(false);
        this.whenPanel = new DatePanel();
    }

    public void setEditable(boolean editable) {
        this.whenPanel.setEditable(editable);
    }

    public void setWhenClarificationText(String text) {
        this.whenClarificationLabel.setText(text);
        this.whenClarificationLabel.setVisible(!Strings.isNullOrEmpty(text));
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.setPreferredSize(fontManager.scale(new Dimension(400, 300)));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.whenLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.whenClarificationLabel)).addComponent(this.whenPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createBaselineGroup(false, false).addComponent(this.whenLabel, -2, -2, -2).addComponent(this.whenClarificationLabel, -2, -2, -2)).addComponent(this.whenPanel, -2, fontManager.scale(35), -2));
    }
}

