/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.sighting.Area;
import com.scythebill.birdlist.model.sighting.Distance;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.util.DirtyImpl;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.components.PossiblyRequiredLabel;
import com.scythebill.birdlist.ui.components.TimePanel;
import com.scythebill.birdlist.ui.components.VisitInfoPreferences;
import com.scythebill.birdlist.ui.components.links.DefaultLinkClickedListener;
import com.scythebill.birdlist.ui.components.photos.PhotosListPanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.fonts.FontPreferences;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.ToStringListCellRenderer;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.joda.time.Duration;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;

public class VisitInfoPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private DirtyImpl dirty = new DirtyImpl(false);
    private JScrollPane commentsScrollPane;
    private boolean startTimeEditable = false;
    private boolean lastValidValue;
    private PanelLayout layout = PanelLayout.NORMAL;
    private VisitInfo lastValue;
    private final DocumentListener dirtyDocument = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent event) {
            VisitInfoPanel.this.dirty.setDirty(true);
            VisitInfoPanel.this.updateValueAndValid();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            VisitInfoPanel.this.dirty.setDirty(true);
            VisitInfoPanel.this.updateValueAndValid();
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            VisitInfoPanel.this.dirty.setDirty(true);
            VisitInfoPanel.this.updateValueAndValid();
        }
    };
    private PossiblyRequiredLabel observationTypeLabel;
    private JComboBox<VisitInfo.ObservationType> observationType;
    private PossiblyRequiredLabel durationLabel;
    private JFormattedTextField durationHoursField;
    private JFormattedTextField durationMinutesField;
    private JLabel durationHoursLabel;
    private JLabel durationMinutesLabel;
    private JTextArea observationTypeDocumentation;
    private PossiblyRequiredLabel areaLabel;
    private JFormattedTextField areaField;
    private JComboBox<AcresOrHectares> acresOrHectares;
    private PossiblyRequiredLabel distanceLabel;
    private JFormattedTextField distanceField;
    private PossiblyRequiredLabel partySizeLabel;
    private JFormattedTextField partySizeField;
    private PossiblyRequiredLabel commentsLabel;
    private JTextArea comments;
    private JComboBox<MilesOrKilometers> milesOrKilometers;
    private boolean editable;
    private FontManager fontManager;
    private LocalTime startTime;
    private PossiblyRequiredLabel startTimeLabel;
    private JLabel startTimeValue;
    private final VisitInfoPreferences visitInfoPreferences;
    private TimePanel startTimeField;
    private JCheckBox completeChecklist;
    private PhotosListPanel photosListPanel;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        FontManager fontManager = new FontManager(new FontPreferences());
        LocalTime startTime = TimeIO.fromString("15:54");
        Alerts alerts = new Alerts(null);
        VisitInfoPanel visitInfoPanel = new VisitInfoPanel(startTime, fontManager, new VisitInfoPreferences(), new FileDialogs(new FilePreferences(), new FileDialogs.FlagsDefaults(), alerts), alerts);
        visitInfoPanel.setPanelLayout(PanelLayout.NORMAL);
        visitInfoPanel.setStartTimeEditable(true);
        frame.getContentPane().add((Component)visitInfoPanel, "Center");
        visitInfoPanel.addPropertyChangeListener("validValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                System.err.printf("%s : %s -> %s\n", e.getPropertyName(), e.getOldValue(), e.getNewValue());
            }
        });
        visitInfoPanel.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                System.err.printf("%s : \n   %s \n-> %s\n", e.getPropertyName(), e.getOldValue(), e.getNewValue());
            }
        });
        visitInfoPanel.addPropertyChangeListener("startTime", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                System.err.printf("%s : \n   %s \n-> %s\n", e.getPropertyName(), e.getOldValue(), e.getNewValue());
            }
        });
        fontManager.applyTo(frame);
        frame.pack();
        frame.setVisible(true);
    }

    public VisitInfoPanel(@Nullable LocalTime startTime, FontManager fontManager, VisitInfoPreferences visitInfoPreferences, FileDialogs fileDialogs, Alerts alerts) {
        this.startTime = startTime;
        this.fontManager = fontManager;
        this.visitInfoPreferences = visitInfoPreferences;
        this.initComponents(fileDialogs, alerts);
        this.attachListeners();
        this.updateValueAndValid();
    }

    public DirtyImpl getDirty() {
        return this.dirty;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.durationHoursField.setEnabled(enabled);
        this.durationMinutesField.setEnabled(enabled);
        this.distanceField.setEnabled(enabled);
        this.areaField.setEnabled(enabled);
        this.partySizeField.setEnabled(enabled);
        this.comments.setEnabled(enabled);
        this.setEditableOrEnabled();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.durationHoursField.setEditable(editable);
        this.durationMinutesField.setEditable(editable);
        this.distanceField.setEditable(editable);
        this.areaField.setEditable(editable);
        this.partySizeField.setEditable(editable);
        this.comments.setEditable(editable);
        this.setEditableOrEnabled();
    }

    private void setEditableOrEnabled() {
        this.acresOrHectares.setEnabled(this.editable && this.isEnabled());
        this.milesOrKilometers.setEnabled(this.editable && this.isEnabled());
        this.observationType.setEnabled(this.editable && this.isEnabled());
        this.completeChecklist.setEnabled(this.editable && this.isEnabled());
        this.photosListPanel.setEnabled(this.editable && this.isEnabled());
    }

    private void attachListeners() {
        PropertyChangeListener dirtyProperty = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                if (oldValue == null ? newValue == null : oldValue.equals(newValue)) {
                    return;
                }
                VisitInfoPanel.this.dirty.setDirty(true);
                VisitInfoPanel.this.updateValueAndValid();
            }
        };
        ActionListener dirtyAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VisitInfoPanel.this.dirty.setDirty(true);
                VisitInfoPanel.this.updateValueAndValid();
            }
        };
        this.startTimeField.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                LocalTime newStartTime;
                LocalTime oldStartTime;
                if (VisitInfoPanel.this.startTimeEditable && !Objects.equal(oldStartTime = VisitInfoPanel.this.startTime, newStartTime = VisitInfoPanel.this.startTimeField.getValue())) {
                    VisitInfoPanel.this.setStartTime(newStartTime);
                    VisitInfoPanel.this.firePropertyChange("startTime", oldStartTime, newStartTime);
                }
            }
        });
        this.durationHoursField.addPropertyChangeListener("value", dirtyProperty);
        this.durationMinutesField.addPropertyChangeListener("value", dirtyProperty);
        this.distanceField.addPropertyChangeListener("value", dirtyProperty);
        this.observationType.addActionListener(dirtyAction);
        this.milesOrKilometers.addActionListener(dirtyAction);
        this.areaField.addPropertyChangeListener("value", dirtyProperty);
        this.acresOrHectares.addActionListener(dirtyAction);
        this.partySizeField.addPropertyChangeListener("value", dirtyProperty);
        this.comments.getDocument().addDocumentListener(this.dirtyDocument);
        this.completeChecklist.addActionListener(dirtyAction);
        this.observationType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VisitInfoPanel.this.updateObservationType();
                VisitInfoPanel.this.fontManager.applyTo(VisitInfoPanel.this);
            }
        });
        this.photosListPanel.getDirty().addDirtyListener(dirtyProperty);
        this.photosListPanel.addPropertyChangeListener("links", dirtyProperty);
        this.updateObservationType();
    }

    public boolean isValidValue() {
        VisitInfo.ObservationType type = (VisitInfo.ObservationType)((Object)this.observationType.getSelectedItem());
        ImmutableSet<VisitInfo.VisitField> requiredFields = type.getRequiredFields();
        if (requiredFields.contains((Object)VisitInfo.VisitField.AREA) && this.areaField.getValue() == null) {
            return false;
        }
        if (requiredFields.contains((Object)VisitInfo.VisitField.DISTANCE) && this.distanceField.getValue() == null) {
            return false;
        }
        if (requiredFields.contains((Object)VisitInfo.VisitField.DURATION) && this.durationHoursField.getValue() == null && this.durationMinutesField.getValue() == null) {
            return false;
        }
        return !requiredFields.contains((Object)VisitInfo.VisitField.PARTY_SIZE) || this.partySizeField.getValue() != null;
    }

    public VisitInfo getValue() {
        String comments;
        Integer partySize;
        Float area;
        Float distance;
        VisitInfo.Builder builder = VisitInfo.builder();
        builder.withObservationType((VisitInfo.ObservationType)((Object)this.observationType.getSelectedItem()));
        Integer hours = (Integer)this.durationHoursField.getValue();
        Integer minutes = (Integer)this.durationMinutesField.getValue();
        if (hours != null || minutes != null) {
            Duration duration = Duration.ZERO;
            if (hours != null) {
                duration = duration.plus(Duration.standardHours(hours.intValue()));
            }
            if (minutes != null) {
                duration = duration.plus(Duration.standardMinutes(minutes.intValue()));
            }
            builder.withDuration(duration);
        }
        if ((distance = (Float)this.distanceField.getValue()) != null) {
            if (this.milesOrKilometers.getSelectedItem() == MilesOrKilometers.MILES) {
                builder.withDistance(Distance.inMiles(distance.floatValue()));
            } else {
                builder.withDistance(Distance.inKilometers(distance.floatValue()));
            }
            this.visitInfoPreferences.milesOrKilometers = (MilesOrKilometers)((Object)this.milesOrKilometers.getSelectedItem());
        }
        if ((area = (Float)this.areaField.getValue()) != null) {
            if (this.acresOrHectares.getSelectedItem() == AcresOrHectares.ACRES) {
                builder.withArea(Area.inAcres(area.floatValue()));
            } else {
                builder.withArea(Area.inHectares(area.floatValue()));
            }
            this.visitInfoPreferences.acresOrHectares = (AcresOrHectares)((Object)this.acresOrHectares.getSelectedItem());
        }
        if ((partySize = (Integer)this.partySizeField.getValue()) != null) {
            builder.withPartySize(partySize);
        }
        if (!(comments = this.comments.getText()).isEmpty()) {
            builder.withComments(comments);
        }
        builder.withCompleteChecklist(this.completeChecklist.isSelected() && this.completeChecklist.isVisible());
        builder.withPhotos(this.photosListPanel.getLinks());
        return builder.build();
    }

    public void setValue(VisitInfo visitInfo) {
        if (visitInfo == null) {
            this.areaField.setText("");
            this.comments.setText("");
            this.distanceField.setText("");
            this.durationHoursField.setText("");
            this.durationMinutesField.setText("");
            this.partySizeField.setText("");
            this.completeChecklist.setSelected(false);
            this.photosListPanel.setLinks(ImmutableList.of());
            return;
        }
        if (visitInfo.observationType().getRequiredFields().contains((Object)VisitInfo.VisitField.START_TIME) && this.startTime == null) {
            throw new IllegalArgumentException(String.format("Observation type %s requires a start time, but none given", new Object[]{visitInfo.observationType()}));
        }
        this.observationType.setSelectedItem((Object)visitInfo.observationType());
        if (visitInfo.area().isPresent()) {
            AcresOrHectares areaType = (AcresOrHectares)((Object)this.acresOrHectares.getSelectedItem());
            switch (areaType) {
                case ACRES: {
                    this.areaField.setValue(Float.valueOf(visitInfo.area().get().acres()));
                    break;
                }
                case HECTARES: {
                    this.areaField.setValue(Float.valueOf(visitInfo.area().get().hectares()));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        } else {
            this.areaField.setText("");
        }
        if (visitInfo.comments().isPresent()) {
            this.comments.setText(visitInfo.comments().get());
            this.comments.setCaretPosition(0);
        } else {
            this.comments.setText("");
        }
        if (visitInfo.distance().isPresent()) {
            MilesOrKilometers distanceType = (MilesOrKilometers)((Object)this.milesOrKilometers.getSelectedItem());
            switch (distanceType) {
                case MILES: {
                    this.distanceField.setValue(Float.valueOf(visitInfo.distance().get().miles()));
                    break;
                }
                case KILOMETERS: {
                    this.distanceField.setValue(Float.valueOf(visitInfo.distance().get().kilometers()));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        } else {
            this.distanceField.setText("");
        }
        if (visitInfo.duration().isPresent()) {
            Duration duration = visitInfo.duration().get();
            int standardMinutes = Math.min(Ints.saturatedCast(duration.getStandardMinutes()), 1439);
            this.durationHoursField.setValue(standardMinutes / 60);
            this.durationMinutesField.setValue(standardMinutes % 60);
        } else {
            this.durationHoursField.setText("");
            this.durationMinutesField.setText("");
        }
        if (visitInfo.partySize().isPresent()) {
            this.partySizeField.setValue(visitInfo.partySize().get());
        } else {
            this.partySizeField.setText("");
        }
        this.completeChecklist.setSelected(visitInfo.completeChecklist());
        this.photosListPanel.setLinks(visitInfo.photos());
    }

    public LocalTime getStartTime() {
        return this.startTimeField.getValue();
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
        VisitInfo.ObservationType observationType = (VisitInfo.ObservationType)((Object)this.observationType.getSelectedItem());
        this.updateUiForStartTime();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.observationType.getModel();
        int indexOf = model.getIndexOf((Object)observationType);
        if (indexOf >= 0) {
            model.setSelectedItem((Object)observationType);
        }
        this.updateObservationType();
    }

    public void tryDefaultObservationType(VisitInfo.ObservationType defaultObservationType) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.observationType.getModel();
        int indexOf = model.getIndexOf((Object)defaultObservationType);
        if (indexOf >= 0) {
            model.setSelectedItem((Object)defaultObservationType);
        }
    }

    private void updateUiForStartTime() {
        VisitInfo.ObservationType[] validTypes;
        if (this.startTime == null) {
            this.startTimeValue.setText(Messages.getMessage(Messages.Name.NONE_IN_PARENTHESES));
            this.startTimeField.setValue(null);
            ArrayList<VisitInfo.ObservationType> typesList = Lists.newArrayList();
            for (VisitInfo.ObservationType type : VisitInfo.ObservationType.values()) {
                if (type.getRequiredFields().contains((Object)VisitInfo.VisitField.START_TIME)) continue;
                typesList.add(type);
            }
            validTypes = typesList.toArray(new VisitInfo.ObservationType[typesList.size()]);
        } else {
            this.startTimeValue.setText(DateTimeFormat.shortTime().print(this.startTime));
            this.startTimeField.setValue(this.startTime);
            validTypes = VisitInfo.ObservationType.values();
        }
        this.startTimeField.getDirty().setDirty(false);
        this.observationType.setModel(new DefaultComboBoxModel<VisitInfo.ObservationType>(validTypes));
        this.observationType.setMaximumRowCount(this.observationType.getItemCount());
    }

    private void initComponents(FileDialogs fileDialogs, Alerts alerts) {
        this.startTimeLabel = new PossiblyRequiredLabel(Messages.getMessage(Messages.Name.START_TIME_LABEL));
        this.startTimeValue = new JLabel();
        this.startTimeValue.putClientProperty("birdlist.plainLabel", true);
        this.startTimeField = new TimePanel();
        this.observationTypeLabel = new PossiblyRequiredLabel(Messages.getMessage(Messages.Name.EBIRD_OBSERVATION_TYPE_LABEL));
        this.observationTypeLabel.setRequired(true);
        this.observationType = new JComboBox();
        ListCellRenderer<String> base = new JComboBox().getRenderer();
        ToString<VisitInfo.ObservationType> toString = new ToString<VisitInfo.ObservationType>(){

            @Override
            public String getString(VisitInfo.ObservationType o) {
                return Messages.getText(o);
            }
        };
        this.observationType.setRenderer(new ToStringListCellRenderer<VisitInfo.ObservationType>(toString, VisitInfo.ObservationType.class, base));
        this.updateUiForStartTime();
        this.observationTypeDocumentation = new JTextArea();
        this.observationTypeDocumentation.setOpaque(false);
        this.observationTypeDocumentation.setColumns(40);
        this.observationTypeDocumentation.setRows(3);
        this.observationTypeDocumentation.setFocusable(false);
        this.observationTypeDocumentation.setEditable(false);
        this.durationLabel = new PossiblyRequiredLabel(Messages.getMessage(Messages.Name.DURATION_LABEL));
        this.durationHoursField = this.dirtySafeField();
        this.durationHoursLabel = new JLabel(Messages.getMessage(Messages.Name.HOURS_ABBREVIATION));
        this.durationHoursLabel.putClientProperty("birdlist.plainLabel", true);
        this.durationMinutesField = this.dirtySafeField();
        this.durationMinutesLabel = new JLabel(Messages.getMessage(Messages.Name.MINUTES_ABBREVIATION));
        this.durationMinutesLabel.putClientProperty("birdlist.plainLabel", true);
        this.distanceLabel = new PossiblyRequiredLabel(Messages.getMessage(Messages.Name.DISTANCE_LABEL));
        this.distanceField = this.dirtySafeField();
        this.areaLabel = new PossiblyRequiredLabel(Messages.getMessage(Messages.Name.AREA_LABEL));
        this.areaField = this.dirtySafeField();
        this.milesOrKilometers = new JComboBox<MilesOrKilometers>(MilesOrKilometers.values());
        this.milesOrKilometers.setSelectedItem((Object)this.visitInfoPreferences.milesOrKilometers);
        this.acresOrHectares = new JComboBox<AcresOrHectares>(AcresOrHectares.values());
        this.acresOrHectares.setSelectedItem((Object)this.visitInfoPreferences.acresOrHectares);
        this.partySizeLabel = new PossiblyRequiredLabel(Messages.getMessage(Messages.Name.PARTY_SIZE_LABEL));
        this.partySizeField = this.dirtySafeField();
        this.commentsLabel = new PossiblyRequiredLabel(Messages.getMessage(Messages.Name.COMMENTS_LABEL));
        this.commentsScrollPane = new JScrollPane();
        this.comments = new JTextArea();
        this.commentsScrollPane.setViewportView(this.comments);
        this.comments.setWrapStyleWord(true);
        this.comments.setLineWrap(true);
        UIUtils.fixTabOnTextArea(this.comments);
        this.durationHoursField.setColumns(3);
        NumberFormatter hoursFormatter = this.allowNullIntegerFormatter();
        hoursFormatter.setMaximum(Integer.valueOf(23));
        hoursFormatter.setMinimum(Integer.valueOf(0));
        hoursFormatter.setCommitsOnValidEdit(true);
        this.durationHoursField.setFormatterFactory(new DefaultFormatterFactory(hoursFormatter));
        this.durationMinutesField.setColumns(3);
        NumberFormatter minutesFormatter = this.allowNullIntegerFormatter();
        minutesFormatter.setMaximum(Integer.valueOf(59));
        minutesFormatter.setMinimum(Integer.valueOf(0));
        minutesFormatter.setCommitsOnValidEdit(true);
        this.durationMinutesField.setFormatterFactory(new DefaultFormatterFactory(minutesFormatter));
        this.partySizeField.setColumns(3);
        NumberFormatter partySizeFormatter = this.allowNullIntegerFormatter();
        partySizeFormatter.setMinimum(Integer.valueOf(1));
        partySizeFormatter.setCommitsOnValidEdit(true);
        this.partySizeField.setFormatterFactory(new DefaultFormatterFactory(partySizeFormatter));
        this.distanceField.setColumns(4);
        NumberFormatter distanceFormatter = this.allowNullDecimalFormatter();
        distanceFormatter.setValueClass(Float.class);
        distanceFormatter.setMinimum(Float.valueOf(0.0f));
        distanceFormatter.setMaximum(Float.valueOf(999.999f));
        distanceFormatter.setCommitsOnValidEdit(true);
        this.distanceField.setFormatterFactory(new DefaultFormatterFactory(distanceFormatter));
        this.areaField.setColumns(4);
        NumberFormatter areaFormatter = this.allowNullDecimalFormatter();
        areaFormatter.setValueClass(Float.class);
        areaFormatter.setMinimum(Float.valueOf(0.0f));
        areaFormatter.setMaximum(Float.valueOf(999.999f));
        areaFormatter.setCommitsOnValidEdit(true);
        this.areaField.setFormatterFactory(new DefaultFormatterFactory(areaFormatter));
        this.completeChecklist = new JCheckBox(Messages.getMessage(Messages.Name.COMPLETE_LIST_OF_SIGHTINGS_QUESTION));
        this.photosListPanel = new PhotosListPanel(this.fontManager, fileDialogs, new PhotoClicked(fileDialogs, alerts));
    }

    private NumberFormatter allowNullIntegerFormatter() {
        return new NumberFormatter(NumberFormat.getIntegerInstance()){

            @Override
            public Object stringToValue(String string) throws ParseException {
                if ("".equals(string)) {
                    return null;
                }
                return super.stringToValue(string);
            }
        };
    }

    private NumberFormatter allowNullDecimalFormatter() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumIntegerDigits(3);
        numberFormat.setMaximumFractionDigits(3);
        return new NumberFormatter(numberFormat){

            @Override
            public Object stringToValue(String string) throws ParseException {
                if ("".equals(string)) {
                    return null;
                }
                return super.stringToValue(string);
            }
        };
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        JComponent startTimeComponent;
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHonorsVisibility(true);
        layout.setAutoCreateGaps(true);
        JComponent jComponent = startTimeComponent = this.startTimeEditable ? this.startTimeField : this.startTimeValue;
        if (this.getPanelLayout() == PanelLayout.NORMAL) {
            this.comments.setRows(6);
            this.comments.setColumns(40);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.startTimeLabel).addComponent(this.observationTypeLabel).addComponent(this.durationLabel).addComponent(this.distanceLabel).addComponent(this.areaLabel).addComponent(this.partySizeLabel).addComponent(this.commentsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(startTimeComponent).addComponent(this.observationType, -2, -2, -2).addComponent(this.observationTypeDocumentation, -2, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.durationHoursField, -2, -2, -2).addComponent(this.durationHoursLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.durationMinutesField, -2, -2, -2).addComponent(this.durationMinutesLabel)).addGroup(layout.createSequentialGroup().addComponent(this.distanceField, -2, -2, -2).addComponent(this.milesOrKilometers, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.areaField, -2, -2, -2).addComponent(this.acresOrHectares, -2, -2, -2)).addComponent(this.partySizeField, -2, -2, -2).addComponent(this.commentsScrollPane, -2, -2, -2).addComponent(this.photosListPanel, -2, -2, -2).addComponent(this.completeChecklist, -2, -2, -2)));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createBaselineGroup(false, false).addComponent(this.observationTypeLabel).addComponent(this.observationType)).addComponent(this.observationTypeDocumentation, -2, -2, -2).addGroup(layout.createBaselineGroup(false, false).addComponent(this.startTimeLabel).addComponent(startTimeComponent)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.durationLabel).addComponent(this.durationHoursField).addComponent(this.durationHoursLabel).addComponent(this.durationMinutesField).addComponent(this.durationMinutesLabel)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.distanceLabel).addComponent(this.distanceField).addComponent(this.milesOrKilometers)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.areaLabel).addComponent(this.areaField).addComponent(this.acresOrHectares)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.partySizeLabel).addComponent(this.partySizeField)).addComponent(this.completeChecklist, -2, -2, -2).addGroup(layout.createBaselineGroup(false, false).addComponent(this.commentsLabel).addComponent(this.commentsScrollPane)).addComponent(this.photosListPanel, fontManager.scale(70), fontManager.scale(80), -2));
        } else {
            this.comments.setRows(3);
            this.comments.setColumns(25);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.observationTypeLabel).addComponent(this.observationType, -2, -2, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.startTimeLabel).addComponent(this.durationLabel).addComponent(this.distanceLabel).addComponent(this.areaLabel).addComponent(this.partySizeLabel)).addGroup(layout.createParallelGroup().addComponent(startTimeComponent, -2, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.durationHoursField, -2, -2, -2).addComponent(this.durationHoursLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.durationMinutesField, -2, -2, -2).addComponent(this.durationMinutesLabel)).addGroup(layout.createSequentialGroup().addComponent(this.distanceField, -2, -2, -2).addComponent(this.milesOrKilometers, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.areaField, -2, -2, -2).addComponent(this.acresOrHectares, -2, -2, -2)).addComponent(this.partySizeField, -2, -2, -2))).addComponent(this.commentsLabel).addComponent(this.commentsScrollPane, -2, -2, -2).addComponent(this.photosListPanel).addComponent(this.completeChecklist, -2, -2, -2));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.observationTypeLabel, -2, -2, -2).addComponent(this.observationType, -2, -2, -2).addGroup(layout.createBaselineGroup(false, false).addComponent(this.startTimeLabel).addComponent(startTimeComponent, -2, -2, -2)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.durationLabel).addComponent(this.durationHoursField).addComponent(this.durationHoursLabel).addComponent(this.durationMinutesField).addComponent(this.durationMinutesLabel)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.distanceLabel).addComponent(this.distanceField).addComponent(this.milesOrKilometers)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.areaLabel).addComponent(this.areaField).addComponent(this.acresOrHectares)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.partySizeLabel, -2, -2, -2).addComponent(this.partySizeField, -2, -2, -2)).addComponent(this.completeChecklist, -2, -2, -2).addComponent(this.commentsLabel).addComponent(this.commentsScrollPane, -2, -2, -2).addComponent(this.photosListPanel, fontManager.scale(70), fontManager.scale(80), -2));
        }
        layout.linkSize(0, this.photosListPanel, this.commentsScrollPane);
    }

    private JFormattedTextField dirtySafeField() {
        return new AutoSelectJFormattedTextField(){

            @Override
            protected void processFocusEvent(FocusEvent event) {
                if (event.getID() == 1005) {
                    this.getDocument().removeDocumentListener(VisitInfoPanel.this.dirtyDocument);
                }
                super.processFocusEvent(event);
                if (event.getID() == 1004) {
                    this.getDocument().addDocumentListener(VisitInfoPanel.this.dirtyDocument);
                }
            }
        };
    }

    private void updateObservationType() {
        VisitInfo.ObservationType type = (VisitInfo.ObservationType)((Object)this.observationType.getSelectedItem());
        ImmutableSet<VisitInfo.VisitField> hiddenFields = type.getHiddenFields();
        this.durationLabel.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.DURATION));
        this.durationHoursField.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.DURATION));
        this.durationHoursLabel.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.DURATION));
        this.durationMinutesField.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.DURATION));
        this.durationMinutesLabel.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.DURATION));
        this.distanceLabel.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.DISTANCE));
        this.distanceField.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.DISTANCE));
        this.milesOrKilometers.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.DISTANCE));
        this.areaLabel.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.AREA));
        this.areaField.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.AREA));
        this.acresOrHectares.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.AREA));
        this.partySizeField.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.PARTY_SIZE));
        this.partySizeLabel.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.PARTY_SIZE));
        ImmutableSet<VisitInfo.VisitField> requiredFields = type.getRequiredFields();
        this.durationLabel.setRequired(requiredFields.contains((Object)VisitInfo.VisitField.DURATION));
        this.distanceLabel.setRequired(requiredFields.contains((Object)VisitInfo.VisitField.DISTANCE));
        this.areaLabel.setRequired(requiredFields.contains((Object)VisitInfo.VisitField.AREA));
        this.partySizeLabel.setRequired(requiredFields.contains((Object)VisitInfo.VisitField.PARTY_SIZE));
        this.startTimeLabel.setRequired(requiredFields.contains((Object)VisitInfo.VisitField.START_TIME));
        this.completeChecklist.setVisible(!hiddenFields.contains((Object)VisitInfo.VisitField.COMPLETE_CHECKLIST));
        if (this.partySizeLabel.isRequired() && "".equals(this.partySizeField.getText())) {
            this.partySizeField.setValue(1);
        }
        Object documentation = Messages.getDescription(type);
        if (this.startTime == null) {
            documentation = (String)documentation + "\n\n" + Messages.getMessage(Messages.Name.START_TIME_ISNT_SET);
        }
        this.observationTypeDocumentation.setText((String)documentation);
    }

    private void updateValueAndValid() {
        VisitInfo value;
        boolean validValue = this.isValidValue();
        if (validValue != this.lastValidValue) {
            this.firePropertyChange("validValue", this.lastValidValue, validValue);
            this.lastValidValue = validValue;
        }
        if (validValue && !Objects.equal(value = this.getValue(), this.lastValue)) {
            this.firePropertyChange("value", this.lastValue, value);
            this.lastValue = value;
        }
    }

    public PanelLayout getPanelLayout() {
        return this.layout;
    }

    public void setPanelLayout(PanelLayout layout) {
        this.layout = layout;
    }

    public boolean isStartTimeEditable() {
        return this.startTimeEditable;
    }

    public void setStartTimeEditable(boolean startTimeEditable) {
        this.startTimeEditable = startTimeEditable;
    }

    public void setPartySize(int size) {
        this.partySizeField.setValue(size);
    }

    public static enum PanelLayout {
        NORMAL,
        NARROW;

    }

    public static enum MilesOrKilometers {
        MILES(Messages.Name.MILES_TEXT),
        KILOMETERS(Messages.Name.KILOMETERS_TEXT);

        private final Messages.Name label;

        private MilesOrKilometers(Messages.Name label) {
            this.label = label;
        }

        public String toString() {
            return Messages.getMessage(this.label);
        }
    }

    public static enum AcresOrHectares {
        ACRES(Messages.Name.ACRES_TEXT),
        HECTARES(Messages.Name.HECTARES_TEXT);

        private final Messages.Name label;

        private AcresOrHectares(Messages.Name label) {
            this.label = label;
        }

        public String toString() {
            return Messages.getMessage(this.label);
        }
    }

    private class PhotoClicked
    extends DefaultLinkClickedListener<Photo> {
        public PhotoClicked(FileDialogs fileDialogs, Alerts alerts) {
            super(VisitInfoPanel.this, fileDialogs, alerts);
        }

        @Override
        protected void replaceLink(Photo oldPhoto, Photo newPhoto) {
            int index = VisitInfoPanel.this.photosListPanel.getLinks().indexOf(oldPhoto);
            if (index >= 0) {
                ArrayList newPhotos = new ArrayList(VisitInfoPanel.this.photosListPanel.getLinks());
                newPhotos.set(index, newPhoto);
                VisitInfoPanel.this.photosListPanel.setLinks(newPhotos);
                VisitInfoPanel.this.dirty.setDirty(true);
            }
        }

        @Override
        protected Photo newLink(File file) {
            return new Photo(file);
        }

        @Override
        protected Messages.Name shouldFindFileMessage() {
            return Messages.Name.PHOTO_NOT_THERE_ANYMORE;
        }
    }
}

