/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.ReportSetMutator;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.NavigablePanel;
import com.scythebill.birdlist.ui.components.DatePanel;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.NewLocationDialog;
import com.scythebill.birdlist.ui.components.VisitInfoPanel;
import com.scythebill.birdlist.ui.components.VisitInfoPreferences;
import com.scythebill.birdlist.ui.components.WherePanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.LocationScorer;
import com.scythebill.birdlist.ui.util.OpenMapUrl;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

class VisitInfoBrowsePanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private final UpdatedListener updatedListener;
    private final VisitInfoPanel visitInfoPanel;
    private final ReportSet reportSet;
    private VisitInfoKey visitInfoKey;
    private VisitInfo visitInfo;
    private JButton saveButton;
    private JButton revertButton;
    private JButton deleteButton;
    private JButton editButton;
    private LocalTime originalStartTime;
    private final NavigableFrame navigableFrame;
    private DatePanel whenPanel;
    private JLabel whenLabel;
    private ReadablePartial originalDate;
    private NewLocationDialog newLocationDialog;
    private PredefinedLocations predefinedLocations;
    private JLabel whereLabel;
    private WherePanel wherePanel;
    private String originalLocation;
    private final Action returnAction;
    private Alerts alerts;
    private final OpenMapUrl openMapUrl;
    private final LocationScorer locationScorer;

    VisitInfoBrowsePanel(ReportSet reportSet, VisitInfoKey visitInfoKey, VisitInfo visitInfo, VisitInfoPreferences visitInfoPreferences, FileDialogs fileDialogs, Alerts alerts, FontManager fontManager, UpdatedListener updatedListener, NavigableFrame navigableFrame, NewLocationDialog newLocationDialog, PredefinedLocations predefinedLocations, OpenMapUrl openMapUrl, LocationScorer locationScorer, Action returnAction) {
        this.reportSet = reportSet;
        this.visitInfoKey = visitInfoKey;
        this.alerts = alerts;
        this.updatedListener = updatedListener;
        this.navigableFrame = navigableFrame;
        this.newLocationDialog = newLocationDialog;
        this.predefinedLocations = predefinedLocations;
        this.openMapUrl = openMapUrl;
        this.locationScorer = locationScorer;
        this.returnAction = returnAction;
        this.visitInfo = visitInfo != null ? visitInfo : VisitInfo.builder().withObservationType(VisitInfo.ObservationType.HISTORICAL).build();
        this.visitInfoPanel = new VisitInfoPanel(visitInfoKey.startTime().orNull(), fontManager, visitInfoPreferences, fileDialogs, alerts);
        this.originalStartTime = visitInfoKey.startTime().orNull();
        this.originalDate = visitInfoKey.date();
        this.originalLocation = visitInfoKey.locationId();
        this.visitInfoPanel.setValue(this.visitInfo);
        this.visitInfoPanel.getDirty().setDirty(false);
        this.visitInfoPanel.setPanelLayout(VisitInfoPanel.PanelLayout.NARROW);
        this.visitInfoPanel.setStartTimeEditable(true);
        this.initComponents();
    }

    private void initComponents() {
        this.whenLabel = new JLabel();
        this.whenLabel.setText(Messages.getMessage(Messages.Name.WHEN_QUESTION));
        this.whenPanel = new DatePanel();
        this.whenPanel.setValue(this.visitInfoKey.date());
        this.whereLabel = new JLabel();
        this.whereLabel.setText(Messages.getMessage(Messages.Name.WHERE_QUESTION));
        this.wherePanel = new WherePanel(this.reportSet, this.newLocationDialog, this.predefinedLocations, this.openMapUrl, this.locationScorer, null);
        this.wherePanel.setWhereLayoutStrategy(IndexerPanel.LayoutStrategy.BELOW);
        this.wherePanel.setWhereLayoutStrategy(IndexerPanel.LayoutStrategy.BELOW);
        this.wherePanel.setWhere(this.reportSet.getLocations().getLocation(this.visitInfoKey.locationId()));
        this.saveButton = new JButton();
        this.revertButton = new JButton();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.saveButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.SAVE_BUTTON)){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisitInfoBrowsePanel.this.save();
            }
        });
        this.editButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.EDIT_SIGHTINGS)){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisitInfoBrowsePanel.this.edit();
            }
        });
        this.revertButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.REVERT_BUTTON)){

            @Override
            public void actionPerformed(ActionEvent event) {
                VisitInfoBrowsePanel.this.revert();
            }
        });
        this.deleteButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.DELETE_ALL)){

            @Override
            public void actionPerformed(ActionEvent event) {
                VisitInfoBrowsePanel.this.delete();
            }
        });
        this.visitInfoPanel.addPropertyChangeListener("validValue", e -> this.updateButtonEnabledState());
        this.visitInfoPanel.addPropertyChangeListener("startTime", e -> this.updateButtonEnabledState());
        this.visitInfoPanel.getDirty().addDirtyListener(e -> this.updateButtonEnabledState());
        this.whenPanel.addPropertyChangeListener("value", e -> this.updateButtonEnabledState());
        this.wherePanel.addPropertyChangeListener("where", e -> this.updateButtonEnabledState());
        this.updateButtonEnabledState();
    }

    private void updateButtonEnabledState() {
        boolean startTimeModified = !Objects.equal(this.originalStartTime, this.visitInfoPanel.getStartTime());
        boolean dateModified = !Objects.equal(this.originalDate, this.whenPanel.getValue());
        Location updatedWhere = this.wherePanel.getWhere();
        boolean locationModified = !Objects.equal(this.originalLocation, updatedWhere == null ? null : updatedWhere.getId());
        this.saveButton.setEnabled(startTimeModified || dateModified && this.whenPanel.getValue() != null || locationModified && updatedWhere != null || this.visitInfoPanel.isValidValue() && this.visitInfoPanel.getDirty().isDirty());
        this.revertButton.setEnabled(startTimeModified || dateModified || locationModified || !this.visitInfoPanel.isValidValue() || this.visitInfoPanel.getDirty().isDirty());
        this.editButton.setEnabled(!this.revertButton.isEnabled());
    }

    private void delete() {
        ArrayList<Sighting> sightingsToRemove = Lists.newArrayList();
        for (Sighting sighting : this.reportSet.getSightings()) {
            if (!this.visitInfoKey.matches(sighting)) continue;
            sightingsToRemove.add(sighting);
        }
        int okCancel = this.alerts.showOkCancel((Object)this, Messages.Name.ARE_YOU_SURE, Messages.Name.VERIFY_DELETE_ALL_SIGHTINGS_FORMAT, sightingsToRemove.size());
        if (okCancel == 0) {
            this.reportSet.mutator().removing(sightingsToRemove).mutate();
            this.updatedListener.visitInfoDeleted(this.visitInfoKey);
        }
    }

    private void save() {
        if (this.visitInfoPanel.isValidValue() && this.wherePanel.getWhere() != null && this.whenPanel.getValue() != null) {
            VisitInfo edited = this.visitInfoPanel.getValue();
            if (!edited.equals(this.visitInfo)) {
                this.reportSet.putVisitInfo(this.visitInfoKey, edited);
                this.reportSet.markDirty();
                this.visitInfo = edited;
            }
            LocalTime newStartTime = this.visitInfoPanel.getStartTime();
            ReadablePartial newDate = this.whenPanel.getValue();
            Location newLocation = this.wherePanel.getWhere();
            this.reportSet.getLocations().ensureAdded(newLocation);
            if (!(Objects.equal(newStartTime, this.originalStartTime) && Objects.equal(newDate, this.originalDate) && Objects.equal(newLocation.getId(), this.originalLocation))) {
                ArrayList<Sighting> sightingsToRemove = Lists.newArrayList();
                ArrayList<Sighting> sightingsToAdd = Lists.newArrayList();
                for (Sighting sighting : this.reportSet.getSightings()) {
                    if (!this.visitInfoKey.matches(sighting)) continue;
                    sightingsToRemove.add(sighting);
                    sightingsToAdd.add(sighting.asBuilder().setTime(newStartTime).setDate(newDate).setLocation(newLocation).build());
                }
                if (!sightingsToRemove.isEmpty()) {
                    ReportSetMutator mutator = this.reportSet.mutator().adding(sightingsToAdd).removing(sightingsToRemove);
                    if (!Objects.equal(newStartTime, this.originalStartTime)) {
                        mutator.withChangedStartTime(Optional.fromNullable(newStartTime));
                    }
                    if (!Objects.equal(newDate, this.originalDate)) {
                        mutator.withChangedDate(newDate);
                    }
                    if (!Objects.equal(newLocation.getId(), this.originalLocation)) {
                        mutator.withChangedLocation(newLocation.getId());
                    }
                    mutator.mutate();
                }
                this.visitInfoKey = this.visitInfoKey.withStartTime(Optional.fromNullable(newStartTime)).withDate(newDate).withLocationId(newLocation.getId());
                this.originalStartTime = newStartTime;
                this.originalDate = newDate;
                this.originalLocation = newLocation.getId();
            }
            this.updatedListener.visitInfoUpdated(this.visitInfoKey);
            this.visitInfoPanel.getDirty().setDirty(false);
        }
        this.updateButtonEnabledState();
    }

    private void revert() {
        this.visitInfoPanel.setStartTime(this.originalStartTime);
        this.visitInfoPanel.setValue(this.visitInfo);
        this.whenPanel.setValue(this.originalDate);
        this.wherePanel.setWhere(this.reportSet.getLocations().getLocation(this.originalLocation));
        this.visitInfoPanel.getDirty().setDirty(false);
        this.updateButtonEnabledState();
    }

    private void edit() {
        JPanel sightingsPanel;
        if (this.visitInfoPanel.getDirty().isDirty()) {
            this.save();
        }
        if ((sightingsPanel = this.navigableFrame.navigateToAndPush("sightings", this.returnAction)) != null) {
            ((NavigablePanel)((Object)sightingsPanel)).navigateTo(this.visitInfoKey);
        }
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHonorsVisibility(true);
        this.whenLabel.setAlignmentX(0.0f);
        this.whenPanel.setAlignmentX(0.0f);
        this.setBorder(new EmptyBorder(0, 2, 0, 2));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.whenLabel, -2, -2, -2).addComponent(this.whenPanel, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wherePanel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.visitInfoPanel, -2, -2, -2).addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createBaselineGroup(false, false).addComponent(this.editButton).addComponent(this.deleteButton)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.saveButton).addComponent(this.revertButton)).addGap(0, fontManager.scale(10), fontManager.scale(10)));
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.visitInfoPanel, -2, -2, Short.MAX_VALUE).addComponent(this.whenLabel, -2, -2, Short.MAX_VALUE).addComponent(this.whenPanel, -2, -2, Short.MAX_VALUE).addComponent(this.wherePanel, -2, -2, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.editButton).addGap(fontManager.scale(2)).addComponent(this.deleteButton)).addGap(0, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.saveButton).addGap(fontManager.scale(2)).addComponent(this.revertButton)));
        layout.linkSize(this.editButton, this.saveButton);
        layout.linkSize(this.deleteButton, this.revertButton);
    }

    static interface UpdatedListener {
        public void visitInfoUpdated(VisitInfoKey var1);

        public void visitInfoDeleted(VisitInfoKey var1);
    }
}

