/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.Link;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.NavigablePanel;
import com.scythebill.birdlist.ui.components.DatePanel;
import com.scythebill.birdlist.ui.components.ErrorLabel;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.NewLocationDialog;
import com.scythebill.birdlist.ui.components.WherePanel;
import com.scythebill.birdlist.ui.components.links.DefaultLinkClickedListener;
import com.scythebill.birdlist.ui.components.links.LinksListPanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.LocationScorer;
import com.scythebill.birdlist.ui.util.OpenMapUrl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class TripInfoBrowsePanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private final UpdatedListener updatedListener;
    private final ReportSet reportSet;
    private JButton saveButton;
    private JButton revertButton;
    private JButton tripSightingsButton;
    private DatePanel startWhenPanel;
    private JLabel startWhenLabel;
    private ReadablePartial originalStartDate;
    private NewLocationDialog newLocationDialog;
    private PredefinedLocations predefinedLocations;
    private JLabel whereLabel;
    private WherePanel wherePanel;
    private String originalLocation;
    private Alerts alerts;
    private final OpenMapUrl openMapUrl;
    private final Trip trip;
    private JLabel endWhenLabel;
    private DatePanel endWhenPanel;
    private LocalTime originalStartTime;
    private LocalTime originalEndTime;
    private ReadablePartial originalEndDate;
    private String originalNotes;
    private String originalName;
    private JScrollPane notesScrollPane;
    private JTextArea notesArea;
    private JLabel notesLabel;
    private JLabel nameLabel;
    private JTextField nameField;
    private ErrorLabel endWhenErrorLabel;
    private Action returnAction;
    private NavigableFrame navigableFrame;
    private FontManager fontManager;
    private FileDialogs fileDialogs;
    private LinksListPanel<Link> linksListPanel;
    private final LocationScorer locationScorer;

    public TripInfoBrowsePanel(ReportSet reportSet, Trip trip, Alerts alerts, FileDialogs fileDialogs, FontManager fontManager, UpdatedListener updatedListener, NewLocationDialog newLocationDialog, PredefinedLocations predefinedLocations, OpenMapUrl openMapUrl, NavigableFrame navigableFrame, LocationScorer locationScorer, Action returnAction) {
        this.reportSet = reportSet;
        this.trip = trip;
        this.alerts = alerts;
        this.fontManager = fontManager;
        this.fileDialogs = fileDialogs;
        this.updatedListener = updatedListener;
        this.newLocationDialog = newLocationDialog;
        this.predefinedLocations = predefinedLocations;
        this.openMapUrl = openMapUrl;
        this.navigableFrame = navigableFrame;
        this.locationScorer = locationScorer;
        this.returnAction = returnAction;
        this.originalStartTime = trip.startTime();
        this.originalEndTime = trip.endTime();
        this.originalStartDate = trip.startDate();
        this.originalEndDate = trip.endDate();
        this.originalName = trip.name();
        this.originalNotes = trip.notes();
        this.originalLocation = trip.locationId();
        this.initComponents();
        this.fontsUpdated(fontManager);
    }

    private void initComponents() {
        this.startWhenLabel = new JLabel();
        this.startWhenLabel.setText(Messages.getMessage(Messages.Name.WHEN_QUESTION));
        this.startWhenPanel = new DatePanel();
        this.startWhenPanel.setValue(this.trip.startDate());
        this.endWhenLabel = new JLabel();
        this.endWhenLabel.setText(Messages.getMessage(Messages.Name.UNTIL_WHEN));
        this.endWhenPanel = new DatePanel();
        this.endWhenPanel.setValue(this.trip.endDate());
        this.endWhenErrorLabel = new ErrorLabel();
        this.whereLabel = new JLabel();
        this.whereLabel.setText(Messages.getMessage(Messages.Name.WHERE_QUESTION));
        this.wherePanel = new WherePanel(this.reportSet, this.newLocationDialog, this.predefinedLocations, this.openMapUrl, this.locationScorer, null);
        this.wherePanel.setWhereLayoutStrategy(IndexerPanel.LayoutStrategy.BELOW);
        this.wherePanel.setWhereLayoutStrategy(IndexerPanel.LayoutStrategy.BELOW);
        this.wherePanel.setWhere(this.reportSet.getLocations().getLocation(this.trip.locationId()));
        this.nameLabel = new JLabel(Messages.getMessage(Messages.Name.TRIP_NAME_LABEL));
        this.nameField = new JTextField(Strings.nullToEmpty(this.trip.name()), 20);
        this.notesLabel = new JLabel(Messages.getMessage(Messages.Name.TRIP_NOTES_LABEL));
        this.notesScrollPane = new JScrollPane();
        this.notesArea = new JTextArea(Strings.nullToEmpty(this.trip.notes()), 8, 20);
        this.notesArea.setWrapStyleWord(true);
        this.notesArea.setLineWrap(true);
        this.notesScrollPane.setViewportView(this.notesArea);
        this.saveButton = new JButton();
        this.revertButton = new JButton();
        this.tripSightingsButton = new JButton();
        DefaultLinkClickedListener<Link> linkClicked = new DefaultLinkClickedListener<Link>((Component)this, this.fileDialogs, this.alerts){

            @Override
            protected Messages.Name shouldFindFileMessage() {
                return Messages.Name.LINK_NOT_THERE_ANYMORE;
            }

            @Override
            protected Link newLink(File file) {
                return new Link(file);
            }

            @Override
            protected void replaceLink(Link oldLink, Link newLink) {
                int index = TripInfoBrowsePanel.this.trip.links().indexOf(oldLink);
                if (index >= 0) {
                    ArrayList<Link> links = new ArrayList<Link>(TripInfoBrowsePanel.this.trip.links());
                    links.set(index, newLink);
                    TripInfoBrowsePanel.this.trip.setLinks(links);
                    TripInfoBrowsePanel.this.linksListPanel.setLinks(links);
                    TripInfoBrowsePanel.this.reportSet.markDirty();
                }
            }
        };
        this.linksListPanel = new LinksListPanel<Link>(this.fontManager, this.fileDialogs, (LinksListPanel.LinkClickedListener)linkClicked){

            @Override
            protected Messages.Name dragLinkName() {
                return Messages.Name.DRAG_TRIP_LINK_OR_CLICK;
            }

            @Override
            protected Messages.Name chooseLinkName() {
                return Messages.Name.CHOOSE_A_LINK;
            }

            @Override
            protected Messages.Name linkFileName() {
                return Messages.Name.LINK_FILE;
            }

            @Override
            protected Link newLink(URI uri) {
                return new Link(uri);
            }

            @Override
            protected Link newLink(File file) {
                return new Link(file);
            }
        };
        this.linksListPanel.setLinks(this.trip.links());
        this.linksListPanel.getDirty().addDirtyListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TripInfoBrowsePanel.this.updateButtonEnabledState();
            }
        });
        this.saveButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.SAVE_BUTTON)){

            @Override
            public void actionPerformed(ActionEvent e) {
                TripInfoBrowsePanel.this.save();
            }
        });
        this.revertButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.REVERT_BUTTON)){

            @Override
            public void actionPerformed(ActionEvent event) {
                TripInfoBrowsePanel.this.revert();
            }
        });
        this.tripSightingsButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.TRIP_SIGHTINGS)){

            @Override
            public void actionPerformed(ActionEvent event) {
                JPanel sightingsPanel;
                TripInfoBrowsePanel.this.save();
                if (TripInfoBrowsePanel.this.trip != null && (sightingsPanel = TripInfoBrowsePanel.this.navigableFrame.navigateToAndPush("sightings", TripInfoBrowsePanel.this.returnAction)) != null) {
                    ((NavigablePanel)((Object)sightingsPanel)).navigateTo(TripInfoBrowsePanel.this.trip);
                }
            }
        });
        this.startWhenPanel.addPropertyChangeListener("value", e -> this.updateButtonEnabledState());
        this.endWhenPanel.addPropertyChangeListener("value", e -> this.updateButtonEnabledState());
        this.wherePanel.addPropertyChangeListener("where", e -> this.updateButtonEnabledState());
        DocumentListener listener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TripInfoBrowsePanel.this.updateButtonEnabledState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TripInfoBrowsePanel.this.updateButtonEnabledState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TripInfoBrowsePanel.this.updateButtonEnabledState();
            }
        };
        this.notesArea.getDocument().addDocumentListener(listener);
        this.nameField.getDocument().addDocumentListener(listener);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent e) {
                if (TripInfoBrowsePanel.this.saveButton.isEnabled()) {
                    TripInfoBrowsePanel.this.save();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorAdded(AncestorEvent e) {
            }
        });
        this.updateButtonEnabledState();
    }

    private boolean isValueValid() {
        if (SightingComparators.comparePartials(this.startWhenPanel.getValue(), this.endWhenPanel.getValue()) > 0) {
            this.endWhenErrorLabel.setText(Messages.getMessage(Messages.Name.TRIP_END_DATE_MUST_NOT_PRECEDE_START_DATE));
            return false;
        }
        this.endWhenErrorLabel.setText("");
        return this.wherePanel.getWhere() != null && this.startWhenPanel.getValue() != null && this.endWhenPanel.getValue() != null && !this.nameField.getText().isBlank();
    }

    private void updateButtonEnabledState() {
        boolean startDateModified = !Objects.equal(this.originalStartDate, this.startWhenPanel.getValue());
        boolean endDateModified = !Objects.equal(this.originalEndDate, this.endWhenPanel.getValue());
        Location updatedWhere = this.wherePanel.getWhere();
        boolean locationModified = !Objects.equal(this.originalLocation, updatedWhere == null ? null : updatedWhere.getId());
        boolean nameModified = !Objects.equal(this.originalName, this.nameField.getText());
        boolean notesModified = !Objects.equal(this.originalNotes, this.notesArea.getText());
        boolean linksModified = this.linksListPanel.getDirty().isDirty();
        this.saveButton.setEnabled(this.isValueValid() && (startDateModified || endDateModified || locationModified || nameModified || notesModified || linksModified));
        this.revertButton.setEnabled(startDateModified || endDateModified || locationModified || nameModified || notesModified || linksModified);
    }

    private void save() {
        if (!this.isValueValid()) {
            return;
        }
        if (!Objects.equal(this.originalName, this.nameField.getText())) {
            this.trip.setName(this.nameField.getText());
            this.originalName = this.nameField.getText();
        }
        if (!Objects.equal(this.originalStartDate, this.startWhenPanel.getValue()) || !Objects.equal(this.originalEndDate, this.endWhenPanel.getValue())) {
            this.trip.setDates(this.startWhenPanel.getValue(), this.endWhenPanel.getValue());
            this.originalStartDate = this.startWhenPanel.getValue();
            this.originalEndDate = this.endWhenPanel.getValue();
        }
        if (!Objects.equal(this.originalNotes, this.notesArea.getText())) {
            this.trip.setNotes(this.notesArea.getText());
            this.originalNotes = this.notesArea.getText();
        }
        Location where = this.wherePanel.getWhere();
        if (!Objects.equal(this.trip.locationId(), where.getId())) {
            ArrayList<Sighting> sightingsToRemove = Lists.newArrayList();
            ArrayList<Sighting> sightingsToAdd = Lists.newArrayList();
            for (Sighting sighting : this.reportSet.getSightings()) {
                if (sighting.getTrip() != this.trip || !sighting.getLocationId().equals(this.trip.locationId())) continue;
                sightingsToAdd.add(sighting.asBuilder().setLocation(where).build());
                sightingsToRemove.add(sighting);
            }
            this.reportSet.mutator().adding(sightingsToAdd).removing(sightingsToRemove).mutate();
            this.trip.setLocation(where);
        }
        this.trip.setLinks(this.linksListPanel.getLinks());
        this.updatedListener.tripUpdated(this.trip);
        this.updateButtonEnabledState();
    }

    private void revert() {
        this.startWhenPanel.setValue(this.originalStartDate);
        this.endWhenPanel.setValue(this.originalEndDate);
        this.nameField.setText(this.originalName);
        this.notesArea.setText(this.originalNotes);
        this.wherePanel.setWhere(this.reportSet.getLocations().getLocation(this.originalLocation));
        this.linksListPanel.setLinks(this.trip.links());
        this.updateButtonEnabledState();
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHonorsVisibility(true);
        this.startWhenLabel.setAlignmentX(0.0f);
        this.startWhenPanel.setAlignmentX(0.0f);
        this.wherePanel.setPreferredSize(null);
        this.setBorder(new EmptyBorder(0, 2, 0, 2));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.nameLabel, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameField, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.startWhenLabel, -2, -2, -2).addComponent(this.startWhenPanel, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.endWhenLabel, -2, -2, -2).addComponent(this.endWhenPanel, -2, -2, -2).addComponent(this.endWhenErrorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.wherePanel, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.notesLabel, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.notesScrollPane, -2, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.linksListPanel, -2, -2, -2).addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createBaselineGroup(false, false).addComponent(this.saveButton).addComponent(this.revertButton).addComponent(this.tripSightingsButton)).addGap(0, fontManager.scale(10), fontManager.scale(10)));
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel, -2, -2, -2).addComponent(this.nameField, -2, -2, Short.MAX_VALUE).addComponent(this.notesLabel, -2, -2, -2).addComponent(this.notesScrollPane, -2, -2, Short.MAX_VALUE).addComponent(this.startWhenLabel, -2, -2, -2).addComponent(this.startWhenPanel, -2, -2, -2).addComponent(this.endWhenLabel, -2, -2, -2).addComponent(this.endWhenPanel, -2, -2, -2).addComponent(this.endWhenErrorLabel).addComponent(this.wherePanel, -2, -2, -2).addComponent(this.linksListPanel, -2, -2, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.CENTER, layout.createSequentialGroup().addComponent(this.saveButton).addGap(fontManager.scale(2)).addComponent(this.revertButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tripSightingsButton)));
        layout.linkSize(this.saveButton, this.revertButton);
    }

    public static interface UpdatedListener {
        public void tripUpdated(Trip var1);
    }
}

