/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.scythebill.birdlist.model.util.DirtyImpl;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.fonts.FontManager;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.NumberFormatter;
import org.joda.time.Chronology;
import org.joda.time.LocalTime;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormat;

public class TimePanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private JFormattedTextField hourField;
    private JFormattedTextField minuteField;
    private JComboBox<String> amPmCombo;
    private final Chronology chrono = GJChronology.getInstance();
    private LocalTime value;
    private NumberFormatter minuteFormatter;
    private NumberFormatter hourFormatter;
    private DirtyImpl dirty = new DirtyImpl(false);
    private Timer timer;
    private boolean dontUpdateValue;
    private JLabel hourMinuteSeparatorLabel;

    public TimePanel() {
        this(Locale.getDefault());
    }

    public TimePanel(Locale locale) {
        this.setLocale(locale);
        this.initGUI();
    }

    public LocalTime getValue() {
        return this.value;
    }

    public DirtyImpl getDirty() {
        return this.dirty;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.hourField != null) {
            this.hourField.setFont(font);
            this.minuteField.setFont(font);
        }
        if (this.amPmCombo != null) {
            this.amPmCombo.setFont(font);
        }
    }

    public void setValue(LocalTime newValue) {
        this.dontUpdateValue = true;
        if (newValue != null && newValue.size() == 0) {
            newValue = null;
        }
        if (!Objects.equal(newValue, this.getValue())) {
            if (newValue == null) {
                this.hourField.setText("");
                this.minuteField.setText("");
                if (this.amPmCombo != null) {
                    this.amPmCombo.setSelectedIndex(0);
                }
            } else {
                int hourOfDay = newValue.getHourOfDay();
                if (this.amPmCombo != null) {
                    this.amPmCombo.setSelectedIndex(hourOfDay < 12 ? 0 : 1);
                    int halfDayHour = hourOfDay % 12;
                    this.hourField.setValue(halfDayHour == 0 ? 12 : halfDayHour);
                } else {
                    this.hourField.setValue(hourOfDay);
                }
                int minute = newValue.getMinuteOfHour();
                this.minuteField.setValue(minute);
            }
        }
        this.dontUpdateValue = false;
        this.updateValue(newValue);
    }

    private void initGUI() {
        String pattern = DateTimeFormat.patternForStyle("-S", this.getLocale());
        boolean isTwentyFourHour = !pattern.contains("a");
        this.hourMinuteSeparatorLabel = new JLabel(TimePanel.hourMinuteSeparator(pattern));
        this.hourFormatter = new NumberFormatter(new DecimalFormat("#")){

            @Override
            public Object stringToValue(String text) throws ParseException {
                if (Strings.isNullOrEmpty(text)) {
                    return null;
                }
                return super.stringToValue(text);
            }
        };
        this.hourFormatter.setValueClass(Integer.class);
        this.hourFormatter.setMinimum(Integer.valueOf(isTwentyFourHour ? 0 : 1));
        this.hourFormatter.setMaximum(Integer.valueOf(isTwentyFourHour ? 23 : 12));
        this.minuteFormatter = new NumberFormatter(new DecimalFormat("00")){

            @Override
            public Object stringToValue(String text) throws ParseException {
                if (Strings.isNullOrEmpty(text)) {
                    return null;
                }
                return super.stringToValue(text);
            }
        };
        this.minuteFormatter.setValueClass(Integer.class);
        this.minuteFormatter.setMinimum(Integer.valueOf(0));
        this.minuteFormatter.setMaximum(Integer.valueOf(59));
        this.hourField = new AutoSelectJFormattedTextField(this.hourFormatter);
        this.hourField.setColumns(2);
        MinuteOrHourChanged dayListener = new MinuteOrHourChanged(this.hourField);
        this.hourField.addPropertyChangeListener("value", dayListener);
        this.hourField.getDocument().addDocumentListener(dayListener);
        this.hourField.setCaret(new DefaultCaret());
        this.attachAquaCaret(this.hourField);
        this.minuteField = new AutoSelectJFormattedTextField(this.minuteFormatter);
        this.minuteField.setColumns(2);
        MinuteOrHourChanged yearListener = new MinuteOrHourChanged(this.minuteField);
        this.minuteField.addPropertyChangeListener("value", yearListener);
        this.minuteField.getDocument().addDocumentListener(yearListener);
        this.attachAquaCaret(this.minuteField);
        if (!isTwentyFourHour) {
            DefaultComboBoxModel<String> amPmModel = new DefaultComboBoxModel<String>(new String[]{"AM", "PM"});
            this.amPmCombo = new JComboBox<String>(amPmModel);
            this.amPmCombo.setMaximumRowCount(2);
            this.amPmCombo.addActionListener(new AmPmChanged());
            this.amPmCombo.setEditable(false);
        }
    }

    private void startTimerToCalculateNewValue(final JFormattedTextField field) {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    field.commitEdit();
                    TimePanel.this.calculateNewValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        this.timer.setRepeats(false);
        this.timer.start();
    }

    private void calculateNewValue() {
        LocalTime newValue;
        if (this.dontUpdateValue) {
            return;
        }
        if (Strings.isNullOrEmpty(this.hourField.getText())) {
            newValue = null;
        } else {
            int hour = (Integer)this.hourField.getValue();
            if (this.amPmCombo != null) {
                boolean isPm;
                if (hour == 12) {
                    hour = 0;
                }
                boolean bl = isPm = this.amPmCombo.getSelectedIndex() == 1;
                if (isPm) {
                    hour += 12;
                }
            }
            int minute = !Strings.isNullOrEmpty(this.minuteField.getText()) ? (Integer)this.minuteField.getValue() : 0;
            newValue = new LocalTime(hour, minute, 0, 0, this.chrono);
        }
        this.updateValue(newValue);
    }

    private void updateValue(LocalTime newValue) {
        LocalTime oldValue = this.value;
        this.value = newValue;
        if (!Objects.equal(oldValue, newValue)) {
            this.firePropertyChange("value", oldValue, newValue);
            this.dirty.setDirty(true);
        }
    }

    private void attachAquaCaret(JFormattedTextField field) {
        JTextField tempField = new JTextField();
        field.setCaret(tempField.getCaret());
    }

    public void setEditable(boolean editable) {
        this.minuteField.setEditable(editable);
        if (this.amPmCombo != null) {
            this.amPmCombo.setEnabled(editable);
        }
        this.hourField.setEditable(editable);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        if (this.amPmCombo != null) {
            layout.setVerticalGroup(layout.createBaselineGroup(false, false).addComponent(this.hourField, -2, -2, -2).addComponent(this.hourMinuteSeparatorLabel).addComponent(this.minuteField, -2, -2, -2).addComponent(this.amPmCombo, -2, -2, -2));
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.hourField, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hourMinuteSeparatorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minuteField, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.amPmCombo, -2, -2, -2));
            layout.linkSize(1, this.hourField, this.minuteField, this.amPmCombo, this.hourMinuteSeparatorLabel);
        } else {
            layout.setVerticalGroup(layout.createBaselineGroup(false, false).addComponent(this.hourField, -2, -2, -2).addComponent(this.hourMinuteSeparatorLabel).addComponent(this.minuteField, -2, -2, -2));
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.hourField, -2, fontManager.scale(40), -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hourMinuteSeparatorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minuteField, -2, fontManager.scale(40), -2));
            layout.linkSize(1, this.hourField, this.minuteField, this.hourMinuteSeparatorLabel);
        }
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.hourField.getBaseline(width, height);
    }

    private static String hourMinuteSeparator(String format) {
        char charBeforeMinute;
        int firstMinute = format.indexOf(109);
        if (firstMinute > 0 && (charBeforeMinute = format.charAt(firstMinute - 1)) != 'h' && charBeforeMinute != 'H') {
            return "" + charBeforeMinute;
        }
        return "";
    }

    private class MinuteOrHourChanged
    implements PropertyChangeListener,
    DocumentListener {
        private JFormattedTextField field;

        public MinuteOrHourChanged(JFormattedTextField field) {
            this.field = field;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TimePanel.this.calculateNewValue();
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            TimePanel.this.startTimerToCalculateNewValue(this.field);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            TimePanel.this.startTimerToCalculateNewValue(this.field);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            TimePanel.this.startTimerToCalculateNewValue(this.field);
        }
    }

    private class AmPmChanged
    implements ActionListener {
        private AmPmChanged() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TimePanel.this.calculateNewValue();
        }
    }
}

