/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class TextLink
extends JButton {
    private Color focusColor;

    public TextLink(String text) {
        this.setText(text);
        this.setOpaque(false);
        this.setDefaultBorder();
        this.setCursor(new Cursor(12));
        this.setContentAreaFilled(false);
        this.focusColor = TextLink.firstNonNullColor("Button.default.focusedBorderColor", "Button.default.focusColor", "Button.focus", "Focus.color");
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                TextLink.this.setDefaultBorder();
            }

            @Override
            public void focusGained(FocusEvent e) {
                TextLink.this.setFocusedBorder();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (this.shouldShowLink()) {
                    TextLink.this.setFont(TextLink.this.getFont().deriveFont(ImmutableMap.of(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON)));
                }
            }

            private boolean shouldShowLink() {
                return TextLink.this.isEnabled() && TextLink.this.getActionListeners().length > 0;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.shouldShowLink()) {
                    TextLink.this.setFont(TextLink.this.getFont().deriveFont(ImmutableMap.of(TextAttribute.UNDERLINE, -1)));
                }
            }
        });
    }

    private static Color firstNonNullColor(String ... strings) {
        for (String string : strings) {
            Color color = UIManager.getColor(string);
            if (color == null) continue;
            return color;
        }
        return null;
    }

    protected void setFocusedBorder() {
        if (this.focusColor != null) {
            this.setBorder(new CompoundBorder(new LineBorder(this.focusColor, 2, true), new EmptyBorder(2, 2, 2, 2)));
        }
    }

    protected void setDefaultBorder() {
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
    }
}

