/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.actions.ActionBroker;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.components.BaseTaxonBrowserPanel;
import com.scythebill.birdlist.ui.components.NewLocationDialog;
import com.scythebill.birdlist.ui.datatransfer.SightingsGroup;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.panels.SpHybridDialog;
import com.scythebill.birdlist.ui.panels.SpeciesInfoDescriber;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.FocusTracker;
import com.scythebill.birdlist.ui.util.LocationScorer;
import com.scythebill.birdlist.ui.util.OpenMapUrl;
import com.scythebill.birdlist.ui.util.TaxonTreeModel;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class TaxonBrowsePanel
extends BaseTaxonBrowserPanel {
    private static final Logger logger = Logger.getLogger(TaxonBrowsePanel.class.getName());
    private TaxonTreeModel taxonTreeModel;
    private final ReportSet reportSet;
    private final ActionBroker actionBroker;
    private Taxon.Type depth;
    private TaxonFocusTracker taxonFocusTracker;
    private Predicate<Sighting> sightingPredicate;
    private Predicate<Taxon> taxonFilter;
    private boolean styledSpeciesWithSightings = true;

    @Inject
    public TaxonBrowsePanel(ReportSet reportSet, FontManager fontManager, NewLocationDialog newLocationDialog, SpHybridDialog spHybridDialog, PredefinedLocations predefinedLocations, ActionBroker actionBroker, SpeciesInfoDescriber speciesInfoDescriber, OpenMapUrl openMapUrl, FileDialogs fileDialogs, Alerts alerts, NavigableFrame navigableFrame, LocationScorer locationScorer) {
        super(fontManager, reportSet, newLocationDialog, spHybridDialog, predefinedLocations, speciesInfoDescriber, openMapUrl, fileDialogs, alerts, navigableFrame, locationScorer);
        this.reportSet = reportSet;
        this.actionBroker = actionBroker;
        this.taxonFocusTracker = new TaxonFocusTracker();
        this.setDragEnabled(true);
        this.setTransferHandler(new BaseTaxonBrowserPanel.TaxonTransferHandler(this));
    }

    public void setTaxonomy(Taxonomy taxonomy, Predicate<Taxon> taxonFilter) {
        this.taxonFilter = taxonFilter == null ? Predicates.alwaysTrue() : taxonFilter;
        this.setTaxonomy(taxonomy);
    }

    @Override
    public void setTaxonomy(Taxonomy taxonomy) {
        if (taxonomy == this.getTaxonomy()) {
            return;
        }
        boolean compatibleTaxonomies = TaxonUtils.areCompatible(this.getTaxonomy(), taxonomy);
        TreePath[] paths = this.getSelectionPaths();
        ArrayList<Taxon> taxa = Lists.newArrayList();
        if (paths != null) {
            TreePath[] treePathArray = paths;
            int n = treePathArray.length;
            block0: for (int i = 0; i < n; ++i) {
                for (TreePath path = treePathArray[i]; path != null; path = path.getParentPath()) {
                    if (!(path.getLastPathComponent() instanceof Taxon)) continue;
                    taxa.add((Taxon)path.getLastPathComponent());
                    continue block0;
                }
            }
        }
        this.clearSelection();
        super.setTaxonomy(taxonomy);
        ArrayList<TreePath> newPaths = Lists.newArrayList();
        if (compatibleTaxonomies) {
            LinkedHashSet<String> taxonIds = Sets.newLinkedHashSet();
            for (Taxon taxon : taxa) {
                MappedTaxonomy mappedTaxonomy;
                if (taxon.getTaxonomy() instanceof MappedTaxonomy) {
                    mappedTaxonomy = (MappedTaxonomy)taxon.getTaxonomy();
                    Preconditions.checkState(taxonomy == mappedTaxonomy.getBaseTaxonomy());
                    SightingTaxon mapping = mappedTaxonomy.getMapping(taxon);
                    if (mapping == null) continue;
                    taxonIds.addAll(mapping.getIds());
                    continue;
                }
                Preconditions.checkState(taxonomy instanceof MappedTaxonomy);
                mappedTaxonomy = (MappedTaxonomy)taxonomy;
                SightingTaxon.Resolved resolved = mappedTaxonomy.resolveInto(SightingTaxons.newSightingTaxon(taxon.getId()));
                if (resolved == null) continue;
                for (Taxon mappedTaxon : resolved.getTaxa()) {
                    taxonIds.add(mappedTaxon.getId());
                }
            }
            for (String id : TaxonUtils.mapToCommonLevel(taxonomy, taxonIds)) {
                Taxon mappedTaxon = taxonomy.getTaxon(id);
                if (mappedTaxon == null) continue;
                newPaths.add(this.toTreePath(mappedTaxon));
            }
        }
        if (this.depth != null) {
            this.setDepth(this.depth, newPaths.toArray(new TreePath[0]), this.taxonFilter);
        }
    }

    public void setDepth(Taxon.Type depth) {
        TreePath[] paths = this.getSelectionPaths();
        this.clearSelection();
        this.setDepth(depth, paths, this.taxonFilter);
    }

    public void setTaxonFilter(Predicate<Taxon> taxonFilter) {
        this.taxonFilter = taxonFilter == null ? Predicates.alwaysTrue() : taxonFilter;
        this.setDepth(this.depth);
    }

    public void setSightingPredicate(Predicate<Sighting> sightingPredicate) {
        this.sightingPredicate = sightingPredicate;
        if (this.taxonTreeModel != null) {
            this.taxonTreeModel.setSightingPredicate(sightingPredicate);
            TreePath[] selectedPaths = this.getSelectionPaths();
            if (selectedPaths.length > 0) {
                if (selectedPaths[0].getLastPathComponent() instanceof Sighting) {
                    this.setSelectionPath(selectedPaths[0].getParentPath());
                    this.taxonTreeModel.structureChanged(selectedPaths[0].getParentPath());
                } else {
                    for (TreePath selectedPath : selectedPaths) {
                        this.taxonTreeModel.structureChanged(selectedPath);
                    }
                }
            }
            this.repaint();
        }
    }

    private void setDepth(Taxon.Type depth, TreePath[] paths, Predicate<Taxon> taxonFilter) {
        this.depth = depth;
        ImmutableList.Builder levelsBuilder = ImmutableList.builder();
        if (depth == Taxon.Type.subspecies) {
            levelsBuilder.add((Object[])new Taxon.Type[]{Taxon.Type.subspecies, Taxon.Type.group});
        } else if (depth == Taxon.Type.group) {
            levelsBuilder.add((Object)Taxon.Type.group);
        }
        levelsBuilder.add((Object[])new Taxon.Type[]{Taxon.Type.species, Taxon.Type.family, Taxon.Type.order});
        ImmutableCollection levels = levelsBuilder.build();
        this.taxonTreeModel = new TaxonTreeModel(this.getTaxonomy(), (List<Taxon.Type>)((Object)levels), taxonFilter);
        this.taxonTreeModel.setReportSet(this.reportSet);
        this.taxonTreeModel.setSightingPredicate(this.sightingPredicate);
        this.setModel(this.taxonTreeModel);
        if (paths != null) {
            final ArrayList<TreePath> newPaths = Lists.newArrayList();
            for (TreePath path : paths) {
                while (!(path.getLastPathComponent() instanceof Taxon && levels.contains((Object)((Taxon)path.getLastPathComponent()).getType()) || (path = path.getParentPath()) == null)) {
                }
                if (path == null) continue;
                newPaths.add(path);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (newPaths.size() > 0) {
                        TaxonBrowsePanel.this.getSelectionModel().addSelectionPaths(newPaths.toArray(new TreePath[newPaths.size()]));
                        TaxonBrowsePanel.this.ensurePathIsVisible((TreePath)newPaths.get(0));
                    }
                }
            });
        }
    }

    public void selectTaxon(String taxonId) {
        Taxon taxon = this.getTaxonomy().getTaxon(taxonId);
        if (taxon != null) {
            TreePath path = this.toTreePath(taxon);
            this.getSelectionModel().setSelectionPath(path);
            this.ensurePathIsVisible(path);
            this.requestFocus();
        } else {
            logger.warning("Could not find taxon to select: " + taxonId);
        }
    }

    private TreePath toTreePath(Taxon taxon) {
        if (taxon.getType() == Taxon.Type.order) {
            return new TreePath(new Object[]{this.getTaxonomy().getRoot(), TaxonUtils.getParentOfType(taxon, Taxon.Type.order)});
        }
        if (taxon.getType() == Taxon.Type.family) {
            return new TreePath(new Object[]{this.getTaxonomy().getRoot(), TaxonUtils.getParentOfType(taxon, Taxon.Type.order), TaxonUtils.getParentOfType(taxon, Taxon.Type.family)});
        }
        if (taxon.getType() == Taxon.Type.group) {
            return new TreePath(new Object[]{this.getTaxonomy().getRoot(), TaxonUtils.getParentOfType(taxon, Taxon.Type.order), TaxonUtils.getParentOfType(taxon, Taxon.Type.family), TaxonUtils.getParentOfType(taxon, Taxon.Type.species), taxon});
        }
        if (taxon.getType() == Taxon.Type.subspecies) {
            if (taxon.getParent().getType() == Taxon.Type.group) {
                return new TreePath(new Object[]{this.getTaxonomy().getRoot(), TaxonUtils.getParentOfType(taxon, Taxon.Type.order), TaxonUtils.getParentOfType(taxon, Taxon.Type.family), TaxonUtils.getParentOfType(taxon, Taxon.Type.species), TaxonUtils.getParentOfType(taxon, Taxon.Type.group), taxon});
            }
            return new TreePath(new Object[]{this.getTaxonomy().getRoot(), TaxonUtils.getParentOfType(taxon, Taxon.Type.order), TaxonUtils.getParentOfType(taxon, Taxon.Type.family), TaxonUtils.getParentOfType(taxon, Taxon.Type.species), taxon});
        }
        return new TreePath(new Object[]{this.getTaxonomy().getRoot(), TaxonUtils.getParentOfType(taxon, Taxon.Type.order), TaxonUtils.getParentOfType(taxon, Taxon.Type.family), TaxonUtils.getParentOfType(taxon, Taxon.Type.species)});
    }

    private boolean isFirstSpeciesInGenus(Taxon taxon) {
        Taxon genus = TaxonUtils.getParentOfType(taxon, Taxon.Type.genus);
        List<Taxon> contents = genus.getContents();
        for (int i = 0; i < contents.size(); ++i) {
            Taxon species = contents.get(i);
            if (!this.taxonFilter.apply(species)) continue;
            return species == taxon;
        }
        return false;
    }

    @Override
    protected Font deriveTaxonFont(Font base, Taxon taxon, boolean leaf) {
        base = super.deriveTaxonFont(base, taxon, leaf);
        switch (taxon.getType()) {
            case species: {
                if (!this.styledSpeciesWithSightings) {
                    return base;
                }
            }
            case group: 
            case subspecies: {
                int style = this.taxonTreeModel.getSightingsOf(taxon).isEmpty() ? 2 : 1;
                return base.deriveFont(style);
            }
        }
        return base;
    }

    @Override
    protected boolean abbreviateGenus(Taxon taxon) {
        return !this.isFirstSpeciesInGenus(taxon);
    }

    @Override
    protected boolean usePreviewColumn(TreePath[] paths) {
        boolean usePreviewDefault = super.usePreviewColumn(paths);
        if (!usePreviewDefault) {
            return false;
        }
        return paths.length != 1 || paths[0].getLastPathComponent() instanceof Sighting;
    }

    public Action getCutAction() {
        return this.taxonFocusTracker.cut;
    }

    @Override
    protected void doMove(SightingsGroup sightings) {
        TreePath selectionPath;
        this.reportSet.mutator().removing(sightings.getSightings()).mutate();
        this.taxonTreeModel.sightingsRemoved(sightings.getParentPath(), sightings.getSightings(), sightings.getOriginalIndices());
        Rectangle pathBounds = this.getPathBounds(sightings.getParentPath());
        if (pathBounds != null) {
            this.repaint(pathBounds);
        }
        for (selectionPath = this.getSelectionPath(); selectionPath != null && selectionPath.getLastPathComponent() instanceof Sighting; selectionPath = selectionPath.getParentPath()) {
        }
        if (selectionPath != null) {
            this.setSelectionPath(selectionPath);
        } else {
            this.setSelectionPath(sightings.getParentPath());
        }
    }

    public void addSighting(TreePath treePath, Sighting sighting) {
        this.addSightings(treePath, ImmutableList.of(sighting));
    }

    @Override
    protected boolean doImport(TransferHandler.TransferSupport transferSupportUnused, SightingsGroup sightings, TreePath target) {
        Taxon taxon;
        if (target.getLastPathComponent() instanceof Taxon) {
            taxon = (Taxon)target.getLastPathComponent();
        } else if (target.getLastPathComponent() instanceof Sighting) {
            Object penultimate = (target = target.getParentPath()).getLastPathComponent();
            if (!(penultimate instanceof Taxon)) {
                return false;
            }
            taxon = (Taxon)penultimate;
        } else {
            return false;
        }
        if (taxon.getType().compareTo(Taxon.Type.species) > 0 || taxon.isDisabled()) {
            return false;
        }
        ImmutableList.Builder newSightingsBuilder = ImmutableList.builder();
        for (Sighting.Builder sighting : sightings.sightingBuilders()) {
            Sighting newSighting = sighting.setTaxon(taxon).build();
            newSightingsBuilder.add(newSighting);
        }
        ImmutableCollection newSightings = newSightingsBuilder.build();
        this.addSightings(target, (ImmutableList<Sighting>)newSightings);
        for (Map.Entry entry : sightings.getVisitInfoMap().entrySet()) {
            if (this.reportSet.getVisitInfo((VisitInfoKey)entry.getKey()) != null) continue;
            this.reportSet.putVisitInfo((VisitInfoKey)entry.getKey(), (VisitInfo)entry.getValue());
        }
        return true;
    }

    @Override
    protected boolean canMoveSightings() {
        return true;
    }

    private void addSightings(TreePath target, ImmutableList<Sighting> newSightings) {
        this.reportSet.mutator().adding(newSightings).mutate();
        this.taxonTreeModel.sightingsAdded(target, newSightings);
        TreePath[] paths = new TreePath[newSightings.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = target.pathByAddingChild(newSightings.get(i));
        }
        SwingUtilities.invokeLater(() -> {
            if (paths.length > 1) {
                this.setSelectionPath(paths[0]);
            }
            this.setSelectionPaths(paths);
            this.requestFocus();
        });
        Rectangle pathBounds = this.getPathBounds(target);
        if (pathBounds != null) {
            this.repaint(pathBounds);
        }
    }

    @Override
    protected void sightingsReplaced(TreePath parent, List<Sighting> oldSightings, List<Sighting> newSightings, int[] oldIndices) {
        Taxon taxon = (Taxon)parent.getLastPathComponent();
        SightingTaxon sightingTaxon = newSightings.get(0).getTaxon();
        if ((sightingTaxon = sightingTaxon.resolve(taxon.getTaxonomy()).getSightingTaxon()).shouldBeDisplayedWith(taxon.getId())) {
            this.taxonTreeModel.sightingsReplaced(parent, oldSightings, newSightings, oldIndices);
        } else {
            this.taxonTreeModel.sightingsRemoved(parent, oldSightings, oldIndices);
        }
    }

    @Override
    protected TreePath pathToSighting(TreePath oldParentPath, Sighting sighting) {
        SightingTaxon.Resolved resolved = sighting.getTaxon().resolve(this.getTaxonomy());
        Taxon taxon = resolved.getTaxa().iterator().next();
        taxon = TaxonUtils.getParentOfAtLeastType(taxon, this.depth);
        return this.toTreePath(taxon).pathByAddingChild(sighting);
    }

    public void setStyledSpeciesWithSightings(boolean styledSpeciesWithSightings) {
        this.styledSpeciesWithSightings = styledSpeciesWithSightings;
    }

    @Override
    protected String getReturnPanelName() {
        return "browse";
    }

    @Override
    protected BaseTaxonBrowserPanel.PostNavigateAction returnToSighting(TreePath oldParentPath, Sighting sighting) {
        return new ReturnToSighting(sighting);
    }

    private class TaxonFocusTracker
    extends FocusTracker {
        private final Action cut;
        private final Action copy;
        private final Action paste;

        public TaxonFocusTracker() {
            super(TaxonBrowsePanel.this);
            this.cut = new BaseTaxonBrowserPanel.CutActionWrapper(TaxonBrowsePanel.this, TransferHandler.getCutAction());
            this.copy = new BaseTaxonBrowserPanel.CopyActionWrapper(TaxonBrowsePanel.this, TransferHandler.getCopyAction());
            this.paste = new BaseTaxonBrowserPanel.PasteActionWrapper(TaxonBrowsePanel.this, TransferHandler.getPasteAction());
        }

        @Override
        protected void focusGained(Component child) {
            TaxonBrowsePanel.this.actionBroker.publishAction("cut", this.cut);
            TaxonBrowsePanel.this.actionBroker.publishAction("copy", this.copy);
            TaxonBrowsePanel.this.actionBroker.publishAction("paste", this.paste);
        }

        @Override
        protected void focusLost(Component child) {
            TaxonBrowsePanel.this.actionBroker.unpublishAction("cut", this.cut);
            TaxonBrowsePanel.this.actionBroker.unpublishAction("copy", this.copy);
            TaxonBrowsePanel.this.actionBroker.unpublishAction("paste", this.paste);
        }
    }

    static class ReturnToSighting
    implements BaseTaxonBrowserPanel.PostNavigateAction {
        private final Sighting sighting;

        public ReturnToSighting(Sighting sighting) {
            this.sighting = sighting;
        }

        @Override
        public void postNavigate(JPanel panel) {
            TaxonBrowsePanel taxonBrowsePanel = UIUtils.findChildOfType(panel, TaxonBrowsePanel.class);
            if (taxonBrowsePanel != null) {
                Taxonomy taxonomy = taxonBrowsePanel.getTaxonomy();
                if (TaxonUtils.areCompatible(this.sighting.getTaxonomy(), taxonomy)) {
                    TreePath taxonPath;
                    Taxon taxon = this.sighting.getTaxon().resolve(taxonomy).getTaxa().iterator().next();
                    TreePath selectedPath = taxonPath = taxonBrowsePanel.toTreePath(taxon);
                    if (taxonPath != null) {
                        TreeModel model = taxonBrowsePanel.getModel();
                        VisitInfoKey originalSightingKey = VisitInfoKey.forSighting(this.sighting);
                        if (originalSightingKey != null) {
                            int childCount = model.getChildCount(taxonPath.getLastPathComponent());
                            for (int i = 0; i < childCount; ++i) {
                                Sighting s;
                                Object child = model.getChild(taxonPath.getLastPathComponent(), i);
                                if (!(child instanceof Sighting) || !originalSightingKey.equals(VisitInfoKey.forSighting(s = (Sighting)child))) continue;
                                selectedPath = selectedPath.pathByAddingChild(child);
                                break;
                            }
                        }
                    }
                    if (selectedPath != null) {
                        taxonBrowsePanel.getSelectionModel().setSelectionPath(selectedPath);
                        taxonBrowsePanel.ensurePathIsVisible(selectedPath);
                    }
                    taxonBrowsePanel.requestFocus();
                }
            }
        }
    }
}

