/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.components.table.ExpandColumn;
import com.scythebill.birdlist.ui.components.table.ExpandableTable;
import com.scythebill.birdlist.ui.components.table.LabelColumn;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.ListListModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public abstract class SpeciesTablePanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private ExpandableTable<SightingTaxon.Resolved> speciesTable;
    private boolean editable;
    private List<SightingTaxon.Resolved> oldTaxonList = ImmutableList.of();
    private SightingTaxon.Resolved selectedTaxon;
    private Predicate<SightingTaxon.Resolved> isImportantPredicate = Predicates.alwaysFalse();
    private JScrollPane scrollPane;
    private FontManager fontManager;
    private ExpandableTable.DetailView<SightingTaxon.Resolved> expandedRowView;
    private String detailTitle;

    protected SpeciesTablePanel(ExpandableTable.DetailView<SightingTaxon.Resolved> expandedRowView, String detailTitle, FontManager fontManager) {
        this.expandedRowView = expandedRowView;
        this.detailTitle = detailTitle;
        this.fontManager = fontManager;
    }

    protected void init() {
        this.initComponents(this.expandedRowView, this.detailTitle);
        this.hookUpContents();
        this.fontsUpdated(this.fontManager);
    }

    public void addUserModificationListener(UserModificationListener l) {
        this.listenerList.add(UserModificationListener.class, l);
    }

    protected void notifyUserModifiedValue() {
        for (UserModificationListener l : (UserModificationListener[])this.getListeners(UserModificationListener.class)) {
            l.userModifiedValue();
        }
    }

    public void addColumn(ExpandableTable.Column<SightingTaxon.Resolved> column) {
        this.speciesTable.addColumn(column);
    }

    public void flushEdits() {
        this.speciesTable.setExpandedIndex(-1);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    private void hookUpContents() {
        this.speciesTable.addPropertyChangeListener("selectedIndex", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int newSelectedIndex = SpeciesTablePanel.this.speciesTable.getSelectedIndex();
                SpeciesTablePanel.this.setSelectedTaxon(newSelectedIndex >= 0 ? SpeciesTablePanel.this.getListModel().asList().get(newSelectedIndex) : null);
            }
        });
        this.speciesTable.addPropertyChangeListener("selectedIndex", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (SpeciesTablePanel.this.speciesTable.getSelectedIndex() != -1 && SpeciesTablePanel.this.speciesTable.getSelectedIndex() != SpeciesTablePanel.this.speciesTable.getExpandedIndex()) {
                    SpeciesTablePanel.this.speciesTable.setExpandedIndex(-1);
                }
            }
        });
    }

    public boolean selectSpecies(SightingTaxon.Resolved resolved, boolean scrollWithVisibleContext) {
        int index = this.findTaxon(resolved);
        if (index >= 0) {
            if (scrollWithVisibleContext) {
                this.speciesTable.setSelectedIndexWithVisibleContext(index);
            } else {
                this.speciesTable.setSelectedIndex(index);
            }
            return true;
        }
        this.speciesTable.setSelectedIndex(-1);
        return false;
    }

    public int findTaxon(SightingTaxon.Resolved resolved) {
        int index = resolved == null ? -1 : this.getListModel().asList().indexOf(resolved);
        return index;
    }

    public void resolvedUpdated(SightingTaxon.Resolved resolved) {
        int row = this.findTaxon(resolved);
        if (row >= 0) {
            this.getListModel().asList().set(row, resolved);
        }
    }

    public boolean expandSpeciesDetail(SightingTaxon.Resolved selectedSpecies) {
        int index = this.findTaxon(selectedSpecies);
        if (index >= 0) {
            if (this.speciesTable.getEnabledRowsModel().isIncluded(index)) {
                this.speciesTable.setExpandedIndex(index);
            }
            return true;
        }
        this.speciesTable.setExpandedIndex(-1);
        return false;
    }

    public void focusOnSpeciesDetail() {
        this.speciesTable.focusOnExpandedIndex();
    }

    public SightingTaxon.Resolved getSelectedSpecies() {
        return (SightingTaxon.Resolved)this.speciesTable.getSelectedValue();
    }

    public SightingTaxon.Resolved getSpecies(int index) {
        return this.speciesTable.getModel().getElementAt(index);
    }

    public void setIsImportant(Predicate<SightingTaxon.Resolved> isImportantPredicate) {
        this.isImportantPredicate = isImportantPredicate;
    }

    public abstract void setSortedContents(Taxonomy var1, List<SightingTaxon.Resolved> var2);

    protected abstract ListListModel<SightingTaxon.Resolved> getListModel();

    public abstract void addSpecies(SightingTaxon.Resolved var1);

    public abstract void removeSpecies(SightingTaxon.Resolved var1);

    public abstract void swapSpecies(SightingTaxon.Resolved var1, SightingTaxon.Resolved var2);

    public abstract ImmutableList<SightingTaxon.Resolved> getValue();

    protected void fireValueChanged() {
        ImmutableList<SightingTaxon.Resolved> newTaxonList = this.getValue();
        this.firePropertyChange("value", this.oldTaxonList, newTaxonList);
        this.oldTaxonList = newTaxonList;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.speciesTable.requestFocusInWindow();
    }

    private void setSelectedTaxon(SightingTaxon.Resolved resolved) {
        this.firePropertyChange("selectedValue", this.selectedTaxon, resolved);
        this.selectedTaxon = resolved;
    }

    protected void speciesTableCreated() {
    }

    private void initComponents(ExpandableTable.DetailView<SightingTaxon.Resolved> expandedRowView, String detailTitle) {
        this.scrollPane = new JScrollPane();
        this.setFocusScrollPaneBorder(false);
        this.speciesTable = new ExpandableTable<SightingTaxon.Resolved>(SightingTaxon.Resolved.class, this.fontManager);
        this.speciesTable.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                SpeciesTablePanel.this.setFocusScrollPaneBorder(false);
            }

            @Override
            public void focusGained(FocusEvent e) {
                SpeciesTablePanel.this.setFocusScrollPaneBorder(true);
            }
        });
        this.speciesTableCreated();
        if (expandedRowView != null) {
            this.speciesTable.addColumn(new ExpandColumn<SightingTaxon.Resolved>(this.speciesTable, detailTitle));
            this.speciesTable.setExpandedRowView(expandedRowView);
        }
        this.speciesTable.addColumn(new TaxonColumn(ExpandableTable.ColumnLayout.weightedWidth(1.0f)));
        this.speciesTable.setActionMap(new ActionMap());
        this.speciesTable.setModel(this.getListModel());
        this.scrollPane.setViewportView(this.speciesTable);
        this.scrollPane.setColumnHeaderView(this.speciesTable.getColumnHeader());
    }

    private void setFocusScrollPaneBorder(boolean isFocused) {
        if (isFocused) {
            Color focusColor = UIManager.getColor("Focus.color");
            if (focusColor == null && (focusColor = UIManager.getColor("Button.focus")) == null) {
                focusColor = UIManager.getColor("TextField.selectionBackground");
            }
            if (focusColor != null) {
                this.scrollPane.setBorder(new LineBorder(focusColor, 2, true));
                return;
            }
        }
        this.scrollPane.setBorder(new EmptyBorder(2, 2, 2, 2));
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.scrollPane, -1, fontManager.scale(395), Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent(this.scrollPane, -1, fontManager.scale(340), Short.MAX_VALUE));
        this.speciesTable.setLineHeight(fontManager.scale(24));
    }

    public ExpandableTable<SightingTaxon.Resolved> getSpeciesTable() {
        return this.speciesTable;
    }

    protected void customizeSpeciesLabel(JLabel label) {
    }

    public static interface UserModificationListener
    extends EventListener {
        public void userModifiedValue();
    }

    private class TaxonColumn
    extends LabelColumn<SightingTaxon.Resolved> {
        public TaxonColumn(ExpandableTable.ColumnLayout width) {
            super(width, Messages.getMessage(Messages.Name.SPECIES_TEXT));
        }

        @Override
        public JComponent createComponent(final SightingTaxon.Resolved value, Set<ExpandableTable.RowState> states) {
            JLabel label = new JLabel(this.getText(value)){

                @Override
                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                    if (!"parent".equals(propertyName) && !"ancestor".equals(propertyName)) {
                        super.firePropertyChange(propertyName, oldValue, newValue);
                    }
                }

                @Override
                protected void paintComponent(Graphics g) {
                    if (SpeciesTablePanel.this.isImportantPredicate.apply(value)) {
                        g.setFont(g.getFont().deriveFont(1));
                        if ((this.getFont().getStyle() & 1) == 0) {
                            this.setFont(g.getFont());
                        }
                    } else if ((this.getFont().getStyle() & 1) != 0) {
                        this.setFont(this.getFont().deriveFont(0));
                    }
                    super.paintComponent(g);
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension preferredSize = super.getPreferredSize();
                    preferredSize.width = Short.MAX_VALUE;
                    return preferredSize;
                }
            };
            label.setOpaque(false);
            label.setFocusable(false);
            label.setBorder(new EmptyBorder(0, 3, 0, 0));
            label.putClientProperty("birdlist.plainLabel", true);
            SpeciesTablePanel.this.customizeSpeciesLabel(label);
            this.updateComponentState(label, value, states);
            return label;
        }

        @Override
        protected String getText(SightingTaxon.Resolved value) {
            if (value.getSmallestTaxonType() != Taxon.Type.species) {
                value = value.resolveParentOfType(Taxon.Type.species);
            }
            return value.getPreferredSingleName();
        }
    }
}

