/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.messages.Messages;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;

public class SpeciesIndexerPanelConfigurer {
    private final NamesPreferences namesPreferences;

    public static SpeciesIndexerPanelConfigurer unconfigured() {
        return new SpeciesIndexerPanelConfigurer(new NamesPreferences());
    }

    @Inject
    public SpeciesIndexerPanelConfigurer(NamesPreferences namesPreferences) {
        this.namesPreferences = namesPreferences;
    }

    public void configure(IndexerPanel<String> indexer, Taxonomy taxonomy) {
        indexer.setPreviewText(Messages.Name.TYPE_A_SPECIES_NAME);
        indexer.removeAllIndexerGroups();
        switch (this.namesPreferences.scientificOrCommon) {
            case COMMON_FIRST: {
                this.addCommonNameIndices(indexer, taxonomy);
                this.addScientificIndices(indexer, taxonomy);
                break;
            }
            case SCIENTIFIC_FIRST: {
                this.addScientificIndices(indexer, taxonomy);
                this.addCommonNameIndices(indexer, taxonomy);
                break;
            }
            case SCIENTIFIC_ONLY: {
                this.addScientificIndices(indexer, taxonomy);
                break;
            }
            case COMMON_ONLY: {
                this.addCommonNameIndices(indexer, taxonomy);
            }
        }
    }

    private void addScientificIndices(IndexerPanel<String> indexer, final Taxonomy taxonomy) {
        ToString<String> sciToString = new ToString<String>(){

            @Override
            public String getString(String taxonId) {
                Taxon taxon = taxonomy.getTaxon(taxonId);
                return taxon == null ? null : TaxonUtils.getFullName(taxon);
            }

            @Override
            public String getPreviewString(String taxonId) {
                return this.getString(taxonId);
            }
        };
        indexer.addIndexerGroup(sciToString, taxonomy.getScientificIndexer());
        if (taxonomy.getAlternateScientificIndexer() != null) {
            indexer.addAlternateIndexerGroup(sciToString, taxonomy.getAlternateScientificIndexer());
        }
    }

    private void addCommonNameIndices(IndexerPanel<String> indexer, final Taxonomy taxonomy) {
        ToString<String> commonToString;
        Indexer<String> localized = taxonomy.getLocalizedCommonIndexer();
        if (localized != null) {
            commonToString = new ToString<String>(){

                @Override
                public String getString(String taxonId) {
                    Taxon taxon = taxonomy.getTaxon(taxonId);
                    if (taxon == null) {
                        return null;
                    }
                    if (taxon.getCommonName() == null && TaxonUtils.getParentOfType(taxon, Taxon.Type.species).getCommonName() == null) {
                        return null;
                    }
                    return TaxonUtils.getCommonName(taxon);
                }

                @Override
                public String getPreviewString(String taxonId) {
                    return this.getString(taxonId);
                }
            };
            indexer.addIndexerGroup(commonToString, localized);
        }
        commonToString = new ToString<String>(){

            @Override
            public String getString(String taxonId) {
                Taxon taxon = taxonomy.getTaxon(taxonId);
                if (taxon == null) {
                    return null;
                }
                if (taxon.getCommonName() == null && TaxonUtils.getParentOfType(taxon, Taxon.Type.species).getCommonName() == null) {
                    return null;
                }
                return TaxonUtils.getEnglishCommonName(taxon);
            }

            @Override
            public String getPreviewString(String taxonId) {
                return this.getString(taxonId);
            }
        };
        indexer.addIndexerGroup(commonToString, taxonomy.getCommonIndexer());
        if (taxonomy.getAlternateCommonIndexer() != null) {
            indexer.addAlternateIndexerGroup(commonToString, taxonomy.getAlternateCommonIndexer());
        }
    }

    public void addSimpleTaxa(IndexerPanel<String> indexer, Taxonomy taxonomy, Iterable<Taxon> taxa) {
        switch (this.namesPreferences.scientificOrCommon) {
            case COMMON_FIRST: {
                this.addSimpleIndices(indexer, taxonomy, taxa, t -> TaxonUtils.getCommonName(t));
                this.addSimpleIndices(indexer, taxonomy, taxa, t -> TaxonUtils.getFullName(t));
                break;
            }
            case SCIENTIFIC_FIRST: {
                this.addSimpleIndices(indexer, taxonomy, taxa, t -> TaxonUtils.getFullName(t));
                this.addSimpleIndices(indexer, taxonomy, taxa, t -> TaxonUtils.getCommonName(t));
                break;
            }
            case SCIENTIFIC_ONLY: {
                this.addSimpleIndices(indexer, taxonomy, taxa, t -> TaxonUtils.getFullName(t));
                break;
            }
            case COMMON_ONLY: {
                this.addSimpleIndices(indexer, taxonomy, taxa, t -> TaxonUtils.getCommonName(t));
            }
        }
    }

    public void configureQuery(IndexerPanel<String> speciesIndexPanel, QueryResults queryResults) {
        List<SightingTaxon.Resolved> queriedTaxa = queryResults.getTaxaAsList();
        if (queriedTaxa.isEmpty()) {
            speciesIndexPanel.setEnabled(false);
        } else if (queryResults.getSmallestType() == Taxon.Type.species) {
            this.configure(speciesIndexPanel, queryResults.getTaxonomy());
            LinkedHashSet<String> taxa = new LinkedHashSet<String>();
            for (SightingTaxon.Resolved resolved : queriedTaxa) {
                if (resolved.getType() != SightingTaxon.Type.SINGLE) continue;
                Taxon taxon = resolved.getTaxon();
                taxa.add(taxon.getId());
            }
            speciesIndexPanel.setFilter(taxa::contains);
            speciesIndexPanel.setEnabled(true);
        } else {
            speciesIndexPanel.removeAllIndexerGroups();
            speciesIndexPanel.setFilter(null);
            this.addSimpleTaxa(speciesIndexPanel, queryResults.getTaxonomy(), queriedTaxa.stream().filter(r -> r.getType() == SightingTaxon.Type.SINGLE).map(SightingTaxon.Resolved::getTaxon).collect(ImmutableList.toImmutableList()));
        }
    }

    private void addSimpleIndices(IndexerPanel<String> indexerPanel, final Taxonomy taxonomy, Iterable<Taxon> taxa, final Function<Taxon, String> toString) {
        Indexer<String> indexer = new Indexer<String>();
        boolean foundOne = false;
        for (Taxon taxon : taxa) {
            String name = toString.apply(taxon);
            if (name == null) continue;
            foundOne = true;
            indexer.add(name, taxon.getId());
        }
        if (foundOne) {
            indexerPanel.addIndexerGroup(new ToString<String>(){

                @Override
                public String getString(String id) {
                    Taxon taxon = taxonomy.getTaxon(id);
                    return taxon == null ? null : (String)toString.apply(taxon);
                }
            }, indexer);
        }
    }
}

