/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.util.AndDirty;
import com.scythebill.birdlist.model.util.Dirty;
import com.scythebill.birdlist.model.util.DirtyImpl;
import com.scythebill.birdlist.ui.components.SpResolverComboBox;
import com.scythebill.birdlist.ui.components.TextLink;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.SpHybridDialog;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

final class SpResolverUi {
    final JComponent spLabel;
    final JComponent spInfoPanel;
    final JComponent spResolverPanel;
    final JComponent separator;
    final JButton spHybridButton;
    final DirtyImpl dirty = new DirtyImpl(false);
    final Dirty combinedDirty;
    private final SpResolverComboBox spResolver;
    private JTextArea speciesInfo;
    private SightingTaxon spHybridTaxon;
    private final SpHybridDialog spHybridDialog;
    private SightingTaxon originalSightingTaxon;
    private Taxon originalTaxon;

    public SpResolverUi(SpResolverComboBox spResolver, Alerts alerts, @Nullable SpHybridDialog spHybridDialog) {
        this.spResolver = spResolver;
        this.spHybridDialog = spHybridDialog;
        JButton jButton = this.spHybridButton = spHybridDialog == null ? null : new JButton(Messages.getMessage(Messages.Name.SP_HYBRID_BUTTON));
        if (spResolver != null) {
            this.spResolverPanel = Box.createHorizontalBox();
            this.spResolverPanel.add(spResolver);
            if (this.spHybridButton != null) {
                this.spResolverPanel.add(Box.createHorizontalStrut(3));
                this.spResolverPanel.add(this.spHybridButton);
                this.spResolverPanel.add(Box.createHorizontalGlue());
            }
            this.spLabel = Box.createHorizontalBox();
            this.spLabel.add(new JLabel(Messages.getMessage(Messages.Name.CHANGE_TO_LABEL)));
            this.spLabel.add(Box.createHorizontalGlue());
            TextLink rangeSummary = new TextLink(Messages.getMessage(Messages.Name.RANGE_SUMMARY_LINK));
            this.spLabel.add(rangeSummary);
            rangeSummary.addActionListener(e -> {
                String formattedMessage = alerts.getFormattedDialogMessage(Messages.Name.RANGE_SUMMARY, Messages.Name.RANGE_SUMMARY_MESSAGE, new Object[0]);
                alerts.showScrollableInfo(rangeSummary, formattedMessage, spResolver.getRangeSummary());
            });
            this.spLabel.add(Box.createHorizontalGlue());
            this.speciesInfo = new JTextArea();
            this.speciesInfo.setEditable(false);
            this.speciesInfo.setLineWrap(true);
            this.speciesInfo.setWrapStyleWord(true);
            this.speciesInfo.setRows(2);
            this.speciesInfo.setOpaque(false);
            JScrollPane speciesInfoScrollPane = new JScrollPane(this.speciesInfo);
            speciesInfoScrollPane.setVerticalScrollBarPolicy(20);
            speciesInfoScrollPane.setHorizontalScrollBarPolicy(31);
            speciesInfoScrollPane.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
            speciesInfoScrollPane.setOpaque(false);
            speciesInfoScrollPane.getViewport().setOpaque(false);
            speciesInfoScrollPane.setBorder(null);
            this.spInfoPanel = speciesInfoScrollPane;
            spResolver.addActionListener(e -> this.updateSpeciesInfo(this.speciesInfo));
            this.updateSpeciesInfo(this.speciesInfo);
            this.separator = new JSeparator();
            this.combinedDirty = new AndDirty(this.dirty, spResolver.getDirty());
        } else {
            this.spLabel = new JLabel();
            this.spInfoPanel = new JLabel();
            this.separator = new JLabel();
            if (this.spHybridButton == null) {
                this.spResolverPanel = new JLabel();
            } else {
                this.spResolverPanel = Box.createHorizontalBox();
                JLabel changeToLabel = new JLabel(Messages.getMessage(Messages.Name.CHANGE_TO_LABEL));
                this.spResolverPanel.add(changeToLabel);
                this.spResolverPanel.add(Box.createHorizontalStrut(5));
                this.spResolverPanel.add(this.spHybridButton);
                this.spHybridButton.addPropertyChangeListener("enabled", e -> changeToLabel.setEnabled(this.spHybridButton.isEnabled()));
            }
            this.combinedDirty = this.dirty;
        }
    }

    public void revert() {
        this.clearDirty();
        this.spHybridTaxon = null;
        if (this.spHybridButton != null) {
            this.spHybridButton.setEnabled(true);
        }
        if (this.spResolver != null) {
            this.spResolver.setEnabled(true);
        }
        if (this.originalTaxon != null) {
            this.reconfigureSpHybridButton(this.originalTaxon);
        } else if (this.originalSightingTaxon != null) {
            this.reconfigureSpHybridButtonForExistingSpOrHybrid(this.originalSightingTaxon);
        }
    }

    public void configureSpHybridButton(Taxon taxon) {
        this.originalTaxon = taxon;
        this.originalSightingTaxon = null;
        this.reconfigureSpHybridButton(taxon);
    }

    private void reconfigureSpHybridButton(Taxon taxon) {
        this.spHybridButton.setText(Messages.getMessage(Messages.Name.SP_HYBRID_BUTTON));
        for (ActionListener l : this.spHybridButton.getActionListeners()) {
            this.spHybridButton.removeActionListener(l);
        }
        this.spHybridButton.addActionListener(e -> this.spHybridDialog.showDialog(this.spResolverPanel, taxon, this::rememberSpHybrid));
    }

    public void configureSpHybridButtonForExistingSpOrHybrid(SightingTaxon sightingTaxon) {
        this.originalTaxon = null;
        this.originalSightingTaxon = sightingTaxon;
        this.reconfigureSpHybridButtonForExistingSpOrHybrid(sightingTaxon);
    }

    private void reconfigureSpHybridButtonForExistingSpOrHybrid(SightingTaxon sightingTaxon) {
        for (ActionListener l : this.spHybridButton.getActionListeners()) {
            this.spHybridButton.removeActionListener(l);
        }
        if (sightingTaxon.getType() == SightingTaxon.Type.HYBRID) {
            this.spHybridButton.setText(Messages.getMessage(Messages.Name.SP_BUTTON));
            SightingTaxon sp = SightingTaxons.newSpTaxon(sightingTaxon.getIds());
            this.spHybridButton.addActionListener(e -> this.rememberSpHybrid(sp));
        } else if (sightingTaxon.getType() == SightingTaxon.Type.SP) {
            this.spHybridButton.setText(Messages.getMessage(Messages.Name.HYBRID_BUTTON));
            SightingTaxon hybrid = SightingTaxons.newHybridTaxon(sightingTaxon.getIds());
            this.spHybridButton.addActionListener(e -> this.rememberSpHybrid(hybrid));
        } else {
            throw new IllegalArgumentException("Not supported for " + sightingTaxon);
        }
    }

    public SightingTaxon getNewSightingTaxon() {
        if (this.spHybridTaxon != null) {
            return this.spHybridTaxon.resolveInternal(this.originalTaxon.getTaxonomy()).getSightingTaxonInBaseTaxonomy();
        }
        if (this.spResolver == null) {
            return null;
        }
        return this.spResolver.getSightingTaxonInBaseTaxonomy();
    }

    private void rememberSpHybrid(SightingTaxon spHybridTaxon) {
        this.dirty.setDirty(true);
        this.spHybridTaxon = spHybridTaxon;
        this.reconfigureSpHybridButtonForExistingSpOrHybrid(spHybridTaxon);
        if (this.spResolver != null) {
            this.spResolver.setEnabled(false);
        }
    }

    private void updateSpeciesInfo(JTextArea speciesInfo) {
        Taxon species;
        SightingTaxon.Resolved resolved = this.spResolver.getResolved();
        if ((resolved.getType() == SightingTaxon.Type.SINGLE || resolved.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) && (species = resolved.getTaxon()) instanceof Species) {
            String info = TaxonUtils.getRange((Species)species);
            speciesInfo.setText(info == null ? "" : info);
            speciesInfo.select(0, 0);
            speciesInfo.setEnabled(true);
            return;
        }
        speciesInfo.setText(Messages.getMessage(Messages.Name.SPECIES_INFORMATION_WILL_APPEAR_HERE));
        speciesInfo.setEnabled(false);
    }

    public void clearDirty() {
        if (this.spResolver != null) {
            this.spResolver.clearDirty();
        }
        this.dirty.setDirty(false);
    }

    public Dirty getDirty() {
        return this.combinedDirty;
    }
}

