/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.util.Dirty;
import com.scythebill.birdlist.model.util.DirtyImpl;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

class SpResolverComboBox
extends JComboBox<ResolvedAndText> {
    private final SightingTaxon.Resolved resolved;
    private final DirtyImpl dirty;

    public static SpResolverComboBox forResolved(SightingTaxon.Resolved resolved) {
        Taxon taxon;
        if (resolved.getType() == SightingTaxon.Type.SP || resolved.getType() == SightingTaxon.Type.HYBRID) {
            return new SpResolverComboBox(resolved);
        }
        if (resolved.getSmallestTaxonType() == Taxon.Type.species && (taxon = resolved.getTaxon()).getContents().isEmpty()) {
            return null;
        }
        return new SpResolverComboBox(resolved);
    }

    private SpResolverComboBox(SightingTaxon.Resolved resolved) {
        this.resolved = resolved;
        this.setModel(this.newModel());
        this.setMaximumRowCount(Math.min(25, this.getModel().getSize()));
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            ResolvedAndText value = (ResolvedAndText)this.getModel().getElementAt(i);
            if (!value.resolved.equals(resolved)) continue;
            this.setSelectedIndex(i);
            break;
        }
        this.dirty = new DirtyImpl(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpResolverComboBox.this.dirty.setDirty(true);
            }
        });
    }

    public Dirty getDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty.setDirty(false);
    }

    private ComboBoxModel<ResolvedAndText> newModel() {
        final ArrayList<ResolvedAndText> values = Lists.newArrayList();
        if (this.resolved.getType() == SightingTaxon.Type.SP) {
            values.add(new ResolvedAndText(Messages.getMessage(Messages.Name.KEEP_AS_SP), this.resolved));
            for (Taxon taxon : this.resolved.getTaxa()) {
                SightingTaxon.Resolved possibleResolved = SightingTaxons.newResolved(taxon);
                values.add(new ResolvedAndText(possibleResolved.getCommonName(), possibleResolved));
            }
        } else if (this.resolved.getType() == SightingTaxon.Type.HYBRID) {
            values.add(new ResolvedAndText(Messages.getMessage(Messages.Name.KEEP_AS_HYBRID), this.resolved));
            for (Taxon taxon : this.resolved.getTaxa()) {
                SightingTaxon.Resolved possibleResolved = SightingTaxons.newResolved(taxon);
                values.add(new ResolvedAndText(possibleResolved.getCommonName(), possibleResolved));
            }
        } else {
            Taxon taxon = this.resolved.getTaxon();
            Taxon species = taxon.getType() == Taxon.Type.species ? taxon : TaxonUtils.getParentOfType(taxon, Taxon.Type.species);
            TaxonUtils.visitTaxa(species, new TaxonVisitor(){

                @Override
                public boolean visitTaxon(Taxon visitedTaxon) {
                    SightingTaxon.Resolved resolvedTaxon = SightingTaxons.newResolved(visitedTaxon);
                    if (visitedTaxon.getType() == Taxon.Type.species) {
                        values.add(new ResolvedAndText(Messages.getMessage(Messages.Name.NONE_IN_BRACKETS), resolvedTaxon));
                    } else if (visitedTaxon.getType() == Taxon.Type.group) {
                        values.add(new ResolvedAndText(resolvedTaxon.getCommonName(), resolvedTaxon));
                    } else if (visitedTaxon.getParent().getType() == Taxon.Type.group) {
                        values.add(new ResolvedAndText("  " + resolvedTaxon.getName(), resolvedTaxon));
                    } else {
                        values.add(new ResolvedAndText(resolvedTaxon.getName(), resolvedTaxon));
                    }
                    return true;
                }
            });
        }
        return new DefaultComboBoxModel<ResolvedAndText>(values.toArray(new ResolvedAndText[0]));
    }

    public SightingTaxon.Resolved getResolved() {
        return ((ResolvedAndText)this.getSelectedItem()).resolved;
    }

    public SightingTaxon getSightingTaxonInBaseTaxonomy() {
        return this.getResolved().getSightingTaxonInBaseTaxonomy();
    }

    public String getRangeSummary() {
        ArrayList<String> ranges = Lists.newArrayList();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            String range;
            Taxon taxon;
            SightingTaxon.Resolved resolved = ((ResolvedAndText)this.getModel().getElementAt((int)i)).resolved;
            if (resolved.getType() == SightingTaxon.Type.SP || resolved.getType() == SightingTaxon.Type.HYBRID || !((taxon = resolved.getTaxon()) instanceof Species) || (range = TaxonUtils.getRange((Species)taxon)) == null) continue;
            if (taxon.getType() == Taxon.Type.subspecies) {
                ranges.add(String.format("%s: %s", resolved.getName(), range));
                continue;
            }
            ranges.add(String.format("%s: %s", resolved.getCommonName(), range));
        }
        return Joiner.on("\n\n").join(ranges);
    }

    static class ResolvedAndText {
        final String text;
        final SightingTaxon.Resolved resolved;

        ResolvedAndText(String text, SightingTaxon.Resolved resolved) {
            this.text = text;
            this.resolved = resolved;
        }

        public String toString() {
            return this.text;
        }
    }
}

