/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.sighting.ApproximateNumber;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.user.UserSet;
import com.scythebill.birdlist.model.util.DirtyImpl;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.components.links.DefaultLinkClickedListener;
import com.scythebill.birdlist.ui.components.photos.PhotosListPanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.UserChipsUi;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.MoreFiles;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;

public class SightingInfoPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private static final ImmutableList<SightingInfo.SightingStatus> SIGHTING_STATUS_VALUES = ImmutableList.copyOf(SightingInfo.SightingStatus.values());
    private static final List<String> SIGHTING_STATUS_TEXT = Lists.transform(SIGHTING_STATUS_VALUES, Messages::getText);
    private static final ImmutableList<SightingInfo.BreedingBirdCode> BREEDING_VALUES = ImmutableList.copyOf(SightingInfo.BreedingBirdCode.values());
    private static final List<String> BREEDING_TEXT = Lists.transform(BREEDING_VALUES, input -> {
        if (input == SightingInfo.BreedingBirdCode.NONE) {
            return Messages.getText(input);
        }
        return input.getId() + " - " + Messages.getText(input);
    });
    private JTextArea description;
    private JCheckBox female;
    private JCheckBox heardOnly;
    private JCheckBox immature;
    private JCheckBox adult;
    private JCheckBox male;
    private JCheckBox photographed;
    private JFormattedTextField numberField;
    private JLabel numberLabel;
    private DirtyImpl dirty = new DirtyImpl(false);
    private SightingInfo sighting;
    private JLabel statusLabel;
    private JComboBox<String> statusCombo;
    private JLabel breedingLabel;
    private JComboBox<String> breedingCombo;
    private boolean editable;
    private JLabel notesLabel;
    private JScrollPane descriptionScrollPane;
    private PhotosListPanel photosListPanel;
    private Layout layoutType;
    private final DocumentListener dirtyDocument = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent event) {
            SightingInfoPanel.this.dirty.setDirty(true);
            SightingInfoPanel.this.firePropertyChange("value", null, null);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            SightingInfoPanel.this.dirty.setDirty(true);
            SightingInfoPanel.this.firePropertyChange("value", null, null);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            SightingInfoPanel.this.dirty.setDirty(true);
            SightingInfoPanel.this.firePropertyChange("value", null, null);
        }
    };
    private final Alerts alerts;
    private final UserSet userSet;
    private final ReportSet reportSet;
    private UserChipsUi userChipsUi;

    public SightingInfoPanel(ReportSet reportSet, Layout layout, FontManager fontManager, FileDialogs fileDialogs, Alerts alerts) {
        this.reportSet = reportSet;
        this.layoutType = layout;
        this.userSet = reportSet.getUserSet();
        this.alerts = alerts;
        this.initComponents(fontManager, fileDialogs);
        this.attachListeners();
    }

    public DirtyImpl getDirty() {
        return this.dirty;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.description.setEnabled(enabled);
        this.numberField.setEnabled(enabled);
        this.numberLabel.setEnabled(enabled);
        this.statusLabel.setEnabled(enabled);
        this.setEditableOrEnabled();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.description.setEditable(editable);
        this.numberField.setEditable(editable);
        this.setEditableOrEnabled();
    }

    private void setEditableOrEnabled() {
        this.female.setEnabled(this.editable && this.isEnabled());
        this.male.setEnabled(this.editable && this.isEnabled());
        this.immature.setEnabled(this.editable && this.isEnabled());
        this.adult.setEnabled(this.editable && this.isEnabled());
        this.heardOnly.setEnabled(this.editable && this.isEnabled());
        this.photographed.setEnabled(this.editable && this.isEnabled());
        this.statusCombo.setEnabled(this.editable && this.isEnabled());
        this.breedingCombo.setEnabled(this.editable && this.isEnabled());
        this.photosListPanel.setEnabled(this.editable && this.isEnabled());
        if (this.userChipsUi != null) {
            this.userChipsUi.setEnabled(this.editable && this.isEnabled());
        }
    }

    private void attachListeners() {
        PropertyChangeListener dirtyProperty = e -> {
            if (!Objects.equal(e.getOldValue(), e.getNewValue())) {
                this.dirty.setDirty(true);
                this.firePropertyChange("value", null, null);
            }
        };
        ActionListener dirtyAction = e -> {
            this.dirty.setDirty(true);
            this.firePropertyChange("value", null, null);
        };
        this.description.getDocument().addDocumentListener(this.dirtyDocument);
        this.numberField.addPropertyChangeListener("value", dirtyProperty);
        this.numberField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == 'h') {
                    SightingInfoPanel.this.heardOnly.doClick();
                    e.consume();
                }
                if (e.getKeyChar() == 'a') {
                    SightingInfoPanel.this.adult.doClick();
                    e.consume();
                }
                if (e.getKeyChar() == 'i') {
                    SightingInfoPanel.this.immature.doClick();
                    e.consume();
                }
                if (e.getKeyChar() == 'm') {
                    SightingInfoPanel.this.male.doClick();
                    e.consume();
                }
                if (e.getKeyChar() == 'f') {
                    SightingInfoPanel.this.female.doClick();
                    e.consume();
                }
                if (e.getKeyChar() == 'p') {
                    SightingInfoPanel.this.photographed.doClick();
                    e.consume();
                }
            }
        });
        this.photosListPanel.getDirty().addDirtyListener(dirtyProperty);
        this.photosListPanel.addPropertyChangeListener("links", e -> {
            this.photographed.setSelected(!this.photosListPanel.getLinks().isEmpty());
            this.dirty.setDirty(true);
            this.firePropertyChange("value", null, null);
        });
        this.female.addActionListener(dirtyAction);
        this.male.addActionListener(dirtyAction);
        this.immature.addActionListener(dirtyAction);
        this.adult.addActionListener(dirtyAction);
        this.heardOnly.addActionListener(dirtyAction);
        this.photographed.addActionListener(dirtyAction);
        this.statusCombo.addActionListener(dirtyAction);
        this.breedingCombo.addActionListener(dirtyAction);
    }

    public void save() {
        this.save(this.sighting);
    }

    public void save(SightingInfo sightingInfo) {
        this.writeIntoSightingInfo(sightingInfo);
        this.dirty.setDirty(false);
        this.photosListPanel.setLinks(sightingInfo.getPhotos());
    }

    public SightingInfo getValue() {
        SightingInfo sightingInfo = new SightingInfo();
        this.writeIntoSightingInfo(sightingInfo);
        return sightingInfo;
    }

    private void writeIntoSightingInfo(SightingInfo sightingInfo) {
        sightingInfo.setDescription(this.description.getText());
        try {
            this.numberField.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        ApproximateNumber number = (ApproximateNumber)this.numberField.getValue();
        sightingInfo.setNumber(number);
        sightingInfo.setFemale(this.female.isSelected());
        sightingInfo.setMale(this.male.isSelected());
        sightingInfo.setImmature(this.immature.isSelected());
        sightingInfo.setAdult(this.adult.isSelected());
        sightingInfo.setHeardOnly(this.heardOnly.isSelected());
        sightingInfo.setPhotographed(this.photographed.isSelected());
        sightingInfo.setSightingStatus((SightingInfo.SightingStatus)((Object)SIGHTING_STATUS_VALUES.get(this.statusCombo.getSelectedIndex())));
        sightingInfo.setBreedingBirdCode((SightingInfo.BreedingBirdCode)((Object)BREEDING_VALUES.get(this.breedingCombo.getSelectedIndex())));
        sightingInfo.setPhotos(this.photosListPanel.getLinks());
        if (this.userChipsUi != null) {
            sightingInfo.setUsers(this.userChipsUi.userChips.getChips());
        }
    }

    public void revert() {
        this.setSighting(this.sighting);
    }

    public void setSighting(SightingInfo newSighting) {
        if (newSighting == null) {
            this.description.setText(null);
            this.numberField.setValue(null);
            this.female.setSelected(false);
            this.male.setSelected(false);
            this.immature.setSelected(false);
            this.adult.setSelected(false);
            this.heardOnly.setSelected(false);
            this.photographed.setSelected(false);
            this.statusCombo.setSelectedIndex(0);
            this.breedingCombo.setSelectedIndex(0);
            this.photosListPanel.setLinks(ImmutableList.of());
            if (this.userChipsUi != null) {
                this.userChipsUi.userChips.clear();
            }
            return;
        }
        this.description.setText(newSighting.getDescription());
        this.description.setCaretPosition(0);
        this.female.setSelected(newSighting.isFemale());
        this.male.setSelected(newSighting.isMale());
        this.immature.setSelected(newSighting.isImmature());
        this.adult.setSelected(newSighting.isAdult());
        this.heardOnly.setSelected(newSighting.isHeardOnly());
        this.photographed.setSelected(newSighting.isPhotographed());
        this.numberField.setValue(newSighting.getNumber());
        this.statusCombo.setSelectedIndex(SIGHTING_STATUS_VALUES.indexOf((Object)newSighting.getSightingStatus()));
        this.breedingCombo.setSelectedIndex(BREEDING_VALUES.indexOf((Object)newSighting.getBreedingBirdCode()));
        this.photosListPanel.setLinks(newSighting.getPhotos());
        if (this.userChipsUi != null) {
            this.userChipsUi.userChips.clear();
            this.userChipsUi.userChips.addAllChips(newSighting.getUsers());
        }
        this.sighting = newSighting;
        this.dirty.setDirty(false);
    }

    private void initComponents(FontManager fontManager, FileDialogs fileDialogs) {
        this.female = new JCheckBox();
        this.male = new JCheckBox();
        this.immature = new JCheckBox();
        this.adult = new JCheckBox();
        this.heardOnly = new JCheckBox();
        this.photographed = new JCheckBox();
        this.descriptionScrollPane = new JScrollPane();
        this.description = new JTextArea();
        this.descriptionScrollPane.setViewportView(this.description);
        this.description.setColumns(this.layoutType == Layout.HORIZONTAL ? 40 : 20);
        this.description.setRows(3);
        this.description.setWrapStyleWord(true);
        this.description.setLineWrap(true);
        this.numberField = new AutoSelectJFormattedTextField(){

            @Override
            protected void processFocusEvent(FocusEvent event) {
                if (event.getID() == 1005) {
                    SightingInfoPanel.this.numberField.getDocument().removeDocumentListener(SightingInfoPanel.this.dirtyDocument);
                }
                super.processFocusEvent(event);
                if (event.getID() == 1004) {
                    SightingInfoPanel.this.numberField.getDocument().addDocumentListener(SightingInfoPanel.this.dirtyDocument);
                }
            }
        };
        this.numberLabel = new JLabel();
        this.male.setText(Messages.getMessage(Messages.Name.MALE_TEXT));
        this.male.setMnemonic('m');
        this.female.setText(Messages.getMessage(Messages.Name.FEMALE_TEXT));
        this.female.setMnemonic('f');
        this.immature.setText(Messages.getMessage(Messages.Name.IMMATURE_TEXT));
        this.immature.setMnemonic('i');
        this.adult.setText(Messages.getMessage(Messages.Name.ADULT_TEXT));
        this.adult.setMnemonic('a');
        this.heardOnly.setText(Messages.getMessage(Messages.Name.HEARD_ONLY_TEXT));
        this.heardOnly.setMnemonic('h');
        this.photographed.setText(Messages.getMessage(Messages.Name.PHOTOGRAPHED_TEXT));
        this.photographed.setMnemonic('p');
        UIUtils.fixTabOnTextArea(this.description);
        this.numberField.setColumns(8);
        this.numberField.setFormatterFactory(new DefaultFormatterFactory(new JFormattedTextField.AbstractFormatter(){

            @Override
            public String valueToString(Object value) throws ParseException {
                if (value == null) {
                    return "";
                }
                return value.toString();
            }

            @Override
            public Object stringToValue(String text) throws ParseException {
                return ApproximateNumber.tryParse(text);
            }
        }));
        this.numberLabel.setText(Messages.getMessage(Messages.Name.NUMBER_LABEL));
        this.statusCombo = new JComboBox<String>(SIGHTING_STATUS_TEXT.toArray(new String[0]));
        this.statusCombo.setMaximumRowCount(SIGHTING_STATUS_TEXT.size());
        this.statusLabel = new JLabel(Messages.getMessage(Messages.Name.STATUS_LABEL));
        this.breedingCombo = new JComboBox<String>(BREEDING_TEXT.toArray(new String[0]));
        this.breedingCombo.setMaximumRowCount(BREEDING_VALUES.size());
        this.breedingLabel = new JLabel(Messages.getMessage(Messages.Name.BREEDING_CODE_LABEL));
        this.notesLabel = new JLabel(Messages.getMessage(Messages.Name.NOTES_LABEL));
        this.photosListPanel = new PhotosListPanel(fontManager, fileDialogs, new PhotoClicked(fileDialogs, this.alerts));
        if (this.userSet != null) {
            this.userChipsUi = new UserChipsUi(this.userSet, fontManager);
            this.userChipsUi.userChips.addChipsChangedListener(() -> this.dirty.setDirty(true));
        }
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHonorsVisibility(true);
        layout.setAutoCreateGaps(false);
        if (this.layoutType == Layout.VERTICAL) {
            GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
            verticalGroup.addGroup(layout.createParallelGroup().addComponent(this.heardOnly).addComponent(this.photographed)).addGroup(layout.createParallelGroup().addComponent(this.male).addComponent(this.female)).addGroup(layout.createParallelGroup().addComponent(this.adult).addComponent(this.immature)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.statusLabel).addComponent(this.statusCombo)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.breedingLabel).addComponent(this.breedingCombo)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.numberLabel).addComponent(this.numberField)).addComponent(this.photosListPanel, fontManager.scale(60), fontManager.scale(70), fontManager.scale(180));
            if (this.userChipsUi != null) {
                verticalGroup.addGroup(layout.createBaselineGroup(false, false).addComponent(this.userChipsUi.userLabel).addComponent(this.userChipsUi.userIndexer).addComponent(this.userChipsUi.addUserButton));
                verticalGroup.addComponent(this.userChipsUi.userChipsScrollPane, fontManager.scale(40), fontManager.scale(60), -2);
            }
            verticalGroup.addComponent(this.notesLabel).addComponent(this.descriptionScrollPane, -2, -2, 150);
            layout.setVerticalGroup(verticalGroup);
            GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup();
            horizontalGroup.addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.numberLabel).addComponent(this.statusLabel).addComponent(this.breedingLabel)).addGroup(layout.createParallelGroup().addComponent(this.numberField, -2, -2, -2).addComponent(this.statusCombo, fontManager.scale(150), fontManager.scale(150), fontManager.scale(150)).addComponent(this.breedingCombo, fontManager.scale(150), fontManager.scale(150), fontManager.scale(150)))).addGroup(layout.createSequentialGroup().addComponent(this.male).addComponent(this.female)).addGroup(layout.createSequentialGroup().addComponent(this.heardOnly).addComponent(this.photographed)).addGroup(layout.createSequentialGroup().addComponent(this.adult).addComponent(this.immature)).addComponent(this.notesLabel).addComponent(this.photosListPanel, -2, -2, fontManager.scale(250)).addComponent(this.descriptionScrollPane, -2, -2, fontManager.scale(250));
            if (this.userChipsUi != null) {
                horizontalGroup.addGroup(layout.createSequentialGroup().addComponent(this.userChipsUi.userLabel).addComponent(this.userChipsUi.userIndexer).addComponent(this.userChipsUi.addUserButton)).addComponent(this.userChipsUi.userChipsScrollPane, fontManager.scale(250), fontManager.scale(250), fontManager.scale(250));
                this.userChipsUi.userChips.setScaledWidth(250);
            }
            layout.setHorizontalGroup(horizontalGroup);
            layout.linkSize(this.heardOnly, this.male, this.adult);
        } else {
            GroupLayout.SequentialGroup leftVerticalGroup = layout.createSequentialGroup();
            leftVerticalGroup.addGroup(layout.createBaselineGroup(false, true).addComponent(this.numberLabel).addComponent(this.numberField).addComponent(this.statusLabel).addComponent(this.statusCombo)).addGroup(layout.createBaselineGroup(false, true).addComponent(this.breedingLabel).addComponent(this.breedingCombo)).addGroup(layout.createBaselineGroup(false, true).addComponent(this.notesLabel).addComponent(this.descriptionScrollPane, -2, -2, fontManager.scale(200)));
            if (this.userChipsUi != null) {
                leftVerticalGroup.addGroup(layout.createBaselineGroup(false, false).addComponent(this.userChipsUi.userLabel, -2, -2, -2).addComponent(this.userChipsUi.userIndexer, -2, -2, -2).addComponent(this.userChipsUi.addUserButton, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userChipsUi.userChipsScrollPane, -2, -2, Short.MAX_VALUE);
            }
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftVerticalGroup).addGroup(layout.createSequentialGroup().addGroup(layout.createBaselineGroup(false, false).addComponent(this.heardOnly).addComponent(this.male).addComponent(this.adult)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.photographed).addComponent(this.female).addComponent(this.immature)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.photosListPanel, fontManager.scale(70), fontManager.scale(80), -2)));
            GroupLayout.ParallelGroup leftHorizontalGroup = layout.createParallelGroup();
            leftHorizontalGroup.addGroup(layout.createSequentialGroup().addComponent(this.breedingLabel).addComponent(this.breedingCombo, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.numberLabel).addComponent(this.numberField, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusLabel).addComponent(this.statusCombo, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.notesLabel).addComponent(this.descriptionScrollPane, -2, -2, fontManager.scale(270)));
            if (this.userChipsUi != null) {
                leftHorizontalGroup.addGroup(layout.createSequentialGroup().addComponent(this.userChipsUi.userLabel, -2, -2, -2).addComponent(this.userChipsUi.userIndexer, -2, -2, -2).addComponent(this.userChipsUi.addUserButton, -2, -2, -2)).addComponent(this.userChipsUi.userChipsScrollPane);
            }
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(leftHorizontalGroup).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.heardOnly).addComponent(this.male).addComponent(this.adult)).addGroup(layout.createSequentialGroup().addComponent(this.photographed).addComponent(this.female).addComponent(this.immature)).addComponent(this.photosListPanel)));
            layout.linkSize(this.photographed, this.heardOnly, this.male, this.female, this.immature, this.adult);
            if (this.userChipsUi != null) {
                layout.linkSize(this.notesLabel, this.numberLabel, this.breedingLabel, this.userChipsUi.userLabel);
            } else {
                layout.linkSize(this.notesLabel, this.numberLabel, this.breedingLabel);
            }
        }
    }

    public JFormattedTextField getNumberField() {
        return this.numberField;
    }

    private void lookForOtherReplacements(File oldDirectory, File newDirectory) {
        MoreFiles.CommonSuffixResults results = MoreFiles.commonSuffix(oldDirectory, newDirectory);
        record SignificantEntry(Sighting sighting, Photo photo) {
        }
        ArrayList<SignificantEntry> significantEntries = new ArrayList<SignificantEntry>();
        for (Sighting sighting : this.reportSet.getSightings()) {
            if (!sighting.hasSightingInfo()) continue;
            SightingInfo info = sighting.getSightingInfo();
            for (Photo photo : info.getPhotos()) {
                if (!photo.isFileBased()) continue;
                File photoFile = photo.toFile();
                if (results.oldDirectory() != null && !MoreFiles.isChildOf(results.oldDirectory(), photoFile)) continue;
                significantEntries.add(new SignificantEntry(sighting, photo));
            }
        }
        int investigated = 0;
        int successful = 0;
        for (SignificantEntry entry : significantEntries) {
            File newFile = results.replacePrefix(entry.photo.toFile());
            ++investigated;
            if (newFile.exists()) {
                ++successful;
            }
            if (investigated <= 1000 && successful <= 3) continue;
            break;
        }
        if (successful > 0 && this.alerts.showYesNo((Object)this, Messages.Name.FIX_OTHER_PHOTOS_TITLE, Messages.Name.FIX_OTHER_PHOTOS_FORMAT, results.oldDirectory().toPath(), results.newDirectory().toPath()) == 0) {
            int updatedCount = 0;
            for (SignificantEntry entry : significantEntries) {
                ArrayList<Photo> photos;
                int index;
                File newFile = results.replacePrefix(entry.photo.toFile());
                if (!newFile.exists() || (index = (photos = new ArrayList<Photo>(entry.sighting().getSightingInfo().getPhotos())).indexOf(entry.photo())) < 0) continue;
                ++updatedCount;
                Photo newPhoto = new Photo(newFile);
                photos.set(index, newPhoto);
                entry.sighting().getSightingInfo().setPhotos(photos);
            }
            if (updatedCount > 0) {
                this.photosListPanel.setLinks(this.sighting.getPhotos());
                this.reportSet.markDirty();
                this.alerts.showMessage((Object)this, Messages.Name.OTHER_PHOTOS_FIXED_TITLE, Messages.Name.OTHER_PHOTOS_FIXED_FORMAT, updatedCount + 1);
            }
        }
    }

    public static enum Layout {
        VERTICAL,
        HORIZONTAL;

    }

    private class PhotoClicked
    extends DefaultLinkClickedListener<Photo> {
        public PhotoClicked(FileDialogs fileDialogs, Alerts alerts) {
            super(SightingInfoPanel.this, fileDialogs, alerts);
        }

        @Override
        protected void replaceLink(Photo oldPhoto, Photo newPhoto) {
            int index = SightingInfoPanel.this.sighting.getPhotos().indexOf(oldPhoto);
            if (index >= 0) {
                ArrayList<Photo> newPhotos = new ArrayList<Photo>(SightingInfoPanel.this.sighting.getPhotos());
                newPhotos.set(index, newPhoto);
                SightingInfoPanel.this.sighting.setPhotos(newPhotos);
                SightingInfoPanel.this.photosListPanel.setLinks(newPhotos);
                SightingInfoPanel.this.reportSet.markDirty();
                if (newPhoto.isFileBased() && oldPhoto.isFileBased() && newPhoto.toFile().getName().equals(oldPhoto.toFile().getName())) {
                    SightingInfoPanel.this.lookForOtherReplacements(oldPhoto.toFile().getAbsoluteFile(), newPhoto.toFile().getAbsoluteFile());
                }
            }
        }

        @Override
        protected Photo newLink(File file) {
            return new Photo(file);
        }

        @Override
        protected Messages.Name shouldFindFileMessage() {
            return Messages.Name.PHOTO_NOT_THERE_ANYMORE;
        }
    }
}

