/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.util.DirtyImpl;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class SightingBulkInfoPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private static final List<SightingInfo.SightingStatus> SIGHTING_STATUS_VALUES = Lists.newArrayList();
    private static final List<String> SIGHTING_STATUS_TEXT;
    private static final List<SightingInfo.BreedingBirdCode> BREEDING_VALUES;
    private static final List<String> BREEDING_TEXT;
    private OptionalBooleanCombobox female;
    private OptionalBooleanCombobox heardOnly;
    private OptionalBooleanCombobox immature;
    private OptionalBooleanCombobox adult;
    private OptionalBooleanCombobox male;
    private OptionalBooleanCombobox photographed;
    private DirtyImpl dirty = new DirtyImpl(false);
    private JComboBox<String> statusCombo;
    private JComboBox<String> breedingCombo;
    private JLabel femaleLabel;
    private JLabel maleLabel;
    private JLabel immatureLabel;
    private JLabel adultLabel;
    private JLabel photographedLabel;
    private JLabel heardOnlyLabel;
    private JLabel statusLabel;
    private JLabel breedingLabel;
    private boolean editable;

    public SightingBulkInfoPanel() {
        this.initComponents();
        this.attachListeners();
    }

    public DirtyImpl getDirty() {
        return this.dirty;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.statusLabel.setEnabled(enabled);
        this.setEditableOrEnabled();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.setEditableOrEnabled();
    }

    private void setEditableOrEnabled() {
        this.female.setEnabled(this.editable && this.isEnabled());
        this.male.setEnabled(this.editable && this.isEnabled());
        this.immature.setEnabled(this.editable && this.isEnabled());
        this.adult.setEnabled(this.editable && this.isEnabled());
        this.heardOnly.setEnabled(this.editable && this.isEnabled());
        this.photographed.setEnabled(this.editable && this.isEnabled());
        this.statusCombo.setEnabled(this.editable && this.isEnabled());
        this.breedingCombo.setEnabled(this.editable && this.isEnabled());
    }

    private void attachListeners() {
        ActionListener dirtyAction = e -> this.dirty.setDirty(true);
        this.female.addActionListener(dirtyAction);
        this.male.addActionListener(dirtyAction);
        this.immature.addActionListener(dirtyAction);
        this.adult.addActionListener(dirtyAction);
        this.heardOnly.addActionListener(dirtyAction);
        this.photographed.addActionListener(dirtyAction);
        this.statusCombo.addActionListener(dirtyAction);
        this.breedingCombo.addActionListener(dirtyAction);
    }

    public void save(Iterable<Sighting> sightings) {
        for (Sighting sighting : sightings) {
            SightingInfo.BreedingBirdCode breeding;
            SightingInfo.SightingStatus status;
            if (this.female.getValue().isPresent()) {
                sighting.getSightingInfo().setFemale(this.female.getValue().get());
            }
            if (this.male.getValue().isPresent()) {
                sighting.getSightingInfo().setMale(this.male.getValue().get());
            }
            if (this.immature.getValue().isPresent()) {
                sighting.getSightingInfo().setImmature(this.immature.getValue().get());
            }
            if (this.adult.getValue().isPresent()) {
                sighting.getSightingInfo().setAdult(this.adult.getValue().get());
            }
            if (this.heardOnly.getValue().isPresent()) {
                sighting.getSightingInfo().setHeardOnly(this.heardOnly.getValue().get());
            }
            if (this.photographed.getValue().isPresent()) {
                sighting.getSightingInfo().setPhotographed(this.photographed.getValue().get());
            }
            if ((status = SIGHTING_STATUS_VALUES.get(this.statusCombo.getSelectedIndex())) != null) {
                sighting.getSightingInfo().setSightingStatus(status);
            }
            if ((breeding = BREEDING_VALUES.get(this.breedingCombo.getSelectedIndex())) == null) continue;
            sighting.getSightingInfo().setBreedingBirdCode(breeding);
        }
        this.dirty.setDirty(false);
    }

    public void revert(Collection<Sighting> sightings) {
        this.setSightings(sightings);
    }

    public void setSightings(Collection<Sighting> sightings) {
        if (sightings.isEmpty()) {
            this.female.unselect();
            this.male.unselect();
            this.immature.unselect();
            this.adult.unselect();
            this.heardOnly.unselect();
            this.photographed.unselect();
            this.statusCombo.setSelectedIndex(0);
            this.breedingCombo.setSelectedIndex(0);
            return;
        }
        SightingInfo first = sightings.iterator().next().getSightingInfo();
        Optional<Boolean> isFemale = Optional.of(first.isFemale());
        Optional<Boolean> isMale = Optional.of(first.isMale());
        Optional<Boolean> isImmature = Optional.of(first.isImmature());
        Optional<Boolean> isAdult = Optional.of(first.isAdult());
        Optional<Boolean> isHeardOnly = Optional.of(first.isHeardOnly());
        Optional<Boolean> isPhotographed = Optional.of(first.isPhotographed());
        Optional<SightingInfo.SightingStatus> status = Optional.of(first.getSightingStatus());
        Optional<SightingInfo.BreedingBirdCode> breeding = Optional.of(first.getBreedingBirdCode());
        for (Sighting sighting : Iterables.skip(sightings, 1)) {
            SightingInfo info = sighting.getSightingInfo();
            if (isFemale.isPresent() && isFemale.get().booleanValue() != info.isFemale()) {
                isFemale = Optional.absent();
            }
            if (isMale.isPresent() && isMale.get().booleanValue() != info.isMale()) {
                isMale = Optional.absent();
            }
            if (isImmature.isPresent() && isImmature.get().booleanValue() != info.isImmature()) {
                isImmature = Optional.absent();
            }
            if (isAdult.isPresent() && isAdult.get().booleanValue() != info.isAdult()) {
                isAdult = Optional.absent();
            }
            if (isHeardOnly.isPresent() && isHeardOnly.get().booleanValue() != info.isHeardOnly()) {
                isHeardOnly = Optional.absent();
            }
            if (isPhotographed.isPresent() && isPhotographed.get().booleanValue() != info.isPhotographed()) {
                isPhotographed = Optional.absent();
            }
            if (status.isPresent() && status.get() != info.getSightingStatus()) {
                status = Optional.absent();
            }
            if (!breeding.isPresent() || breeding.get() == info.getBreedingBirdCode()) continue;
            breeding = Optional.absent();
        }
        this.female.setValue(isFemale);
        this.male.setValue(isMale);
        this.immature.setValue(isImmature);
        this.adult.setValue(isImmature);
        this.heardOnly.setValue(isHeardOnly);
        this.photographed.setValue(isPhotographed);
        if (status.isPresent()) {
            this.statusCombo.setSelectedIndex(SIGHTING_STATUS_VALUES.indexOf((Object)status.get()));
        } else {
            this.statusCombo.setSelectedIndex(0);
        }
        if (breeding.isPresent()) {
            this.breedingCombo.setSelectedIndex(BREEDING_VALUES.indexOf((Object)breeding.get()));
        } else {
            this.breedingCombo.setSelectedIndex(0);
        }
        this.dirty.setDirty(false);
    }

    private void initComponents() {
        this.female = new OptionalBooleanCombobox();
        this.male = new OptionalBooleanCombobox();
        this.immature = new OptionalBooleanCombobox();
        this.adult = new OptionalBooleanCombobox();
        this.heardOnly = new OptionalBooleanCombobox();
        this.photographed = new OptionalBooleanCombobox();
        this.maleLabel = new JLabel(Messages.getMessage(Messages.Name.MALE_LABEL));
        this.femaleLabel = new JLabel(Messages.getMessage(Messages.Name.FEMALE_LABEL));
        this.immatureLabel = new JLabel(Messages.getMessage(Messages.Name.IMMATURE_LABEL));
        this.adultLabel = new JLabel(Messages.getMessage(Messages.Name.ADULT_LABEL));
        this.heardOnlyLabel = new JLabel(Messages.getMessage(Messages.Name.HEARD_ONLY_LABEL));
        this.photographedLabel = new JLabel(Messages.getMessage(Messages.Name.PHOTOGRAPHED_LABEL));
        this.statusCombo = new JComboBox<String>(SIGHTING_STATUS_TEXT.toArray(new String[0]));
        this.statusLabel = new JLabel(Messages.getMessage(Messages.Name.STATUS_LABEL));
        this.breedingCombo = new JComboBox<String>(BREEDING_TEXT.toArray(new String[0]));
        this.breedingLabel = new JLabel(Messages.getMessage(Messages.Name.BREEDING_CODE_LABEL));
        this.breedingCombo.setMaximumRowCount(BREEDING_TEXT.size());
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHonorsVisibility(true);
        layout.setAutoCreateGaps(false);
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createBaselineGroup(false, false).addComponent(this.heardOnlyLabel).addComponent(this.heardOnly)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.maleLabel).addComponent(this.male)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.femaleLabel).addComponent(this.female)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.adultLabel).addComponent(this.adult)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.immatureLabel).addComponent(this.immature)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.photographedLabel).addComponent(this.photographed)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.statusLabel).addComponent(this.statusCombo)).addComponent(this.breedingLabel, -2, -2, -2).addComponent(this.breedingCombo, -2, -2, -2));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.heardOnlyLabel).addComponent(this.maleLabel).addComponent(this.femaleLabel).addComponent(this.adultLabel).addComponent(this.immatureLabel).addComponent(this.photographedLabel).addComponent(this.statusLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.heardOnly, -2, -2, -2).addComponent(this.male, -2, -2, -2).addComponent(this.female, -2, -2, -2).addComponent(this.adult, -2, -2, -2).addComponent(this.immature, -2, -2, -2).addComponent(this.photographed, -2, -2, -2).addComponent(this.statusCombo, -2, -2, -2))).addComponent(this.breedingLabel).addComponent(this.breedingCombo, fontManager.scale(200), fontManager.scale(200), fontManager.scale(200)));
    }

    static {
        SIGHTING_STATUS_VALUES.add(null);
        SIGHTING_STATUS_VALUES.addAll(Arrays.asList(SightingInfo.SightingStatus.values()));
        SIGHTING_STATUS_TEXT = Lists.transform(SIGHTING_STATUS_VALUES, status -> status == null ? "" : Messages.getText(status));
        BREEDING_VALUES = Lists.newArrayList();
        BREEDING_VALUES.add(null);
        BREEDING_VALUES.addAll(Arrays.asList(SightingInfo.BreedingBirdCode.values()));
        BREEDING_TEXT = Lists.transform(BREEDING_VALUES, new Function<SightingInfo.BreedingBirdCode, String>(){

            @Override
            public String apply(@Nullable SightingInfo.BreedingBirdCode input) {
                if (input == null) {
                    return "";
                }
                if (input == SightingInfo.BreedingBirdCode.NONE) {
                    return Messages.getText(input);
                }
                return input.getId() + " - " + Messages.getText(input);
            }
        });
    }

    static class OptionalBooleanCombobox
    extends JComboBox<Object> {
        private static final ImmutableList<Optional<Boolean>> VALUES = ImmutableList.of(Optional.absent(), Optional.of(true), Optional.of(false));

        public OptionalBooleanCombobox() {
            super(new Object[]{"", Messages.getMessage(Messages.Name.YES_TEXT), Messages.getMessage(Messages.Name.NO_TEXT)});
        }

        public void setValue(Optional<Boolean> selected) {
            if (selected.isPresent()) {
                this.setSelectedIndex(selected.get() != false ? 1 : 2);
            } else {
                this.unselect();
            }
        }

        public void unselect() {
            this.setSelectedIndex(0);
        }

        public Optional<Boolean> getValue() {
            return (Optional)VALUES.get(this.getSelectedIndex());
        }
    }
}

