/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.ReportSetMutator;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.util.AndDirty;
import com.scythebill.birdlist.model.util.Dirty;
import com.scythebill.birdlist.model.util.DirtyImpl;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.SightingBulkInfoPanel;
import com.scythebill.birdlist.ui.components.SpResolverComboBox;
import com.scythebill.birdlist.ui.components.SpResolverUi;
import com.scythebill.birdlist.ui.components.WhenPanel;
import com.scythebill.birdlist.ui.components.WherePanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.SpHybridDialog;
import com.scythebill.birdlist.ui.panels.UserChipsUi;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;

public class SightingBulkEditPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private WhenPanel whenPanel;
    private SightingBulkInfoPanel infoPanel;
    private JButton saveButton;
    private JButton revertButton;
    private final ReportSet reportSet;
    private final UpdatedListener saved;
    private final Taxonomy taxonomy;
    private final FontManager fontManager;
    private JLabel subspecies;
    private List<Sighting> sightings;
    private SpResolverComboBox spResolver;
    private int lastSavedSpIndex;
    private SpResolverUi spResolverUi;
    private UserChipsUi addedUsersChipsUi;
    private UserChipsUi removedUsersChipsUi;
    private Dirty dirty;
    @Nullable
    private WherePanel wherePanel;
    private final Component wherePanelOrPlaceholder;
    private final Alerts alerts;
    @Nullable
    private final SpHybridDialog spHybridDialog;

    public SightingBulkEditPanel(Taxonomy taxonomy, ReportSet reportSet, List<Sighting> sightings, UpdatedListener onSaved, Alerts alerts, FontManager fontManager, WherePanel wherePanel, @Nullable SpHybridDialog spHybridDialog) {
        this.alerts = alerts;
        this.fontManager = fontManager;
        this.wherePanel = wherePanel;
        this.spHybridDialog = spHybridDialog;
        if (wherePanel == null) {
            this.wherePanelOrPlaceholder = new JPanel();
            this.wherePanelOrPlaceholder.setPreferredSize(new Dimension(0, 0));
        } else {
            this.wherePanelOrPlaceholder = wherePanel;
        }
        Preconditions.checkArgument(sightings.size() > 1);
        this.taxonomy = taxonomy;
        this.reportSet = reportSet;
        this.sightings = sightings;
        this.saved = onSaved;
        this.initComponents();
        this.hookUpContents();
    }

    public Dirty getDirty() {
        return this.dirty;
    }

    private void hookUpContents() {
        this.saveButton.setEnabled(false);
        this.revertButton.setEnabled(false);
        this.infoPanel.getDirty().setDirty(false);
        this.whenPanel.getDirty().setDirty(false);
        this.dirty = new AndDirty(this.infoPanel.getDirty(), this.whenPanel.getDirty());
        if (this.wherePanel != null) {
            this.wherePanel.getDirty().setDirty(false);
            this.dirty = new AndDirty(this.dirty, this.wherePanel.getDirty());
        }
        this.spResolverUi.clearDirty();
        this.dirty = new AndDirty(this.dirty, this.spResolverUi.getDirty());
        this.dirty.addDirtyListener(e -> this.updateSaveAndRevertButton());
        if (this.addedUsersChipsUi != null) {
            DirtyImpl addedDirty = new DirtyImpl(false);
            this.addedUsersChipsUi.userChips.addChipsChangedListener(() -> {
                addedDirty.setDirty(!this.addedUsersChipsUi.userChips.getChips().isEmpty());
                this.updateSaveAndRevertButton();
            });
            this.dirty = new AndDirty(this.dirty, addedDirty);
        }
        if (this.removedUsersChipsUi != null) {
            DirtyImpl removedDirty = new DirtyImpl(false);
            this.removedUsersChipsUi.userChips.addChipsChangedListener(() -> {
                removedDirty.setDirty(!this.removedUsersChipsUi.userChips.getChips().isEmpty());
                this.updateSaveAndRevertButton();
            });
            this.dirty = new AndDirty(this.dirty, removedDirty);
        }
    }

    public void setInlineButtonsVisible(boolean inlineButtonsVisible) {
        this.saveButton.setVisible(inlineButtonsVisible);
        this.revertButton.setVisible(inlineButtonsVisible);
    }

    public void save() {
        Location location;
        ArrayList<Sighting> original = Lists.newArrayList(this.sightings);
        ArrayList<Sighting> added = null;
        SightingTaxon newTaxon = this.spResolverUi.getNewSightingTaxon();
        if (newTaxon != null && this.sightings.stream().anyMatch(s -> !s.getTaxon().equals(newTaxon))) {
            if (this.spResolver != null) {
                this.lastSavedSpIndex = this.spResolver.getSelectedIndex();
            }
            added = Lists.newArrayList();
            for (Sighting sighting : this.sightings) {
                added.add(sighting.asBuilder().setTaxon(newTaxon).build());
            }
            this.sightings = added;
            this.spResolverUi.clearDirty();
        }
        this.infoPanel.save(this.sightings);
        if (this.reportSet.getUserSet() != null) {
            if (!this.addedUsersChipsUi.userChips.getChips().isEmpty() || !this.removedUsersChipsUi.userChips.getChips().isEmpty()) {
                final Collection<User> addedUsers = this.addedUsersChipsUi.userChips.getChips();
                final Collection<User> removedUsers = this.removedUsersChipsUi.userChips.getChips();
                LoadingCache<ImmutableSet<User>, ImmutableSet<User>> modifiedUsersCache = CacheBuilder.newBuilder().build(new CacheLoader<ImmutableSet<User>, ImmutableSet<User>>(){

                    @Override
                    public ImmutableSet<User> load(ImmutableSet<User> original) {
                        LinkedHashSet<User> users = new LinkedHashSet<User>(original);
                        users.addAll(addedUsers);
                        users.removeAll(removedUsers);
                        return ImmutableSet.copyOf(users);
                    }
                });
                for (Sighting sighting : this.sightings) {
                    sighting.getSightingInfo().setUsers((Collection<User>)modifiedUsersCache.getUnchecked(sighting.getSightingInfo().getUsers()));
                }
            }
            this.addedUsersChipsUi.userChips.clear();
            this.removedUsersChipsUi.userChips.clear();
        }
        ReportSetMutator mutator = this.reportSet.mutator();
        if (this.whenPanel.getDirty().isDirty()) {
            ReadablePartial updatedWhen = this.whenPanel.getWhen();
            if (updatedWhen != null) {
                added = Lists.newArrayList();
                for (Sighting sighting : this.sightings) {
                    Partial sightingWhen = sighting.getStoredDateAsPartial() == null ? new Partial(GJChronology.getInstance()) : new Partial(sighting.getStoredDateAsPartial());
                    if (updatedWhen.isSupported(DateTimeFieldType.year())) {
                        sightingWhen = sightingWhen.with(DateTimeFieldType.year(), updatedWhen.get(DateTimeFieldType.year()));
                    }
                    if (updatedWhen.isSupported(DateTimeFieldType.monthOfYear())) {
                        sightingWhen = sightingWhen.with(DateTimeFieldType.monthOfYear(), updatedWhen.get(DateTimeFieldType.monthOfYear()));
                    }
                    if (updatedWhen.isSupported(DateTimeFieldType.dayOfMonth())) {
                        sightingWhen = sightingWhen.with(DateTimeFieldType.dayOfMonth(), updatedWhen.get(DateTimeFieldType.dayOfMonth()));
                    }
                    added.add(sighting.asBuilder().setDate(sightingWhen).build());
                }
                this.sightings = added;
                mutator.withChangedDate(updatedWhen);
            }
            this.whenPanel.getDirty().setDirty(false);
        }
        if (this.wherePanel != null && this.wherePanel.getDirty().isDirty() && (location = this.wherePanel.getWhere()) != null) {
            this.reportSet.getLocations().ensureAdded(location);
            added = Lists.newArrayList();
            for (Sighting sighting : this.sightings) {
                added.add(sighting.asBuilder().setLocation(location).build());
            }
            this.sightings = added;
            mutator.withChangedLocation(location.getId());
        }
        if (added != null) {
            mutator.removing(original).adding(added).mutate();
            this.saved.sightingsSwapped(original, added);
        } else {
            this.saved.sightingsUpdated(this.sightings);
            this.reportSet.markDirty();
        }
        this.updateSaveAndRevertButton();
    }

    public void revert() {
        Taxon species;
        this.infoPanel.revert(this.sightings);
        this.whenPanel.setWhen(SightingBulkEditPanel.mergePartials(this.sightings));
        this.whenPanel.getDirty().setDirty(false);
        if (this.wherePanel != null) {
            Location location = this.mergeLocations(this.sightings);
            this.wherePanel.setWhere(location);
            this.wherePanel.getDirty().setDirty(false);
        }
        if (this.spResolver != null) {
            this.spResolver.setSelectedIndex(this.lastSavedSpIndex);
        }
        this.spResolverUi.revert();
        if (this.spResolverUi.spHybridButton != null && (species = this.getCommonSpecies()) == null) {
            this.spResolverUi.spHybridButton.setEnabled(false);
        }
        if (this.addedUsersChipsUi != null) {
            this.addedUsersChipsUi.userChips.clear();
        }
        if (this.removedUsersChipsUi != null) {
            this.removedUsersChipsUi.userChips.clear();
        }
        this.updateSaveAndRevertButton();
    }

    private void initComponents() {
        this.subspecies = new JLabel();
        String subspeciesText = this.getSubspeciesText();
        if (Strings.isNullOrEmpty(subspeciesText)) {
            this.subspecies.setVisible(false);
        } else {
            this.subspecies.setText("<html>" + subspeciesText.replace("/", "/<wbr>"));
        }
        this.spResolver = this.getSpResolver();
        this.spResolverUi = new SpResolverUi(this.spResolver, this.alerts, this.spHybridDialog);
        if (this.spResolver != null) {
            this.spResolver.addActionListener(e -> this.updateSaveAndRevertButton());
            this.lastSavedSpIndex = this.spResolver.getSelectedIndex();
        }
        if (this.spResolverUi.spHybridButton != null) {
            Taxon species = this.getCommonSpecies();
            if (species == null) {
                this.spResolverUi.spHybridButton.setEnabled(false);
            } else {
                this.spResolverUi.configureSpHybridButton(species);
            }
        }
        this.infoPanel = new SightingBulkInfoPanel();
        this.infoPanel.setSightings(this.sightings);
        this.whenPanel = new WhenPanel(this.fontManager);
        Partial bulkPartial = SightingBulkEditPanel.mergePartials(this.sightings);
        this.whenPanel.setWhen(bulkPartial);
        if (this.wherePanel != null) {
            this.wherePanel.setLayoutStrategy(IndexerPanel.LayoutStrategy.BELOW);
            this.wherePanel.setWhere(this.mergeLocations(this.sightings));
        }
        if (this.reportSet.getUserSet() != null) {
            this.addedUsersChipsUi = new UserChipsUi(this.reportSet.getUserSet(), this.fontManager);
            this.removedUsersChipsUi = new UserChipsUi(this.reportSet.getUserSet(), this.fontManager);
            this.removedUsersChipsUi.addUserButton.setText(Messages.getMessage(Messages.Name.REMOVE_BUTTON));
        }
        this.saveButton = new JButton();
        this.revertButton = new JButton();
        this.saveButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.SAVE_BUTTON)){

            @Override
            public void actionPerformed(ActionEvent e) {
                SightingBulkEditPanel.this.save();
            }
        });
        this.revertButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.REVERT_BUTTON)){

            @Override
            public void actionPerformed(ActionEvent event) {
                SightingBulkEditPanel.this.revert();
            }
        });
    }

    private Location mergeLocations(List<Sighting> sightingsToMerge) {
        String locationId = sightingsToMerge.get(0).getLocationId();
        for (Sighting sighting : Iterables.skip(sightingsToMerge, 1)) {
            if (Objects.equal(locationId, sighting.getLocationId())) continue;
            return null;
        }
        if (locationId == null) {
            return null;
        }
        return this.reportSet.getLocations().getLocation(locationId);
    }

    private static Partial mergePartials(List<Sighting> sightingsToMerge) {
        ReadablePartial first = sightingsToMerge.get(0).getStoredDateAsPartial();
        Optional day = first != null && first.isSupported(DateTimeFieldType.dayOfMonth()) ? Optional.of(first.get(DateTimeFieldType.dayOfMonth())) : Optional.absent();
        Optional month = first != null && first.isSupported(DateTimeFieldType.monthOfYear()) ? Optional.of(first.get(DateTimeFieldType.monthOfYear())) : Optional.absent();
        Optional year = first != null && first.isSupported(DateTimeFieldType.year()) ? Optional.of(first.get(DateTimeFieldType.year())) : Optional.absent();
        for (Sighting sighting : Iterables.skip(sightingsToMerge, 1)) {
            ReadablePartial partial = sighting.getStoredDateAsPartial();
            if (partial == null) continue;
            if (day.isPresent() && (!partial.isSupported(DateTimeFieldType.dayOfMonth()) || partial.get(DateTimeFieldType.dayOfMonth()) != ((Integer)day.get()).intValue())) {
                day = Optional.absent();
            }
            if (month.isPresent() && (!partial.isSupported(DateTimeFieldType.monthOfYear()) || partial.get(DateTimeFieldType.monthOfYear()) != ((Integer)month.get()).intValue())) {
                month = Optional.absent();
            }
            if (!year.isPresent() || partial.isSupported(DateTimeFieldType.year()) && partial.get(DateTimeFieldType.year()) == ((Integer)year.get()).intValue()) continue;
            year = Optional.absent();
        }
        Partial bulkPartial = new Partial(GJChronology.getInstance());
        if (year.isPresent()) {
            bulkPartial = bulkPartial.with(DateTimeFieldType.year(), (Integer)year.get());
        }
        if (month.isPresent()) {
            bulkPartial = bulkPartial.with(DateTimeFieldType.monthOfYear(), (Integer)month.get());
        }
        if (day.isPresent()) {
            bulkPartial = bulkPartial.with(DateTimeFieldType.dayOfMonth(), (Integer)day.get());
        }
        return bulkPartial;
    }

    private SpResolverComboBox getSpResolver() {
        HashSet<SightingTaxon.Resolved> resolveds = Sets.newHashSet();
        for (Sighting sighting : this.sightings) {
            resolveds.add(sighting.getTaxon().resolve(this.taxonomy));
        }
        if (resolveds.size() > 1) {
            return null;
        }
        SightingTaxon.Resolved resolved = (SightingTaxon.Resolved)Iterables.getOnlyElement(resolveds);
        return SpResolverComboBox.forResolved(resolved);
    }

    private String getSubspeciesText() {
        String subspeciesText = this.getSubspeciesText(this.sightings.get(0));
        if (subspeciesText == null) {
            return null;
        }
        for (Sighting sighting : Iterables.skip(this.sightings, 1)) {
            if (subspeciesText.equals(this.getSubspeciesText(sighting))) continue;
            return null;
        }
        return subspeciesText;
    }

    private String getSubspeciesText(Sighting sighting) {
        SightingTaxon.Resolved resolved = sighting.getTaxon().resolve(this.taxonomy);
        if (resolved.getSmallestTaxonType() != Taxon.Type.species || resolved.getSightingTaxon().getType() != SightingTaxon.Type.SINGLE) {
            return resolved.getCommonName();
        }
        return null;
    }

    private Taxon getCommonSpecies() {
        LinkedHashSet<String> taxa = new LinkedHashSet<String>();
        for (Sighting sighting : this.sightings) {
            taxa.addAll(sighting.getTaxon().getIds());
        }
        SightingTaxon.Resolved resolved = SightingTaxons.newPossiblySpTaxon(taxa).resolve(this.taxonomy);
        SightingTaxon speciesTaxon = resolved.getParentOfAtLeastType(Taxon.Type.species);
        if (speciesTaxon.getType() != SightingTaxon.Type.SINGLE) {
            return null;
        }
        return this.taxonomy.getTaxon(speciesTaxon.getId());
    }

    private void updateSaveAndRevertButton() {
        boolean isDirty;
        boolean bl = isDirty = this.infoPanel.getDirty().isDirty() || this.whenPanel.getDirty().isDirty() || this.wherePanel != null && this.wherePanel.getDirty().isDirty() || this.spResolverUi.getDirty().isDirty();
        if (this.addedUsersChipsUi != null) {
            boolean bl2 = isDirty = isDirty || !this.addedUsersChipsUi.userChips.getChips().isEmpty();
        }
        if (this.removedUsersChipsUi != null) {
            isDirty = isDirty || !this.removedUsersChipsUi.userChips.getChips().isEmpty();
        }
        this.saveButton.setEnabled(isDirty);
        this.revertButton.setEnabled(isDirty);
    }

    public void setEditable(boolean editable) {
        this.saveButton.setVisible(editable);
        this.revertButton.setVisible(editable);
        this.infoPanel.setEditable(editable);
        this.whenPanel.setEditable(editable);
        if (this.wherePanel != null) {
            this.wherePanel.setEditable(editable);
        }
        this.spResolverUi.spLabel.setVisible(editable);
        this.spResolverUi.spInfoPanel.setVisible(editable);
        if (this.spResolverUi.spHybridButton != null) {
            this.spResolverUi.spHybridButton.setVisible(editable);
        }
        if (this.spResolver != null) {
            this.spResolver.setVisible(editable);
        }
        if (this.addedUsersChipsUi != null) {
            this.addedUsersChipsUi.addUserButton.setVisible(editable);
            this.addedUsersChipsUi.userIndexer.setVisible(editable);
            this.addedUsersChipsUi.userChips.setEnabled(editable);
        }
        if (this.removedUsersChipsUi != null) {
            this.removedUsersChipsUi.addUserButton.setVisible(editable);
            this.removedUsersChipsUi.userIndexer.setVisible(editable);
            this.removedUsersChipsUi.userChips.setEnabled(editable);
        }
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHonorsVisibility(true);
        if (this.reportSet.getUserSet() == null) {
            GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addComponent(this.subspecies).addComponent(this.spResolverUi.spLabel).addComponent(this.spResolverUi.spResolverPanel, -2, -2, -2).addComponent(this.spResolverUi.spInfoPanel, -2, -2, -2).addComponent(this.spResolverUi.separator, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.whenPanel);
            if (this.wherePanel == null) {
                verticalGroup.addComponent(this.wherePanelOrPlaceholder, -2, -2, -2);
            } else {
                verticalGroup.addComponent(this.wherePanelOrPlaceholder);
            }
            verticalGroup.addComponent(this.infoPanel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.saveButton).addComponent(this.revertButton));
            layout.setVerticalGroup(verticalGroup);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subspecies).addComponent(this.spResolverUi.spLabel).addComponent(this.spResolverUi.spResolverPanel, -2, fontManager.scale(300), fontManager.scale(300)).addComponent(this.spResolverUi.spInfoPanel, -2, fontManager.scale(250), fontManager.scale(250)).addComponent(this.spResolverUi.separator).addComponent(this.whenPanel).addComponent(this.wherePanelOrPlaceholder).addComponent(this.infoPanel).addGroup(layout.createSequentialGroup().addComponent(this.saveButton).addComponent(this.revertButton)));
        } else {
            GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addComponent(this.subspecies).addComponent(this.spResolverUi.spLabel).addComponent(this.spResolverUi.spResolverPanel, -2, -2, -2).addComponent(this.spResolverUi.separator, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.whenPanel);
            if (this.wherePanel == null) {
                verticalGroup.addComponent(this.wherePanelOrPlaceholder, -2, -2, -2);
            } else {
                verticalGroup.addComponent(this.wherePanelOrPlaceholder);
            }
            verticalGroup.addComponent(this.infoPanel).addGroup(layout.createBaselineGroup(false, false).addComponent(this.addedUsersChipsUi.userIndexer, -2, -2, -2).addComponent(this.addedUsersChipsUi.addUserButton, -2, -2, -2)).addComponent(this.addedUsersChipsUi.userChipsScrollPane, -2, -2, Short.MAX_VALUE).addGroup(layout.createBaselineGroup(false, false).addComponent(this.removedUsersChipsUi.userIndexer, -2, -2, -2).addComponent(this.removedUsersChipsUi.addUserButton, -2, -2, -2)).addComponent(this.removedUsersChipsUi.userChipsScrollPane, -2, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.saveButton).addComponent(this.revertButton));
            layout.setVerticalGroup(verticalGroup);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subspecies).addComponent(this.spResolverUi.spLabel).addComponent(this.spResolverUi.spResolverPanel, -2, fontManager.scale(250), fontManager.scale(250)).addComponent(this.spResolverUi.separator).addComponent(this.whenPanel).addComponent(this.wherePanelOrPlaceholder).addComponent(this.infoPanel).addGroup(layout.createSequentialGroup().addComponent(this.addedUsersChipsUi.userIndexer, -2, -2, -2).addComponent(this.addedUsersChipsUi.addUserButton, -2, -2, -2)).addComponent(this.addedUsersChipsUi.userChipsScrollPane).addGroup(layout.createSequentialGroup().addComponent(this.removedUsersChipsUi.userIndexer, -2, -2, -2).addComponent(this.removedUsersChipsUi.addUserButton, -2, -2, -2)).addComponent(this.removedUsersChipsUi.userChipsScrollPane).addGroup(layout.createSequentialGroup().addComponent(this.saveButton).addComponent(this.revertButton)));
        }
    }

    public static interface UpdatedListener {
        public void sightingsUpdated(List<Sighting> var1);

        public void sightingsSwapped(List<Sighting> var1, List<Sighting> var2);

        public void sightingsRemoved(List<Sighting> var1);
    }
}

