/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.ReportSetMutator;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.components.NewLocationDialog;
import com.scythebill.birdlist.ui.components.SightingBulkEditPanel;
import com.scythebill.birdlist.ui.components.WherePanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.LocationScorer;
import com.scythebill.birdlist.ui.util.OpenMapUrl;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;

public class SightingBulkEditDialog {
    private final FontManager fontManager;
    private final Alerts alerts;
    private final PredefinedLocations predefinedLocations;
    private final NewLocationDialog newLocationDialog;
    private final OpenMapUrl openMapUrl;
    private final LocationScorer locationScorer;

    @Inject
    public SightingBulkEditDialog(FontManager fontManager, Alerts alerts, NewLocationDialog newLocationDialog, PredefinedLocations predefinedLocations, OpenMapUrl openMapUrl, LocationScorer locationScorer) {
        this.fontManager = fontManager;
        this.alerts = alerts;
        this.newLocationDialog = newLocationDialog;
        this.predefinedLocations = predefinedLocations;
        this.openMapUrl = openMapUrl;
        this.locationScorer = locationScorer;
    }

    public void bulkEditSightings(Window parent, SightingBulkEditPanel.UpdatedListener onSaved, Taxonomy taxonomy, ReportSet reportSet, List<Sighting> sightings) {
        SightingBulkEditPanel sightingBulkEditPanel = new SightingBulkEditPanel(taxonomy, reportSet, sightings, onSaved, this.alerts, this.fontManager, new WherePanel(reportSet, this.newLocationDialog, this.predefinedLocations, this.openMapUrl, this.locationScorer, ""), null);
        sightingBulkEditPanel.setInlineButtonsVisible(false);
        this.showBulkEditDialog(parent, sightingBulkEditPanel, sightings, reportSet, onSaved);
    }

    private void showBulkEditDialog(final Window parent, final SightingBulkEditPanel sightingBulkEditPanel, final List<Sighting> sightings, final ReportSet reportSet, final SightingBulkEditPanel.UpdatedListener onSaved) {
        final int size = sightings.size();
        Dialog.ModalityType modality = Toolkit.getDefaultToolkit().isModalityTypeSupported(Dialog.ModalityType.DOCUMENT_MODAL) ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.APPLICATION_MODAL;
        final JDialog dialog = new JDialog(parent, Messages.getMessage(Messages.Name.BULK_EDIT_TITLE), modality);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        };
        final AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int okCancel = 0;
                if (size > 10) {
                    okCancel = SightingBulkEditDialog.this.alerts.showOkCancel((Object)parent, Messages.Name.ARE_YOU_SURE, Messages.Name.VERIFY_CHANGE_ALL_SIGHTINGS_FORMAT, size);
                }
                if (okCancel == 0) {
                    sightingBulkEditPanel.save();
                }
                dialog.dispose();
            }
        };
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int okCancel = SightingBulkEditDialog.this.alerts.showOkCancel((Object)parent, Messages.Name.ARE_YOU_SURE, Messages.Name.VERIFY_DELETE_ALL_SIGHTINGS_FORMAT, size);
                if (okCancel == 0) {
                    ReportSetMutator mutator = reportSet.mutator();
                    mutator.removing(sightings);
                    mutator.mutate();
                    onSaved.sightingsRemoved(sightings);
                }
                dialog.dispose();
            }
        };
        sightingBulkEditPanel.getDirty().addDirtyListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean isDirty = (Boolean)evt.getNewValue();
                okAction.setEnabled(isDirty);
            }
        });
        okAction.setEnabled(false);
        this.fontManager.applyTo(sightingBulkEditPanel);
        JPanel bulkEditWithDescription = new JPanel();
        bulkEditWithDescription.setLayout(new BoxLayout(bulkEditWithDescription, 3));
        JLabel label = new JLabel(Messages.getFormattedMessage(Messages.Name.EDIT_ALL_SIGHTINGS_FORMAT, sightings.size()));
        bulkEditWithDescription.add(label);
        bulkEditWithDescription.add(Box.createVerticalStrut(10));
        bulkEditWithDescription.add(sightingBulkEditPanel);
        label.setAlignmentX(0.0f);
        sightingBulkEditPanel.setAlignmentX(0.0f);
        BulkEditActionsPanel okCancel = new BulkEditActionsPanel(okAction, deleteAction, cancelAction, bulkEditWithDescription);
        this.fontManager.applyTo(okCancel);
        dialog.setContentPane(okCancel);
        dialog.pack();
        dialog.setVisible(true);
    }

    static class BulkEditActionsPanel
    extends JPanel {
        private JButton okButton;

        public BulkEditActionsPanel(Action okAction, Action deleteAction, Action cancelAction, Component content) {
            this.setBorder(new EmptyBorder(20, 20, 15, 20));
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            JSeparator separator = new JSeparator();
            JButton cancelButton = new JButton();
            cancelButton.setAction(cancelAction);
            cancelButton.setText(Messages.getMessage(Messages.Name.CANCEL_BUTTON));
            JButton deleteButton = new JButton();
            deleteButton.setAction(deleteAction);
            deleteButton.setText(Messages.getMessage(Messages.Name.DELETE_ALL));
            this.okButton = new JButton(okAction);
            this.okButton.setText(Messages.getMessage(Messages.Name.OK_BUTTON));
            JPanel spacer = new JPanel();
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent(content).addComponent(spacer).addComponent(separator).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(cancelButton).addGap(0, 75, Short.MAX_VALUE).addComponent(deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton)));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(content).addGap(18).addComponent(spacer, 0, 0, Short.MAX_VALUE).addComponent(separator, -2, -2, -2).addGroup(layout.createParallelGroup().addComponent(cancelButton).addComponent(deleteButton).addComponent(this.okButton)));
            layout.linkSize(cancelButton, this.okButton);
            UIUtils.focusOnEntry(this, this.okButton);
            KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
            this.getInputMap(2).put(escape, "cancelPanel");
            this.getActionMap().put("cancelPanel", cancelAction);
        }
    }
}

