/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.ReportSetMutator;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.AndDirty;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.NavigablePanel;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.NewLocationDialog;
import com.scythebill.birdlist.ui.components.SightingInfoPanel;
import com.scythebill.birdlist.ui.components.SpResolverComboBox;
import com.scythebill.birdlist.ui.components.SpResolverUi;
import com.scythebill.birdlist.ui.components.WhenPanel;
import com.scythebill.birdlist.ui.components.WherePanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.SpHybridDialog;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import com.scythebill.birdlist.ui.util.LocationScorer;
import com.scythebill.birdlist.ui.util.OpenMapUrl;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class SightingBrowsePanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private Sighting sighting;
    private SightingInfoPanel infoPanel;
    private JButton saveButton;
    private JButton revertButton;
    private JButton editVisitButton;
    private JButton editTripButton;
    private final ReportSet reportSet;
    private WhenPanel whenPanel;
    private WherePanel wherePanel;
    private JLabel whereLabel;
    private final UpdatedListener saved;
    private final Taxonomy taxonomy;
    private final PredefinedLocations predefinedLocations;
    private final NewLocationDialog newLocationDialog;
    private SpResolverComboBox spResolver;
    private JLabel species;
    private int lastSavedSpIndex;
    private SpResolverUi spResolverUi;
    private FontManager fontManager;
    private AndDirty dirty;
    private final FileDialogs fileDialogs;
    private final Alerts alerts;
    private SpHybridDialog spHybridDialog;
    private final OpenMapUrl openMapUrl;
    private final Action returnAction;
    private final NavigableFrame navigableFrame;
    private Location rootLocation;
    private final LocationScorer locationScorer;

    public SightingBrowsePanel(Taxonomy taxonomy, ReportSet reportSet, Sighting sighting, NewLocationDialog newLocationDialog, NavigableFrame navigableFrame, Action returnAction, SpHybridDialog spHybridDialog, PredefinedLocations predefinedLocations, OpenMapUrl openMapUrl, FontManager fontManager, FileDialogs fileDialogs, Alerts alerts, LocationScorer locationScorer, UpdatedListener onSaved) {
        this.taxonomy = taxonomy;
        this.reportSet = reportSet;
        this.sighting = sighting;
        this.navigableFrame = navigableFrame;
        this.returnAction = returnAction;
        this.spHybridDialog = spHybridDialog;
        this.predefinedLocations = predefinedLocations;
        this.openMapUrl = openMapUrl;
        this.alerts = alerts;
        this.locationScorer = locationScorer;
        this.saved = onSaved;
        this.newLocationDialog = newLocationDialog;
        this.fontManager = fontManager;
        this.fileDialogs = fileDialogs;
        this.initComponents();
        this.hookUpContents();
    }

    private void hookUpContents() {
        this.infoPanel.setSighting(this.sighting.getSightingInfo());
        this.whenPanel.setWhen(this.sighting.getStoredDateAsPartial());
        this.whenPanel.setWhenClarificationText(this.tripDateText());
        this.wherePanel.setWhere(this.reportSet.getLocations().getLocation(this.sighting.getLocationId()));
        this.updateWhereLabel();
        this.saveButton.setEnabled(false);
        this.revertButton.setEnabled(false);
        this.editVisitButton.setEnabled(VisitInfoKey.forSighting(this.sighting) != null);
        this.editVisitButton.setVisible(this.sighting.getTrip() == null);
        this.editTripButton.setVisible(this.sighting.getTrip() != null);
        this.infoPanel.getDirty().setDirty(false);
        this.whenPanel.getDirty().setDirty(false);
        this.wherePanel.getDirty().setDirty(false);
        this.dirty = new AndDirty(this.infoPanel.getDirty(), this.whenPanel.getDirty(), this.wherePanel.getDirty());
        if (this.spResolverUi != null) {
            this.dirty = new AndDirty(this.spResolverUi.getDirty(), this.dirty);
            this.spResolverUi.clearDirty();
        }
        this.dirty.addDirtyListener(e -> this.updateButtons());
        this.wherePanel.addPropertyChangeListener("where", e -> this.updateButtons());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent e) {
                if (SightingBrowsePanel.this.spResolverUi.getDirty().isDirty()) {
                    return;
                }
                if (SightingBrowsePanel.this.dirty.isDirty()) {
                    SightingBrowsePanel.this.save();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorAdded(AncestorEvent e) {
            }
        });
    }

    private String tripDateText() {
        Trip trip = this.sighting.getTrip();
        String tripDatesText = trip == null ? "" : (trip.startDate().equals(trip.endDate()) ? Messages.getFormattedMessage(Messages.Name.TRIP_DATE_FORMAT, PartialIO.toUserString(trip.startDate(), this.getLocale())) : Messages.getFormattedMessage(Messages.Name.TRIP_DATES_FORMAT, Trips.rangeToUserString(trip.startDate(), trip.endDate(), this.getLocale())));
        return tripDatesText;
    }

    public void save() {
        SightingTaxon sightingTaxon;
        Sighting original = this.sighting;
        Sighting added = null;
        Location location = this.wherePanel.getWhere();
        if (location == null && this.wherePanel.getDirty().isDirty()) {
            return;
        }
        boolean changed = false;
        if (this.spResolverUi != null && (sightingTaxon = this.spResolverUi.getNewSightingTaxon()) != null && !this.sighting.getTaxon().equals(sightingTaxon)) {
            if (this.spResolver != null) {
                this.lastSavedSpIndex = this.spResolver.getSelectedIndex();
            }
            this.sighting = added = this.sighting.asBuilder().setTaxon(sightingTaxon).build();
            changed = true;
            this.spResolverUi.clearDirty();
        }
        if (this.infoPanel.getDirty().isDirty()) {
            this.infoPanel.save(this.sighting.getSightingInfo());
            changed = true;
        }
        ReportSetMutator mutator = this.reportSet.mutator();
        if (!Objects.equal(this.whenPanel.getWhen(), this.sighting.getStoredDateAsPartial())) {
            this.sighting = added = this.sighting.asBuilder().setDate(this.whenPanel.getWhen()).build();
            mutator.withChangedDate(this.sighting.getStoredDateAsPartial());
            changed = true;
        }
        if (location != null) {
            this.reportSet.getLocations().ensureAdded(location);
            if (!Objects.equal(location.getId(), this.sighting.getLocationId())) {
                this.sighting = added = this.sighting.asBuilder().setLocation(location).build();
                mutator.withChangedLocation(location.getId());
                changed = true;
            }
        }
        if (added != null) {
            mutator.removing(ImmutableList.of(original)).adding(ImmutableList.of(added)).mutate();
            this.saved.sightingsSwapped(original, added);
        } else if (changed) {
            this.reportSet.markDirty();
            this.saved.sightingsUpdated(this.sighting);
        }
        this.whenPanel.setWhenClarificationText(this.tripDateText());
        this.infoPanel.getDirty().setDirty(false);
        this.whenPanel.getDirty().setDirty(false);
        this.wherePanel.getDirty().setDirty(false);
    }

    public void revert() {
        this.infoPanel.revert();
        this.whenPanel.setWhen(this.sighting.getStoredDateAsPartial());
        this.wherePanel.setWhere(this.reportSet.getLocations().getLocation(this.sighting.getLocationId()));
        this.updateWhereLabel();
        this.whenPanel.getDirty().setDirty(false);
        this.wherePanel.getDirty().setDirty(false);
        if (this.spResolver != null) {
            this.spResolver.setSelectedIndex(this.lastSavedSpIndex);
        }
        this.spResolverUi.revert();
    }

    private void initComponents() {
        this.species = new JLabel();
        String speciesText = this.getSpeciesText();
        if (Strings.isNullOrEmpty(speciesText)) {
            this.species.setVisible(false);
        } else {
            this.species.setText("<html>" + speciesText.replace("/", "/<wbr>"));
        }
        this.spResolver = this.getSpResolver();
        this.spResolverUi = new SpResolverUi(this.spResolver, this.alerts, this.spHybridDialog);
        if (this.spResolver != null) {
            this.spResolver.addActionListener(e -> this.updateButtons());
            this.lastSavedSpIndex = this.spResolver.getSelectedIndex();
        }
        if (this.spResolverUi.spHybridButton != null) {
            SightingTaxon.Resolved resolved = this.sighting.getTaxon().resolve(this.taxonomy);
            if (resolved.getType() != SightingTaxon.Type.SINGLE) {
                this.spResolverUi.configureSpHybridButtonForExistingSpOrHybrid(resolved.getSightingTaxon());
            } else {
                this.spResolverUi.configureSpHybridButton(resolved.getTaxon());
            }
        }
        this.whenPanel = new WhenPanel(this.fontManager);
        this.wherePanel = new WherePanel(this.reportSet, this.newLocationDialog, this.predefinedLocations, this.openMapUrl, this.locationScorer, "(None)");
        this.wherePanel.setWhereLayoutStrategy(IndexerPanel.LayoutStrategy.BELOW);
        this.whereLabel = new JLabel();
        this.whereLabel.setVisible(false);
        this.infoPanel = new SightingInfoPanel(this.reportSet, SightingInfoPanel.Layout.VERTICAL, this.fontManager, this.fileDialogs, this.alerts);
        this.saveButton = new JButton();
        this.revertButton = new JButton();
        this.editVisitButton = new JButton();
        this.editTripButton = new JButton();
        this.saveButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.SAVE_BUTTON)){

            @Override
            public void actionPerformed(ActionEvent e) {
                SightingBrowsePanel.this.save();
            }
        });
        this.revertButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.REVERT_BUTTON)){

            @Override
            public void actionPerformed(ActionEvent event) {
                SightingBrowsePanel.this.revert();
            }
        });
        this.editVisitButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.VISIT_SIGHTINGS)){

            @Override
            public void actionPerformed(ActionEvent event) {
                JPanel sightingsPanel;
                SightingBrowsePanel.this.save();
                VisitInfoKey visitInfoKey = VisitInfoKey.forSighting(SightingBrowsePanel.this.sighting);
                if (visitInfoKey != null && (sightingsPanel = SightingBrowsePanel.this.navigableFrame.navigateToAndPush("sightings", SightingBrowsePanel.this.returnAction)) != null) {
                    ((NavigablePanel)((Object)sightingsPanel)).navigateTo(visitInfoKey);
                }
            }
        });
        this.editTripButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.TRIP_SIGHTINGS)){

            @Override
            public void actionPerformed(ActionEvent event) {
                JPanel sightingsPanel;
                SightingBrowsePanel.this.save();
                Trip trip = SightingBrowsePanel.this.sighting.getTrip();
                if (trip != null && (sightingsPanel = SightingBrowsePanel.this.navigableFrame.navigateToAndPush("sightings", SightingBrowsePanel.this.returnAction)) != null) {
                    ((NavigablePanel)((Object)sightingsPanel)).navigateTo(trip);
                }
            }
        });
    }

    private String getSpeciesText() {
        SightingTaxon.Resolved resolved = this.sighting.getTaxon().resolve(this.taxonomy);
        return resolved.getPreferredSingleName();
    }

    private void updateButtons() {
        boolean isDirty = this.infoPanel.getDirty().isDirty() || this.whenPanel.getDirty().isDirty() || this.wherePanel.getDirty().isDirty() || this.spResolverUi.getDirty().isDirty();
        boolean whereIsValid = this.wherePanel.getWhere() != null || !this.wherePanel.getDirty().isDirty();
        this.saveButton.setEnabled(isDirty && whereIsValid);
        this.revertButton.setEnabled(isDirty);
        this.editVisitButton.setEnabled(this.wherePanel.getWhere() != null && this.whenPanel.getWhen() != null);
        boolean isTrip = this.sighting.getTrip() != null && this.whenPanel.getWhen() == null;
        this.editVisitButton.setVisible(!isTrip);
        this.editTripButton.setVisible(isTrip);
    }

    public void setWhereEditable(boolean whereEditable) {
        this.wherePanel.setVisible(whereEditable);
        this.whereLabel.setVisible(!whereEditable);
    }

    public void setEditable(boolean editable) {
        this.saveButton.setVisible(editable);
        this.revertButton.setVisible(editable);
        this.whenPanel.setEditable(editable);
        this.wherePanel.setEditable(editable);
        this.infoPanel.setEditable(editable);
        this.spResolverUi.spLabel.setVisible(editable);
        this.spResolverUi.spInfoPanel.setVisible(editable);
        if (this.spResolverUi.spHybridButton != null) {
            this.spResolverUi.spHybridButton.setVisible(editable);
        }
        if (this.spResolver != null) {
            this.spResolver.setVisible(editable);
        }
    }

    public void setRootLocation(Location rootLocation) {
        this.rootLocation = rootLocation;
        this.updateWhereLabel();
    }

    private void updateWhereLabel() {
        this.whereLabel.setText((String)(this.sighting.getLocationId() == null ? "" : "<html>" + LocationIdToString.getString(this.reportSet.getLocations(), this.sighting.getLocationId(), true, this.rootLocation)));
    }

    private SpResolverComboBox getSpResolver() {
        SightingTaxon.Resolved resolved = this.sighting.getTaxon().resolve(this.taxonomy);
        return SpResolverComboBox.forResolved(resolved);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHonorsVisibility(true);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        verticalGroup.addComponent(this.species).addComponent(this.whereLabel).addComponent(this.spResolverUi.spLabel).addComponent(this.spResolverUi.spResolverPanel, -2, -2, -2);
        if (this.reportSet.getUserSet() == null) {
            verticalGroup.addComponent(this.spResolverUi.spInfoPanel, -2, -2, -2);
        }
        verticalGroup.addComponent(this.spResolverUi.separator, 5, 5, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.whenPanel).addComponent(this.wherePanel).addComponent(this.infoPanel).addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createBaselineGroup(false, false).addComponent(this.saveButton).addComponent(this.revertButton).addComponent(this.editTripButton).addComponent(this.editVisitButton)).addGap(0, fontManager.scale(10), fontManager.scale(10));
        layout.setVerticalGroup(verticalGroup);
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        horizontalGroup.addComponent(this.species).addComponent(this.spResolverUi.spLabel).addComponent(this.spResolverUi.spResolverPanel, -2, fontManager.scale(300), fontManager.scale(300));
        if (this.reportSet.getUserSet() == null) {
            horizontalGroup.addGroup(layout.createSequentialGroup().addGap(5).addComponent(this.spResolverUi.spInfoPanel, -2, fontManager.scale(245), fontManager.scale(245)));
        }
        horizontalGroup.addComponent(this.spResolverUi.separator).addComponent(this.whenPanel).addComponent(this.wherePanel).addComponent(this.whereLabel).addComponent(this.infoPanel).addGroup(GroupLayout.Alignment.CENTER, layout.createSequentialGroup().addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.revertButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.editTripButton).addComponent(this.editVisitButton));
        layout.setHorizontalGroup(horizontalGroup);
    }

    static interface UpdatedListener {
        public void sightingsUpdated(Sighting var1);

        public void sightingsSwapped(Sighting var1, Sighting var2);
    }
}

