/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.Timer;

public class ProgressSpinner
extends JComponent {
    private boolean started;
    private int progress;
    private static final int INCREMENTS = 20;
    private static final double RADIANS_DELTA = 0.3141592653589793;
    private ActionListener advance = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ProgressSpinner.this.advance();
        }
    };
    private Timer timer;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Box box = Box.createVerticalBox();
        final ProgressSpinner spinner = new ProgressSpinner();
        final JButton start = new JButton("Start");
        box.add(spinner);
        box.add(start);
        frame.setContentPane(box);
        frame.setVisible(true);
        frame.pack();
        start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (spinner.isStarted()) {
                    spinner.stop();
                    start.setText("Start");
                } else {
                    spinner.start();
                    start.setText("Stop");
                }
            }
        });
    }

    public ProgressSpinner() {
        this.setPreferredSize(new Dimension(100, 100));
    }

    public void start() {
        if (!this.started) {
            this.progress = 0;
            this.started = true;
            this.repaint();
            if (this.timer == null) {
                this.timer = new Timer(40, this.advance);
            }
            this.timer.start();
        }
    }

    public void stop() {
        if (this.started) {
            this.started = false;
            this.timer.stop();
            this.repaint();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    private void advance() {
        ++this.progress;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isStarted()) {
            int radius = Math.min(this.getWidth() / 2, this.getHeight() / 2);
            int centerX = this.getWidth() / 2;
            int centerY = this.getHeight() / 2;
            int centerOmitted = radius / 2;
            double radiansStart = (double)(this.progress % 20) * 0.3141592653589793;
            for (int i = 0; i < 20; ++i) {
                Color foreground;
                double radians = radiansStart + (double)i * 0.3141592653589793;
                double sine = Math.sin(radians);
                double cosine = Math.cos(radians);
                int startX = (int)((double)centerX + (double)centerOmitted * cosine);
                int startY = (int)((double)centerY + (double)centerOmitted * sine);
                int endX = (int)((double)centerX + (double)radius * cosine);
                int endY = (int)((double)centerY + (double)radius * sine);
                int halfway = 10;
                if (i < halfway) {
                    foreground = Color.WHITE;
                } else {
                    float grayscale = 1.0f / (float)halfway * (float)(20 - i - 1);
                    foreground = new Color(grayscale, grayscale, grayscale);
                }
                g.setColor(foreground);
                g.drawLine(startX, startY, endX, endY);
            }
        }
    }
}

