/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class OkCancelPanel
extends JPanel {
    public static Action CLOSE_WINDOW_ACTION = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.getWindowAncestor((Component)e.getSource()).dispose();
        }
    };
    protected JButton okButton;

    public OkCancelPanel(Action okAction, @Nullable Action cancelOrOtherAction, Component content, @Nullable Component focusOnEntry) {
        this.setBorder(new EmptyBorder(20, 20, 15, 20));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        JSeparator separator = new JSeparator();
        JButton cancelButton = new JButton();
        if (cancelOrOtherAction == null) {
            cancelButton.setVisible(false);
        } else {
            cancelButton.setAction(cancelOrOtherAction);
            if (cancelOrOtherAction.getValue("Name") == null) {
                cancelButton.setText(Messages.getMessage(Messages.Name.CANCEL_BUTTON));
            }
        }
        this.okButton = new JButton(okAction);
        if (okAction.getValue("Name") == null) {
            this.okButton.setText(Messages.getMessage(Messages.Name.OK_BUTTON));
        }
        JPanel spacer = new JPanel();
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(content).addComponent(spacer).addComponent(separator).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(cancelButton).addGap(0, 75, Short.MAX_VALUE).addComponent(this.okButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(content).addGap(18).addComponent(spacer, 0, 0, Short.MAX_VALUE).addComponent(separator, -2, -2, -2).addGroup(layout.createParallelGroup().addComponent(cancelButton).addComponent(this.okButton)));
        if (cancelButton.isVisible()) {
            layout.linkSize(cancelButton, this.okButton);
        }
        UIUtils.focusOnEntry(this, focusOnEntry == null ? this.okButton : focusOnEntry);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap(2).put(escape, "cancelPanel");
        this.getActionMap().put("cancelPanel", cancelOrOtherAction);
    }

    public void showInDialog(Window parent, FontManager fontManager) {
        Dialog.ModalityType modality = Toolkit.getDefaultToolkit().isModalityTypeSupported(Dialog.ModalityType.DOCUMENT_MODAL) ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.APPLICATION_MODAL;
        JDialog dialog = new JDialog(parent, modality);
        dialog.setContentPane(this);
        fontManager.applyTo(dialog);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void focusOnOk() {
        UIUtils.focusOnEntry(this, this.okButton);
    }
}

