/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Objects;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.util.Dirty;
import com.scythebill.birdlist.model.util.DirtyImpl;
import com.scythebill.birdlist.ui.components.DatePanel;
import com.scythebill.birdlist.ui.components.ErrorLabel;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.RequiredLabel;
import com.scythebill.birdlist.ui.components.TimePanel;
import com.scythebill.birdlist.ui.components.WherePanelIndexers;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.UserChipsUi;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import com.scythebill.birdlist.ui.util.LocationScorer;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class NewWhenAndWherePanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private IndexerPanel<Object> whereIndexer;
    private JLabel whereLabel;
    private RequiredLabel whereIsRequired = new RequiredLabel();
    private DatePanel whenPanel;
    private JLabel whenLabel;
    private TimePanel timePanel;
    private JLabel timeLabel;
    private DatePanel endWhenPanel;
    private JLabel endWhenLabel;
    private TimePanel endTimePanel;
    private JLabel endTimeLabel;
    private final ReportSet reportSet;
    private final PredefinedLocations predefinedLocations;
    private Location where;
    private String cachedWhereText = "";
    private DirtyImpl dirty = new DirtyImpl(false);
    private JLabel whereLabelHelp;
    private JLabel locationDetailLabel;
    private WherePanelIndexers whereIndexers;
    private FontManager fontManager;
    private UserChipsUi userChipsUi;
    private ImmutableSet<User> who = ImmutableSet.of();
    private boolean showTripSettings;
    private ErrorLabel endWhenErrorLabel;
    private LocationScorer locationScorer;

    @Inject
    public NewWhenAndWherePanel(ReportSet reportSet, PredefinedLocations predefinedLocations, LocationScorer locationScorer, FontManager fontManager) {
        this.reportSet = reportSet;
        this.predefinedLocations = predefinedLocations;
        this.locationScorer = locationScorer;
        this.fontManager = fontManager;
        this.initGUI();
        this.hookUpContents();
    }

    public void setWhereLayoutStrategy(IndexerPanel.LayoutStrategy layoutStrategy) {
        this.whereIndexer.setLayoutStrategy(layoutStrategy);
    }

    public void setShowTripSettings(boolean showTripSettings) {
        ReadablePartial startValue;
        this.showTripSettings = showTripSettings;
        if (showTripSettings && this.endWhenPanel.getValue() == null && (startValue = this.whenPanel.getValue()) != null) {
            this.endWhenPanel.setValue(startValue);
        }
        this.endWhenLabel.setVisible(showTripSettings);
        this.endWhenPanel.setVisible(showTripSettings);
        this.endTimeLabel.setVisible(showTripSettings && this.isTimeSupported(this.getEndWhen()));
        this.endTimePanel.setVisible(showTripSettings && this.isTimeSupported(this.getEndWhen()));
        this.updateEndErrorMessage();
    }

    private void hookUpContents() {
        this.whereIndexers = new WherePanelIndexers(this.reportSet.getLocations(), this.predefinedLocations, false, null, Predicates.alwaysTrue(), null);
        this.whereIndexers.configureIndexer(this.whereIndexer);
        this.whereIndexer.setOrdering(this.locationScorer.ordering());
        this.whereIndexer.setCanShowPopupOnFocusGained(false);
        this.whereIndexer.setSupportsNewValues(true);
        this.whereIndexer.setPreviewText(Messages.Name.START_TYPING_A_LOCATION);
        this.whereIndexer.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Location location = WherePanelIndexers.toLocation(NewWhenAndWherePanel.this.reportSet.getLocations(), event.getNewValue());
                if (location == null) {
                    NewWhenAndWherePanel.this.setWhereImpl(null);
                } else {
                    NewWhenAndWherePanel.this.setWhereImpl(location);
                }
            }
        });
        this.whereIndexer.addPropertyChangeListener("popupVisible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                NewWhenAndWherePanel.this.updateLocationText();
                NewWhenAndWherePanel.this.firePropertyChange("wherePopupVisible", e.getOldValue(), e.getNewValue());
            }
        });
        this.whereIndexer.getTextComponent().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.fireWhereTextChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.fireWhereTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.fireWhereTextChanged();
            }

            private void fireWhereTextChanged() {
                String newValue = NewWhenAndWherePanel.this.getWhereText();
                NewWhenAndWherePanel.this.firePropertyChange("whereText", NewWhenAndWherePanel.this.cachedWhereText, newValue);
                NewWhenAndWherePanel.this.cachedWhereText = newValue;
                NewWhenAndWherePanel.this.updateLocationText();
            }
        });
        this.whenPanel.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewWhenAndWherePanel.this.firePropertyChange("when", evt.getOldValue(), evt.getNewValue());
                boolean hasTime = NewWhenAndWherePanel.this.isTimeSupported((ReadablePartial)evt.getNewValue());
                NewWhenAndWherePanel.this.timeLabel.setVisible(hasTime);
                NewWhenAndWherePanel.this.timePanel.setVisible(hasTime);
                NewWhenAndWherePanel.this.updateEndErrorMessage();
                NewWhenAndWherePanel.this.dirty.setDirty(true);
            }
        });
        this.endWhenPanel.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewWhenAndWherePanel.this.firePropertyChange("endWhen", evt.getOldValue(), evt.getNewValue());
                boolean hasTime = NewWhenAndWherePanel.this.isTimeSupported((ReadablePartial)evt.getNewValue());
                NewWhenAndWherePanel.this.endTimeLabel.setVisible(NewWhenAndWherePanel.this.showTripSettings && hasTime);
                NewWhenAndWherePanel.this.endTimePanel.setVisible(NewWhenAndWherePanel.this.showTripSettings && hasTime);
                NewWhenAndWherePanel.this.updateEndErrorMessage();
                NewWhenAndWherePanel.this.dirty.setDirty(true);
            }
        });
        this.timePanel.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewWhenAndWherePanel.this.firePropertyChange("time", evt.getOldValue(), evt.getNewValue());
                NewWhenAndWherePanel.this.dirty.setDirty(true);
            }
        });
        this.endTimePanel.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewWhenAndWherePanel.this.firePropertyChange("endTime", evt.getOldValue(), evt.getNewValue());
                NewWhenAndWherePanel.this.dirty.setDirty(true);
            }
        });
        if (this.userChipsUi != null) {
            this.userChipsUi.userChips.addChipsChangedListener(() -> {
                this.setWhoImpl(this.userChipsUi.userChips.getChips());
                this.dirty.setDirty(true);
            });
        }
    }

    private boolean isTimeSupported(ReadablePartial when) {
        if (when == null) {
            return false;
        }
        return when.isSupported(DateTimeFieldType.dayOfMonth()) && when.isSupported(DateTimeFieldType.monthOfYear()) && when.isSupported(DateTimeFieldType.year());
    }

    public Dirty getDirty() {
        return this.dirty;
    }

    public ReadablePartial getWhen() {
        return this.whenPanel.getValue();
    }

    public void setWhen(ReadablePartial partial) {
        this.whenPanel.setValue(partial);
    }

    public ReadablePartial getEndWhen() {
        if (!this.showTripSettings) {
            return null;
        }
        ReadablePartial endWhen = this.endWhenPanel.getValue();
        if (endWhen != null && this.whenPanel.getValue() != null && SightingComparators.comparePartials(this.whenPanel.getValue(), endWhen) > 0) {
            return null;
        }
        return endWhen;
    }

    public void setEndWhen(ReadablePartial partial) {
        this.endWhenPanel.setValue(partial);
    }

    public LocalTime getTime() {
        if (!this.isTimeSupported(this.getWhen())) {
            return null;
        }
        return this.timePanel.getValue();
    }

    public void setTime(LocalTime time) {
        this.timePanel.setValue(time);
    }

    public LocalTime getEndTime() {
        if (!this.showTripSettings) {
            return null;
        }
        if (!this.isTimeSupported(this.getEndWhen())) {
            return null;
        }
        return this.endTimePanel.getValue();
    }

    public void setEndTime(LocalTime time) {
        this.endTimePanel.setValue(time);
    }

    public void setWhere(Location location) {
        if (location != null && location.getId() == null) {
            this.setWhereImpl(null);
            this.setWhereText(location.getDisplayName());
        } else {
            this.setWhereImpl(location);
            if (location != null && location.getId() == null) {
                this.setWhereText(location.getDisplayName());
            } else {
                this.whereIndexer.setValue(location == null ? null : location.getId());
            }
        }
    }

    public Location getWhere() {
        return this.where;
    }

    public String getWhereText() {
        return this.whereIndexer.getTextValue();
    }

    public void setWhereText(String whereText) {
        this.whereIndexer.setValue(null);
        this.whereIndexer.setTextValue(whereText);
    }

    protected void setWhereImpl(Location location) {
        if (this.where != location) {
            Location oldWhere = this.where;
            this.where = location;
            this.firePropertyChange("where", oldWhere, this.where);
            this.dirty.setDirty(true);
        }
    }

    public void shown() {
        this.whereIndexer.requestFocusInWindow();
        this.updateLocationText();
    }

    public ImmutableSet<User> getWho() {
        return this.who;
    }

    public void setWho(Collection<User> users) {
        this.setWhoImpl(users);
        if (this.userChipsUi != null) {
            this.userChipsUi.userChips.clear();
            if (users != null) {
                this.userChipsUi.userChips.addAllChips(users);
            }
        }
    }

    private void setWhoImpl(Collection<User> users) {
        ImmutableSet<User> oldWho = this.who;
        ImmutableSet<User> newWho = ImmutableSet.copyOf(users);
        if (!Objects.equal(oldWho, newWho)) {
            this.who = newWho;
            this.firePropertyChange("who", oldWho, newWho);
        }
    }

    private void initGUI() {
        if (this.reportSet.getUserSet() != null) {
            this.userChipsUi = new UserChipsUi(this.reportSet.getUserSet(), this.fontManager);
            this.userChipsUi.userLabel.setText(Messages.getMessage(Messages.Name.WHO_QUESTION));
            this.userChipsUi.userChips.setScaledWidth(400);
        }
        this.whereIndexer = new IndexerPanel();
        this.whereLabel = new JLabel();
        this.whereLabel.setText(Messages.getMessage(Messages.Name.WHERE_QUESTION));
        this.whereLabelHelp = new JLabel();
        this.whereLabelHelp.putClientProperty("birdlist.plainLabel", true);
        this.locationDetailLabel = new JLabel();
        this.locationDetailLabel.putClientProperty("birdlist.plainLabel", true);
        this.whenLabel = new JLabel();
        this.whenLabel.setText(Messages.getMessage(Messages.Name.WHEN_QUESTION));
        this.whenPanel = new DatePanel();
        this.timeLabel = new JLabel(Messages.getMessage(Messages.Name.START_TIME_QUESTION));
        this.timePanel = new TimePanel();
        this.timeLabel.setVisible(false);
        this.timePanel.setVisible(false);
        this.endWhenLabel = new JLabel();
        this.endWhenLabel.setText(Messages.getMessage(Messages.Name.UNTIL_WHEN));
        this.endWhenPanel = new DatePanel();
        this.endWhenLabel.setVisible(false);
        this.endWhenPanel.setVisible(false);
        this.endWhenErrorLabel = new ErrorLabel();
        this.endTimeLabel = new JLabel(Messages.getMessage(Messages.Name.END_TIME_QUESTION));
        this.endTimePanel = new TimePanel();
        this.endTimeLabel.setVisible(false);
        this.endTimePanel.setVisible(false);
    }

    public void setEditable(boolean editable) {
        this.whenPanel.setEditable(editable);
        this.whereIndexer.setEditable(editable);
    }

    public boolean isWherePopupVisible() {
        return this.whereIndexer.isPopupVisible();
    }

    public boolean hasWhere() {
        return this.whereIndexer.getValue() != null;
    }

    public boolean hasWhen() {
        return this.whenPanel.getValue() != null;
    }

    public boolean hasEndWhen() {
        if (!this.showTripSettings) {
            return false;
        }
        if (this.endWhenPanel.getValue() == null) {
            return false;
        }
        return this.whenPanel.getValue() == null || SightingComparators.comparePartials(this.whenPanel.getValue(), this.endWhenPanel.getValue()) <= 0;
    }

    private String locationHierarchyAsString(Location location) {
        if (location == null) {
            return "";
        }
        Object text = "";
        for (int count = 0; location != null && count < 4; location = location.getParent(), ++count) {
            text = (String)text + "\u2190 ";
            text = (String)text + LocationIdToString.getStringWithType(location) + " ";
        }
        if (location != null) {
            text = (String)text + "\u2190 \u2026";
        }
        return text;
    }

    private void updateLocationText() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Location location = NewWhenAndWherePanel.this.getWhere();
                if (location != null) {
                    NewWhenAndWherePanel.this.whereLabelHelp.setText("");
                    NewWhenAndWherePanel.this.locationDetailLabel.setText(NewWhenAndWherePanel.this.locationHierarchyAsString(location.getParent()));
                } else if (!Strings.isNullOrEmpty(NewWhenAndWherePanel.this.getWhereText())) {
                    NewWhenAndWherePanel.this.locationDetailLabel.setText("");
                    if (NewWhenAndWherePanel.this.isWherePopupVisible()) {
                        NewWhenAndWherePanel.this.whereLabelHelp.setText(Messages.getMessage(Messages.Name.PICK_VALUE_OR_ESCAPE_TO_CLOSE));
                    } else {
                        NewWhenAndWherePanel.this.whereLabelHelp.setText(Messages.getFormattedMessage(Messages.Name.LOCATION_IS_NEW_FORMAT, NewWhenAndWherePanel.this.getWhereText()));
                    }
                } else {
                    NewWhenAndWherePanel.this.locationDetailLabel.setText("");
                    NewWhenAndWherePanel.this.whereLabelHelp.setText("");
                }
            }
        });
    }

    private void updateEndErrorMessage() {
        if (!this.showTripSettings) {
            this.endWhenErrorLabel.setText("");
        } else {
            ReadablePartial startWhen = this.whenPanel.getValue();
            ReadablePartial endWhen = this.endWhenPanel.getValue();
            if (startWhen != null && endWhen != null && endWhen.isSupported(DateTimeFieldType.year()) && SightingComparators.comparePartials(startWhen, endWhen) > 0) {
                this.endWhenErrorLabel.setText(Messages.getMessage(Messages.Name.TRIP_END_DATE_MUST_NOT_PRECEDE_START_DATE));
            } else {
                this.endWhenErrorLabel.setText("");
            }
        }
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        this.setPreferredSize(fontManager.scale(new Dimension(400, 300)));
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup();
        if (this.userChipsUi != null) {
            horizontalGroup.addComponent(this.userChipsUi.userLabel).addGroup(layout.createSequentialGroup().addComponent(this.userChipsUi.userIndexer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userChipsUi.addUserButton)).addGroup(layout.createSequentialGroup().addGap(10).addComponent(this.userChipsUi.userChipsScrollPane, fontManager.scale(400), fontManager.scale(400), fontManager.scale(400)));
        }
        horizontalGroup.addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.whenLabel).addComponent(this.whenPanel).addComponent(this.endWhenLabel).addComponent(this.endWhenPanel)).addGap(50).addGroup(layout.createParallelGroup().addComponent(this.timeLabel).addComponent(this.timePanel).addComponent(this.endTimeLabel).addComponent(this.endTimePanel))).addComponent(this.endWhenErrorLabel).addGroup(layout.createSequentialGroup().addComponent(this.whereLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.whereLabelHelp)).addGroup(layout.createSequentialGroup().addComponent(this.whereIsRequired).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.whereIndexer, -2, -2, fontManager.scale(300))).addGroup(layout.createSequentialGroup().addGap(20).addComponent(this.locationDetailLabel));
        layout.setHorizontalGroup(horizontalGroup);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        if (this.userChipsUi != null) {
            verticalGroup.addComponent(this.userChipsUi.userLabel, -2, -2, -2).addGroup(layout.createBaselineGroup(false, false).addComponent(this.userChipsUi.userIndexer, -2, -2, -2).addComponent(this.userChipsUi.addUserButton, -2, -2, -2)).addComponent(this.userChipsUi.userChipsScrollPane, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED);
        }
        verticalGroup.addGroup(layout.createBaselineGroup(false, false).addComponent(this.whenLabel, -2, -2, -2).addComponent(this.timeLabel, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.whenPanel, -2, -2, -2).addComponent(this.timePanel, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.endWhenLabel, -2, -2, -2).addComponent(this.endTimeLabel, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.endWhenPanel, -2, -2, -2).addComponent(this.endTimePanel, -2, -2, -2)).addComponent(this.endWhenErrorLabel).addGap(fontManager.scale(17)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.whereLabel, -2, -2, -2).addComponent(this.whereLabelHelp, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.whereIsRequired).addComponent(this.whereIndexer, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.locationDetailLabel);
        layout.setVerticalGroup(verticalGroup);
    }
}

