/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.ui.actions.locationapi.GeocoderResults;
import com.scythebill.birdlist.ui.actions.locationapi.ReverseGeocoder;
import com.scythebill.birdlist.ui.actions.locationapi.combined.CombinedGeocoder;
import com.scythebill.birdlist.ui.actions.locationapi.combined.CombinedReverseGeocoder;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.ProgressSpinner;
import com.scythebill.birdlist.ui.components.RequiredLabel;
import com.scythebill.birdlist.ui.components.TextLink;
import com.scythebill.birdlist.ui.components.WherePanelIndexers;
import com.scythebill.birdlist.ui.components.table.DeleteColumn;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.location.LocationPreview;
import com.scythebill.birdlist.ui.panels.location.LocationPreviews;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FullWidthCombboxPopups;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class NewLocationPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private static final int LOCATION_PREVIEW_DELAY_MILLIS = 500;
    private static final int REVERSE_GEOCODE_DELAY_MILLIS = 300;
    private static final int GEOCODE_DELAY_MILLIS = 500;
    private static final Logger logger = Logger.getLogger(NewLocationPanel.class.getName());
    private static final ImmutableBiMap<Integer, Location.Type> TYPE_MAP = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put((Object)1, (Object)Location.Type.park)).put((Object)2, (Object)Location.Type.city)).put((Object)3, (Object)Location.Type.town)).put((Object)4, (Object)Location.Type.county)).put((Object)5, (Object)Location.Type.state)).put((Object)6, (Object)Location.Type.country)).build();
    private final List<String> types;
    private JComboBox<String> ofTypeChoice;
    private IndexerPanel<Object> inIndexer;
    private RequiredLabel inIsRequired;
    private JLabel summaryLabel;
    private final LocationSet locations;
    private final PredefinedLocations predefinedLocations;
    private boolean complete;
    private Location lastLocation;
    private String name;
    private final Alerts alerts;
    private final DocumentListener updateComplete;
    private JPanel moreSpecificPanel;
    private TextLink lessSpecificRow;
    private TextLink moreSpecificRow;
    private final FontManager fontManager;
    private JPanel inBox;
    private WherePanelIndexers whereIndexers;
    private JComponent focusComponent;
    private JLabel inHelp;
    private JLabel latitudeLabel;
    private JLabel longitudeLabel;
    private JFormattedTextField latitudeField;
    private JFormattedTextField longitudeField;
    private JLabel ofTypeLabel;
    private final CombinedGeocoder geocoder;
    private final ReverseGeocoder reverseGeocoder;
    private final JPanel locationPreviewPanel;
    private final LocationPreview locationPreview;
    private JLabel descriptionLabel;
    private JScrollPane descriptionScrollPane;
    private JTextArea description;
    private JCheckBox privateLocation;
    private LatLongCoordinates geocodedLatLong;
    private Location geocodedParent;
    private Timer geocodeTimer;
    private ProgressSpinner geocodeSpinner;
    private TextLink geocodeErrors;
    private JButton ignoreGeocode;
    private JButton searchNear;
    private List<LatLongCoordinates> geocodeResultsToIgnore;
    private final PropertyChangeListener latLongChanged;
    private Timer locationPreviewTimer;
    private JTextField nameField;
    private Location valueWithoutGeocoding;
    private JComboBox<UIGeocoderResults> multipleGeocodeResults;
    private JLabel multipleGeocodeResultsLabel;
    private Location existingLocationBeingEdited;
    private Timer reverseGeocodeTimer;
    private boolean latLongExplicitlyEntered;
    private ListenableFuture<?> currentGeocodeFuture;

    @Inject
    public NewLocationPanel(LocationSet locations, PredefinedLocations predefinedLocations, FontManager fontManager, Alerts alerts, CombinedGeocoder geocoder, CombinedReverseGeocoder reverseGeocoder, LocationPreviews locationPreviews) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(Messages.getMessage(Messages.Name.LOCATION_TYPE_NO_TYPE));
        for (Location.Type type : TYPE_MAP.values()) {
            builder.add(Messages.getText(type));
        }
        this.types = builder.build();
        this.inIsRequired = new RequiredLabel();
        this.lastLocation = null;
        this.updateComplete = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewLocationPanel.this.updateCompleteAndValue();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewLocationPanel.this.updateCompleteAndValue();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewLocationPanel.this.updateCompleteAndValue();
            }
        };
        this.geocodeResultsToIgnore = Lists.newArrayList();
        this.latLongChanged = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getNewValue() == null && event.getOldValue() == null) {
                    return;
                }
                NewLocationPanel.this.ignoreGeocode.setVisible(false);
                NewLocationPanel.this.updateCompleteAndValue();
            }
        };
        this.locations = locations;
        this.predefinedLocations = predefinedLocations;
        this.fontManager = fontManager;
        this.alerts = alerts;
        this.geocoder = geocoder;
        this.reverseGeocoder = reverseGeocoder;
        this.locationPreview = locationPreviews.getLocationPreview();
        this.locationPreviewPanel = (JPanel)((Object)this.locationPreview);
        this.initGUI();
        this.hookUpContents();
    }

    public String getLocationName() {
        return this.name;
    }

    public void setLocationName(String initialName) {
        this.nameField.setText(initialName);
        this.name = initialName;
        this.moreSpecificPanel.removeAll();
        this.moreSpecificRow.setVisible(false);
        this.lessSpecificRow.setVisible(false);
        this.inIndexer.clearValue();
        this.updateCompleteAndValue();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.nameField.setEnabled(enabled);
        this.inIndexer.setEnabled(enabled);
        this.moreSpecificRow.setEnabled(enabled);
        this.lessSpecificRow.setEnabled(enabled);
        this.latitudeField.setEnabled(enabled);
        this.latitudeLabel.setEnabled(enabled);
        this.longitudeField.setEnabled(enabled);
        this.longitudeLabel.setEnabled(enabled);
        this.multipleGeocodeResults.setEnabled(enabled);
        this.multipleGeocodeResultsLabel.setEnabled(enabled);
        this.inHelp.setEnabled(enabled);
        this.ofTypeLabel.setEnabled(enabled);
        this.ofTypeChoice.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
        this.description.setEnabled(enabled);
        this.privateLocation.setEnabled(enabled);
        this.summaryLabel.setEnabled(enabled);
        for (Component component : this.moreSpecificPanel.getComponents()) {
            component.setEnabled(enabled);
        }
    }

    public void setLocationLatLong(@Nullable LatLongCoordinates latLong) {
        this.latitudeField.removePropertyChangeListener("value", this.latLongChanged);
        this.longitudeField.removePropertyChangeListener("value", this.latLongChanged);
        if (latLong == null) {
            this.latitudeField.setText("");
            this.longitudeField.setText("");
        } else {
            this.latitudeField.setValue(latLong.latitudeAsDouble());
            this.longitudeField.setValue(latLong.longitudeAsDouble());
        }
        this.latitudeField.addPropertyChangeListener("value", this.latLongChanged);
        this.longitudeField.addPropertyChangeListener("value", this.latLongChanged);
        this.latLongExplicitlyEntered = latLong != null;
        this.updateCompleteAndValue();
    }

    public void setParentLocation(Location location) {
        if (location == null) {
            this.inIndexer.setTextValue("");
            this.inIndexer.setEditable(true);
            this.focusComponent = this.inIndexer;
        } else {
            this.inIndexer.setValue(location.getId());
            this.inIndexer.setEditable(false);
            this.focusComponent = this.nameField;
        }
    }

    public void setGeocodedParentLocation(Location location) {
        this.setParentLocation(location);
        this.geocodedParent = location;
    }

    public void setExistingLocation(Location location) {
        this.existingLocationBeingEdited = location;
        this.setLocationName(location.getModelName());
        this.inIndexer.setValue(location.getParent() == null ? null : location.getParent().getId());
        this.inIndexer.setEditable(true);
        this.focusComponent = this.nameField;
        this.latitudeField.setText(location.getLatLong().isPresent() ? location.getLatLong().get().latitude() : "");
        this.longitudeField.setText(location.getLatLong().isPresent() ? location.getLatLong().get().longitude() : "");
        this.description.setText(location.getDescription());
        this.privateLocation.setSelected(location.isPrivate());
        if (location.getType() == null) {
            this.ofTypeChoice.setSelectedIndex(0);
        } else {
            Integer index = (Integer)((ImmutableMap)((Object)TYPE_MAP.inverse())).get((Object)location.getType());
            if (index != null) {
                this.ofTypeChoice.setSelectedIndex(index);
            } else {
                logger.severe("Editing of location type " + location.getType() + " not supported");
            }
        }
    }

    public void reindexLocations() {
        this.whereIndexers.reindex(false, Predicates.alwaysTrue());
        this.whereIndexers.configureIndexer(this.inIndexer);
    }

    private void hookUpContents() {
        this.whereIndexers = new WherePanelIndexers(this.locations, this.predefinedLocations, false, null, Predicates.alwaysTrue(), null);
        this.whereIndexers.configureIndexer(this.inIndexer);
        this.nameField.putClientProperty("JTextField.placeholderText", Messages.getMessage(Messages.Name.CHOOSE_A_LOCATION_NAME));
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(this::updateValue);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(this::updateValue);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(this::updateValue);
            }

            private void updateValue() {
                NewLocationPanel.this.name = CharMatcher.whitespace().trimFrom(NewLocationPanel.this.nameField.getText());
                NewLocationPanel.this.nameField.setColumns(Math.min(30, Math.max(15, NewLocationPanel.this.name.length() / 5 * 5 + 5)));
                NewLocationPanel.this.revalidate();
                NewLocationPanel.this.updateCompleteAndValue();
            }
        });
        this.inIndexer.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Location location = WherePanelIndexers.toLocation(NewLocationPanel.this.locations, e.getNewValue());
                if (location != null && !Objects.equal(location, NewLocationPanel.this.geocodedParent)) {
                    NewLocationPanel.this.geocodedParent = null;
                    NewLocationPanel.this.multipleGeocodeResults.setVisible(false);
                    NewLocationPanel.this.multipleGeocodeResultsLabel.setVisible(false);
                    NewLocationPanel.this.updateCompleteAndValue();
                    NewLocationPanel.this.updateInHelp(location);
                }
                NewLocationPanel.this.moreSpecificRow.setVisible(location != null);
            }
        });
        this.ofTypeChoice.addActionListener(e -> this.updateValue(false, true));
        this.moreSpecificRow.addActionListener(e -> {
            this.geocodedParent = null;
            this.moreSpecificPanel.add(new NewLocationRow());
            this.lessSpecificRow.setVisible(true);
            this.revalidate();
            this.updateCompleteAndValue();
        });
        this.lessSpecificRow.addActionListener(e -> {
            this.geocodedParent = null;
            this.moreSpecificPanel.remove(this.moreSpecificPanel.getComponentCount() - 1);
            if (this.moreSpecificPanel.getComponentCount() == 0) {
                this.lessSpecificRow.setVisible(false);
            }
            this.revalidate();
            this.updateCompleteAndValue();
        });
        this.description.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent event) {
                NewLocationPanel.this.updateValue(false, false);
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                NewLocationPanel.this.updateValue(false, false);
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                NewLocationPanel.this.updateValue(false, false);
            }
        });
        this.privateLocation.addActionListener(e -> this.updateValue(false, false));
        this.latitudeField.addPropertyChangeListener("value", this.latLongChanged);
        this.longitudeField.addPropertyChangeListener("value", this.latLongChanged);
        this.ignoreGeocode.addActionListener(e -> {
            this.ignoreGeocode.setVisible(false);
            if (this.geocodedLatLong != null) {
                this.geocodeResultsToIgnore.add(this.geocodedLatLong);
                this.valueWithoutGeocoding = null;
                this.geocodedParent = null;
                this.geocodedLatLong = null;
                this.nameField.requestFocusInWindow();
                this.latitudeField.removePropertyChangeListener("value", this.latLongChanged);
                this.longitudeField.removePropertyChangeListener("value", this.latLongChanged);
                this.latitudeField.setText("");
                this.longitudeField.setText("");
                this.locationPreview.setLatLong(null);
                this.latitudeField.addPropertyChangeListener("value", this.latLongChanged);
                this.longitudeField.addPropertyChangeListener("value", this.latLongChanged);
                this.updateCompleteAndValue();
            }
        });
        this.searchNear.addActionListener(e -> this.runReverseGeocoding());
        this.multipleGeocodeResults.addActionListener(e -> {
            UIGeocoderResults results = (UIGeocoderResults)this.multipleGeocodeResults.getSelectedItem();
            this.geocodeResultsAvailable(results.results, false, true);
        });
        this.locationPreview.addMapClickedListener(latLong -> {
            this.valueWithoutGeocoding = null;
            this.geocodedParent = null;
            this.geocodedLatLong = null;
            this.locationPreview.setLatLong(latLong);
            this.latitudeField.removePropertyChangeListener("value", this.latLongChanged);
            this.longitudeField.removePropertyChangeListener("value", this.latLongChanged);
            this.latitudeField.setText(latLong.latitude());
            this.longitudeField.setText(latLong.longitude());
            this.latitudeField.addPropertyChangeListener("value", this.latLongChanged);
            this.longitudeField.addPropertyChangeListener("value", this.latLongChanged);
            this.updateCompleteAndValue();
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (NewLocationPanel.this.geocodeTimer != null) {
                    NewLocationPanel.this.geocodeTimer.stop();
                    NewLocationPanel.this.geocodeTimer = null;
                }
                if (NewLocationPanel.this.reverseGeocodeTimer != null) {
                    NewLocationPanel.this.reverseGeocodeTimer.stop();
                    NewLocationPanel.this.reverseGeocodeTimer = null;
                }
                if (NewLocationPanel.this.locationPreviewTimer != null) {
                    NewLocationPanel.this.locationPreviewTimer.stop();
                    NewLocationPanel.this.locationPreviewTimer = null;
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
    }

    private void updateValue(boolean immediatelyLoadImage, boolean geocode) {
        Location newValue;
        Location oldValue = this.lastLocation;
        this.lastLocation = newValue = this.getValue();
        this.searchNear.setVisible(this.getCurrentLatLong() != null);
        Location oldValueWithoutGeocoding = this.valueWithoutGeocoding;
        this.valueWithoutGeocoding = this.getValuePerhapsIgnoringGeocoding(true);
        this.firePropertyChange("value", oldValue, newValue);
        if (newValue == null) {
            this.summaryLabel.setText("");
        } else {
            Location parentWithId;
            int alreadyPresentParents = 0;
            Object summary = "<html>";
            Location findingAParent = newValue;
            for (parentWithId = newValue.getParent(); parentWithId != null && parentWithId.getId() == null; parentWithId = parentWithId.getParent()) {
            }
            Object parentId = parentWithId == null ? null : this.whereIndexers.toIndexerObject(parentWithId);
            this.inIndexer.setValue(parentId);
            while (findingAParent != null) {
                summary = (String)summary + HtmlResponseWriter.htmlEscape(LocationIdToString.getStringWithType(findingAParent));
                if (findingAParent.getId() != null && ++alreadyPresentParents >= 2) {
                    if (findingAParent.getParent() == null) break;
                    summary = (String)summary + " \u2190 \u2026";
                    break;
                }
                findingAParent = findingAParent.getParent();
                summary = (String)summary + " \u2190<wbr> ";
            }
            this.summaryLabel.setText((String)summary);
        }
        if (geocode) {
            this.geocodeErrors.setVisible(false);
            LatLongCoordinates newLatLong = newValue == null ? this.getCurrentLatLong() : newValue.getLatLong().orNull();
            if (!Objects.equal(this.locationPreview.getLatLong(), newLatLong)) {
                if (this.locationPreviewTimer != null) {
                    this.locationPreviewTimer.stop();
                }
                if (immediatelyLoadImage || newLatLong == null) {
                    this.locationPreview.setLatLong(newLatLong);
                } else {
                    if (this.locationPreviewTimer != null) {
                        this.locationPreviewTimer.stop();
                    }
                    this.locationPreviewTimer = new Timer(500, e -> {
                        if (Objects.equal(this.getCurrentLatLong(), newLatLong)) {
                            this.locationPreview.setLatLong(newLatLong);
                        }
                    });
                    this.locationPreviewTimer.setRepeats(false);
                    this.locationPreviewTimer.start();
                }
            }
            if (newValue == null) {
                if (newLatLong != null) {
                    if (this.reverseGeocodeTimer == null) {
                        this.reverseGeocodeTimer = new Timer(300, e -> this.runReverseGeocoding());
                    }
                    this.reverseGeocodeTimer.setRepeats(false);
                    this.reverseGeocodeTimer.setCoalesce(true);
                    this.reverseGeocodeTimer.start();
                }
            } else if (!this.latLongExplicitlyEntered) {
                if (this.geocodeTimer == null) {
                    this.geocodeTimer = new Timer(500, e -> this.runGeocoding());
                    this.geocodeTimer.setRepeats(false);
                    this.geocodeTimer.setCoalesce(true);
                    this.geocodeTimer.start();
                } else if (!(this.valueWithoutGeocoding == null || oldValueWithoutGeocoding != null && oldValueWithoutGeocoding.getModelName().equals(this.valueWithoutGeocoding.getModelName()) && oldValueWithoutGeocoding.getType() == this.valueWithoutGeocoding.getType() && oldValueWithoutGeocoding.getParent().equals(this.valueWithoutGeocoding.getParent()))) {
                    GeocoderResults currentMultiResults = null;
                    if (this.multipleGeocodeResults.isVisible() && this.multipleGeocodeResults.getSelectedItem() instanceof UIGeocoderResults) {
                        UIGeocoderResults selectedItem = (UIGeocoderResults)this.multipleGeocodeResults.getSelectedItem();
                        currentMultiResults = selectedItem.results;
                    }
                    if (currentMultiResults == null || !this.valueWithoutGeocoding.getModelName().equals(currentMultiResults.name())) {
                        this.geocodeTimer.restart();
                    }
                }
            }
        }
    }

    private void geocodeResultsAvailable(GeocoderResults results, boolean showIgnoreGeocode, boolean takeNameFromGeocode) {
        this.geocodedLatLong = results == null ? null : results.coordinates();
        Location location = this.geocodedParent = results == null ? null : results.preferredParent().orNull();
        if (this.geocodedParent != null) {
            this.geocodedParent = Locations.normalizeLocation(this.geocodedParent, this.locations);
        }
        if (!this.latLongExplicitlyEntered) {
            String newLongitudeText;
            String newLatitudeText = this.geocodedLatLong == null ? "" : this.geocodedLatLong.latitude();
            String string = newLongitudeText = this.geocodedLatLong == null ? "" : this.geocodedLatLong.longitude();
            if (newLatitudeText.equals(this.latitudeField.getText()) && newLongitudeText.equals(this.longitudeField.getText())) {
                return;
            }
            this.latitudeField.removePropertyChangeListener("value", this.latLongChanged);
            this.longitudeField.removePropertyChangeListener("value", this.latLongChanged);
            if (this.geocodedLatLong != null) {
                this.latitudeField.setText(this.geocodedLatLong.latitude());
                this.longitudeField.setText(this.geocodedLatLong.longitude());
                if (showIgnoreGeocode) {
                    this.ignoreGeocode.setText(Messages.getFormattedMessage(Messages.Name.IGNORE_RESULT_FORMAT, new Object[]{results.source()}));
                    this.ignoreGeocode.setVisible(true);
                }
            } else {
                this.latitudeField.setText("");
                this.longitudeField.setText("");
                this.ignoreGeocode.setVisible(false);
            }
            this.latitudeField.addPropertyChangeListener("value", this.latLongChanged);
            this.longitudeField.addPropertyChangeListener("value", this.latLongChanged);
        }
        if (takeNameFromGeocode && results != null) {
            this.nameField.setText(results.name());
        }
        SwingUtilities.invokeLater(() -> this.updateValue(true, true));
    }

    private void updateCompleteAndValue() {
        Object longitude;
        Object latitude;
        boolean isComplete = false;
        if (!Strings.isNullOrEmpty(this.name) && this.inIndexer.getValue() != null) {
            isComplete = true;
            for (Component c : this.moreSpecificPanel.getComponents()) {
                NewLocationRow row = (NewLocationRow)c;
                if (row.getLocationBuilder() != null) continue;
                isComplete = false;
                break;
            }
        }
        if ((latitude = this.latitudeField.getValue()) == null != ((longitude = this.longitudeField.getValue()) == null)) {
            isComplete = false;
        }
        this.setComplete(isComplete);
        this.updateValue(false, true);
    }

    private void initGUI() {
        this.ofTypeLabel = new JLabel();
        this.ofTypeLabel.setText(Messages.getMessage(Messages.Name.LOCATION_TYPE_LABEL));
        this.ofTypeChoice = new JComboBox();
        this.ofTypeChoice.setModel(new DefaultComboBoxModel<String>(this.types.toArray(new String[0])));
        this.inBox = new JPanel();
        this.inBox.setLayout(new BoxLayout(this.inBox, 2));
        this.nameField = new JTextField("", 15);
        this.focusComponent = this.nameField;
        this.inBox.add(this.nameField);
        JLabel inLabel = new JLabel(Messages.getMessage(Messages.Name.LOCATION_IS_IN_LABEL));
        this.inBox.add(inLabel);
        this.inIndexer = new IndexerPanel();
        this.inIndexer.setColumns(20);
        this.inIndexer.setLayoutStrategy(IndexerPanel.LayoutStrategy.BELOW);
        this.inIndexer.setPreviewText(Messages.Name.START_TYPING_A_LOCATION);
        this.focusComponent = this.inIndexer;
        this.inHelp = new JLabel();
        this.updateInHelp(null);
        this.moreSpecificPanel = new JPanel();
        this.moreSpecificPanel.setLayout(new BoxLayout(this.moreSpecificPanel, 3));
        this.moreSpecificRow = new TextLink(Messages.getMessage(Messages.Name.EVEN_MORE_SPECIFIC));
        this.moreSpecificRow.setVisible(false);
        this.lessSpecificRow = new TextLink(Messages.getMessage(Messages.Name.LESS_SPECIFIC));
        this.lessSpecificRow.setVisible(false);
        this.summaryLabel = new JLabel();
        this.summaryLabel.putClientProperty("birdlist.plainLabel", true);
        this.summaryLabel.setVerticalAlignment(1);
        this.latitudeLabel = new JLabel(Messages.getMessage(Messages.Name.LATITUDE_LABEL));
        this.longitudeLabel = new JLabel(Messages.getMessage(Messages.Name.LONGITUDE_LABEL));
        this.latitudeField = new AutoSelectJFormattedTextField();
        this.latitudeField.setColumns(11);
        NumberFormatter latitudeFormatter = this.allowNullDecimalFormatter();
        latitudeFormatter.setValueClass(Double.class);
        latitudeFormatter.setMinimum(Double.valueOf(-90.0));
        latitudeFormatter.setMaximum(Double.valueOf(90.0));
        latitudeFormatter.setCommitsOnValidEdit(true);
        this.latitudeField.setFormatterFactory(new DefaultFormatterFactory(latitudeFormatter));
        this.longitudeField = new AutoSelectJFormattedTextField();
        this.longitudeField.setColumns(11);
        NumberFormatter longitudeFormatter = this.allowNullDecimalFormatter();
        longitudeFormatter.setValueClass(Double.class);
        longitudeFormatter.setMinimum(Double.valueOf(-180.0));
        longitudeFormatter.setMaximum(Double.valueOf(180.0));
        longitudeFormatter.setCommitsOnValidEdit(true);
        this.longitudeField.setFormatterFactory(new DefaultFormatterFactory(longitudeFormatter));
        this.geocodeSpinner = new ProgressSpinner();
        this.geocodeSpinner.setVisible(false);
        this.geocodeErrors = new TextLink("");
        this.geocodeErrors.putClientProperty("birdlist.plainLabel", true);
        this.geocodeErrors.setVisible(false);
        this.geocodeErrors.setForeground(new Color(192, 0, 0));
        this.ignoreGeocode = new JButton(Messages.getMessage(Messages.Name.IGNORE_THIS_RESULT));
        this.ignoreGeocode.setIcon(DeleteColumn.deleteIcon());
        this.ignoreGeocode.setVisible(false);
        this.searchNear = new JButton(Messages.getMessage(Messages.Name.SEARCH_NEARBY));
        this.searchNear.setVisible(false);
        this.multipleGeocodeResults = new JComboBox();
        FullWidthCombboxPopups.install(this.multipleGeocodeResults);
        this.multipleGeocodeResultsLabel = new JLabel(Messages.getMessage(Messages.Name.MULTIPLE_SEARCH_RESULTS));
        this.multipleGeocodeResults.setVisible(false);
        this.multipleGeocodeResultsLabel.setVisible(false);
        this.descriptionLabel = new JLabel(Messages.getMessage(Messages.Name.DESCRIPTION_OF_THIS_LOCATION));
        this.descriptionScrollPane = new JScrollPane();
        this.description = new JTextArea();
        this.descriptionScrollPane.setViewportView(this.description);
        this.description.setColumns(40);
        this.description.setRows(6);
        this.description.setWrapStyleWord(true);
        this.description.setLineWrap(true);
        UIUtils.fixTabOnTextArea(this.description);
        this.privateLocation = new JCheckBox(Messages.getMessage(Messages.Name.PRIVATE_LOCATION_CHECKBOX));
        this.fontManager.applyTo(this);
    }

    public boolean isComplete() {
        return this.complete;
    }

    private void setComplete(boolean newComplete) {
        if (newComplete != this.complete) {
            this.complete = newComplete;
            this.firePropertyChange("complete", !newComplete, newComplete);
        }
    }

    public Location getValue() {
        return this.getValuePerhapsIgnoringGeocoding(false);
    }

    private Location getValuePerhapsIgnoringGeocoding(boolean ignoreGeocoding) {
        if (Strings.isNullOrEmpty(this.name)) {
            return null;
        }
        if (ignoreGeocoding ? this.inIndexer.getValue() == null : this.inIndexer.getValue() == null && this.geocodedParent == null) {
            return null;
        }
        Location parent = WherePanelIndexers.toLocation(this.locations, this.inIndexer.getValue());
        if (!ignoreGeocoding && this.geocodedParent != null && (parent == null || this.existingLocationBeingEdited == null || this.existingLocationBeingEdited.getParent().isBuiltInLocation())) {
            parent = this.geocodedParent;
        }
        List<Component> rowsLastToFirst = Lists.reverse(Arrays.asList(this.moreSpecificPanel.getComponents()));
        for (Component c : rowsLastToFirst) {
            NewLocationRow row = (NewLocationRow)c;
            Location.Builder builder = row.getLocationBuilder();
            if (builder == null) {
                return null;
            }
            parent = this.possiblyReplaceWithPredefined(builder.setParent(parent).build());
        }
        LatLongCoordinates latLong = this.getCurrentLatLong();
        Location.Type type = (Location.Type)((Object)TYPE_MAP.get(this.ofTypeChoice.getSelectedIndex()));
        return this.possiblyReplaceWithPredefined(Location.builder().setName(this.name).setParent(parent).setType(type).setLatLong(latLong).setDescription(this.description.getText()).setPrivate(this.privateLocation.isSelected()).build());
    }

    private LatLongCoordinates getCurrentLatLong() {
        Double latitude = (Double)this.latitudeField.getValue();
        Double longitude = (Double)this.longitudeField.getValue();
        LatLongCoordinates latLong = null;
        if (latitude != null && longitude != null) {
            latLong = LatLongCoordinates.withLatAndLong(latitude, longitude);
        }
        return latLong;
    }

    private Location possiblyReplaceWithPredefined(Location location) {
        PredefinedLocations.PredefinedLocation predefinedLocation = this.predefinedLocations.getPredefinedLocationChildThatHasNotBeenCreatedYet(this.locations, location.getParent(), location.getModelName());
        if (predefinedLocation == null) {
            return location;
        }
        return predefinedLocation.create(this.locations, location.getParent());
    }

    public Location getValueAfterValidating() {
        Location location = this.getValue();
        if (location == null) {
            return null;
        }
        Location firstParentWithoutAnId = location;
        while (firstParentWithoutAnId.getParent().getId() == null) {
            firstParentWithoutAnId = firstParentWithoutAnId.getParent();
        }
        Location existingLocation = firstParentWithoutAnId.getParent().getContent(firstParentWithoutAnId.getModelName());
        if (existingLocation != null && existingLocation != this.existingLocationBeingEdited && this.existingLocationBeingEdited == null) {
            this.alerts.showError((Object)this, Messages.Name.DUPLICATE_LOCATION_TITLE, Messages.Name.DUPLICATE_LOCATION_FORMAT, HtmlResponseWriter.htmlEscape(firstParentWithoutAnId.getDisplayName()), HtmlResponseWriter.htmlEscape(firstParentWithoutAnId.getParent().getDisplayName()));
            return null;
        }
        return location;
    }

    public Location getValuePossiblyReusing() {
        Location location = this.getValue();
        if (location == null) {
            return null;
        }
        return Locations.normalizeLocation(location, this.locations);
    }

    public void clearValue() {
        this.inIndexer.clearValue();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.focusComponent.requestFocusInWindow();
    }

    private NumberFormatter allowNullDecimalFormatter() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumIntegerDigits(3);
        numberFormat.setMaximumFractionDigits(7);
        return new NumberFormatter(numberFormat){

            @Override
            public Object stringToValue(String string) throws ParseException {
                if ("".equals(string)) {
                    return null;
                }
                return super.stringToValue(string);
            }
        };
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout thisLayout = new GroupLayout(this);
        this.setMinimumSize(fontManager.scale(new Dimension(300, 400)));
        this.setBorder(new EmptyBorder(fontManager.scale(20), fontManager.scale(20), fontManager.scale(20), fontManager.scale(20)));
        this.locationPreviewPanel.setPreferredSize(fontManager.scale(new Dimension(400, 400)));
        this.setLayout(thisLayout);
        int geocodeSpinnerSize = fontManager.scale(50);
        thisLayout.setVerticalGroup(thisLayout.createSequentialGroup().addComponent(this.inBox, -2, -2, -2).addGroup(thisLayout.createParallelGroup().addComponent(this.locationPreviewPanel).addGroup(thisLayout.createSequentialGroup().addComponent(this.lessSpecificRow, -2, -2, -2).addComponent(this.moreSpecificPanel).addComponent(this.moreSpecificRow, -2, -2, -2).addGroup(thisLayout.createBaselineGroup(false, false).addComponent(this.inIsRequired).addComponent(this.inIndexer).addComponent(this.inHelp)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(thisLayout.createBaselineGroup(false, false).addComponent(this.ofTypeLabel).addComponent(this.ofTypeChoice)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(thisLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.geocodeSpinner, geocodeSpinnerSize, geocodeSpinnerSize, geocodeSpinnerSize).addGroup(thisLayout.createSequentialGroup().addComponent(this.ignoreGeocode, -2, -2, -2).addComponent(this.searchNear, -2, -2, -2).addComponent(this.multipleGeocodeResultsLabel, -2, -2, -2).addComponent(this.multipleGeocodeResults, -2, -2, -2)).addComponent(this.geocodeErrors, -2, -2, -2).addGroup(thisLayout.createSequentialGroup().addGroup(thisLayout.createBaselineGroup(false, false).addComponent(this.latitudeLabel).addComponent(this.latitudeField, -2, -2, -2)).addGroup(thisLayout.createBaselineGroup(false, false).addComponent(this.longitudeLabel).addComponent(this.longitudeField, -2, -2, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.summaryLabel, fontManager.scale(60), -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionLabel, -2, -2, -2).addComponent(this.descriptionScrollPane, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.privateLocation, -2, -2, -2))));
        thisLayout.setHorizontalGroup(thisLayout.createSequentialGroup().addGroup(thisLayout.createParallelGroup().addGroup(thisLayout.createSequentialGroup().addGap(20).addComponent(this.summaryLabel, fontManager.scale(200), fontManager.scale(200), fontManager.scale(400))).addComponent(this.inBox, -2, -2, -2).addGroup(thisLayout.createSequentialGroup().addComponent(this.inIsRequired).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inIndexer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inHelp)).addComponent(this.lessSpecificRow, -2, -2, -2).addComponent(this.moreSpecificPanel).addComponent(this.moreSpecificRow, -2, -2, -2).addComponent(this.descriptionLabel, -2, -2, -2).addComponent(this.descriptionScrollPane, -2, -2, -2).addComponent(this.privateLocation, -2, -2, -2).addGroup(thisLayout.createSequentialGroup().addGroup(thisLayout.createParallelGroup().addComponent(this.ofTypeLabel).addComponent(this.latitudeLabel).addComponent(this.longitudeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(thisLayout.createParallelGroup().addComponent(this.ofTypeChoice, -2, -2, -2).addComponent(this.latitudeField, -2, -2, -2).addComponent(this.longitudeField, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.geocodeErrors, -2, -2, -2).addGroup(thisLayout.createParallelGroup().addComponent(this.ignoreGeocode, -2, -2, -2).addComponent(this.searchNear, -2, -2, -2).addComponent(this.multipleGeocodeResultsLabel, -2, -2, -2).addComponent(this.multipleGeocodeResults, -2, fontManager.scale(150), fontManager.scale(190))).addComponent(this.geocodeSpinner, geocodeSpinnerSize, geocodeSpinnerSize, geocodeSpinnerSize))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.locationPreviewPanel));
    }

    private void updateInHelp(Location location) {
        if (location == null) {
            this.inHelp.setText(Messages.getMessage(Messages.Name.SELECT_AN_EXISTING_LOCATION));
        } else if (location.getType() == null) {
            this.inHelp.setText("");
        } else {
            this.inHelp.setText(String.format("(%s)", location.getType().toString()));
        }
    }

    private Location getCommonPredefinedLocation(ImmutableList<GeocoderResults> resultsList) {
        Location commonParent = null;
        for (GeocoderResults results : resultsList) {
            Location parent = this.getPredefinedParent(results);
            if (parent == null) continue;
            if (commonParent == null) {
                commonParent = parent;
                continue;
            }
            commonParent = Locations.getCommonAncestor(commonParent, parent);
        }
        return commonParent;
    }

    private Location getPredefinedParent(GeocoderResults geocoderResults) {
        if (geocoderResults.preferredParent().isPresent()) {
            for (Location location = geocoderResults.preferredParent().get(); location != null; location = location.getParent()) {
                if (!location.isBuiltInLocation()) continue;
                return location;
            }
        }
        return null;
    }

    private void showGeocodeError(String text, @Nullable Throwable t) {
        if (t != null) {
            if (t.getCause() instanceof UnknownHostException || t.getCause() instanceof SocketException || t.getCause() instanceof SocketTimeoutException) {
                text = (String)text + " " + Messages.getMessage(Messages.Name.NETWORK_FAILED_ERROR);
                t = null;
            } else {
                text = (String)text + " " + Messages.getMessage(Messages.Name.CLICK_FOR_DETAILS);
            }
        }
        this.geocodeErrors.setText((String)text);
        this.geocodeErrors.setEnabled(true);
        this.geocodeErrors.setVisible(true);
        if (t == null) {
            for (ActionListener listener : this.geocodeErrors.getActionListeners()) {
                this.geocodeErrors.removeActionListener(listener);
            }
            this.geocodeErrors.setFocusable(false);
            this.geocodeErrors.setCursor(null);
        } else {
            Throwable errorToShow = t;
            this.geocodeErrors.addActionListener(e -> this.alerts.showError((Object)this.geocodeErrors, errorToShow, this.geocodeErrors.getText(), Messages.getMessage(Messages.Name.LOCATION_DETECTION_FAILED), new Object[0]));
            this.geocodeErrors.setFocusable(true);
            this.geocodeErrors.setCursor(new Cursor(12));
        }
    }

    private void runReverseGeocoding() {
        final LatLongCoordinates newLatLong = this.getCurrentLatLong();
        if (newLatLong == null) {
            return;
        }
        ListenableFuture<ImmutableList<GeocoderResults>> reverseGeocode = this.reverseGeocoder.reverseGeocode(this.locations, newLatLong);
        this.geocodeSpinner.start();
        this.geocodeSpinner.setVisible(true);
        this.geocodeErrors.setVisible(false);
        this.ignoreGeocode.setVisible(false);
        this.multipleGeocodeResultsLabel.setVisible(false);
        this.multipleGeocodeResults.setVisible(false);
        Futures.addCallback(reverseGeocode, new FutureCallback<ImmutableList<GeocoderResults>>(){

            @Override
            public void onFailure(Throwable t) {
                SwingUtilities.invokeLater(() -> {
                    NewLocationPanel.this.geocodeSpinner.stop();
                    NewLocationPanel.this.geocodeSpinner.setVisible(false);
                    if (!(Throwables.getRootCause(t) instanceof CancellationException)) {
                        NewLocationPanel.this.showGeocodeError(Messages.getMessage(Messages.Name.ERROR_FETCHING_LOCATION), t);
                    }
                });
            }

            @Override
            public void onSuccess(final ImmutableList<GeocoderResults> resultsList) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewLocationPanel.this.geocodeSpinner.stop();
                        NewLocationPanel.this.geocodeSpinner.setVisible(false);
                        if (!resultsList.isEmpty()) {
                            Location commonPredefinedLocation;
                            if (NewLocationPanel.this.inIndexerIsEdited() && (commonPredefinedLocation = NewLocationPanel.this.getCommonPredefinedLocation(resultsList)) != null) {
                                NewLocationPanel.this.locations.ensureAdded(commonPredefinedLocation);
                                NewLocationPanel.this.inIndexer.setValue(commonPredefinedLocation.getId());
                            }
                            ArrayList<UIGeocoderResults> resultsStartingWithEmptyString = Lists.newArrayList();
                            resultsStartingWithEmptyString.add(new UIGeocoderResults(null, resultsList));
                            HashSet<GeocoderResults.Source> sources = Sets.newHashSet();
                            for (GeocoderResults results : resultsList) {
                                resultsStartingWithEmptyString.add(new UIGeocoderResults(results, resultsList, newLatLong));
                                sources.add(results.source());
                            }
                            NewLocationPanel.this.multipleGeocodeResults.setModel(new DefaultComboBoxModel<UIGeocoderResults>(resultsStartingWithEmptyString.toArray(new UIGeocoderResults[0])));
                            NewLocationPanel.this.multipleGeocodeResultsLabel.setText(Messages.getFormattedMessage(Messages.Name.MULTIPLE_RESULTS_FROM_FORMAT, Joiner.on(", ").join(sources)));
                            NewLocationPanel.this.multipleGeocodeResultsLabel.setVisible(true);
                            NewLocationPanel.this.multipleGeocodeResults.setVisible(true);
                        } else {
                            NewLocationPanel.this.showGeocodeError(Messages.getMessage(Messages.Name.COULDNT_FIND_RESULTS_FOR_LAT_LONG), null);
                        }
                    }
                });
            }
        }, MoreExecutors.directExecutor());
    }

    private void runGeocoding() {
        if (this.lastLocation == null) {
            return;
        }
        if (!this.valueWithoutGeocoding.getLatLong().isPresent() || Objects.equal(this.valueWithoutGeocoding.getLatLong().get(), this.geocodedLatLong)) {
            final String lastLocationName = this.valueWithoutGeocoding.getDisplayName();
            if (!this.latitudeField.hasFocus() && !this.longitudeField.hasFocus()) {
                ListenableFuture<ImmutableList<GeocoderResults>> geocode = this.geocoder.geocode(this.locations, this.valueWithoutGeocoding, this.geocodeResultsToIgnore);
                this.currentGeocodeFuture = geocode;
                this.geocodeSpinner.start();
                this.geocodeSpinner.setVisible(true);
                this.geocodeErrors.setVisible(false);
                this.ignoreGeocode.setVisible(false);
                this.multipleGeocodeResultsLabel.setVisible(false);
                this.multipleGeocodeResults.setVisible(false);
                Futures.addCallback(geocode, new FutureCallback<ImmutableList<GeocoderResults>>(){

                    @Override
                    public void onFailure(Throwable t) {
                        SwingUtilities.invokeLater(() -> {
                            NewLocationPanel.this.geocodeSpinner.stop();
                            NewLocationPanel.this.geocodeSpinner.setVisible(false);
                            if (!(Throwables.getRootCause(t) instanceof CancellationException)) {
                                NewLocationPanel.this.showGeocodeError(Messages.getMessage(Messages.Name.ERROR_FETCHING_LOCATION), t);
                            }
                        });
                    }

                    @Override
                    public void onSuccess(ImmutableList<GeocoderResults> resultsList) {
                        SwingUtilities.invokeLater(() -> {
                            NewLocationPanel.this.geocodeSpinner.stop();
                            NewLocationPanel.this.geocodeSpinner.setVisible(false);
                            if (resultsList.size() > 1) {
                                ArrayList<UIGeocoderResults> resultsStartingWithEmptyString = Lists.newArrayList();
                                resultsStartingWithEmptyString.add(new UIGeocoderResults(null, resultsList));
                                HashSet<GeocoderResults.Source> sources = Sets.newHashSet();
                                for (GeocoderResults results : resultsList) {
                                    resultsStartingWithEmptyString.add(new UIGeocoderResults(results, resultsList));
                                    sources.add(results.source());
                                }
                                NewLocationPanel.this.multipleGeocodeResults.setModel(new DefaultComboBoxModel<UIGeocoderResults>(resultsStartingWithEmptyString.toArray(new UIGeocoderResults[0])));
                                NewLocationPanel.this.multipleGeocodeResultsLabel.setText(Messages.getFormattedMessage(Messages.Name.MULTIPLE_RESULTS_FROM_FORMAT, Joiner.on(", ").join(sources)));
                                NewLocationPanel.this.multipleGeocodeResultsLabel.setVisible(true);
                                NewLocationPanel.this.multipleGeocodeResults.setVisible(true);
                            } else {
                                GeocoderResults results;
                                GeocoderResults geocoderResults = results = resultsList.isEmpty() ? null : (GeocoderResults)resultsList.get(0);
                                if (results == null) {
                                    NewLocationPanel.this.showGeocodeError(Messages.getFormattedMessage(Messages.Name.COULDNT_FIND_LOCATION_FORMAT, lastLocationName), null);
                                }
                                NewLocationPanel.this.geocodeResultsAvailable(results, true, false);
                            }
                        });
                    }
                }, MoreExecutors.directExecutor());
            }
        }
    }

    public void cancelAsyncOperations() {
        if (this.currentGeocodeFuture != null) {
            this.currentGeocodeFuture.cancel(true);
        }
        if (this.geocodeTimer != null) {
            this.geocodeTimer.stop();
        }
        if (this.locationPreviewTimer != null) {
            this.locationPreviewTimer.stop();
        }
        if (this.reverseGeocodeTimer != null) {
            this.reverseGeocodeTimer.stop();
        }
    }

    private boolean inIndexerIsEdited() {
        return this.inIndexer.getTextValue().isEmpty() || this.inIndexer.getValue() != null && WherePanelIndexers.toLocation(this.locations, this.inIndexer.getValue()) == this.geocodedParent;
    }

    static class UIGeocoderResults {
        private final GeocoderResults results;
        private final String uiName;

        UIGeocoderResults(GeocoderResults results, Collection<GeocoderResults> allResults) {
            this.results = results;
            if (results == null) {
                this.uiName = "";
            } else {
                String name = results.nameWithSource();
                for (GeocoderResults otherResults : allResults) {
                    if (otherResults == results || !otherResults.nameWithSource().equals(name)) continue;
                    if (!results.preferredParent().isPresent()) break;
                    name = String.format("%s (%s)", name, results.preferredParent().get().getDisplayName());
                    break;
                }
                this.uiName = name;
            }
        }

        public UIGeocoderResults(GeocoderResults results, ImmutableList<GeocoderResults> allResults, LatLongCoordinates center) {
            this.results = results;
            if (results == null) {
                this.uiName = "";
            } else {
                String name = results.nameWithSource();
                for (GeocoderResults otherResults : allResults) {
                    if (otherResults == results || !otherResults.nameWithSource().equals(name)) continue;
                    if (!results.preferredParent().isPresent()) break;
                    name = String.format("%s (%s)", name, results.preferredParent().get().getDisplayName());
                    break;
                }
                if (results.coordinates() != null) {
                    name = String.format("%s (%.1f km)", name, results.coordinates().kmDistance(center));
                }
                this.uiName = name;
            }
        }

        public String toString() {
            return this.uiName;
        }
    }

    private class NewLocationRow
    extends JPanel {
        private JComboBox<String> ofTypeChoice;
        private JTextField field;

        NewLocationRow() {
            this.initGUI();
            this.hookUpContents();
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.ofTypeChoice.setEnabled(enabled);
            this.field.setEnabled(enabled);
        }

        private void initGUI() {
            this.setAlignmentX(0.0f);
            GroupLayout thisLayout = new GroupLayout(this);
            this.ofTypeChoice = new JComboBox();
            this.ofTypeChoice.setModel(new DefaultComboBoxModel<String>(NewLocationPanel.this.types.toArray(new String[0])));
            JLabel inLabel = new JLabel();
            inLabel.setText(Messages.getMessage(Messages.Name.LOCATION_IS_IN_LABEL));
            this.field = new JTextField();
            this.field.setColumns(20);
            this.setBorder(new EmptyBorder(0, 15, 0, 0));
            this.setLayout(thisLayout);
            thisLayout.setVerticalGroup(thisLayout.createSequentialGroup().addGroup(thisLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.field, -2, -2, -2).addComponent(this.ofTypeChoice, -2, -2, -2)).addComponent(inLabel));
            thisLayout.setHorizontalGroup(thisLayout.createParallelGroup().addGroup(thisLayout.createSequentialGroup().addComponent(this.field, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ofTypeChoice, -2, -2, -2)).addComponent(inLabel));
            NewLocationPanel.this.fontManager.applyTo(this);
        }

        private void hookUpContents() {
            this.field.getDocument().addDocumentListener(NewLocationPanel.this.updateComplete);
            this.ofTypeChoice.addActionListener(e -> NewLocationPanel.this.updateValue(false, false));
        }

        private Location.Builder getLocationBuilder() {
            if (this.field.getText().isEmpty()) {
                return null;
            }
            return Location.builder().setName(this.field.getText()).setType((Location.Type)((Object)TYPE_MAP.get(this.ofTypeChoice.getSelectedIndex())));
        }
    }
}

