/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.ui.components.NewLocationPanel;
import com.scythebill.birdlist.ui.components.OkCancelPanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JDialog;

public class NewLocationDialog {
    private final Provider<NewLocationPanel> panelProvider;
    private final FontManager fontManager;
    private final Alerts alerts;

    @Inject
    public NewLocationDialog(Provider<NewLocationPanel> panelProvider, Alerts alerts, FontManager fontManager) {
        this.panelProvider = panelProvider;
        this.alerts = alerts;
        this.fontManager = fontManager;
    }

    public void newLocation(String name, Window parent, LocationReceiver newLocation) {
        NewLocationPanel newLocationPanel = this.panelProvider.get();
        newLocationPanel.setLocationName(name);
        this.showLocationDialog(parent, newLocation, newLocationPanel, Messages.Name.NEW_LOCATION);
    }

    public void newLocation(Location location, Window windowAncestor, LocationReceiver newLocation) {
        NewLocationPanel newLocationPanel = this.panelProvider.get();
        newLocationPanel.setLocationName("");
        newLocationPanel.setParentLocation(location);
        this.showLocationDialog(windowAncestor, newLocation, newLocationPanel, Messages.Name.NEW_LOCATION);
    }

    public void editLocation(Location existingLocation, Window windowAncestor, LocationReceiver newLocation) {
        NewLocationPanel newLocationPanel = this.panelProvider.get();
        newLocationPanel.setExistingLocation(existingLocation);
        this.showLocationDialog(windowAncestor, newLocation, newLocationPanel, Messages.Name.EDIT_LOCATION);
    }

    private void showLocationDialog(Window parent, final LocationReceiver newLocation, final NewLocationPanel newLocationPanel, Messages.Name title) {
        Dialog.ModalityType modality = Toolkit.getDefaultToolkit().isModalityTypeSupported(Dialog.ModalityType.DOCUMENT_MODAL) ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.APPLICATION_MODAL;
        final JDialog dialog = new JDialog(parent, Messages.getMessage(title), modality);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        };
        final AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Location location = newLocationPanel.getValueAfterValidating();
                if (location != null) {
                    if (newLocation.locationAvailable(location)) {
                        dialog.dispose();
                    }
                } else if (newLocationPanel.getValue() == null) {
                    NewLocationDialog.this.alerts.showError((Object)newLocationPanel, Messages.Name.COULDNT_CREATE_LOCATION_TITLE, Messages.Name.COULDNT_CREATE_LOCATION_MESSAGE, new Object[0]);
                }
            }
        };
        newLocationPanel.addPropertyChangeListener("complete", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                okAction.setEnabled(newLocationPanel.isComplete());
            }
        });
        OkCancelPanel okCancel = new OkCancelPanel(okAction, cancelAction, newLocationPanel, newLocationPanel);
        okCancel.setPreferredSize(this.fontManager.scale(new Dimension(900, 600)));
        dialog.setContentPane(okCancel);
        this.fontManager.applyTo(dialog);
        dialog.pack();
        dialog.setVisible(true);
    }

    public static interface LocationReceiver {
        public boolean locationAvailable(Location var1);
    }
}

