/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.formdev.flatlaf.icons.FlatSearchIcon;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.util.AlternateName;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.components.RequiredLabel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.DoubleClickListener;
import com.scythebill.birdlist.ui.util.ListListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class IndexerPanel<T>
extends JPanel
implements FontManager.FontsUpdatedListener {
    private static final int SECONDARY_INDEXER_THRESHOLD = 5;
    private final List<ActionListener> actionListeners = Lists.newLinkedList();
    private LayoutStrategy layout = LayoutStrategy.RIGHT;
    private final Action hideAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent action) {
            IndexerPanel.this.hidePopup();
        }
    };
    private short popupHeight = (short)150;
    private JTextField valueField;
    private JScrollPane scroller;
    private JList<Object> popupList;
    private List<IndexerGroup> indexerGroups = Lists.newArrayList();
    private Mixer<T> mixer;
    private T value;
    private T selectedValue;
    private boolean textIsDirty;
    private boolean dontUpdatePopup;
    private Action setValueAction;
    private boolean canShowPopupOnFocusGained = true;
    private boolean supportsNewValues;
    private Color defaultTextForeground;
    private Predicate<T> filter;
    private Supplier<Ordering<T>> sortOrderSupplier;
    private Supplier<Ordering<AlternateName<T>>> alternateSortOrderSupplier;

    public IndexerPanel() {
        this.initComponents();
        this.valueField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                IndexerPanel.this.textIsDirty = true;
                IndexerPanel.this.updatePopup();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                IndexerPanel.this.textIsDirty = true;
                IndexerPanel.this.updatePopup();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                IndexerPanel.this.textIsDirty = true;
                IndexerPanel.this.updatePopup();
            }
        });
        this.valueField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (IndexerPanel.this.canShowPopupOnFocusGained && IndexerPanel.this.textIsDirty) {
                    IndexerPanel.this.updatePopup();
                } else {
                    IndexerPanel.this.valueField.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() != IndexerPanel.this.popupList) {
                    IndexerPanel.this.hidePopup();
                }
                if (IndexerPanel.this.textIsDirty && IndexerPanel.this.value == null) {
                    IndexerPanel.this.setInvalidText(true);
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent e) {
                IndexerPanel.this.removePopup();
            }
        });
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        this.setValueAction = new AbstractAction("setValue"){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (IndexerPanel.this.popupList == null || !IndexerPanel.this.popupList.isShowing()) {
                    if (IndexerPanel.this.getValue() != null) {
                        IndexerPanel.this.fireActionPerformed();
                    }
                    return;
                }
                int selectedIndex = IndexerPanel.this.popupList.getSelectedIndex();
                IndexerPanel.this.setValueFromListIndex(selectedIndex);
            }
        };
        this.valueField.getInputMap().put(enterKey, "setValue");
        this.valueField.getActionMap().put("setValue", this.setValueAction);
        this.valueField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (IndexerPanel.this.popupList == null || !IndexerPanel.this.popupList.isShowing()) {
                    return;
                }
                if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38) {
                    keyEvent.setSource(IndexerPanel.this.popupList);
                    IndexerPanel.this.popupList.dispatchEvent(keyEvent);
                    keyEvent.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                this.keyPressed(keyEvent);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                this.keyPressed(keyEvent);
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap(1).put(escape, "hide");
        this.getActionMap().put("hide", this.hideAction);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.valueField.setEditable(enabled);
        this.valueField.setEnabled(enabled);
        if (!enabled) {
            this.hidePopup();
        }
    }

    public boolean getSupportsNewValues() {
        return this.supportsNewValues;
    }

    public void setSupportsNewValues(boolean supportsNewValues) {
        this.supportsNewValues = supportsNewValues;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public boolean isPopupVisible() {
        return this.scroller != null && this.scroller.isVisible();
    }

    private void fireActionPerformed() {
        ActionEvent event = new ActionEvent(this, 1001, null);
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(event);
        }
    }

    public String getTextValue() {
        return this.valueField.getText();
    }

    public void setTextValue(String text) {
        this.valueField.setText(text);
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.internalSetValue(value);
        this.dontUpdatePopup = true;
        String text = null;
        for (IndexerGroup indexerGroup : this.indexerGroups) {
            text = indexerGroup.toString.getString(value);
            if (text == null) continue;
            break;
        }
        this.valueField.setText(text);
        this.valueField.select(0, 0);
        this.dontUpdatePopup = false;
        this.textIsDirty = false;
        this.setInvalidText(false);
    }

    public T getSelectedValue() {
        return this.selectedValue;
    }

    private void internalSetValue(T value) {
        T oldValue = this.value;
        this.value = value;
        if (!Objects.equal(oldValue, value)) {
            this.firePropertyChange("value", oldValue, value);
        }
    }

    public void clearValue() {
        this.internalSetValue(null);
        this.valueField.setText("");
        this.textIsDirty = false;
    }

    public int getColumns() {
        return this.valueField.getColumns();
    }

    public void setColumns(int columns) {
        this.valueField.setColumns(columns);
    }

    private void hidePopup() {
        if (this.scroller != null) {
            this.scroller.setVisible(false);
            this.setSelectedValue(null);
            this.firePropertyChange("popupVisible", true, false);
        }
    }

    private void removePopup() {
        if (this.scroller != null) {
            JRootPane rootPane = SwingUtilities.getRootPane(this.scroller);
            Rectangle bounds = SwingUtilities.convertRectangle(this.scroller, this.scroller.getBounds(), rootPane);
            this.scroller.getParent().remove(this.scroller);
            this.scroller = null;
            this.popupList = null;
            rootPane.repaint(bounds);
        }
    }

    private void updatePopup() {
        if (this.dontUpdatePopup) {
            return;
        }
        if (!this.isShowing()) {
            return;
        }
        String valueFromField = this.valueField.getText();
        if (valueFromField == null) {
            return;
        }
        valueFromField = valueFromField.trim();
        LinkedHashSet foundMatches = Sets.newLinkedHashSet();
        Predicate alternateNotFoundYet = input -> !foundMatches.contains(input.getObject());
        for (IndexerGroup indexerGroup : this.indexerGroups) {
            indexerGroup.matches = null;
            indexerGroup.alternateMatches = null;
        }
        for (IndexerGroup indexerGroup : this.indexerGroups) {
            if (indexerGroup.indexer != null) {
                Collection found = this.filter(indexerGroup.indexer.find(valueFromField));
                if (this.sortOrderSupplier != null) {
                    found = this.sortOrderSupplier.get().sortedCopy(found);
                }
                found.removeAll(foundMatches);
                indexerGroup.matches = found;
                foundMatches.addAll(found);
            } else {
                Preconditions.checkState(indexerGroup.alternateIndexer != null);
                List alternateFound = this.filterAlternateNames(indexerGroup.alternateIndexer.find(valueFromField));
                alternateFound = this.alternateSortOrderSupplier != null ? this.alternateSortOrderSupplier.get().sortedCopy(Iterables.filter(alternateFound, alternateNotFoundYet)) : ImmutableList.copyOf(Iterables.filter(alternateFound, alternateNotFoundYet));
                indexerGroup.alternateMatches = alternateFound;
                for (AlternateName alternateMatch : alternateFound) {
                    foundMatches.add(alternateMatch.getObject());
                }
            }
            if (foundMatches.size() <= 5) continue;
            break;
        }
        if (foundMatches.size() == 1 && Objects.equal(this.value, foundMatches.iterator().next()) && !this.isPopupVisible()) {
            return;
        }
        LinkedHashSet<Object> results = new LinkedHashSet<Object>();
        if (this.mixer != null) {
            boolean mixedYet = false;
            for (IndexerGroup indexerGroup : this.indexerGroups) {
                if (indexerGroup.indexer != null) {
                    if (indexerGroup.matches == null) continue;
                    if (!mixedYet && !indexerGroup.matches.isEmpty()) {
                        List<T> mixed = this.mixer.mix(ImmutableList.copyOf(indexerGroup.matches));
                        indexerGroup.matches = mixed;
                    }
                    indexerGroup.matches = this.addToResults(results, indexerGroup.matches);
                    if (mixedYet || indexerGroup.matches.isEmpty()) continue;
                    mixedYet = true;
                    continue;
                }
                if (indexerGroup.alternateMatches == null) continue;
                indexerGroup.alternateMatches = this.addToResults(results, indexerGroup.alternateMatches);
            }
        } else {
            for (IndexerGroup indexerGroup : this.indexerGroups) {
                if (indexerGroup.indexer != null) {
                    if (indexerGroup.matches == null) continue;
                    indexerGroup.matches = this.addToResults(results, indexerGroup.matches);
                    continue;
                }
                if (indexerGroup.alternateMatches == null) continue;
                indexerGroup.alternateMatches = this.addToResults(results, indexerGroup.alternateMatches);
            }
        }
        ListListModel resultsModel = new ListListModel(new ArrayList(results));
        if (this.popupList == null) {
            this.createPopup();
        }
        this.popupList.setVisibleRowCount(Math.min(10, resultsModel.getSize()));
        this.popupList.setModel(resultsModel);
        if (resultsModel.getSize() == 0) {
            this.scroller.setVisible(false);
            this.internalSetValue(null);
            this.firePropertyChange("popupVisible", true, false);
            this.setInvalidText(!valueFromField.isEmpty());
        } else {
            this.setInvalidText(false);
            this.popupList.setSelectedIndex(0);
            this.popupList.scrollRectToVisible(this.popupList.getCellBounds(0, 0));
            this.showPopup();
        }
    }

    private Collection<AlternateName<T>> filterAlternateNames(Collection<AlternateName<T>> found) {
        if (this.filter == null) {
            return found;
        }
        return found.stream().filter((? super T alternate) -> this.filter.apply(alternate.getObject())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Collection<T> filter(Collection<T> found) {
        if (this.filter == null) {
            return found;
        }
        return found.stream().filter(this.filter).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private <U> Collection<U> addToResults(Collection<Object> results, Collection<U> source) {
        ArrayList<U> outResults = Lists.newArrayListWithExpectedSize(source.size());
        for (U sourceElement : source) {
            if (!results.add(sourceElement)) continue;
            outResults.add(sourceElement);
        }
        return outResults;
    }

    private void setInvalidText(boolean invalid) {
        if (this.supportsNewValues) {
            return;
        }
        if (invalid) {
            this.valueField.setForeground(RequiredLabel.getRequiredColor());
        } else {
            this.valueField.setForeground(this.defaultTextForeground);
        }
    }

    private void showPopup() {
        this.layoutPopup();
        this.scroller.setVisible(true);
        this.firePropertyChange("popupVisible", false, true);
    }

    private void layoutPopup() {
        JLayeredPane layered = this.getRootPane().getLayeredPane();
        Rectangle fieldBounds = SwingUtilities.convertRectangle(this, this.valueField.getBounds(), layered);
        Dimension size = this.scroller.getPreferredSize();
        this.scroller.setSize(Math.max(size.width, this.valueField.getWidth()), Math.min(size.height, this.getPopupHeight()));
        switch (this.getLayoutStrategy()) {
            case BELOW: {
                this.scroller.setLocation(fieldBounds.x, fieldBounds.y + fieldBounds.height);
                break;
            }
            case RIGHT: {
                this.scroller.setLocation(fieldBounds.x + fieldBounds.width, fieldBounds.y);
            }
        }
    }

    private void createPopup() {
        this.popupList = new JList();
        this.popupList.setFont(this.valueField.getFont());
        this.popupList.setSelectionMode(0);
        this.popupList.setCellRenderer(new ToStringListCellRenderer());
        this.popupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                Object castValue = IndexerPanel.this.listValueFromEntry(IndexerPanel.this.popupList.getSelectedValue());
                IndexerPanel.this.setSelectedValue(castValue);
            }
        });
        this.popupList.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() != IndexerPanel.this.valueField) {
                    IndexerPanel.this.hidePopup();
                }
            }
        });
        this.popupList.addMouseListener(new DoubleClickListener(){

            @Override
            protected void doubleClicked(MouseEvent event) {
                int index = IndexerPanel.this.popupList.locationToIndex(event.getPoint());
                IndexerPanel.this.setValueFromListIndex(index);
            }
        });
        JLayeredPane layered = this.getRootPane().getLayeredPane();
        this.scroller = new JScrollPane();
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.setViewportView(this.popupList);
        layered.add((Component)this.scroller, JLayeredPane.POPUP_LAYER);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.popupList.getInputMap(1).put(escape, "hide");
        this.popupList.getActionMap().put("hide", this.hideAction);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.popupList.getInputMap(1).put(enter, "setValue");
        this.popupList.getActionMap().put("setValue", this.setValueAction);
    }

    private void setSelectedValue(T newSelectedValue) {
        T oldSelectedValue = this.selectedValue;
        this.selectedValue = newSelectedValue;
        this.firePropertyChange("selectedValue", oldSelectedValue, newSelectedValue);
    }

    public void addIndexerGroup(ToString<T> toString, Indexer<T> indexer) {
        IndexerGroup indexerGroup = new IndexerGroup();
        indexerGroup.toString = toString;
        indexerGroup.indexer = indexer;
        this.indexerGroups.add(indexerGroup);
    }

    public void addAlternateIndexerGroup(ToString<T> toString, Indexer<AlternateName<T>> indexer) {
        IndexerGroup indexerGroup = new IndexerGroup();
        indexerGroup.toString = toString;
        indexerGroup.alternateIndexer = indexer;
        this.indexerGroups.add(indexerGroup);
    }

    public LayoutStrategy getLayoutStrategy() {
        return this.layout;
    }

    public void setLayoutStrategy(LayoutStrategy layout) {
        this.layout = layout;
    }

    public void setOrdering(Supplier<Ordering<T>> sortOrderSupplier) {
        this.sortOrderSupplier = sortOrderSupplier;
        this.alternateSortOrderSupplier = sortOrderSupplier == null ? null : new AlternateSortOrderSupplier(sortOrderSupplier);
    }

    public Supplier<Ordering<T>> getOrdering() {
        return this.sortOrderSupplier;
    }

    public Predicate<T> getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate<T> filter) {
        this.filter = filter;
    }

    private void initComponents() {
        this.valueField = new JTextField();
        this.valueField.setColumns(20);
        this.valueField.putClientProperty("JTextField.leadingIcon", new FlatSearchIcon());
        this.defaultTextForeground = UIManager.getColor("TextField.foreground");
        this.add(this.valueField);
        GroupLayout layout = new GroupLayout(this);
        this.add(this.valueField);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.valueField, -1, -2, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.valueField, -1, -2, -2));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.defaultTextForeground = UIManager.getColor("TextField.foreground");
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.valueField.requestFocusInWindow();
    }

    public short getPopupHeight() {
        return this.popupHeight;
    }

    public void setPopupHeight(short popupHeight) {
        this.popupHeight = popupHeight;
    }

    public void setPreviewText(Messages.Name name) {
        this.valueField.putClientProperty("JTextField.placeholderText", Messages.getMessage(name));
    }

    @Deprecated
    public void setPreviewText(String previewText) {
        this.valueField.putClientProperty("JTextField.placeholderText", previewText);
    }

    public String getPreviewText() {
        return (String)this.valueField.getClientProperty("JTextField.placeholderText");
    }

    public JTextComponent getTextComponent() {
        return this.valueField;
    }

    private void setValueFromListIndex(int selectedIndex) {
        if (selectedIndex >= 0) {
            T newValue = this.listValueFromEntry(this.popupList.getModel().getElementAt(selectedIndex));
            this.setValue(newValue);
            this.valueField.selectAll();
        } else {
            this.setValue(null);
            this.valueField.setText("");
        }
        this.hidePopup();
    }

    private T listValueFromEntry(Object value) {
        Object castValue = value instanceof AlternateName ? ((AlternateName)value).getObject() : value;
        return (T)castValue;
    }

    public void setEditable(boolean editable) {
        this.valueField.setEditable(editable);
    }

    public boolean getCanShowPopupOnFocusGained() {
        return this.canShowPopupOnFocusGained;
    }

    public void setCanShowPopupOnFocusGained(boolean canShowPopupOnFocusGained) {
        this.canShowPopupOnFocusGained = canShowPopupOnFocusGained;
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        if (this.scroller != null && this.scroller.isVisible()) {
            this.popupList.setFont(fontManager.getTextFont());
            SwingUtilities.invokeLater(this::layoutPopup);
        } else {
            this.removePopup();
        }
    }

    public Mixer<T> getMixer() {
        return this.mixer;
    }

    public void setMixer(Mixer<T> mixer) {
        this.mixer = mixer;
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.valueField.getBaseline(width, height);
    }

    public void removeAllIndexerGroups() {
        this.indexerGroups.clear();
    }

    public static enum LayoutStrategy {
        BELOW,
        RIGHT;

    }

    private class IndexerGroup {
        ToString<T> toString;
        Indexer<T> indexer;
        Collection<T> matches;
        Indexer<AlternateName<T>> alternateIndexer;
        Collection<AlternateName<T>> alternateMatches;

        private IndexerGroup() {
        }
    }

    public static interface Mixer<T> {
        public List<T> mix(List<T> var1);
    }

    private class ToStringListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private ToStringListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object cellValue, int index, boolean isSelected, boolean cellHasFocus) {
            int sizeSoFar = 0;
            for (IndexerGroup indexerGroup : IndexerPanel.this.indexerGroups) {
                int groupSize;
                int n = indexerGroup.matches != null ? (indexerGroup.matches == null ? 0 : indexerGroup.matches.size()) : (groupSize = indexerGroup.alternateMatches == null ? 0 : indexerGroup.alternateMatches.size());
                if (index < sizeSoFar + groupSize) {
                    if (indexerGroup.indexer != null) {
                        Object castValue = cellValue;
                        cellValue = indexerGroup.toString.getPreviewString(castValue);
                        break;
                    }
                    AlternateName castValue = (AlternateName)cellValue;
                    cellValue = String.format("%s (%s)", indexerGroup.toString.getPreviewString(castValue.getObject()), castValue.getName());
                    break;
                }
                sizeSoFar += groupSize;
            }
            return super.getListCellRendererComponent(list, cellValue, index, isSelected, cellHasFocus);
        }
    }

    static class AlternateSortOrderSupplier<T>
    implements Supplier<Ordering<AlternateName<T>>> {
        private final Supplier<Ordering<T>> supplier;

        AlternateSortOrderSupplier(Supplier<Ordering<T>> supplier) {
            this.supplier = supplier;
        }

        @Override
        public Ordering<AlternateName<T>> get() {
            final Ordering<T> ordering = this.supplier.get();
            return new Ordering<AlternateName<T>>(){

                @Override
                public int compare(@Nullable AlternateName<T> left, @Nullable AlternateName<T> right) {
                    Object leftValue = left == null ? null : (Object)left.getObject();
                    Object rightValue = right == null ? null : (Object)right.getObject();
                    return ordering.compare(leftValue, rightValue);
                }
            };
        }
    }
}

