/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Strings;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.html.HTMLEditorKit;

public class HtmlResultPanel
extends JPanel {
    private JEditorPane editor;
    private JScrollPane scrollPane;
    private String plainText;
    private String documentName;
    private Map<DataFlavor, String> additionalFormats = new LinkedHashMap<DataFlavor, String>();

    public HtmlResultPanel(Messages.Name message, String html, FontManager fontManager) {
        this.editor = new JEditorPane();
        this.editor.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        HTMLEditorKit kit = new HTMLEditorKit();
        this.editor.setEditorKit(kit);
        this.editor.setDocument(kit.createDefaultDocument());
        this.editor.setText(html);
        this.editor.setEditable(false);
        this.scrollPane = new JScrollPane(this.editor);
        JLabel label = new JLabel("<html>" + Messages.getMessage(message));
        label.putClientProperty("birdlist.plainLabel", true);
        GroupLayout layout = new GroupLayout(this);
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scrollPane, -2, fontManager.scale(500), Short.MAX_VALUE));
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label).addComponent(this.scrollPane, -2, fontManager.scale(600), Short.MAX_VALUE));
        this.setLayout(layout);
        fontManager.applyTo(this);
    }

    public Action printAction() {
        if (!this.printIsAvailable()) {
            return null;
        }
        return new AbstractAction(Messages.getMessage(Messages.Name.PRINT_MENU)){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlResultPanel.this.print();
            }
        };
    }

    public void setDocumentName(String name) {
        this.documentName = name;
    }

    private boolean printIsAvailable() {
        return false;
    }

    private void print() {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            if (!Strings.isNullOrEmpty(this.documentName)) {
                printerJob.setJobName(this.documentName);
            }
            if (printerJob.printDialog(new HashPrintRequestAttributeSet(DialogTypeSelection.NATIVE))) {
                printerJob.setPrintable(this.editor.getPrintable(null, new MessageFormat("{0,number,integer}")));
                printerJob.print();
            }
        }
        catch (PrinterException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPlainText(String plainText) {
        this.plainText = plainText;
    }

    public void copyToClipboard() {
        this.editor.selectAll();
        HtmlAndPlainTextTransferable t = new HtmlAndPlainTextTransferable();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(t, null);
        this.editor.setCaretPosition(0);
    }

    public void selectAllWhenVisible() {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                HtmlResultPanel.this.editor.selectAll();
                HtmlResultPanel.this.scrollPane.scrollRectToVisible(new Rectangle());
                HtmlResultPanel.this.editor.setCaretPosition(0);
            }
        });
    }

    public void addAdditionalFormat(DataFlavor dataFlavor, String text) {
        this.additionalFormats.put(dataFlavor, text);
    }

    class HtmlAndPlainTextTransferable
    implements Transferable {
        HtmlAndPlainTextTransferable() {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>();
            flavors.add(DataFlavor.allHtmlFlavor);
            if (HtmlResultPanel.this.plainText != null) {
                flavors.add(DataFlavor.stringFlavor);
            }
            flavors.addAll(HtmlResultPanel.this.additionalFormats.keySet());
            return flavors.toArray(new DataFlavor[flavors.size()]);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (flavor.equals(DataFlavor.allHtmlFlavor)) {
                return true;
            }
            if (HtmlResultPanel.this.plainText != null && flavor.equals(DataFlavor.stringFlavor)) {
                return true;
            }
            return HtmlResultPanel.this.additionalFormats.containsKey(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.allHtmlFlavor)) {
                return HtmlResultPanel.this.editor.getText();
            }
            if (flavor.equals(DataFlavor.stringFlavor) && HtmlResultPanel.this.plainText != null) {
                return HtmlResultPanel.this.plainText;
            }
            if (HtmlResultPanel.this.additionalFormats.containsKey(flavor)) {
                return HtmlResultPanel.this.additionalFormats.get(flavor);
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

