/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.components.SpeciesTablePanel;
import com.scythebill.birdlist.ui.components.table.DeleteColumn;
import com.scythebill.birdlist.ui.components.table.ExpandableTable;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.ListListModel;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class DirectSpeciesTablePanel
extends SpeciesTablePanel {
    private ListListModel<SightingTaxon.Resolved> speciesListModel;
    private AbstractAction deleteAction;

    public DirectSpeciesTablePanel(ExpandableTable.DetailView<SightingTaxon.Resolved> expandedRowView, String detailTitle, FontManager fontManager) {
        super(expandedRowView, detailTitle, fontManager);
        this.init();
        this.hookUpContents();
    }

    private void hookUpContents() {
        this.deleteAction = new AbstractAction(Messages.getMessage(Messages.Name.DELETE_ACTION)){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!DirectSpeciesTablePanel.this.isEditable()) {
                    return;
                }
                SightingTaxon.Resolved resolved = DirectSpeciesTablePanel.this.getSelectedSpecies();
                if (resolved != null) {
                    DirectSpeciesTablePanel.this.removeSpecies(resolved);
                    DirectSpeciesTablePanel.this.notifyUserModifiedValue();
                }
            }
        };
        this.deleteAction.setEnabled(false);
        this.addPropertyChangeListener("selectedValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SightingTaxon.Resolved resolved = DirectSpeciesTablePanel.this.getSelectedSpecies();
                DirectSpeciesTablePanel.this.deleteAction.setEnabled(resolved != null);
            }
        });
        KeyStroke deleteKey = KeyStroke.getKeyStroke(127, 0);
        this.getSpeciesTable().getInputMap().put(deleteKey, "delete");
        this.getSpeciesTable().getActionMap().put("delete", this.deleteAction);
    }

    public Action getDeleteAction() {
        return this.deleteAction;
    }

    @Override
    public void addSpecies(SightingTaxon.Resolved resolved) {
        Preconditions.checkNotNull(resolved);
        TaxonUtils.sortedInsert(this.speciesListModel.asList(), resolved);
        this.fireValueChanged();
    }

    @Override
    public void removeSpecies(SightingTaxon.Resolved taxon) {
        Preconditions.checkNotNull(taxon);
        this.speciesListModel.asList().remove(taxon);
        this.fireValueChanged();
    }

    @Override
    public void swapSpecies(SightingTaxon.Resolved currentTaxon, SightingTaxon.Resolved newTaxon) {
        this.removeSpecies(currentTaxon);
        this.addSpecies(newTaxon);
    }

    @Override
    public void setSortedContents(Taxonomy taxonomy, List<SightingTaxon.Resolved> taxa) {
        Preconditions.checkNotNull(taxa);
        this.speciesListModel.asList().clear();
        this.speciesListModel.asList().addAll(taxa);
        this.fireValueChanged();
    }

    @Override
    public ImmutableList<SightingTaxon.Resolved> getValue() {
        return ImmutableList.copyOf(this.speciesListModel.asList());
    }

    @Override
    protected ListListModel<SightingTaxon.Resolved> getListModel() {
        if (this.speciesListModel == null) {
            this.speciesListModel = new ListListModel();
        }
        return this.speciesListModel;
    }

    public void addDeleteColumn() {
        this.addColumn((ExpandableTable.Column<SightingTaxon.Resolved>)new DeleteColumn<SightingTaxon.Resolved>(ExpandableTable.ColumnLayout.fixedWidth(20), this.getSpeciesTable()){

            @Override
            protected void deleteRow(int index) {
                DirectSpeciesTablePanel.this.speciesListModel.asList().remove(index);
                DirectSpeciesTablePanel.this.fireValueChanged();
                DirectSpeciesTablePanel.this.notifyUserModifiedValue();
            }

            @Override
            public String getName() {
                return "";
            }
        });
    }
}

