/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class DepthChooser
extends JComboBox<String> {
    private Taxon.Type depth = Taxon.Type.species;

    public DepthChooser() {
        this.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getMessage(Messages.Name.SPECIES_ONLY), Messages.getMessage(Messages.Name.EBIRD_GROUPS), Messages.getMessage(Messages.Name.SUBSPECIES_SHOWN)}));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Taxon.Type depth = switch (DepthChooser.this.getSelectedIndex()) {
                    case 0 -> Taxon.Type.species;
                    case 1 -> Taxon.Type.group;
                    case 2 -> Taxon.Type.subspecies;
                    default -> throw new IllegalArgumentException();
                };
                Taxon.Type oldDepth = DepthChooser.this.depth;
                DepthChooser.this.depth = depth;
                DepthChooser.this.firePropertyChange("depth", (Object)oldDepth, (Object)depth);
            }
        });
    }

    public Taxon.Type getDepth() {
        return this.depth;
    }

    public void setDepth(Taxon.Type depth) {
        switch (depth) {
            case species: {
                this.setSelectedIndex(0);
                break;
            }
            case group: {
                this.setSelectedIndex(1);
                break;
            }
            case subspecies: {
                this.setSelectedIndex(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + depth);
            }
        }
        this.depth = depth;
    }
}

