/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.components.YearFormatter;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.NumberFormatter;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;

public class DatePanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private JFormattedTextField dayField;
    private JFormattedTextField yearField;
    private JComboBox<String> monthField;
    private final Chronology chrono = GJChronology.getInstance();
    private ReadablePartial value;
    private NumberFormatter dayFormatter;
    private Timer timer;
    private boolean dontUpdateValue;

    public DatePanel() {
        this.initGUI();
    }

    public ReadablePartial getValue() {
        return this.value;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.dayField != null) {
            this.dayField.setFont(font);
            this.monthField.setFont(font);
            this.yearField.setFont(font);
        }
    }

    public void setValue(ReadablePartial newValue) {
        this.dontUpdateValue = true;
        if (newValue != null && newValue.size() == 0) {
            newValue = null;
        }
        if (newValue == null) {
            this.yearField.setText("");
            this.monthField.setSelectedIndex(0);
            this.dayField.setText("");
        } else {
            if (newValue.isSupported(DateTimeFieldType.year())) {
                int year = newValue.get(DateTimeFieldType.year());
                this.yearField.setValue(year);
            } else {
                this.yearField.setText("");
            }
            if (newValue.isSupported(DateTimeFieldType.monthOfYear())) {
                int month = newValue.get(DateTimeFieldType.monthOfYear());
                this.monthField.setSelectedIndex(month);
            } else {
                this.monthField.setSelectedIndex(0);
            }
            if (newValue.isSupported(DateTimeFieldType.dayOfMonth())) {
                int day = newValue.get(DateTimeFieldType.dayOfMonth());
                this.dayField.setValue(day);
            } else {
                this.dayField.setText("");
            }
        }
        this.dontUpdateValue = false;
        this.updateValue(newValue);
    }

    private void initGUI() {
        this.dayFormatter = new NumberFormatter(new DecimalFormat("##")){

            @Override
            public Object stringToValue(String text) throws ParseException {
                if (Strings.isNullOrEmpty(text)) {
                    return null;
                }
                return super.stringToValue(text);
            }
        };
        this.dayFormatter.setValueClass(Integer.class);
        this.dayFormatter.setMinimum(Integer.valueOf(1));
        this.dayFormatter.setMaximum(Integer.valueOf(31));
        this.dayField = new AutoSelectJFormattedTextField(this.dayFormatter);
        YearOrDayChanged dayListener = new YearOrDayChanged(this.dayField);
        this.dayField.addPropertyChangeListener("value", dayListener);
        this.dayField.getDocument().addDocumentListener(dayListener);
        this.dayField.setCaret(new DefaultCaret());
        this.attachAquaCaret(this.dayField);
        DefaultComboBoxModel<String> monthFieldModel = new DefaultComboBoxModel<String>(DatePanel.getMonthNames().toArray(new String[0]));
        this.monthField = new JComboBox();
        this.monthField.setModel(monthFieldModel);
        this.monthField.setMaximumRowCount(monthFieldModel.getSize());
        this.monthField.addActionListener(new MonthChanged());
        this.monthField.setEditable(false);
        this.yearField = new AutoSelectJFormattedTextField(new YearFormatter());
        YearOrDayChanged yearListener = new YearOrDayChanged(this.yearField);
        this.yearField.addPropertyChangeListener("value", yearListener);
        this.yearField.getDocument().addDocumentListener(yearListener);
        this.attachAquaCaret(this.yearField);
        this.dayField.putClientProperty("JTextField.placeholderText", Messages.getMessage(Messages.Name.DAY_PROMPT));
        this.yearField.putClientProperty("JTextField.placeholderText", Messages.getMessage(Messages.Name.YEAR_PROMPT));
    }

    private static final List<String> getMonthNames() {
        ArrayList<String> months = Lists.newArrayList();
        months.add("");
        GJChronology chrono = GJChronology.getInstance();
        DateTimeField monthField = chrono.monthOfYear();
        for (int month = monthField.getMinimumValue(); month <= monthField.getMaximumValue(); ++month) {
            months.add(monthField.getAsShortText(month, (Locale)null));
        }
        return months;
    }

    private void startTimerToCalculateNewValue(final JFormattedTextField field) {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    field.commitEdit();
                    DatePanel.this.calculateNewValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        this.timer.setRepeats(false);
        this.timer.start();
    }

    private void calculateNewValue() {
        int month;
        Partial newValue = new Partial(this.chrono);
        if (!Strings.isNullOrEmpty(this.yearField.getText())) {
            int year = (Integer)this.yearField.getValue();
            newValue = newValue.with(DateTimeFieldType.year(), year);
        }
        if ((month = this.monthField.getSelectedIndex()) > 0) {
            newValue = newValue.with(DateTimeFieldType.monthOfYear(), month);
        }
        int maxDay = this.chrono.dayOfMonth().getMaximumValue(newValue);
        this.dayFormatter.setMaximum(Integer.valueOf(maxDay));
        if (!Strings.isNullOrEmpty(this.dayField.getText())) {
            int day = (Integer)this.dayField.getValue();
            if (day > maxDay) {
                day = maxDay;
                this.dayField.setValue(day);
            }
            newValue = newValue.with(DateTimeFieldType.dayOfMonth(), day);
        }
        if (newValue.size() == 0) {
            newValue = null;
        }
        if (!this.dontUpdateValue) {
            this.updateValue(newValue);
        }
    }

    private void updateValue(ReadablePartial newValue) {
        ReadablePartial oldValue = this.value;
        this.value = newValue;
        if (!Objects.equal(oldValue, newValue)) {
            this.firePropertyChange("value", oldValue, newValue);
        }
    }

    private void attachAquaCaret(JFormattedTextField field) {
        JTextField tempField = new JTextField();
        field.setCaret(tempField.getCaret());
    }

    public void setEditable(boolean editable) {
        this.dayField.setEditable(editable);
        this.monthField.setEnabled(editable);
        this.yearField.setEditable(editable);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setVerticalGroup(layout.createBaselineGroup(false, false).addComponent(this.monthField, -2, -2, -2).addComponent(this.dayField, -2, -2, -2).addComponent(this.yearField, -2, -2, -2));
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.dayField, -2, fontManager.scale(55), -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.monthField, -2, fontManager.scale(84), -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearField, -2, fontManager.scale(70), -2));
        layout.linkSize(1, this.dayField, this.yearField, this.monthField);
    }

    private class YearOrDayChanged
    implements PropertyChangeListener,
    DocumentListener {
        private JFormattedTextField field;

        public YearOrDayChanged(JFormattedTextField field) {
            this.field = field;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DatePanel.this.calculateNewValue();
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            DatePanel.this.startTimerToCalculateNewValue(this.field);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            DatePanel.this.startTimerToCalculateNewValue(this.field);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            DatePanel.this.startTimerToCalculateNewValue(this.field);
        }
    }

    private class MonthChanged
    implements ActionListener {
        private MonthChanged() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DatePanel.this.calculateNewValue();
        }
    }
}

