/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.google.common.base.Preconditions;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.TextLink;
import com.scythebill.birdlist.ui.components.table.DeleteColumn;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.fonts.FontPreferences;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Icons;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import org.apache.commons.lang3.StringUtils;

public class ChipsTextPanel<T>
extends JPanel
implements FontManager.FontsUpdatedListener {
    private final Set<T> chips;
    private final Function<T, String> toString;
    private final FontManager fontManager;
    private int scaledWidth = 80;
    private Icon toggleOffIcon;
    private Icon toggleOnIcon;
    private Predicate<T> toggleOnPredicate;
    private Messages.Name offTooltipFormat;
    private Messages.Name onTooltipFormat;
    private boolean editable;
    private Icon dragIcon;
    private static final Icon EDIT_ICON = new ImageIcon(ChipsTextPanel.class.getResource("/com/scythebill/birdlist/ui/icons/pencil.png"));
    private Function<T, Transferable> dragTransferableFunction;

    public static void main(String[] args) {
        FlatMacDarkLaf.setup();
        IndexerPanel<String> indexerPanel = new IndexerPanel<String>();
        indexerPanel.setPreviewText("Enter a name");
        Indexer<String> indexer = new Indexer<String>();
        indexer.add("Adam Winer", "Adam Winer");
        indexer.add("Howard Winer", "Howard Winer");
        indexerPanel.addIndexerGroup(new ToString<String>(){}, indexer);
        FontManager fontManager = new FontManager(new FontPreferences());
        ChipsTextPanel<String> chipsTextPanel = new ChipsTextPanel<String>(s -> s, fontManager);
        chipsTextPanel.addChipEditedListener(new ChipEditedListener<String>(){

            @Override
            public void chipEdited(String chip, String newText) {
                System.err.printf("Chip %s is now %s\n", chip, newText);
            }
        });
        chipsTextPanel.addDragFeature(EDIT_ICON, s -> new StringSelection((String)s));
        JScrollPane scrollPane = new JScrollPane(chipsTextPanel, 20, 31);
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 3));
        Box indexerAndButton = Box.createHorizontalBox();
        JButton addButton = new JButton("Add");
        indexerPanel.addPropertyChangeListener("value", e -> addButton.setEnabled(indexerPanel.getValue() != null));
        addButton.addActionListener(e -> chipsTextPanel.addChip((String)indexerPanel.getValue()));
        indexerAndButton.add(indexerPanel);
        indexerAndButton.add(addButton);
        frame.getContentPane().add(indexerAndButton);
        frame.getContentPane().add(scrollPane);
        fontManager.applyTo(frame);
        frame.pack();
        frame.setVisible(true);
    }

    public ChipsTextPanel(Function<T, String> toStringFunc, FontManager fontManager) {
        this(toStringFunc, null, fontManager);
    }

    public ChipsTextPanel(Function<T, String> toStringFunc, Comparator<? super T> comparator, FontManager fontManager) {
        this.toString = toStringFunc;
        this.fontManager = fontManager;
        this.chips = comparator == null ? new LinkedHashSet() : new TreeSet<T>(comparator);
        this.resetContent();
    }

    public void addDragFeature(Icon dragIcon, Function<T, Transferable> dragTransferableFunction) {
        this.dragIcon = dragIcon;
        this.dragTransferableFunction = dragTransferableFunction;
    }

    public void addToggleFeature(Icon offIcon, Icon onIcon, Predicate<T> onPredicate, Messages.Name offTooltipFormat, Messages.Name onTooltipFormat) {
        this.toggleOffIcon = Preconditions.checkNotNull(offIcon);
        this.toggleOnIcon = Preconditions.checkNotNull(onIcon);
        this.toggleOnPredicate = Preconditions.checkNotNull(onPredicate);
        this.offTooltipFormat = offTooltipFormat;
        this.onTooltipFormat = onTooltipFormat;
    }

    public void makeEditable() {
        this.editable = true;
        this.resetContent();
    }

    public void addChip(T chipValue) {
        if (this.chips.add(chipValue)) {
            this.resetContent();
            for (ChipsChangedListener listener : (ChipsChangedListener[])this.getListeners(ChipsChangedListener.class)) {
                listener.chipsChanged();
            }
        }
    }

    public void addAllChips(Collection<T> chips) {
        if (this.chips.addAll(chips)) {
            this.resetContent();
            for (ChipsChangedListener listener : (ChipsChangedListener[])this.getListeners(ChipsChangedListener.class)) {
                listener.chipsChanged();
            }
        }
    }

    public void removeChip(T chipValue) {
        if (this.chips.remove(chipValue)) {
            this.resetContent();
            for (ChipsChangedListener listener : (ChipsChangedListener[])this.getListeners(ChipsChangedListener.class)) {
                listener.chipsChanged();
            }
        }
    }

    public void setScaledWidth(int scaledWidth) {
        this.scaledWidth = scaledWidth;
    }

    public void clear() {
        if (!this.chips.isEmpty()) {
            this.chips.clear();
            this.resetContent();
            for (ChipsChangedListener listener : (ChipsChangedListener[])this.getListeners(ChipsChangedListener.class)) {
                listener.chipsChanged();
            }
        }
    }

    public void addChipsChangedListener(ChipsChangedListener listener) {
        this.listenerList.add(ChipsChangedListener.class, listener);
    }

    public void addChipToggledListener(ChipToggledListener<T> listener) {
        this.listenerList.add(ChipToggledListener.class, listener);
    }

    public void addChipEditedListener(ChipEditedListener<T> listener) {
        this.listenerList.add(ChipEditedListener.class, listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.resetContent();
    }

    private boolean dragFeatureEnabled() {
        return this.dragIcon != null;
    }

    private boolean toggleFeatureEnabled() {
        return this.toggleOnIcon != null;
    }

    private void resetContent() {
        Icon editIcon = null;
        if (this.editable) {
            editIcon = Icons.getWhiteIconIfDark(this, EDIT_ICON);
        }
        this.removeAll();
        for (T chip : this.chips) {
            JPanel box = new JPanel();
            box.setLayout(new BoxLayout(box, 0));
            box.putClientProperty("FlatLaf.style", "border: 1,1,1,1,@disabledForeground,1,16;");
            box.add(Box.createHorizontalStrut(5));
            if (this.isEnabled() && this.dragFeatureEnabled()) {
                final JLabel label = new JLabel(this.dragIcon);
                label.setTransferHandler(new ChipTransferHandler(chip));
                label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        label.getTransferHandler().exportAsDrag(label, e, 1);
                    }
                });
                box.add(label);
            }
            String chipText = this.toString.apply(chip);
            if (this.isEnabled() && this.toggleFeatureEnabled()) {
                TextLink textLink = new TextLink("");
                boolean on = this.toggleOnPredicate.test(chip);
                textLink.setIcon(on ? this.toggleOnIcon : this.toggleOffIcon);
                textLink.setToolTipText(Messages.getFormattedMessage(on ? this.onTooltipFormat : this.offTooltipFormat, chipText));
                textLink.addActionListener(e -> this.toggleValue(chip, textLink));
                box.add(textLink);
            }
            Component component = this.toComponent(chip, chipText);
            box.add(component);
            if (this.isEnabled() && this.editable) {
                TextLink editLink = new TextLink("");
                editLink.setIcon(editIcon);
                editLink.addActionListener(e -> this.editChip(chip, chipText, box, component, editLink));
                box.add(editLink);
            }
            if (this.isEnabled()) {
                TextLink deleteLink = new TextLink("");
                deleteLink.setIcon(DeleteColumn.deleteIcon());
                deleteLink.setToolTipText(Messages.getFormattedMessage(Messages.Name.REMOVE_FORMAT, chipText));
                deleteLink.addActionListener(e -> this.removeChip(chip));
                box.add(deleteLink);
            }
            this.add(box);
            this.fontManager.applyTo(box);
        }
        if (this.chips.isEmpty()) {
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(" "));
            box.add(new JLabel(new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                }

                @Override
                public int getIconWidth() {
                    return 1;
                }

                @Override
                public int getIconHeight() {
                    return 24;
                }
            }));
            this.add(box);
        }
        this.revalidate();
        this.repaint();
    }

    private void editChip(T chip, String chipText, JPanel box, Component component, TextLink editLink) {
        JTextField textField = new JTextField(chipText);
        Dimension size = component.getSize();
        size.width += editLink.getWidth();
        textField.setMaximumSize(size);
        textField.setMinimumSize(size);
        textField.setPreferredSize(size);
        for (int i = 0; i < box.getComponentCount(); ++i) {
            if (box.getComponent(i) != component) continue;
            box.remove(i);
            box.add((Component)textField, i);
            box.remove(editLink);
            break;
        }
        final ActionListener actionListener = e -> {
            for (ChipEditedListener listener : (ChipEditedListener[])this.getListeners(ChipEditedListener.class)) {
                listener.chipEdited(chip, textField.getText());
                this.resetContent();
            }
        };
        textField.addActionListener(actionListener);
        textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                actionListener.actionPerformed(null);
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.revalidate();
        this.repaint();
        textField.requestFocusInWindow();
    }

    protected Component toComponent(T chip, String chipText) {
        JLabel label = new JLabel(StringUtils.abbreviate(chipText, 16));
        if (!label.getText().equals(chipText)) {
            label.setToolTipText(chipText);
        }
        return label;
    }

    public Collection<T> getChips() {
        return Collections.unmodifiableCollection(this.chips);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        FixedWidthFlowLayout layout = new FixedWidthFlowLayout(fontManager.scale(this.scaledWidth));
        layout.setAlignOnBaseline(true);
        layout.setAlignment(3);
        layout.setHgap(5);
        this.setLayout(layout);
    }

    private void toggleValue(T chip, TextLink textLink) {
        boolean newValue = !this.toggleOnPredicate.test(chip);
        textLink.setIcon(newValue ? this.toggleOnIcon : this.toggleOffIcon);
        textLink.setToolTipText(Messages.getFormattedMessage(newValue ? this.onTooltipFormat : this.offTooltipFormat, this.toString.apply(chip)));
        ChipToggledListener[] chipToggledListenerArray = (ChipToggledListener[])this.getListeners(ChipToggledListener.class);
        int n = chipToggledListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ChipToggledListener rawListener;
            ChipToggledListener listener = rawListener = chipToggledListenerArray[i];
            listener.chipToggled(chip, newValue);
        }
    }

    public static interface ChipEditedListener<T>
    extends EventListener {
        public void chipEdited(T var1, String var2);
    }

    public static interface ChipsChangedListener
    extends EventListener {
        public void chipsChanged();
    }

    public static interface ChipToggledListener<T>
    extends EventListener {
        public void chipToggled(T var1, boolean var2);
    }

    private class ChipTransferHandler
    extends TransferHandler {
        private T chip;

        public ChipTransferHandler(T chip) {
            this.chip = chip;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return false;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return false;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return ChipsTextPanel.this.dragTransferableFunction.apply(this.chip);
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            if (action == 2) {
                ChipsTextPanel.this.removeChip(this.chip);
            }
        }
    }

    static class FixedWidthFlowLayout
    extends FlowLayout {
        private int fixedWidth;

        FixedWidthFlowLayout(int fixedWidth) {
            this.fixedWidth = fixedWidth;
            this.setAlignOnBaseline(true);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            Dimension size = this.layoutSize(target, Component::getPreferredSize);
            size.width = Math.max(size.width, this.fixedWidth);
            return size;
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.layoutSize(target, Component::getMinimumSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container target, Function<Component, Dimension> sizeFunction) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension accumulatedDimension = new Dimension(0, 0);
                int nmembers = target.getComponentCount();
                boolean useBaseline = this.getAlignOnBaseline();
                int maxAscent = 0;
                int maxDescent = 0;
                int currentLineWidth = 0;
                int currentLineHeight = 0;
                for (int i = 0; i < nmembers; ++i) {
                    int baseline;
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    Dimension d = sizeFunction.apply(m);
                    if (currentLineWidth > 0 && currentLineWidth + this.getHgap() + d.width > this.fixedWidth) {
                        if (useBaseline) {
                            currentLineHeight = Math.max(maxAscent + maxDescent, currentLineHeight);
                        }
                        accumulatedDimension.width = Math.max(accumulatedDimension.width, currentLineWidth);
                        if (accumulatedDimension.height > 0) {
                            accumulatedDimension.height += this.getVgap();
                        }
                        accumulatedDimension.height += currentLineHeight;
                        maxAscent = 0;
                        maxDescent = 0;
                        currentLineWidth = 0;
                        currentLineHeight = 0;
                    }
                    if (currentLineWidth < 0) {
                        currentLineWidth += this.getHgap();
                    }
                    currentLineWidth += d.width;
                    currentLineHeight = Math.max(currentLineHeight, d.height);
                    if (!useBaseline || (baseline = m.getBaseline(d.width, d.height)) < 0) continue;
                    maxAscent = Math.max(maxAscent, baseline);
                    maxDescent = Math.max(maxDescent, d.height - baseline);
                }
                if (useBaseline) {
                    currentLineHeight = Math.max(maxAscent + maxDescent, currentLineHeight);
                }
                accumulatedDimension.width = Math.max(accumulatedDimension.width, currentLineWidth);
                if (accumulatedDimension.height > 0) {
                    accumulatedDimension.height += this.getVgap();
                }
                accumulatedDimension.height += currentLineHeight;
                Graphics g = target.getGraphics();
                if (g != null) {
                    accumulatedDimension.height = Math.max(accumulatedDimension.height, UIUtils.getFontHeight(g, target.getFont()));
                }
                Insets insets = target.getInsets();
                accumulatedDimension.width += insets.left + insets.right + this.getHgap() * 2;
                accumulatedDimension.height += insets.top + insets.bottom + this.getVgap() * 2;
                return accumulatedDimension;
            }
        }
    }
}

