/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.ResolvedComparator;
import com.scythebill.birdlist.ui.components.SpeciesTablePanel;
import com.scythebill.birdlist.ui.components.table.DelayedUI;
import com.scythebill.birdlist.ui.components.table.ExpandableTable;
import com.scythebill.birdlist.ui.components.table.SomeRowsTableRowsModel;
import com.scythebill.birdlist.ui.components.table.TableRowsModel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.util.ListListModel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorListener;

public class ChecklistSpeciesTablePanel
extends SpeciesTablePanel {
    private ListListModel<SightingTaxon.Resolved> speciesListModel;
    private Checklist checklist;
    private boolean includeRarities;
    private Taxonomy speciesListModelTaxonomy;
    private static final Object KEY = new Object();
    private final MouseListener labelListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            Point tablePoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), ChecklistSpeciesTablePanel.this.getSpeciesTable());
            int row = ChecklistSpeciesTablePanel.this.getSpeciesTable().getRow(tablePoint.y);
            if (e.getClickCount() == 2) {
                TableRowsModel enabledRows = ChecklistSpeciesTablePanel.this.getSpeciesTable().getEnabledRowsModel();
                if (enabledRows.isIncluded(row)) {
                    enabledRows.removeRow(row);
                } else {
                    enabledRows.includeRow(row);
                }
            } else {
                ChecklistSpeciesTablePanel.this.redispatchMouseEventToParent(e);
            }
        }
    };

    public ChecklistSpeciesTablePanel(ExpandableTable.DetailView<SightingTaxon.Resolved> expandedRowView, String detailTitle, FontManager fontManager, Checklist checklist, boolean includeRarities, Taxonomy taxonomy) {
        super(expandedRowView, detailTitle, fontManager);
        this.checklist = checklist;
        this.includeRarities = includeRarities;
        this.speciesListModelTaxonomy = taxonomy;
        this.speciesListModel = this.newListModel(taxonomy);
        this.init();
        this.hookUpContents();
    }

    @Override
    protected void speciesTableCreated() {
        this.getSpeciesTable().setEnabledRowsModel(new SomeRowsTableRowsModel());
        this.getSpeciesTable().setHighlightEnabledRows(true);
        this.getSpeciesTable().getEnabledRowsModel().addListener(new TableRowsModel.Listener(){

            @Override
            public void rowRemoved(int row) {
                ChecklistSpeciesTablePanel.this.fireValueChanged();
            }

            @Override
            public void rowIncluded(int row) {
                ChecklistSpeciesTablePanel.this.fireValueChanged();
            }
        });
        this.addColumn(new CheckColumn(ExpandableTable.ColumnLayout.fixedWidth(30)));
    }

    private ListListModel<SightingTaxon.Resolved> newListModel(Taxonomy taxonomy) {
        TreeSet<SightingTaxon.Resolved> set = Sets.newTreeSet(new ResolvedComparator());
        for (SightingTaxon taxon : this.checklist.getTaxa(taxonomy)) {
            Checklist.Status status;
            if (!this.includeRarities && ((status = this.checklist.getStatus(taxonomy, taxon)) == Checklist.Status.RARITY || status == Checklist.Status.EXTINCT || status == Checklist.Status.RARITY_FROM_INTRODUCED)) continue;
            set.add(taxon.resolveInternal(taxonomy));
        }
        ListListModel<SightingTaxon.Resolved> model = new ListListModel<SightingTaxon.Resolved>();
        model.asList().addAll(set);
        return model;
    }

    private void hookUpContents() {
        KeyStroke upKey = KeyStroke.getKeyStroke(32, 0);
        this.getSpeciesTable().getInputMap().put(upKey, "space");
        this.getSpeciesTable().getActionMap().put("space", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int row = ChecklistSpeciesTablePanel.this.getSpeciesTable().getSelectedIndex();
                if (row != -1) {
                    TableRowsModel enabledRows = ChecklistSpeciesTablePanel.this.getSpeciesTable().getEnabledRowsModel();
                    if (enabledRows.isIncluded(row)) {
                        enabledRows.removeRow(row);
                    } else {
                        enabledRows.includeRow(row);
                    }
                }
            }
        });
    }

    @Override
    public void addSpecies(SightingTaxon.Resolved resolved) {
        Preconditions.checkNotNull(resolved);
        this.addSpeciesInternal(resolved);
        this.fireValueChanged();
    }

    @Override
    public void removeSpecies(SightingTaxon.Resolved taxon) {
        Preconditions.checkNotNull(taxon);
        throw new UnsupportedOperationException();
    }

    @Override
    public void swapSpecies(SightingTaxon.Resolved currentTaxon, SightingTaxon.Resolved newTaxon) {
        int indexOf = this.speciesListModel.asList().indexOf(currentTaxon);
        Preconditions.checkState(indexOf >= 0, currentTaxon.getFullName() + " not found");
        this.speciesListModel.asList().set(indexOf, newTaxon);
    }

    @Override
    public void setSortedContents(Taxonomy taxonomy, List<SightingTaxon.Resolved> taxa) {
        Preconditions.checkNotNull(taxa);
        TableRowsModel enabledRowsModel = this.getSpeciesTable().getEnabledRowsModel();
        for (int i = 0; i < this.speciesListModel.getSize(); ++i) {
            if (!enabledRowsModel.isIncluded(i)) continue;
            enabledRowsModel.removeRow(i);
        }
        if (taxonomy != this.speciesListModelTaxonomy) {
            this.speciesListModelTaxonomy = taxonomy;
            this.speciesListModel = this.newListModel(taxonomy);
            this.getSpeciesTable().setModel(this.speciesListModel);
        }
        for (SightingTaxon.Resolved resolved : taxa) {
            this.addSpecies(resolved);
        }
        this.fireValueChanged();
    }

    private void addSpeciesInternal(SightingTaxon.Resolved resolved) {
        int searchResult = Collections.binarySearch(this.speciesListModel.asList(), resolved, new ResolvedComparator());
        if (searchResult >= 0) {
            this.getSpeciesTable().getEnabledRowsModel().includeRow(searchResult);
        } else {
            int insertionIndex = -searchResult - 1;
            this.speciesListModel.asList().add(insertionIndex, resolved);
            this.getSpeciesTable().getEnabledRowsModel().includeRow(insertionIndex);
        }
    }

    @Override
    public ImmutableList<SightingTaxon.Resolved> getValue() {
        ImmutableList.Builder enabled = ImmutableList.builder();
        List<SightingTaxon.Resolved> resolved = this.speciesListModel.asList();
        TableRowsModel enabledRowsModel = this.getSpeciesTable().getEnabledRowsModel();
        for (int i = 0; i < resolved.size(); ++i) {
            if (!enabledRowsModel.isIncluded(i)) continue;
            enabled.add(resolved.get(i));
        }
        return enabled.build();
    }

    @Override
    protected ListListModel<SightingTaxon.Resolved> getListModel() {
        return this.speciesListModel;
    }

    @Override
    protected void customizeSpeciesLabel(JLabel label) {
        label.setCursor(Cursor.getPredefinedCursor(12));
        label.addMouseListener(this.labelListener);
    }

    private void redispatchMouseEventToParent(MouseEvent e) {
        e.getComponent().getParent().dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, e.getComponent().getParent()));
    }

    class CheckColumn
    implements ExpandableTable.Column<SightingTaxon.Resolved> {
        private final ActionListener listener;
        private ExpandableTable.ColumnLayout width;

        public CheckColumn(ExpandableTable.ColumnLayout width) {
            this.width = width;
            this.listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExpandableTable<SightingTaxon.Resolved> table = ChecklistSpeciesTablePanel.this.getSpeciesTable();
                    table.requestFocusInWindow();
                    JCheckBox checkBox = (JCheckBox)e.getSource();
                    SightingTaxon.Resolved resolved = (SightingTaxon.Resolved)checkBox.getClientProperty(KEY);
                    int row = ChecklistSpeciesTablePanel.this.getListModel().asList().indexOf(resolved);
                    if (row >= 0) {
                        boolean isSelected = checkBox.isSelected();
                        if (isSelected) {
                            table.getEnabledRowsModel().includeRow(row);
                        } else {
                            table.getEnabledRowsModel().removeRow(row);
                        }
                        ChecklistSpeciesTablePanel.this.notifyUserModifiedValue();
                        table.setSelectedIndex(row);
                    }
                }
            };
        }

        @Override
        public JComponent createComponent(SightingTaxon.Resolved value, Set<ExpandableTable.RowState> states) {
            JCheckBox checkBox = new JCheckBox(){

                @Override
                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                    if (!"parent".equals(propertyName) && !"ancestor".equals(propertyName)) {
                        super.firePropertyChange(propertyName, oldValue, newValue);
                    }
                }

                @Override
                public void updateUI() {
                    if (DelayedUI.instance().requestUICreation(this)) {
                        super.updateUI();
                    }
                }

                @Override
                public void addAncestorListener(AncestorListener listener) {
                }
            };
            checkBox.setFocusable(false);
            checkBox.addActionListener(this.listener);
            this.updateComponentValue((Component)checkBox, value);
            this.updateComponentState((Component)checkBox, value, states);
            return checkBox;
        }

        @Override
        public ExpandableTable.ColumnLayout getWidth() {
            return this.width;
        }

        @Override
        public void updateComponentValue(Component component, SightingTaxon.Resolved value) {
            JCheckBox checkBox = (JCheckBox)component;
            checkBox.putClientProperty(KEY, value);
        }

        @Override
        public void updateComponentState(Component component, SightingTaxon.Resolved value, Set<ExpandableTable.RowState> states) {
            JCheckBox checkBox = (JCheckBox)component;
            checkBox.setSelected(states.contains((Object)ExpandableTable.RowState.ENABLED));
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public boolean sizeComponentsToFit() {
            return false;
        }
    }
}

