/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components;

import com.formdev.flatlaf.FlatLaf;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.LocalNames;
import com.scythebill.birdlist.ui.actions.Attachable;
import com.scythebill.birdlist.ui.actions.ForwardingAction;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.components.NewLocationDialog;
import com.scythebill.birdlist.ui.components.SightingBrowsePanel;
import com.scythebill.birdlist.ui.components.SightingBulkEditPanel;
import com.scythebill.birdlist.ui.components.TripInfoBrowsePanel;
import com.scythebill.birdlist.ui.components.VisitInfoBrowsePanel;
import com.scythebill.birdlist.ui.components.VisitInfoPreferences;
import com.scythebill.birdlist.ui.components.WherePanel;
import com.scythebill.birdlist.ui.components.browser.BrowserPreviewRenderer;
import com.scythebill.birdlist.ui.components.browser.DefaultBrowserCellRenderer;
import com.scythebill.birdlist.ui.components.browser.JBrowser;
import com.scythebill.birdlist.ui.datatransfer.SightingTransferable;
import com.scythebill.birdlist.ui.datatransfer.SightingsGroup;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.ShowSpeciesMap;
import com.scythebill.birdlist.ui.panels.SpHybridDialog;
import com.scythebill.birdlist.ui.panels.SpeciesInfoDescriber;
import com.scythebill.birdlist.ui.panels.reports.ReportsTreeModel;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import com.scythebill.birdlist.ui.util.LocationScorer;
import com.scythebill.birdlist.ui.util.OpenMapUrl;
import com.scythebill.birdlist.ui.util.ResolvedWithKey;
import com.scythebill.birdlist.ui.util.ResolvedWithSighting;
import com.scythebill.birdlist.ui.util.SightingFlags;
import com.scythebill.birdlist.ui.util.TaxonTreeModel;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.joda.time.ReadablePartial;

public abstract class BaseTaxonBrowserPanel
extends JBrowser
implements FontManager.FontsUpdatedListener {
    protected final FontManager fontManager;
    private Location locationRoot;
    private Taxonomy taxonomy;
    private final ReportSet reportSet;
    private final SpeciesInfoDescriber speciesInfoDescriber;
    private final NewLocationDialog newLocationDialog;
    private final SpHybridDialog spHybridDialog;
    private final PredefinedLocations predefinedLocations;
    private final FileDialogs fileDialogs;
    private final Alerts alerts;
    private final OpenMapUrl openMapUrl;
    protected final NavigableFrame navigableFrame;
    private final LocationScorer locationScorer;
    private static final Logger logger = Logger.getLogger(BaseTaxonBrowserPanel.class.getName());
    private static final ImmutableSet<Species.Status> STATUS_TO_SHOW = ImmutableSet.of(Species.Status.EN, Species.Status.CR, Species.Status.EW, Species.Status.EX);

    public BaseTaxonBrowserPanel(FontManager fontManager, ReportSet reportSet, NewLocationDialog newLocationDialog, SpHybridDialog spHybridDialog, PredefinedLocations predefinedLocations, SpeciesInfoDescriber speciesInfoDescriber, OpenMapUrl openMapUrl, FileDialogs fileDialogs, Alerts alerts, NavigableFrame navigableFrame, LocationScorer locationScorer) {
        this.fontManager = fontManager;
        this.reportSet = reportSet;
        this.newLocationDialog = newLocationDialog;
        this.spHybridDialog = spHybridDialog;
        this.predefinedLocations = predefinedLocations;
        this.speciesInfoDescriber = speciesInfoDescriber;
        this.fileDialogs = fileDialogs;
        this.alerts = alerts;
        this.navigableFrame = navigableFrame;
        this.openMapUrl = openMapUrl;
        this.locationScorer = locationScorer;
        this.updateUI();
        this.setSelectionMode(4);
        this.setPreviewRenderer(new TaxonPreviewRenderer());
        fontManager.applyTo(this);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setCellRenderer(new TaxonBrowserCellRenderer());
    }

    public void setTaxonomy(Taxonomy taxonomy) {
        this.taxonomy = taxonomy;
    }

    public Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    public void setLocationRoot(Location locationRoot) {
        this.locationRoot = locationRoot;
    }

    public Location getLocationRoot() {
        return this.locationRoot;
    }

    @Override
    public void doLayout() {
        Font font = this.fontManager.getTextFont();
        this.setFixedCellHeight(UIUtils.getFontHeight(this.getGraphics(), font) + 2);
        super.doLayout();
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof Taxon) {
            return this.convertTaxonToString((Taxon)value, null);
        }
        if (value instanceof SightingTaxon.Resolved) {
            return this.convertResolvedToString((SightingTaxon.Resolved)value, null);
        }
        if (value instanceof Sighting) {
            Sighting sighting = (Sighting)value;
            ReadablePartial date = sighting.getSingleDateAsPartial();
            Object text = "";
            boolean wroteTrip = false;
            if (date != null) {
                text = PartialIO.toShortUserString(date, this.getLocale());
            } else if (sighting.getTrip() != null && sighting.getTrip().hasName()) {
                text = Trips.nameWithDate(sighting.getTrip(), this.getLocale());
                wroteTrip = true;
            } else {
                text = Messages.getMessage(Messages.Name.NO_DATE_FOR_SIGHTING);
            }
            SightingTaxon.Type type = sighting.getTaxon().resolve(this.getTaxonomy()).resolveParentOfType(Taxon.Type.species).getType();
            if (type == SightingTaxon.Type.SP) {
                text = (String)text + " (sp)";
            } else if (type == SightingTaxon.Type.HYBRID) {
                text = (String)text + " (hyb)";
            }
            text = SightingFlags.appendSightingInfo((String)text, sighting);
            if (sighting.getLocationId() != null) {
                if (!wroteTrip || !sighting.getLocationId().equals(sighting.getTrip().locationId())) {
                    String locationText = LocationIdToString.getString(this.getReportSet().getLocations(), sighting.getLocationId(), true, this.locationRoot);
                    text = (String)text + " " + locationText;
                }
            } else if (!(wroteTrip || date != null && date.size() != 0)) {
                text = (String)text + " " + Messages.getMessage(Messages.Name.NO_DETAILS_FOR_SIGHTING);
            }
            return text;
        }
        if (value instanceof VisitInfoKey) {
            VisitInfoKey visitInfoKey = (VisitInfoKey)value;
            Object text = PartialIO.toUserString(visitInfoKey.date(), this.getLocale());
            if (visitInfoKey.startTime().isPresent()) {
                text = (String)text + ", " + TimeIO.toShortUserString(visitInfoKey.startTime().get(), this.getLocale());
            }
            return text;
        }
        return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
    }

    protected boolean abbreviateGenus(Taxon taxon) {
        return true;
    }

    protected String convertTaxonToString(Taxon taxon, @Nullable Sighting sighting) {
        LocalNames localNames = taxon.getTaxonomy().getLocalNames();
        switch (taxon.getType()) {
            case species: {
                String sciName = !this.abbreviateGenus(taxon) ? TaxonUtils.getFullName(taxon) : TaxonUtils.getAbbreviatedName(taxon);
                Species.Status status = this.getStatus(taxon);
                if (this.showStatus(status)) {
                    return localNames.compoundName(taxon, this.abbreviateGenus(taxon), status);
                }
                return localNames.compoundName(taxon, this.abbreviateGenus(taxon));
            }
            case subspecies: 
            case group: {
                if (taxon.getCommonName() != null) {
                    Species.Status subspStatus = this.getStatus(taxon);
                    if (this.showStatus(subspStatus)) {
                        return localNames.compoundName(taxon, true, subspStatus);
                    }
                    return localNames.compoundName(taxon, true);
                }
                return localNames.abbreviatedScientificName(taxon);
            }
        }
        String sciName = taxon.getName();
        if (taxon.getCommonName() != null && !taxon.getCommonName().equals(sciName)) {
            return localNames.compoundName(taxon, false);
        }
        return sciName;
    }

    private boolean showStatus(Species.Status status) {
        return STATUS_TO_SHOW.contains((Object)status);
    }

    protected String convertResolvedToString(SightingTaxon.Resolved taxon, @Nullable Sighting sighting) {
        if (taxon.getType() == SightingTaxon.Type.SINGLE) {
            return this.convertTaxonToString(taxon.getTaxon(), sighting);
        }
        return taxon.getPreferredSingleName();
    }

    private Species.Status getStatus(Taxon taxon) {
        if (taxon instanceof Species) {
            return ((Species)taxon).getStatus();
        }
        return Species.Status.LC;
    }

    protected Font deriveTaxonFont(Font base, Taxon taxon, boolean leaf) {
        if (taxon.isDisabled()) {
            base = base.deriveFont(ImmutableMap.of(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON));
        }
        return base;
    }

    protected Color deriveTaxonForeground(Color foreground, Taxon taxon, boolean leaf, boolean selected, Object value) {
        return foreground;
    }

    protected Font deriveOtherFont(Font base, Object value) {
        return base;
    }

    private Optional<String> getPathText(TreePath path) {
        Component browserCellRendererComponent = this.getCellRenderer().getBrowserCellRendererComponent(this, path.getLastPathComponent(), false, false, false, 0, false);
        return this.getText(browserCellRendererComponent);
    }

    private int comparePaths(TreePath left, TreePath right) {
        if (left.getPathCount() == right.getPathCount()) {
            return this.comparePathsOfEqualLength(left, right);
        }
        if (left.getPathCount() > right.getPathCount()) {
            return this.comparePathsOfUnequalLength(left, right);
        }
        return -this.comparePathsOfUnequalLength(right, left);
    }

    private int comparePathsOfUnequalLength(TreePath longer, TreePath shorter) {
        while (longer.getPathCount() > shorter.getPathCount()) {
            longer = longer.getParentPath();
        }
        return this.comparePathsOfEqualLength(longer, shorter);
    }

    private int comparePathsOfEqualLength(TreePath left, TreePath right) {
        while (true) {
            TreePath leftParent = left.getParentPath();
            TreePath rightParent = right.getParentPath();
            if (leftParent.getLastPathComponent().equals(rightParent.getLastPathComponent())) break;
            left = leftParent;
            right = rightParent;
        }
        TreeModel model = this.getModel();
        int leftIndex = model.getIndexOfChild(left.getParentPath().getLastPathComponent(), left.getLastPathComponent());
        int rightIndex = model.getIndexOfChild(right.getParentPath().getLastPathComponent(), right.getLastPathComponent());
        return leftIndex - rightIndex;
    }

    private Optional<String> getText(Component component) {
        String text;
        if (component instanceof JLabel && !Strings.isNullOrEmpty(text = ((JLabel)component).getText())) {
            return Optional.of(text);
        }
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                Optional<String> childText = this.getText(child);
                if (!childText.isPresent()) continue;
                return childText;
            }
        }
        return Optional.absent();
    }

    protected abstract void doMove(SightingsGroup var1);

    protected boolean canImportSightingsToPath(TreePath path) {
        SightingTaxon.Resolved r;
        Taxon t;
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof Sighting) {
            return true;
        }
        Taxon taxon = lastPathComponent instanceof Taxon ? (t = (Taxon)lastPathComponent) : (lastPathComponent instanceof SightingTaxon.Resolved ? ((r = (SightingTaxon.Resolved)lastPathComponent).getType() == SightingTaxon.Type.SINGLE ? r.getTaxon() : null) : null);
        if (taxon == null) {
            return false;
        }
        return !taxon.isDisabled() && taxon.getType().compareTo(Taxon.Type.species) <= 0;
    }

    protected boolean canImportSightings(TransferHandler.TransferSupport transferSupport, TreePath target, SightingsGroup sightings) {
        Taxon taxon;
        if (target.getLastPathComponent() instanceof Taxon) {
            taxon = (Taxon)target.getLastPathComponent();
        } else if (target.getLastPathComponent() instanceof SightingTaxon.Resolved) {
            SightingTaxon.Resolved resolved = (SightingTaxon.Resolved)target.getLastPathComponent();
            if (resolved.getType() != SightingTaxon.Type.SINGLE) {
                return false;
            }
            taxon = resolved.getTaxon();
        } else if (target.getLastPathComponent() instanceof Sighting) {
            if (transferSupport.isDrop()) {
                return false;
            }
            Object penultimate = target.getParentPath().getLastPathComponent();
            if (!(penultimate instanceof Taxon)) {
                return false;
            }
            taxon = (Taxon)penultimate;
        } else {
            return false;
        }
        if (taxon.getType().compareTo(Taxon.Type.species) > 0 || taxon.isDisabled()) {
            return false;
        }
        return !transferSupport.isDrop() || !taxon.equals(sightings.getSourceTaxon());
    }

    protected boolean doImport(TransferHandler.TransferSupport transferSupport, SightingsGroup sightings, TreePath target) {
        return false;
    }

    protected boolean canMoveSightings() {
        return false;
    }

    protected void customizeSightingPreviewPanel(SightingBrowsePanel panel) {
    }

    protected void customizeSightingPreviewPanel(SightingBulkEditPanel sightingBulkEditPanel) {
    }

    protected boolean hasSightingsGroup(TreePath[] paths) {
        if (paths == null) {
            return false;
        }
        for (TreePath path : paths) {
            ResolvedWithKey rwk;
            List<Sighting> rwkSightings;
            Object lastComponent = path.getLastPathComponent();
            if (lastComponent instanceof Sighting || lastComponent instanceof ResolvedWithSighting || lastComponent instanceof ResolvedWithKey && (rwkSightings = this.getSightingsForResolvedWithKey(rwk = (ResolvedWithKey)lastComponent)).size() == 1) continue;
            return false;
        }
        return true;
    }

    protected ReportSet getReportSet() {
        return this.reportSet;
    }

    public void saveCurrentPreview() {
        Component c = this.getPreviewRendererComponent();
        if (c instanceof SightingBrowsePanel) {
            ((SightingBrowsePanel)c).save();
        } else if (c instanceof SightingBulkEditPanel) {
            ((SightingBulkEditPanel)c).save();
        }
    }

    private void reselectIfNecessary(TreePath oldParentPath, List<Sighting> newSightings) {
        TreePath[] paths = new TreePath[newSightings.size()];
        for (int i = 0; i < newSightings.size(); ++i) {
            paths[i] = this.pathToSighting(oldParentPath, newSightings.get(i));
        }
        this.setSelectionPaths(paths);
        this.ensurePathIsVisible(paths[0]);
        if (paths.length > 1) {
            this.ensurePathIsVisible(paths[paths.length - 1]);
        }
    }

    protected abstract String getReturnPanelName();

    protected abstract PostNavigateAction returnToSighting(TreePath var1, Sighting var2);

    protected abstract TreePath pathToSighting(TreePath var1, Sighting var2);

    protected abstract void sightingsReplaced(TreePath var1, List<Sighting> var2, List<Sighting> var3, int[] var4);

    protected int getSightingIndex(Sighting sighting, TreePath parentPath) {
        return this.getModel().getIndexOfChild(parentPath.getLastPathComponent(), sighting);
    }

    protected boolean canImportSightings() {
        return true;
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setFixedCellWidth(fontManager.scale(270));
        this.setMinimumCellWidth(fontManager.scale(200));
        this.setMinimumSize(fontManager.scale(new Dimension(1000, 800)));
    }

    protected boolean allowLocationEditing() {
        return true;
    }

    protected VisitInfoPreferences getVisitInfoPreferences() {
        throw new UnsupportedOperationException();
    }

    protected void replaceVisitInfoKey(VisitInfoKey updatedVisitInfoKey) {
        throw new UnsupportedOperationException();
    }

    protected void visitInfoKeyDeleted(VisitInfoKey deletedVisitInfoKey) {
        throw new UnsupportedOperationException();
    }

    protected Action getReturnToCurrentVisitInfoAction(VisitInfoKey visitInfoKey) {
        return null;
    }

    protected Action getReturnToCurrentTripAction(Trip trip) {
        return null;
    }

    public List<Sighting> getSightingsForResolvedWithKey(ResolvedWithKey rwk) {
        return ((ReportsTreeModel)this.getModel()).getChildren(rwk);
    }

    protected class TaxonPreviewRenderer
    implements BrowserPreviewRenderer {
        protected TaxonPreviewRenderer() {
        }

        @Override
        public Component getPreviewRendererComponent(JBrowser browser, final TreePath[] paths) {
            ArrayList<Sighting> sightings = Lists.newArrayList();
            ArrayList<VisitInfoKey> visitInfoKeys = Lists.newArrayList();
            ArrayList<Trip> trips = Lists.newArrayList();
            for (TreePath path : paths) {
                Object lastElement = path.getLastPathComponent();
                if (lastElement instanceof SightingTaxon.Resolved) {
                    return this.newResolvedPreview((SightingTaxon.Resolved)lastElement);
                }
                if (lastElement instanceof ResolvedWithSighting) {
                    sightings.add(((ResolvedWithSighting)lastElement).getSighting());
                    continue;
                }
                if (lastElement instanceof ResolvedWithKey) {
                    ResolvedWithKey rwk = (ResolvedWithKey)lastElement;
                    List<Sighting> rwkSightings = BaseTaxonBrowserPanel.this.getSightingsForResolvedWithKey(rwk);
                    if (rwkSightings.size() == 1) {
                        sightings.addAll(rwkSightings);
                        continue;
                    }
                    return this.newEmptyLabel();
                }
                if (lastElement instanceof Sighting) {
                    Sighting sighting = (Sighting)lastElement;
                    sightings.add(sighting);
                    continue;
                }
                if (lastElement instanceof VisitInfoKey) {
                    VisitInfoKey vik = (VisitInfoKey)lastElement;
                    visitInfoKeys.add(vik);
                    continue;
                }
                if (lastElement instanceof Trip) {
                    Trip trip = (Trip)lastElement;
                    trips.add(trip);
                    continue;
                }
                return this.newEmptyLabel();
            }
            if (!trips.isEmpty()) {
                if (trips.size() > 1 || !visitInfoKeys.isEmpty() || !sightings.isEmpty()) {
                    return this.newEmptyLabel();
                }
                Trip trip = (Trip)trips.get(0);
                TripInfoBrowsePanel.UpdatedListener updatedListener = new TripInfoBrowsePanel.UpdatedListener(){

                    @Override
                    public void tripUpdated(Trip trip) {
                        BaseTaxonBrowserPanel.this.getModel().valueForPathChanged(paths[0], trip);
                    }
                };
                TripInfoBrowsePanel tripInfoBrowsePanel = new TripInfoBrowsePanel(BaseTaxonBrowserPanel.this.reportSet, trip, BaseTaxonBrowserPanel.this.alerts, BaseTaxonBrowserPanel.this.fileDialogs, BaseTaxonBrowserPanel.this.fontManager, updatedListener, BaseTaxonBrowserPanel.this.newLocationDialog, BaseTaxonBrowserPanel.this.predefinedLocations, BaseTaxonBrowserPanel.this.openMapUrl, BaseTaxonBrowserPanel.this.navigableFrame, BaseTaxonBrowserPanel.this.locationScorer, BaseTaxonBrowserPanel.this.getReturnToCurrentTripAction(trip));
                BaseTaxonBrowserPanel.this.fontManager.applyTo(tripInfoBrowsePanel);
                return tripInfoBrowsePanel;
            }
            if (!visitInfoKeys.isEmpty()) {
                if (visitInfoKeys.size() > 1 || !sightings.isEmpty()) {
                    return this.newEmptyLabel();
                }
                Preconditions.checkState(paths.length == 1);
                final VisitInfoKey visitInfoKey = (VisitInfoKey)visitInfoKeys.get(0);
                VisitInfoBrowsePanel.UpdatedListener updated = new VisitInfoBrowsePanel.UpdatedListener(){

                    @Override
                    public void visitInfoUpdated(VisitInfoKey updatedVisitInfoKey) {
                        if (!visitInfoKey.equals(updatedVisitInfoKey)) {
                            BaseTaxonBrowserPanel.this.replaceVisitInfoKey(updatedVisitInfoKey);
                        }
                    }

                    @Override
                    public void visitInfoDeleted(VisitInfoKey key) {
                        BaseTaxonBrowserPanel.this.visitInfoKeyDeleted(key);
                    }
                };
                VisitInfoBrowsePanel panel = new VisitInfoBrowsePanel(BaseTaxonBrowserPanel.this.reportSet, visitInfoKey, BaseTaxonBrowserPanel.this.reportSet.getVisitInfo(visitInfoKey), BaseTaxonBrowserPanel.this.getVisitInfoPreferences(), BaseTaxonBrowserPanel.this.fileDialogs, BaseTaxonBrowserPanel.this.alerts, BaseTaxonBrowserPanel.this.fontManager, updated, BaseTaxonBrowserPanel.this.navigableFrame, BaseTaxonBrowserPanel.this.newLocationDialog, BaseTaxonBrowserPanel.this.predefinedLocations, BaseTaxonBrowserPanel.this.openMapUrl, BaseTaxonBrowserPanel.this.locationScorer, BaseTaxonBrowserPanel.this.getReturnToCurrentVisitInfoAction(visitInfoKey));
                BaseTaxonBrowserPanel.this.fontManager.applyTo(panel);
                return panel;
            }
            if (sightings.size() == 1) {
                Sighting sighting = (Sighting)Iterables.getOnlyElement(sightings);
                final TreePath path = paths[0];
                final int currentIndex = BaseTaxonBrowserPanel.this.getSightingIndex(sighting, path.getParentPath());
                final AtomicReference<SightingBrowsePanel> panelReference = new AtomicReference<SightingBrowsePanel>();
                SightingBrowsePanel sightingBrowsePanel = new SightingBrowsePanel(BaseTaxonBrowserPanel.this.taxonomy, BaseTaxonBrowserPanel.this.getReportSet(), sighting, BaseTaxonBrowserPanel.this.newLocationDialog, BaseTaxonBrowserPanel.this.navigableFrame, new ReturnToPanel(BaseTaxonBrowserPanel.this.navigableFrame, BaseTaxonBrowserPanel.this.getReturnPanelName(), BaseTaxonBrowserPanel.this.returnToSighting(path.getParentPath(), sighting)), BaseTaxonBrowserPanel.this.spHybridDialog, BaseTaxonBrowserPanel.this.predefinedLocations, BaseTaxonBrowserPanel.this.openMapUrl, BaseTaxonBrowserPanel.this.fontManager, BaseTaxonBrowserPanel.this.fileDialogs, BaseTaxonBrowserPanel.this.alerts, BaseTaxonBrowserPanel.this.locationScorer, new SightingBrowsePanel.UpdatedListener(){

                    @Override
                    public void sightingsUpdated(Sighting updatedSighting) {
                        this.sightingsSwapped(updatedSighting, updatedSighting);
                    }

                    @Override
                    public void sightingsSwapped(Sighting oldSighting, Sighting newSighting) {
                        if (BaseTaxonBrowserPanel.this.isDisplayable()) {
                            if (path.equals(BaseTaxonBrowserPanel.this.getSelectionPath())) {
                                BaseTaxonBrowserPanel.this.sightingsReplaced(path.getParentPath(), ImmutableList.of(oldSighting), ImmutableList.of(newSighting), new int[]{currentIndex});
                                if (panelReference.get() != null && ((SightingBrowsePanel)panelReference.get()).isDisplayable()) {
                                    BaseTaxonBrowserPanel.this.reselectIfNecessary(path.getParentPath(), ImmutableList.of(newSighting));
                                }
                            } else {
                                SwingUtilities.invokeLater(() -> BaseTaxonBrowserPanel.this.sightingsReplaced(path.getParentPath(), ImmutableList.of(oldSighting), ImmutableList.of(newSighting), new int[]{currentIndex}));
                            }
                        }
                    }
                });
                panelReference.set(sightingBrowsePanel);
                BaseTaxonBrowserPanel.this.fontManager.applyTo(sightingBrowsePanel);
                BaseTaxonBrowserPanel.this.customizeSightingPreviewPanel(sightingBrowsePanel);
                return sightingBrowsePanel;
            }
            final TreePath parent = paths[0].getParentPath();
            final int[] indices = new int[paths.length];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = BaseTaxonBrowserPanel.this.getModel().getIndexOfChild(parent.getLastPathComponent(), paths[i].getLastPathComponent());
            }
            SightingBulkEditPanel.UpdatedListener updated = new SightingBulkEditPanel.UpdatedListener(){

                @Override
                public void sightingsUpdated(List<Sighting> sightings) {
                    this.sightingsSwapped(sightings, sightings);
                }

                @Override
                public void sightingsSwapped(List<Sighting> oldSightings, List<Sighting> newSightings) {
                    if (BaseTaxonBrowserPanel.this.isDisplayable()) {
                        BaseTaxonBrowserPanel.this.sightingsReplaced(parent, oldSightings, newSightings, indices);
                        BaseTaxonBrowserPanel.this.reselectIfNecessary(parent, newSightings);
                    }
                }

                @Override
                public void sightingsRemoved(List<Sighting> sightings) {
                    throw new UnsupportedOperationException("Not supported here");
                }
            };
            SightingBulkEditPanel sightingBulkEditPanel = new SightingBulkEditPanel(BaseTaxonBrowserPanel.this.taxonomy, BaseTaxonBrowserPanel.this.reportSet, sightings, updated, BaseTaxonBrowserPanel.this.alerts, BaseTaxonBrowserPanel.this.fontManager, BaseTaxonBrowserPanel.this.allowLocationEditing() ? new WherePanel(BaseTaxonBrowserPanel.this.reportSet, BaseTaxonBrowserPanel.this.newLocationDialog, BaseTaxonBrowserPanel.this.predefinedLocations, BaseTaxonBrowserPanel.this.openMapUrl, BaseTaxonBrowserPanel.this.locationScorer, "") : null, BaseTaxonBrowserPanel.this.spHybridDialog);
            BaseTaxonBrowserPanel.this.fontManager.applyTo(sightingBulkEditPanel);
            BaseTaxonBrowserPanel.this.customizeSightingPreviewPanel(sightingBulkEditPanel);
            return sightingBulkEditPanel;
        }

        private Component newResolvedPreview(SightingTaxon.Resolved resolved) {
            if (resolved.getLargestTaxonType().compareTo(Taxon.Type.species) > 0) {
                return this.newEmptyLabel();
            }
            StringBuilder builder = new StringBuilder("<html>");
            BaseTaxonBrowserPanel.this.speciesInfoDescriber.toHtmlText(resolved, BaseTaxonBrowserPanel.this.reportSet, builder, true);
            JScrollPane speciesInfoScrollPane = new JScrollPane();
            JEditorPane speciesInfoText = new JEditorPane(){

                @Override
                public void updateUI() {
                    super.updateUI();
                    if (!FlatLaf.isLafDark()) {
                        this.setBackground(Color.WHITE);
                    }
                }
            };
            speciesInfoText.setContentType("text/html");
            if (!FlatLaf.isLafDark()) {
                speciesInfoText.setBackground(Color.WHITE);
            }
            speciesInfoText.putClientProperty("JEditorPane.honorDisplayProperties", true);
            speciesInfoScrollPane.setViewportView(speciesInfoText);
            speciesInfoScrollPane.setVerticalScrollBarPolicy(20);
            speciesInfoScrollPane.setHorizontalScrollBarPolicy(31);
            speciesInfoText.setEditable(false);
            speciesInfoText.setText(builder.toString());
            speciesInfoText.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (SpeciesInfoDescriber.isShowMapUrl(event.getURL())) {
                            String id = SpeciesInfoDescriber.getShowMapSpeciesId(event.getURL());
                            try {
                                ShowSpeciesMap showSpeciesMap = new ShowSpeciesMap(BaseTaxonBrowserPanel.this.predefinedLocations, BaseTaxonBrowserPanel.this.reportSet);
                                showSpeciesMap.showRange(BaseTaxonBrowserPanel.this.reportSet, BaseTaxonBrowserPanel.this.taxonomy, id);
                            }
                            catch (IOException e) {
                                BaseTaxonBrowserPanel.this.alerts.showError((Object)BaseTaxonBrowserPanel.this, (Throwable)e, Messages.Name.MAP_FAILED, Messages.Name.COULDNT_WRITE_MAP, new Object[0]);
                            }
                        } else {
                            try {
                                DesktopUtils.openUrlInBrowser(event.getURL().toURI(), BaseTaxonBrowserPanel.this.alerts);
                            }
                            catch (URISyntaxException e) {
                                logger.log(Level.WARNING, "Couldn't open URL " + event.getURL(), e);
                            }
                        }
                    }
                }
            });
            BaseTaxonBrowserPanel.this.fontManager.applyTo(speciesInfoScrollPane);
            return speciesInfoScrollPane;
        }

        private Component newEmptyLabel() {
            JLabel label = new JLabel();
            return label;
        }
    }

    private class TaxonBrowserCellRenderer
    extends DefaultBrowserCellRenderer {
        public TaxonBrowserCellRenderer() {
            this.setOpenIcon(null);
            this.setClosedIcon(null);
            this.setLeafIcon(null);
        }

        @Override
        public Component getBrowserCellRendererComponent(JBrowser browser, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value == TaxonTreeModel.Node.SEPARATOR) {
                return new JSeparator(0);
            }
            Component cell = super.getBrowserCellRendererComponent(browser, value, selected, expanded, leaf, row, hasFocus);
            cell.setFont(BaseTaxonBrowserPanel.this.fontManager.getTextFont());
            if (value instanceof SightingTaxon.Resolved) {
                SightingTaxon.Resolved resolved = (SightingTaxon.Resolved)value;
                if (resolved.getType() == SightingTaxon.Type.SINGLE) {
                    cell.setFont(BaseTaxonBrowserPanel.this.deriveTaxonFont(cell.getFont(), resolved.getTaxon(), leaf));
                    cell.setForeground(BaseTaxonBrowserPanel.this.deriveTaxonForeground(this.getForeground(), resolved.getTaxon(), leaf, selected, value));
                }
            } else if (value instanceof ResolvedWithKey) {
                ResolvedWithKey resolvedWithKey = (ResolvedWithKey)value;
                if (resolvedWithKey.getResolved().getType() == SightingTaxon.Type.SINGLE) {
                    cell.setFont(BaseTaxonBrowserPanel.this.deriveTaxonFont(cell.getFont(), resolvedWithKey.getResolved().getTaxon(), leaf));
                    cell.setForeground(BaseTaxonBrowserPanel.this.deriveTaxonForeground(this.getForeground(), resolvedWithKey.getResolved().getTaxon(), leaf, selected, value));
                }
            } else if (value instanceof ResolvedWithSighting) {
                ResolvedWithSighting resolvedWithSighting = (ResolvedWithSighting)value;
                if (resolvedWithSighting.getResolved().getType() == SightingTaxon.Type.SINGLE) {
                    cell.setFont(BaseTaxonBrowserPanel.this.deriveTaxonFont(cell.getFont(), resolvedWithSighting.getResolved().getTaxon(), leaf));
                    cell.setForeground(BaseTaxonBrowserPanel.this.deriveTaxonForeground(this.getForeground(), resolvedWithSighting.getResolved().getTaxon(), leaf, selected, value));
                }
            } else if (value instanceof Taxon) {
                Taxon taxon = (Taxon)value;
                cell.setFont(BaseTaxonBrowserPanel.this.deriveTaxonFont(cell.getFont(), taxon, leaf));
                cell.setForeground(BaseTaxonBrowserPanel.this.deriveTaxonForeground(this.getForeground(), taxon, leaf, selected, value));
            } else {
                cell.setFont(BaseTaxonBrowserPanel.this.deriveOtherFont(cell.getFont(), value));
            }
            return cell;
        }
    }

    protected class PasteActionWrapper
    extends ForwardingAction
    implements Attachable,
    FlavorListener,
    TreeSelectionListener {
        public PasteActionWrapper(Action wrapped) {
            super(BaseTaxonBrowserPanel.this, wrapped);
        }

        @Override
        public void attach() {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.addFlavorListener(this);
            BaseTaxonBrowserPanel.this.getSelectionModel().addTreeSelectionListener(this);
            this.updateEnabled();
        }

        private void updateEnabled() {
            this.setEnabled(this.pasteAvailable());
        }

        private boolean pasteAvailable() {
            if (!BaseTaxonBrowserPanel.this.canImportSightings()) {
                return false;
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                if (!clipboard.isDataFlavorAvailable(SightingsGroup.FLAVOR)) {
                    return false;
                }
            }
            catch (IllegalStateException e) {
                return false;
            }
            TreePath[] paths = BaseTaxonBrowserPanel.this.getSelectionPaths();
            if (paths == null || paths.length != 1) {
                return false;
            }
            TreePath path = paths[0];
            return BaseTaxonBrowserPanel.this.canImportSightingsToPath(path);
        }

        @Override
        public void unattach() {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.removeFlavorListener(this);
            BaseTaxonBrowserPanel.this.getSelectionModel().removeTreeSelectionListener(this);
        }

        @Override
        public void flavorsChanged(FlavorEvent e) {
            this.updateEnabled();
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.updateEnabled();
        }
    }

    protected class CopyActionWrapper
    extends ForwardingAction
    implements Attachable,
    TreeSelectionListener {
        public CopyActionWrapper(Action wrapped) {
            super(BaseTaxonBrowserPanel.this, wrapped);
        }

        @Override
        public void attach() {
            BaseTaxonBrowserPanel.this.getSelectionModel().addTreeSelectionListener(this);
            this.updateEnabled();
        }

        @Override
        public void unattach() {
            BaseTaxonBrowserPanel.this.getSelectionModel().removeTreeSelectionListener(this);
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            this.updateEnabled();
        }

        private void updateEnabled() {
            this.setEnabled(this.hasText(BaseTaxonBrowserPanel.this.getSelectionPaths()));
        }

        private boolean hasText(TreePath[] paths) {
            if (paths == null) {
                return false;
            }
            for (TreePath path : paths) {
                if (!BaseTaxonBrowserPanel.this.getPathText(path).isPresent()) continue;
                return true;
            }
            return false;
        }
    }

    protected class CutActionWrapper
    extends ForwardingAction
    implements Attachable,
    TreeSelectionListener {
        public CutActionWrapper(Action wrapped) {
            super(BaseTaxonBrowserPanel.this, wrapped);
        }

        @Override
        public void attach() {
            BaseTaxonBrowserPanel.this.getSelectionModel().addTreeSelectionListener(this);
            this.updateEnabled();
        }

        @Override
        public void unattach() {
            BaseTaxonBrowserPanel.this.getSelectionModel().removeTreeSelectionListener(this);
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            this.updateEnabled();
        }

        private void updateEnabled() {
            this.setEnabled(BaseTaxonBrowserPanel.this.canMoveSightings() && BaseTaxonBrowserPanel.this.hasSightingsGroup(BaseTaxonBrowserPanel.this.getSelectionPaths()));
        }
    }

    static class ReturnToPanel
    extends AbstractAction {
        private final NavigableFrame navigableFrame;
        private final String panelName;
        private final PostNavigateAction postNavigateAction;

        ReturnToPanel(NavigableFrame navigableFrame, String panelName, PostNavigateAction postNavigateAction) {
            this.navigableFrame = navigableFrame;
            this.panelName = panelName;
            this.postNavigateAction = postNavigateAction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel panel = this.navigableFrame.navigateTo(this.panelName);
            if (panel != null) {
                this.postNavigateAction.postNavigate(panel);
            }
        }
    }

    public static interface PostNavigateAction {
        public void postNavigate(JPanel var1);
    }

    protected class TaxonTransferHandler
    extends TransferHandler {
        protected TaxonTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            StringSelection textTransferable;
            BaseTaxonBrowserPanel.this.saveCurrentPreview();
            TreePath[] paths = BaseTaxonBrowserPanel.this.getSelectionPaths();
            if (paths == null || paths.length == 0) {
                return null;
            }
            String pathsAsText = Stream.of(paths).sorted(BaseTaxonBrowserPanel.this::comparePaths).map(BaseTaxonBrowserPanel.this::getPathText).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n"));
            SightingsGroup sightings = this.getSightingsGroup(paths);
            StringSelection stringSelection = textTransferable = pathsAsText.isEmpty() ? null : new StringSelection(pathsAsText);
            if (sightings == null) {
                return textTransferable;
            }
            return new SightingTransferable(sightings, textTransferable);
        }

        @Override
        public int getSourceActions(JComponent component) {
            TreePath[] paths = BaseTaxonBrowserPanel.this.getSelectionPaths();
            SightingsGroup sightings = this.getSightingsGroup(paths);
            if (sightings == null) {
                return 1;
            }
            return BaseTaxonBrowserPanel.this.canMoveSightings() ? 3 : 1;
        }

        @Override
        public boolean canImport(JComponent component, DataFlavor[] flavors) {
            throw new UnsupportedOperationException("Legacy canImport() not supported");
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            if (!BaseTaxonBrowserPanel.this.canImportSightings()) {
                return false;
            }
            if (!transferSupport.isDataFlavorSupported(SightingsGroup.FLAVOR)) {
                return false;
            }
            TreePath target = this.getDropTarget(transferSupport);
            if (target == null) {
                return false;
            }
            SightingsGroup sightings = this.getSighting(transferSupport);
            if (sightings == null) {
                return false;
            }
            return BaseTaxonBrowserPanel.this.canImportSightings(transferSupport, target, sightings);
        }

        private SightingsGroup getSighting(TransferHandler.TransferSupport transferSupport) {
            return SightingsGroup.fromTransferable(transferSupport.getTransferable());
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            if (action == 0) {
                return;
            }
            if (action == 2 && data.isDataFlavorSupported(SightingsGroup.FLAVOR)) {
                SightingsGroup sightings = SightingsGroup.fromTransferable(data);
                BaseTaxonBrowserPanel.this.doMove(sightings);
            }
        }

        @Override
        public boolean importData(JComponent component, Transferable data) {
            throw new UnsupportedOperationException("Legacy importData() not supported.");
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (!this.canImport(transferSupport)) {
                return false;
            }
            SightingsGroup sightings = this.getSighting(transferSupport);
            TreePath target = this.getDropTarget(transferSupport);
            BaseTaxonBrowserPanel.this.doImport(transferSupport, sightings, target);
            return true;
        }

        private TreePath getDropTarget(TransferHandler.TransferSupport transferSupport) {
            if (!transferSupport.isDrop()) {
                TreePath[] paths = BaseTaxonBrowserPanel.this.getSelectionPaths();
                if (paths == null || paths.length != 1) {
                    return null;
                }
                return paths[0];
            }
            Point locationInBrowser = SwingUtilities.convertPoint(transferSupport.getComponent(), transferSupport.getDropLocation().getDropPoint(), BaseTaxonBrowserPanel.this);
            TreePath path = BaseTaxonBrowserPanel.this.getPathForLocation(locationInBrowser.x, locationInBrowser.y);
            if (path == null) {
                return null;
            }
            Rectangle bounds = BaseTaxonBrowserPanel.this.getPathBounds(path);
            if (bounds == null) {
                return null;
            }
            if (!bounds.contains(locationInBrowser)) {
                return null;
            }
            return path;
        }

        private SightingsGroup getSightingsGroup(TreePath[] paths) {
            ImmutableList.Builder sightingsBuilder = ImmutableList.builder();
            ImmutableList.Builder originalIndices = ImmutableList.builder();
            if (paths == null || paths.length == 0) {
                return null;
            }
            TreePath firstPath = paths[0];
            Object commonParent = firstPath.getParentPath().getLastPathComponent();
            for (TreePath path : paths) {
                Object last = path.getLastPathComponent();
                if (last instanceof Sighting) {
                    Sighting s = (Sighting)last;
                    sightingsBuilder.add(s);
                } else if (last instanceof ResolvedWithSighting) {
                    ResolvedWithSighting rws = (ResolvedWithSighting)last;
                    sightingsBuilder.add(rws.getSighting());
                } else if (last instanceof ResolvedWithKey) {
                    ResolvedWithKey rwk = (ResolvedWithKey)last;
                    List<Sighting> rwkSightings = BaseTaxonBrowserPanel.this.getSightingsForResolvedWithKey(rwk);
                    if (rwkSightings.size() != 1) {
                        return null;
                    }
                    sightingsBuilder.add(rwkSightings.get(0));
                } else {
                    return null;
                }
                Object parent = path.getParentPath().getLastPathComponent();
                if (!parent.equals(commonParent)) {
                    throw new IllegalStateException("Multiple sightings from different parents");
                }
                originalIndices.add((Object)BaseTaxonBrowserPanel.this.getModel().getIndexOfChild(parent, last));
            }
            ImmutableCollection sightings = sightingsBuilder.build();
            LinkedHashMap<VisitInfoKey, VisitInfo> visitInfoMap = Maps.newLinkedHashMap();
            for (Sighting sighting : sightings) {
                VisitInfo visitInfo;
                VisitInfoKey key = VisitInfoKey.forSighting(sighting);
                if (key == null || (visitInfo = BaseTaxonBrowserPanel.this.reportSet.getVisitInfo(key)) == null) continue;
                visitInfoMap.put(key, visitInfo);
            }
            return new SightingsGroup((ImmutableList<Sighting>)sightings, ImmutableMap.copyOf(visitInfoMap), (ImmutableList<Integer>)originalIndices.build(), paths[0].getParentPath());
        }
    }
}

