/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.backup;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.backup.BackupFrequency;
import com.scythebill.birdlist.ui.backup.BackupPreferences;
import com.scythebill.birdlist.ui.backup.BackupSaver;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.prefs.PreferencesManager;
import com.scythebill.birdlist.ui.util.Alerts;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class BegForBackups {
    private static final int MIN_SIZE_TO_BEG = 1000;
    private final BackupPreferences backupPreferences;
    private final BackupSaver backupSaver;
    private final Alerts alerts;
    private static final AtomicBoolean alreadyBegged = new AtomicBoolean(false);

    @Inject
    public BegForBackups(PreferencesManager preferencesManager, BackupSaver backupSaver, Alerts alerts) {
        this.backupPreferences = preferencesManager.getPreference(BackupPreferences.class);
        this.backupSaver = backupSaver;
        this.alerts = alerts;
    }

    public void check(ReportSet reportSet, File file) {
        if (this.backupPreferences.frequency != BackupFrequency.NEVER && this.backupPreferences.backupDirectory != null) {
            return;
        }
        if (reportSet.getSightings().size() < 1000) {
            return;
        }
        Instant nextTimeToBeg = new Instant(this.backupPreferences.nextTimeToBeg);
        if (nextTimeToBeg.isAfterNow()) {
            return;
        }
        if (alreadyBegged.getAndSet(true)) {
            return;
        }
        int option = this.alerts.showWithOptions(null, Messages.Name.BACKUP_BEG_TITLE, Messages.Name.BACKUP_BEG_MESSAGE, new Object[]{Messages.Name.OK_BUTTON, Messages.Name.ASK_ME_LATER, Messages.Name.DONT_ASK_AGAIN});
        if (option == -1 || option == 1) {
            nextTimeToBeg = new Instant().plus(Duration.standardDays(7L));
            this.backupPreferences.nextTimeToBeg = nextTimeToBeg.getMillis();
        } else if (option == 2) {
            this.backupPreferences.nextTimeToBeg = Long.MAX_VALUE;
        } else if (this.backupSaver.chooseBackupDirectory(null, file)) {
            this.backupSaver.maybeSaveAll();
        }
    }
}

