/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.backup;

import com.google.common.base.Preconditions;
import com.google.common.html.HtmlEscapers;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.xml.XmlReportSetExport;
import com.scythebill.birdlist.ui.backup.BackupFrequency;
import com.scythebill.birdlist.ui.backup.BackupPreferences;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.prefs.PreferencesManager;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.chrono.GJChronology;

@Singleton
public class BackupSaver {
    private final ListeningScheduledExecutorService executorService;
    private final BackupPreferences backupPreferences;
    private final CopyOnWriteArrayList<BackupEntry> entries = new CopyOnWriteArrayList();
    private final Alerts alerts;
    private final FileDialogs fileDialogs;
    private Instant lastWarnedOfBackupError;
    private Instant lastWarnedOfInvalidBackupDirectory;
    private static final int ERROR_COUNT_TO_START_WARNING = 2;

    @Inject
    BackupSaver(PreferencesManager preferencesManager, ListeningScheduledExecutorService executorService, Alerts alerts, FileDialogs fileDialogs) {
        this.alerts = alerts;
        this.fileDialogs = fileDialogs;
        this.backupPreferences = preferencesManager.getPreference(BackupPreferences.class);
        this.executorService = executorService;
    }

    public Closeable initiateBackup(ReportSet reportSet, File file) {
        BackupEntry backupEntry = new BackupEntry(reportSet, file);
        BackupResult backupResult = backupEntry.maybeWriteNow(false);
        backupEntry.maybeSchedule(backupResult);
        this.entries.add(backupEntry);
        return () -> {
            backupEntry.close();
            this.entries.remove(backupEntry);
        };
    }

    public void saveNow(ReportSet reportSet, File file) {
        BackupEntry backupEntry = new BackupEntry(reportSet, file);
        backupEntry.maybeWriteNow(true);
    }

    public void maybeSaveAll() {
        for (BackupEntry entry : this.entries) {
            BackupResult result = entry.maybeWriteNow(false);
            entry.maybeSchedule(result);
        }
    }

    public void definitelySaveAll() {
        for (BackupEntry entry : this.entries) {
            BackupResult result = entry.maybeWriteNow(true);
            entry.maybeSchedule(result);
        }
    }

    public boolean backupsAreEnabled() {
        if (this.backupPreferences.frequency == BackupFrequency.NEVER) {
            return false;
        }
        if (this.backupPreferences.backupDirectory == null) {
            return false;
        }
        File directory = new File(this.backupPreferences.backupDirectory);
        return directory.exists() && directory.isDirectory();
    }

    public boolean chooseBackupDirectory(Component component, File reportSetFile) {
        File file;
        File current = null;
        if (this.backupPreferences.backupDirectory != null) {
            current = new File(this.backupPreferences.backupDirectory);
            if (!current.exists()) {
                current = null;
            } else if (!current.isDirectory()) {
                current = current.getParentFile();
            }
        }
        while (true) {
            if ((file = this.fileDialogs.openDirectory(UIUtils.findFrame(component), Messages.getMessage(Messages.Name.CHOOSE_A_BACKUP_DIRECTORY), current, FilePreferences.FileType.BACKUPS)) == null) {
                return false;
            }
            if (!file.isDirectory() && (file = file.getParentFile()) == null) {
                return false;
            }
            try {
                File tempFile = File.createTempFile("scythebill", "tmp", file);
                tempFile.delete();
            }
            catch (IOException e) {
                this.alerts.showError((Object)component, Messages.Name.COULD_NOT_WRITE_INTO_DIRECTORY_TITLE, Messages.Name.COULD_NOT_WRITE_INTO_DIRECTORY_FORMAT, HtmlEscapers.htmlEscaper().escape(file.getName()));
                continue;
            }
            break;
        }
        this.backupPreferences.backupDirectory = file.getAbsolutePath();
        if (this.backupPreferences.backupDirectory.equals(reportSetFile.getParentFile().getAbsolutePath())) {
            this.alerts.showMessage((Object)component, Messages.Name.PLEASE_RECONSIDER, Messages.Name.SAME_FOLDER_IS_NOT_SAFE, new Object[0]);
        }
        if (this.backupPreferences.frequency == BackupFrequency.NEVER) {
            this.backupPreferences.frequency = BackupFrequency.MONTHLY;
        }
        return true;
    }

    class BackupEntry {
        private final ReportSet reportSet;
        private final String fileName;
        private final File file;
        private volatile ListenableScheduledFuture<?> scheduledTask;
        private volatile boolean closed;
        private volatile int errorCount;

        BackupEntry(ReportSet reportSet, File file) {
            this.reportSet = reportSet;
            this.file = file;
            String fileName = file.getName();
            if (fileName.endsWith(".bsxm")) {
                fileName = fileName.substring(0, fileName.length() - ".bsxm".length());
            }
            this.fileName = fileName;
        }

        void close() {
            this.closed = true;
            ListenableScheduledFuture<?> scheduledTask = this.scheduledTask;
            if (scheduledTask != null) {
                scheduledTask.cancel(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(boolean forceAWrite) throws IOException {
            File directory;
            if (BackupSaver.this.backupPreferences.backupDirectory != null && (directory = new File(BackupSaver.this.backupPreferences.backupDirectory)).exists() && directory.isDirectory()) {
                LocalDate localDate = new LocalDate(GJChronology.getInstance());
                File backupFile = null;
                for (int i = 0; i < 100; ++i) {
                    File possibleBackupFile = this.backupFileName(directory, localDate, i);
                    if (!possibleBackupFile.exists()) {
                        backupFile = possibleBackupFile;
                        break;
                    }
                    if (forceAWrite) continue;
                    return;
                }
                if (backupFile != null) {
                    FileOutputStream backupOut = new FileOutputStream(backupFile);
                    ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(backupOut));
                    ZipEntry entry = new ZipEntry(this.fileName + "-backup.bsxm");
                    zipOut.putNextEntry(entry);
                    XmlReportSetExport export = new XmlReportSetExport();
                    BufferedWriter out = null;
                    try {
                        out = new BufferedWriter(new OutputStreamWriter((OutputStream)zipOut, StandardCharsets.UTF_8));
                        export.export(out, "UTF-8", this.reportSet, this.reportSet.getTaxonomy());
                        ((Writer)out).flush();
                        zipOut.closeEntry();
                    }
                    finally {
                        if (out != null) {
                            zipOut.close();
                        }
                    }
                }
            }
        }

        BackupResult maybeWriteNow(boolean forceAWrite) {
            BackupResult needsBackup;
            if (this.closed) {
                return BackupResult.NOT_NEEDED;
            }
            if (!forceAWrite && this.reportSet.getSightings().isEmpty()) {
                return BackupResult.NOT_NEEDED;
            }
            BackupResult backupResult = needsBackup = forceAWrite ? BackupResult.NEEDED : this.needsBackup();
            if (needsBackup == BackupResult.NEEDED) {
                try {
                    this.write(forceAWrite);
                    this.errorCount = 0;
                }
                catch (IOException e) {
                    if (++this.errorCount > 2 || forceAWrite) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (BackupSaver.this.lastWarnedOfBackupError == null || BackupSaver.this.lastWarnedOfBackupError.plus(Duration.standardDays(1L)).isBeforeNow()) {
                                    BackupSaver.this.lastWarnedOfBackupError = new Instant();
                                    BackupSaver.this.alerts.showError(null, Messages.Name.ERROR_BACKING_UP_TITLE, Messages.Name.ERROR_BACKING_UP_FORMAT, HtmlEscapers.htmlEscaper().escape(BackupEntry.this.file.getName()));
                                }
                            }
                        });
                    }
                    needsBackup = BackupResult.ERROR;
                }
            }
            return needsBackup;
        }

        private BackupResult needsBackup() {
            LocalDate today;
            if (BackupSaver.this.backupPreferences.frequency == BackupFrequency.NEVER) {
                return BackupResult.NOT_NEEDED;
            }
            if (BackupSaver.this.backupPreferences.backupDirectory == null) {
                return BackupResult.NOT_NEEDED;
            }
            final File directory = new File(BackupSaver.this.backupPreferences.backupDirectory);
            if (!directory.exists() || !directory.isDirectory()) {
                if (++this.errorCount > 2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (BackupSaver.this.lastWarnedOfInvalidBackupDirectory == null || BackupSaver.this.lastWarnedOfInvalidBackupDirectory.plus(Duration.standardDays(1L)).isBeforeNow()) {
                                BackupSaver.this.lastWarnedOfInvalidBackupDirectory = new Instant();
                                BackupSaver.this.alerts.showError(null, Messages.Name.ERROR_BACKING_UP_TITLE, Messages.Name.BACKUP_DIRECTORY_NOT_FOUND_FORMAT, HtmlEscapers.htmlEscaper().escape(directory.getName()));
                            }
                        }
                    });
                }
                return BackupResult.ERROR;
            }
            if (this.file.getParentFile().getAbsolutePath().equals(BackupSaver.this.backupPreferences.backupDirectory) && this.file.getName().contains("-backup-")) {
                return BackupResult.NOT_NEEDED;
            }
            LocalDate date = today = new LocalDate(GJChronology.getInstance());
            if (BackupSaver.this.backupPreferences.frequency == BackupFrequency.OBSESSIVELY) {
                return BackupResult.NEEDED;
            }
            if (BackupSaver.this.backupPreferences.frequency == BackupFrequency.WEEKLY) {
                for (int i = 0; i < 7; ++i) {
                    File backupFile = this.backupFileName(directory, date, 0);
                    if (backupFile.exists()) {
                        return BackupResult.NOT_NEEDED;
                    }
                    date = date.minusDays(1);
                }
                return BackupResult.NEEDED;
            }
            Preconditions.checkState(BackupSaver.this.backupPreferences.frequency == BackupFrequency.MONTHLY);
            int todaysMonth = today.getMonthOfYear();
            while (date.getMonthOfYear() == todaysMonth) {
                File backupFile = this.backupFileName(directory, date, 0);
                if (backupFile.exists()) {
                    return BackupResult.NOT_NEEDED;
                }
                date = date.minusDays(1);
            }
            return BackupResult.NEEDED;
        }

        void maybeSchedule(BackupResult backupResult) {
            Duration duration;
            if (this.closed) {
                return;
            }
            if (BackupSaver.this.backupPreferences.frequency == BackupFrequency.NEVER) {
                return;
            }
            if (BackupSaver.this.backupPreferences.frequency == BackupFrequency.OBSESSIVELY) {
                duration = BackupFrequency.OBSESSIVELY.duration();
            } else {
                Duration duration2 = duration = backupResult == BackupResult.ERROR ? Duration.standardMinutes((long)(5.0 * Math.pow(2.0, Math.min(this.errorCount, 4)))) : Duration.standardDays(1L);
            }
            if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
                this.scheduledTask.cancel(false);
            }
            this.scheduledTask = BackupSaver.this.executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    BackupEntry.this.scheduledTask = null;
                    BackupResult result = BackupEntry.this.maybeWriteNow(false);
                    BackupEntry.this.maybeSchedule(result);
                }
            }, duration.getMillis(), TimeUnit.MILLISECONDS);
        }

        private File backupFileName(File directory, LocalDate localDate, int attemptIndex) {
            String date = PartialIO.toString(localDate);
            String backupFileName = attemptIndex == 0 ? String.format("%s-backup-%s.zip", this.fileName, date) : String.format("%s-backup-%s-%d.zip", this.fileName, date, attemptIndex);
            File backupFile = new File(directory, backupFileName);
            return backupFile;
        }
    }

    static enum BackupResult {
        NOT_NEEDED,
        ERROR,
        NEEDED;

    }
}

