/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.app;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.TaxonomyImpl;
import com.scythebill.birdlist.model.taxa.names.LocalNames;
import com.scythebill.birdlist.model.taxa.names.NamesLoader;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.model.util.Progress;
import com.scythebill.birdlist.model.util.TaxonomyIndexer;
import com.scythebill.birdlist.ui.app.MappedTaxonomyLoader;
import com.scythebill.birdlist.ui.app.StartupView;
import com.scythebill.birdlist.ui.app.TaxonomyLoader;
import com.scythebill.birdlist.ui.app.TaxonomyReference;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.guice.IOC;
import com.scythebill.birdlist.ui.panels.VersionUpgradeNotice;
import com.scythebill.birdlist.ui.uptodate.UpToDateLoader;
import java.awt.EventQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

@Singleton
public class Startup {
    private final TaxonomyLoader taxonomyLoader;
    private final ListeningScheduledExecutorService executorService;
    private Future<Taxonomy> taxonomyFuture;
    private Future<MappedTaxonomy> iocFuture;
    private Future<?> clementsIndices;
    private Future<?> iocIndices;
    private final StartupView startupView;
    private volatile boolean isStarting;
    private final UpToDateLoader upToDate;
    private final VersionUpgradeNotice upgradeNotice;
    private final TaxonomyReference iocRef;
    private final NamesLoader iocNamesLoader;
    private MappedTaxonomyLoader iocLoader;
    private NamesPreferences namesPreferences;

    @Inject
    public Startup(@Clements TaxonomyReference clementsRef, final @Clements NamesLoader clementsNamesLoader, @IOC TaxonomyReference iocRef, @IOC NamesLoader iocNamesLoader, NamesPreferences namesPreferences, ListeningScheduledExecutorService executorService, StartupView startupView, UpToDateLoader upToDate, VersionUpgradeNotice upgradeNotice) {
        this.namesPreferences = namesPreferences;
        this.taxonomyLoader = new TaxonomyLoader(clementsRef){

            @Override
            public Taxonomy call() throws Exception {
                Taxonomy taxonomy = super.call();
                ((TaxonomyImpl)taxonomy).setLocalNames(new LocalNames(clementsNamesLoader, Startup.this.namesPreferences, NamesPreferences.LocaleOption.CLEMENTS));
                return taxonomy;
            }
        };
        this.iocRef = iocRef;
        this.iocNamesLoader = iocNamesLoader;
        this.executorService = executorService;
        this.startupView = startupView;
        this.upToDate = upToDate;
        this.upgradeNotice = upgradeNotice;
    }

    public synchronized void init() {
        this.taxonomyFuture = this.executorService.submit((Callable)this.taxonomyLoader);
        this.iocLoader = new MappedTaxonomyLoader(this.iocRef, this.taxonomyFuture){

            @Override
            public MappedTaxonomy call() throws Exception {
                MappedTaxonomy loaded = super.call();
                loaded.setLocalNames(new LocalNames(Startup.this.iocNamesLoader, Startup.this.namesPreferences, NamesPreferences.LocaleOption.IOC));
                return loaded;
            }
        };
        this.iocFuture = this.executorService.submit((Callable)this.iocLoader);
        Runnable checkUpToDate = new Runnable(){

            @Override
            public void run() {
                ListenableFuture<ImmutableList<UpToDateLoader.VersionInfo>> upToDateFuture = Startup.this.upToDate.load();
                Futures.addCallback(upToDateFuture, new FutureCallback<ImmutableList<UpToDateLoader.VersionInfo>>(){

                    @Override
                    public void onFailure(Throwable t) {
                        throw new RuntimeException(t);
                    }

                    @Override
                    public void onSuccess(ImmutableList<UpToDateLoader.VersionInfo> versionInfo) {
                        if (!versionInfo.isEmpty()) {
                            SwingUtilities.invokeLater(() -> Startup.this.upgradeNotice.showUpgrade(versionInfo));
                        }
                    }
                }, Startup.this.executorService);
            }
        };
        ScheduledFuture unused = this.executorService.scheduleAtFixedRate(checkUpToDate, 0L, 1L, TimeUnit.DAYS);
    }

    public synchronized void start(final Runnable onTaxonomyLoaded) {
        TaxonomyIndexer clementsIndexer = new TaxonomyIndexer(this.taxonomyFuture);
        this.clementsIndices = clementsIndexer.load(this.executorService);
        TaxonomyIndexer iocIndexer = new TaxonomyIndexer(this.iocFuture);
        this.iocIndices = iocIndexer.load(this.executorService);
        this.startupView.addProgress(this.taxonomyLoader, 0.3);
        this.startupView.addProgress(this.iocLoader, 0.3);
        this.startupView.addProgress(clementsIndexer.getCommonIndexLoader(), 0.1);
        this.startupView.addProgress(clementsIndexer.getScientificIndexLoader(), 0.1);
        this.startupView.addProgress(iocIndexer.getCommonIndexLoader(), 0.1);
        this.startupView.addProgress(iocIndexer.getScientificIndexLoader(), 0.1);
        this.startupView.start();
        Future unused = this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Startup.this.taxonomyFuture.get();
                Startup.this.clementsIndices.get();
                Startup.this.iocIndices.get();
                EventQueue.invokeLater(onTaxonomyLoaded);
                return null;
            }
        });
        this.isStarting = true;
    }

    public void addProgress(Progress progress, double fraction) {
        this.startupView.addProgress(progress, fraction);
    }

    public void finish() {
        if (this.isStarting) {
            this.startupView.stop();
            this.isStarting = false;
        }
    }

    public boolean isStarting() {
        return this.isStarting;
    }

    public Module constructedObjectsModule() {
        return new AbstractModule(){

            @Override
            protected void configure() {
                try {
                    this.bind(Taxonomy.class).annotatedWith(Clements.class).toInstance(Startup.this.taxonomyFuture.get());
                    this.bind(MappedTaxonomy.class).annotatedWith(IOC.class).toInstance(Startup.this.iocFuture.get());
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public synchronized Future<Taxonomy> getTaxonomyFuture() {
        return this.taxonomyFuture;
    }

    public synchronized Future<? extends Taxonomy> getIocTaxonomyFuture() {
        return this.iocFuture;
    }

    public synchronized Taxonomy getTaxonomy() {
        Preconditions.checkState(this.taxonomyFuture.isDone());
        try {
            return this.taxonomyFuture.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

