/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.app;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.AndDirty;
import com.scythebill.birdlist.model.util.Dirty;
import com.scythebill.birdlist.model.util.DirtyProxy;
import com.scythebill.birdlist.model.xml.XmlReportSetExport;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.logging.Logger;

public class ReportSetSaver {
    private static final Logger logger = Logger.getLogger(ReportSetSaver.class.getName());
    private static final long MODIFICATION_LEEWAY_MILLIS = 5000L;
    private final String filename;
    private final ReportSet reportSet;
    private final Supplier<Taxonomy> taxonomySupplier;
    private long lastModifiedMillis;
    private final DirtyProxy editorDirtyProxy;
    private final AndDirty dirty;
    private Editor editor;

    @Inject
    public ReportSetSaver(ReportSet reportSet, @Clements Supplier<Taxonomy> taxonomySupplier, @Named(value="com.adamwiner.birdlist.ui.reportFile") String filename) {
        this.reportSet = reportSet;
        this.taxonomySupplier = taxonomySupplier;
        this.filename = filename;
        this.lastModifiedMillis = new File(filename).lastModified();
        this.editorDirtyProxy = new DirtyProxy();
        this.dirty = new AndDirty(reportSet.getDirty(), this.editorDirtyProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportSet save() throws IOException {
        if (this.editor != null) {
            this.editor.beforeSave();
        }
        File tmpOutFile = this.tmpFile();
        File temp2 = this.tmp2File();
        try {
            if (!tmpOutFile.createNewFile()) {
                logger.info("Temporary file already existed:" + tmpOutFile);
            }
            this.writeFile(tmpOutFile);
            File originalFile = new File(this.filename);
            this.copyCreationTimestamp(originalFile, tmpOutFile);
            if (temp2.exists() && !temp2.delete()) {
                logger.warning("Couldn't delete temporary file - swap may fail");
            }
            if (!originalFile.renameTo(temp2)) {
                throw new IOException("Could not rename the original file to " + temp2.getName());
            }
            if (!tmpOutFile.renameTo(originalFile)) {
                throw new IOException("Could not rename the temporary swap file to " + originalFile.getName());
            }
            this.reportSet.clearDirty();
            if (!temp2.delete()) {
                logger.info("Delete failed");
            }
            this.updateLastModifiedTimestampToNow();
        }
        catch (IOException e) {
            try {
                tmpOutFile.delete();
                temp2.delete();
                this.writeFile(new File(this.filename));
                this.reportSet.clearDirty();
                this.updateLastModifiedTimestampToNow();
            }
            catch (IOException finalException) {
                finalException.initCause(e);
                if (UIUtils.isWindows() && finalException instanceof FileNotFoundException && finalException.getMessage() != null && finalException.getMessage().contains("Access is denied")) {
                    throw new WindowsPermissionException(new File(this.filename), finalException);
                }
                throw finalException;
            }
            ReportSet reportSet = this.reportSet;
            return reportSet;
        }
        finally {
            this.tmpFile().delete();
            this.tmp2File().delete();
        }
        this.updateLastModifiedTimestampToNow();
        return this.reportSet;
    }

    public Dirty getDirty() {
        return this.dirty;
    }

    public void attachEditor(Editor editor) {
        Preconditions.checkState(this.editor == null, "Editor already attached, not released");
        this.editor = Preconditions.checkNotNull(editor);
        this.editorDirtyProxy.setProxiedDirty(editor.getDirty());
    }

    public void releaseEditor() {
        Preconditions.checkState(this.editor != null, "Editor not attached");
        this.editor = null;
        this.editorDirtyProxy.setProxiedDirty(null);
    }

    public File file() {
        return new File(this.filename);
    }

    public boolean beforeNavigation() {
        if (this.editor == null) {
            return true;
        }
        return !this.editor.getDirty().isDirty() || this.editor.beforeNavigation();
    }

    public boolean hasBeenModifiedElsewhere() {
        long newLastModifiedMillis = new File(this.filename).lastModified();
        if (newLastModifiedMillis > this.lastModifiedMillis + 5000L) {
            this.lastModifiedMillis = newLastModifiedMillis;
            return true;
        }
        return false;
    }

    private void updateLastModifiedTimestampToNow() {
        this.lastModifiedMillis = Math.max(System.currentTimeMillis(), new File(this.filename).lastModified());
    }

    private void copyCreationTimestamp(File from, File to) {
        try {
            BasicFileAttributeView fromAttributes = Files.getFileAttributeView(Paths.get(from.getAbsolutePath(), new String[0]), BasicFileAttributeView.class, new LinkOption[0]);
            FileTime fromCreationTime = fromAttributes.readAttributes().creationTime();
            BasicFileAttributeView toAttributes = Files.getFileAttributeView(Paths.get(to.getAbsolutePath(), new String[0]), BasicFileAttributeView.class, new LinkOption[0]);
            toAttributes.setTimes(null, null, fromCreationTime);
        }
        catch (IOException e) {
            logger.info("Can't clone creation times: " + e.getMessage());
        }
    }

    private File tmpFile() {
        return new File(this.filename + ".tmp");
    }

    private File tmp2File() {
        return new File(this.filename + ".tmp2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File tmpOutFile) throws IOException {
        XmlReportSetExport rse = new XmlReportSetExport();
        FileOutputStream output = new FileOutputStream(tmpOutFile);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8));){
            rse.export(writer, StandardCharsets.UTF_8.name(), this.reportSet, Preconditions.checkNotNull(this.taxonomySupplier.get()));
        }
    }

    public static interface Editor {
        public Dirty getDirty();

        public void beforeSave();

        public boolean beforeNavigation();
    }

    public class WindowsPermissionException
    extends IOException {
        private final File file;

        WindowsPermissionException(File file, IOException e) {
            super(e);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }

    class UnsafeSaveException
    extends IOException {
        UnsafeSaveException(IOException e) {
            super("Saved " + ReportSetSaver.this.filename + ", but unsafely.", e);
        }
    }
}

