/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.app;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.ChecklistResolution;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.ClementsChecklist;
import com.scythebill.birdlist.model.io.ProgressInputStream;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.upgrades.OneTimeUpgradeProcessor;
import com.scythebill.birdlist.model.taxa.CompletedUpgrade;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.TaxonomyImpl;
import com.scythebill.birdlist.model.taxa.TaxonomyMappings;
import com.scythebill.birdlist.model.taxa.names.LocalNames;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.model.util.Progress;
import com.scythebill.birdlist.model.util.TaxonomyIndexer;
import com.scythebill.birdlist.model.xml.XmlReportSetImport;
import com.scythebill.birdlist.ui.events.TaxonomyPreferences;
import com.scythebill.birdlist.ui.prefs.ReportPreferencesManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.io.input.BOMInputStream;

public class ReportSetLoader
implements Callable<ReportSet>,
Progress {
    private final File file;
    private final long size;
    private final Future<Taxonomy> taxonomyFuture;
    private volatile ProgressInputStream progressStream;
    private final TaxonomyMappings mappings;
    private final Future<? extends Taxonomy> iocFuture;
    private final NamesPreferences namesPreferences;
    private OneTimeUpgradeProcessor oneTimeUpgradeProcessor;
    private final Checklists checklists;

    public ReportSetLoader(File file, Future<Taxonomy> future, Future<? extends Taxonomy> iocFuture, TaxonomyMappings mappings, Checklists checklists, NamesPreferences namesPreferences, OneTimeUpgradeProcessor oneTimeUpgradeProcessor) {
        this.namesPreferences = namesPreferences;
        this.oneTimeUpgradeProcessor = oneTimeUpgradeProcessor;
        this.file = Preconditions.checkNotNull(file);
        this.taxonomyFuture = Preconditions.checkNotNull(future);
        this.iocFuture = Preconditions.checkNotNull(iocFuture);
        this.mappings = mappings;
        this.checklists = checklists;
        this.size = file.length();
    }

    @Override
    public ReportSet call() throws Exception {
        ReportSet reportSet;
        Taxonomy taxonomy = this.taxonomyFuture.get();
        MappedTaxonomy iocTaxonomy = (MappedTaxonomy)this.iocFuture.get();
        this.progressStream = new ProgressInputStream(((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(new FileInputStream(this.file))).get());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.progressStream, StandardCharsets.UTF_8));){
            XmlReportSetImport rsi = new XmlReportSetImport();
            reportSet = rsi.importReportSet(reader, taxonomy, Optional.of(iocTaxonomy), this.mappings);
        }
        this.loadExtendedTaxonomyIndexers(reportSet);
        this.oneTimeUpgradeProcessor.upgradeReportSet(reportSet);
        if (reportSet.getCompletedUpgrade() == null) {
            this.computeIocUpgrade(reportSet, iocTaxonomy);
        } else {
            ImmutableSet<SightingTaxon> affectedIocSightingTaxa = this.affectedIocSightingTaxa(reportSet, iocTaxonomy);
            reportSet.getCompletedUpgrade().applyAdditionalSps(iocTaxonomy, affectedIocSightingTaxa);
        }
        return reportSet;
    }

    private void computeIocUpgrade(ReportSet reportSet, final MappedTaxonomy iocTaxonomy) throws IOException {
        ReportPreferencesManager reportPreferencesManager = new ReportPreferencesManager(reportSet, new Gson());
        TaxonomyPreferences.PerReportSet perReportSet = reportPreferencesManager.getPreference(TaxonomyPreferences.PerReportSet.class);
        final String lastIocVersion = this.getLastIocVersion(perReportSet);
        if (lastIocVersion != null && !lastIocVersion.equals(iocTaxonomy.getId())) {
            perReportSet.setLastIocVersion(iocTaxonomy);
            reportPreferencesManager.save(true);
            ImmutableSet<SightingTaxon> affectedSightingTaxa = this.mappings.getIocAffectedSightingTaxa(lastIocVersion);
            final ImmutableSet taxaFromReportSet = reportSet.getSightings().stream().map(Sighting::getTaxon).filter(affectedSightingTaxa::contains).collect(ImmutableSet.toImmutableSet());
            this.updateChecklistForIocUpgrade(reportSet, affectedSightingTaxa, iocTaxonomy);
            if (!taxaFromReportSet.isEmpty()) {
                reportSet.setCompletedUpgrade(new CompletedUpgrade(){

                    @Override
                    public Collection<SightingTaxon> warnings() {
                        return ImmutableSet.of();
                    }

                    @Override
                    public Collection<SightingTaxon> sps(Taxonomy taxonomy) {
                        return taxaFromReportSet;
                    }

                    @Override
                    public String getPreviousTaxonomyId() {
                        return lastIocVersion;
                    }

                    @Override
                    public String getNewTaxonomyName() {
                        return iocTaxonomy.getName();
                    }

                    @Override
                    public Taxonomy getForcedTaxonomy() {
                        return iocTaxonomy;
                    }

                    @Override
                    public void applyAdditionalSps(Taxonomy onlyForTaxonomy, ImmutableSet<SightingTaxon> additionalSps) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        }
    }

    private void updateChecklistForIocUpgrade(ReportSet reportSet, ImmutableSet<SightingTaxon> affectedSightingTaxa, MappedTaxonomy iocTaxonomy) {
        ChecklistResolution checklistResolution = new ChecklistResolution(this.checklists, ImmutableSet.of());
        for (Map.Entry<String, Checklist> checklistEntry : reportSet.checklists().entrySet()) {
            Location checklistLocation = reportSet.getLocations().getLocation(checklistEntry.getKey());
            Checklist builtInChecklist = this.checklists.getNearestBuiltInChecklist(iocTaxonomy, reportSet, checklistLocation);
            if (builtInChecklist == null) continue;
            Checklist customChecklist = checklistEntry.getValue();
            ImmutableSet affectedTaxaFromChecklist = customChecklist.getTaxa(iocTaxonomy.getBaseTaxonomy()).stream().filter(affectedSightingTaxa::contains).collect(ImmutableSet.toImmutableSet());
            if (affectedTaxaFromChecklist.isEmpty()) continue;
            LinkedHashMap<SightingTaxon, Checklist.Status> checklistMap = new LinkedHashMap<SightingTaxon, Checklist.Status>();
            for (SightingTaxon taxon : customChecklist.getTaxa(iocTaxonomy.getBaseTaxonomy())) {
                checklistMap.put(taxon, customChecklist.getStatus(iocTaxonomy.getBaseTaxonomy(), taxon));
            }
            for (SightingTaxon affectedTaxon : affectedTaxaFromChecklist) {
                Checklist.Status previousStatus;
                SightingTaxon maybeImproved = checklistResolution.resolveAgainstChecklist(iocTaxonomy, true, affectedTaxon, builtInChecklist);
                if (maybeImproved == null) continue;
                SightingTaxon.Resolved oldResolved = affectedTaxon.resolve(iocTaxonomy);
                SightingTaxon.Resolved newResolved = maybeImproved.resolve(iocTaxonomy);
                if (newResolved.getTaxa().size() >= oldResolved.getTaxa().size() || (previousStatus = (Checklist.Status)((Object)checklistMap.remove(affectedTaxon))) == null) continue;
                checklistMap.put(maybeImproved, previousStatus);
            }
            reportSet.setChecklist(checklistLocation, new ClementsChecklist(checklistMap));
        }
    }

    private ImmutableSet<SightingTaxon> affectedIocSightingTaxa(ReportSet reportSet, MappedTaxonomy iocTaxonomy) throws IOException {
        ReportPreferencesManager reportPreferencesManager = new ReportPreferencesManager(reportSet, new Gson());
        TaxonomyPreferences.PerReportSet perReportSet = reportPreferencesManager.getPreference(TaxonomyPreferences.PerReportSet.class);
        String lastIocVersion = this.getLastIocVersion(perReportSet);
        if (lastIocVersion == null || lastIocVersion.equals(iocTaxonomy.getId())) {
            return ImmutableSet.of();
        }
        perReportSet.setLastIocVersion(iocTaxonomy);
        reportPreferencesManager.save(true);
        ImmutableSet<SightingTaxon> affectedSightingTaxa = this.mappings.getIocAffectedSightingTaxa(lastIocVersion);
        return reportSet.getSightings().stream().map(Sighting::getTaxon).filter(affectedSightingTaxa::contains).collect(ImmutableSet.toImmutableSet());
    }

    private String getLastIocVersion(TaxonomyPreferences.PerReportSet perReportSet) {
        if (perReportSet != null) {
            return perReportSet.lastIocVersion();
        }
        return null;
    }

    private void loadExtendedTaxonomyIndexers(ReportSet reportSet) {
        for (Taxonomy taxonomy : reportSet.extendedTaxonomies()) {
            new TaxonomyIndexer(Futures.immediateFuture(taxonomy)).load(MoreExecutors.newDirectExecutorService());
            ((TaxonomyImpl)taxonomy).setLocalNames(LocalNames.trival(this.namesPreferences));
        }
    }

    @Override
    public long current() {
        return this.progressStream == null ? 0L : this.progressStream.getCurrentPosition();
    }

    @Override
    public long max() {
        return this.size;
    }
}

