/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.app;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Singleton
public class OtherFileLoaderRegistry {
    private final List<File> filesToProcess = Lists.newArrayList();
    private final List<ActionListener> listeners = Lists.newCopyOnWriteArrayList();

    @Inject
    OtherFileLoaderRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFiles(Collection<File> files) {
        OtherFileLoaderRegistry otherFileLoaderRegistry = this;
        synchronized (otherFileLoaderRegistry) {
            this.filesToProcess.addAll(files);
        }
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getAndClear() {
        ArrayList<File> files = Lists.newArrayList();
        OtherFileLoaderRegistry otherFileLoaderRegistry = this;
        synchronized (otherFileLoaderRegistry) {
            files.addAll(this.filesToProcess);
            this.filesToProcess.clear();
        }
        return files;
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }
}

