/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.app;

import com.scythebill.birdlist.model.io.ProgressInputStream;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.Progress;
import com.scythebill.birdlist.model.xml.XmlTaxonImport;
import com.scythebill.birdlist.ui.app.TaxonomyReference;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class MappedTaxonomyLoader
implements Callable<MappedTaxonomy>,
Progress {
    private volatile ProgressInputStream progressStream;
    private final Future<Taxonomy> baseTaxonomy;
    private final TaxonomyReference reference;

    public MappedTaxonomyLoader(TaxonomyReference reference, Future<Taxonomy> baseTaxonomy) {
        this.reference = reference;
        this.baseTaxonomy = baseTaxonomy;
    }

    @Override
    public MappedTaxonomy call() throws Exception {
        this.progressStream = new ProgressInputStream(this.reference.streamProvider.openStream());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.progressStream, Charset.forName("UTF-8")));){
            MappedTaxonomy mappedTaxonomy = new XmlTaxonImport().importMappedTaxa(reader, this.baseTaxonomy.get());
            return mappedTaxonomy;
        }
    }

    @Override
    public long current() {
        if (this.progressStream == null) {
            return 0L;
        }
        return this.progressStream.getCurrentPosition();
    }

    @Override
    public long max() {
        return this.reference.size;
    }
}

