/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.app;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.upgrades.OneTimeUpgradeProcessor;
import com.scythebill.birdlist.model.sighting.upgrades.UpgraderProcessing;
import com.scythebill.birdlist.model.taxa.CompletedUpgrade;
import com.scythebill.birdlist.model.taxa.TaxonomyMappings;
import com.scythebill.birdlist.model.taxa.UnsupportedTaxonomyException;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.model.xml.VersionTooNewException;
import com.scythebill.birdlist.ui.app.FrameFactory;
import com.scythebill.birdlist.ui.app.ReportSetLoader;
import com.scythebill.birdlist.ui.app.Startup;
import com.scythebill.birdlist.ui.backup.BackupSaver;
import com.scythebill.birdlist.ui.backup.BegForBackups;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.MainFrame;
import com.scythebill.birdlist.ui.panels.OpenOrNewListFrame;
import com.scythebill.birdlist.ui.panels.TaxonomyUpgradeNotice;
import com.scythebill.birdlist.ui.prefs.PreferencesManager;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@Singleton
public class FrameRegistry {
    private static final Logger logger = Logger.getLogger(FrameRegistry.class.getName());
    private final Map<String, LoadedFrame> frames = new MapMaker().makeMap();
    private final Map<String, LoadedFrame> framesBeingReloaded = new MapMaker().makeMap();
    private final Map<String, Boolean> framesInProgress = new MapMaker().makeMap();
    private final ListeningExecutorService executor;
    private final Startup startup;
    private final Injector globalInjector;
    private final FilePreferences filePreferences;
    private OpenOrNewListFrame openOrNewFrame;
    private final FrameFactory frameFactory;
    private final TaxonomyMappings taxonomyMappings;
    private final Checklists checklists;
    private final UpgraderProcessing upgraderProcessing;
    private final BackupSaver backupSaver;
    private final FontManager fontManager;
    private final PreferencesManager preferencesManager;
    private final FileDialogs fileDialogs;
    private final Alerts alerts;
    private final NamesPreferences namesPreferences;
    private OneTimeUpgradeProcessor oneTimeUpgradeProcessor;
    private BegForBackups begForBackups;

    @Inject
    public FrameRegistry(Injector globalInjector, Startup startup, ListeningExecutorService executor, PreferencesManager preferencesManager, FilePreferences filePreferences, NamesPreferences namesPreferences, FrameFactory frameFactory, BegForBackups begForBackups, BackupSaver backupSaver, TaxonomyMappings taxonomyMappings, UpgraderProcessing upgraderProcessing, OneTimeUpgradeProcessor oneTimeUpgradeProcessor, FontManager fontManager, Checklists checklists, FileDialogs fileDialogs, Alerts alerts) {
        this.globalInjector = globalInjector;
        this.startup = startup;
        this.executor = executor;
        this.preferencesManager = preferencesManager;
        this.filePreferences = filePreferences;
        this.namesPreferences = namesPreferences;
        this.frameFactory = frameFactory;
        this.begForBackups = begForBackups;
        this.backupSaver = backupSaver;
        this.taxonomyMappings = taxonomyMappings;
        this.upgraderProcessing = upgraderProcessing;
        this.oneTimeUpgradeProcessor = oneTimeUpgradeProcessor;
        this.fontManager = fontManager;
        this.checklists = checklists;
        this.fileDialogs = fileDialogs;
        this.alerts = alerts;
    }

    public void startLoadingReportSet(String newFilename, @Nullable Runnable onFailure) {
        LoadedFrame loadedFrame = this.frames.get(newFilename);
        if (loadedFrame != null) {
            loadedFrame.mainFrame.toFront();
        } else if (this.framesInProgress.containsKey(newFilename)) {
            logger.info("Still loading " + newFilename);
        } else {
            String filename = this.potentiallyMoveFileOutOfDangerousLocation(newFilename);
            logger.info("Initiating load of " + filename);
            File file = new File(filename);
            ReportSetLoader reportSetLoader = new ReportSetLoader(file, this.startup.getTaxonomyFuture(), this.startup.getIocTaxonomyFuture(), this.taxonomyMappings, this.checklists, this.namesPreferences, this.oneTimeUpgradeProcessor);
            this.startup.addProgress(reportSetLoader, 0.4);
            this.framesInProgress.put(filename, true);
            Future future = this.executor.submit((Callable)reportSetLoader);
            future.addListener(() -> this.lambda$startLoadingReportSet$1(filename, file, (ListenableFuture)future, onFailure), this.executor);
        }
    }

    private String potentiallyMoveFileOutOfDangerousLocation(String filename) {
        String newFile;
        File file = new File(filename);
        Optional<String> dangerousPath = this.fileDialogs.findDangerousPath(file);
        if (dangerousPath.isPresent() && this.alerts.showYesNo(null, Messages.Name.PICK_A_NEW_LOCATION, Messages.Name.SAVING_FILES_NOT_RECOMMENDED_FORMAT, dangerousPath.get()) == 0 && (newFile = this.moveFileToNewLocation(file)) != null) {
            return newFile;
        }
        if (this.fileDialogs.isInsideZipFile(file) && this.alerts.showYesNo(null, Messages.Name.PICK_A_NEW_LOCATION, Messages.Name.OPENING_FILES_IN_ZIP_WARNING, new Object[0]) == 0 && (newFile = this.moveFileToNewLocation(file)) != null) {
            return newFile;
        }
        return filename;
    }

    private String moveFileToNewLocation(File file) {
        File saveFile;
        while (true) {
            if ((saveFile = this.fileDialogs.saveFile(null, Messages.getMessage(Messages.Name.NEW_LOCATION), file.getName(), null, FilePreferences.FileType.SIGHTINGS)) == null) {
                return null;
            }
            try {
                if (!saveFile.exists() && !saveFile.createNewFile()) {
                    throw new IOException("Could not create new file");
                }
            }
            catch (IOException e) {
                FileDialogs.showFileSaveError(this.alerts, e, saveFile);
                continue;
            }
            try {
                Files.copy(file, saveFile);
            }
            catch (IOException e) {
                FileDialogs.showFileSaveError(this.alerts, e, saveFile);
                continue;
            }
            break;
        }
        return saveFile.getAbsolutePath();
    }

    public void displayLoadedReportSet(File file, ReportSet loadedReportSet) {
        LoadedFrame loadedFrame = this.frames.get(file.getAbsolutePath());
        if (loadedFrame != null) {
            loadedFrame.mainFrame.toFront();
        } else {
            this.onReportSetLoaded(file, Futures.immediateFuture(loadedReportSet), null);
        }
    }

    private void onReportSetLoaded(File file, Future<ReportSet> future, @Nullable Runnable onFailure) {
        ReportSet loadedReportSet;
        final String filename = file.getAbsolutePath();
        try {
            loadedReportSet = future.get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof VersionTooNewException) {
                String version = ((VersionTooNewException)e.getCause()).getVersion();
                this.alerts.showError(null, Messages.Name.USING_OLD_VERSION_TITLE, Messages.Name.USING_OLD_VERSION_FORMAT, HtmlResponseWriter.htmlEscape(file.getName()), HtmlResponseWriter.htmlEscape(version));
            } else if (e.getCause() instanceof UnsupportedTaxonomyException) {
                String version = ((UnsupportedTaxonomyException)e.getCause()).getVersion();
                this.alerts.showError(null, Messages.Name.USING_OLD_VERSION_TITLE, Messages.Name.USING_OLD_VERSION_FORMAT, HtmlResponseWriter.htmlEscape(file.getName()), HtmlResponseWriter.htmlEscape(version));
            } else if (e.getCause() instanceof FileNotFoundException) {
                this.alerts.showError(null, Messages.Name.IO_EXCEPTION_TITLE, Messages.Name.IO_EXCEPTION_FORMAT, HtmlResponseWriter.htmlEscape(file.getName()), HtmlResponseWriter.htmlEscape(file.getParentFile().getName()));
            } else {
                this.alerts.showError(null, (Throwable)e, Messages.Name.BAD_FILE_TITLE, Messages.Name.BAD_FILE_FORMAT, HtmlResponseWriter.htmlEscape(file.getName()));
            }
            logger.log(Level.WARNING, "Error loading report set", e);
            this.framesInProgress.remove(filename);
            if (onFailure != null) {
                onFailure.run();
            }
            return;
        }
        ImmutableSet<SightingTaxon> spsToResolve = ImmutableSet.of();
        ReportSet reportSet = loadedReportSet;
        this.upgraderProcessing.upgradeReportSet(reportSet);
        if (!reportSet.getLocations().restoredLocations().isEmpty()) {
            this.alerts.showError(null, Messages.Name.CORRUPTED_LOCATIONS_TITLE, Messages.Name.CORRUPTED_LOCATIONS_FORMAT, HtmlResponseWriter.htmlEscape(file.getName()), reportSet.getLocations().restoredLocations().size());
        }
        if (reportSet.getCompletedUpgrade() != null) {
            reportSet.markDirty();
            CompletedUpgrade completedUpgrade = reportSet.getCompletedUpgrade();
            Injector storeInjector = this.frameFactory.createOpenOrNewFrameInjector(this.globalInjector, this.startup);
            TaxonomyStore taxonomyStore = storeInjector.getInstance(TaxonomyStore.class);
            TaxonomyUpgradeNotice taxonomyUpgradeNotice = new TaxonomyUpgradeNotice(this.startup.getTaxonomy(), this.alerts, this.fontManager, taxonomyStore);
            if (completedUpgrade.getForcedTaxonomy() != null) {
                spsToResolve = ImmutableSet.copyOf(taxonomyUpgradeNotice.showNonClementsUpgrade(reportSet, file, completedUpgrade));
            } else {
                taxonomyStore.setTaxonomy(this.startup.getTaxonomy());
                spsToResolve = ImmutableSet.copyOf(taxonomyUpgradeNotice.showClementsUpgrade(reportSet, file, reportSet.getCompletedUpgrade(), this.backupSaver));
            }
            ImmutableSet<SightingTaxon> remainingTaxaAfterChecklistResolution = taxonomyUpgradeNotice.attemptChecklistResolution(reportSet, this.checklists, spsToResolve, completedUpgrade.getForcedTaxonomy() == taxonomyStore.getIoc());
            if (remainingTaxaAfterChecklistResolution != null) {
                spsToResolve = remainingTaxaAfterChecklistResolution;
            }
            reportSet.setSpsToResolve(spsToResolve, completedUpgrade.getForcedTaxonomy());
        }
        Injector frameInjector = this.frameFactory.createMainFrameInjector(this.globalInjector, this.startup, filename, reportSet);
        this.startup.finish();
        if (this.openOrNewFrame != null) {
            this.openOrNewFrame.dispose();
            this.openOrNewFrame = null;
        }
        boolean needToResolveTaxa = reportSet.getSpsToResolve() != null && !reportSet.getSpsToResolve().isEmpty();
        final MainFrame newFrame = MainFrame.start(frameInjector, needToResolveTaxa ? "resolveTaxa" : "main");
        Closeable backup = this.backupSaver.initiateBackup(reportSet, file);
        final LoadedFrame loadedFrame = new LoadedFrame(newFrame, reportSet, backup);
        this.frames.put(filename, loadedFrame);
        this.framesInProgress.remove(filename);
        LoadedFrame oldFrame = this.framesBeingReloaded.get(filename);
        if (oldFrame != null) {
            oldFrame.mainFrame.dispose();
        }
        this.filePreferences.setLastLoadedReportSets(this.frames.keySet());
        this.filePreferences.rememberFile(file, FilePreferences.FileType.SIGHTINGS);
        newFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                logger.info("Closed " + filename);
                try {
                    loadedFrame.backup.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Closing backup failed", e);
                }
                if (FrameRegistry.this.framesBeingReloaded.containsKey(filename) && FrameRegistry.this.framesBeingReloaded.get((Object)filename).mainFrame == newFrame) {
                    FrameRegistry.this.framesBeingReloaded.remove(filename);
                }
                if (FrameRegistry.this.frames.containsKey(filename) && FrameRegistry.this.frames.get((Object)filename).mainFrame == newFrame) {
                    FrameRegistry.this.frames.remove(filename);
                }
                if (FrameRegistry.this.frames.isEmpty() && FrameRegistry.this.framesBeingReloaded.isEmpty()) {
                    FrameRegistry.this.handleNoVisibleFrames();
                } else {
                    FrameRegistry.this.filePreferences.setLastLoadedReportSets(FrameRegistry.this.frames.keySet());
                }
            }
        });
        this.begForBackups.check(reportSet, file);
    }

    public boolean isEmpty() {
        return this.frames.isEmpty() && this.framesInProgress.isEmpty() && this.framesBeingReloaded.isEmpty();
    }

    public boolean saveBeforeQuitting() {
        for (LoadedFrame frame : ImmutableList.copyOf(this.frames.values())) {
            frame.mainFrame.toFront();
            if (!frame.mainFrame.saveBeforeClosing()) {
                return false;
            }
            frame.mainFrame.dispose();
        }
        return true;
    }

    public void showNoOtherWindowFrame() {
        Injector openOrNewInjector = this.frameFactory.createOpenOrNewFrameInjector(this.globalInjector, this.startup);
        this.openOrNewFrame = openOrNewInjector.getInstance(OpenOrNewListFrame.class);
        this.openOrNewFrame.start();
        this.openOrNewFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (FrameRegistry.this.isEmpty()) {
                    FrameRegistry.this.handleNoVisibleFrames();
                }
            }
        });
    }

    public Iterable<ReportSet> loadedReportSets() {
        return FluentIterable.from(this.frames.values()).transform(loadedFrame -> loadedFrame.reportSet);
    }

    private void handleNoVisibleFrames() {
        this.preferencesManager.save();
        System.exit(0);
    }

    public void reload(File reportSetFile, MainFrame mainFrame) {
        String fileName = reportSetFile.getAbsolutePath();
        LoadedFrame loadedFrame = Preconditions.checkNotNull(this.frames.remove(fileName));
        this.framesBeingReloaded.put(fileName, loadedFrame);
        mainFrame.setEnabled(false);
        this.startLoadingReportSet(fileName, () -> {
            logger.warning("Failed to reload " + fileName);
            mainFrame.setEnabled(true);
            this.frames.put(fileName, loadedFrame);
            this.framesBeingReloaded.remove(fileName);
        });
    }

    public boolean isLoaded(File reportSetFile) {
        String fileName = reportSetFile.getAbsolutePath();
        return this.frames.containsKey(fileName);
    }

    private /* synthetic */ void lambda$startLoadingReportSet$1(String filename, File file, ListenableFuture future, Runnable onFailure) {
        logger.info("Completed load of " + filename);
        EventQueue.invokeLater(() -> this.onReportSetLoaded(file, future, onFailure));
    }

    static class LoadedFrame {
        final MainFrame mainFrame;
        final ReportSet reportSet;
        final Closeable backup;

        LoadedFrame(MainFrame mainFrame, ReportSet reportSet, Closeable backup) {
            this.backup = backup;
            this.mainFrame = Preconditions.checkNotNull(mainFrame);
            this.reportSet = Preconditions.checkNotNull(reportSet);
        }
    }
}

