/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.app;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.app.Startup;
import com.scythebill.birdlist.ui.events.EventsModule;
import com.scythebill.birdlist.ui.guice.InitialRunWindowModule;
import com.scythebill.birdlist.ui.guice.PerWindowActionsModule;
import com.scythebill.birdlist.ui.guice.ReportSetModule;
import com.scythebill.birdlist.ui.panels.PanelsModule;

public abstract class FrameFactory {
    private static final String REPORT_FILE_KEY_NAME = "com.adamwiner.birdlist.ui.reportFile";

    public Injector createOpenOrNewFrameInjector(Injector globalInjector, Startup startup) {
        return globalInjector.createChildInjector(Iterables.concat(ImmutableList.of(new InitialRunWindowModule(), new EventsModule(), startup.constructedObjectsModule()), this.getCustomPerWindowModules()));
    }

    public Injector createMainFrameInjector(Injector globalInjector, Startup startup, final String reportSetFilename, final ReportSet reportSet) {
        return globalInjector.createChildInjector(Iterables.concat(this.getCustomPerWindowModules(), ImmutableList.of(new PerWindowActionsModule(), new ReportSetModule(), new PanelsModule(), new EventsModule(), new AbstractModule(){

            @Override
            protected void configure() {
                this.bindConstant().annotatedWith(Names.named(FrameFactory.REPORT_FILE_KEY_NAME)).to(reportSetFilename);
                this.bind(ReportSet.class).toInstance(reportSet);
            }
        }, startup.constructedObjectsModule())));
    }

    protected abstract Iterable<? extends Module> getCustomPerWindowModules();
}

