/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions.locationapi.google;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.ui.guice.GoogleApiKey;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;

@Singleton
public class GoogleStaticGeoImageLoader {
    private static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(10000).setSocketTimeout(10000).build();
    private static final Cache<RequestKey, BufferedImage> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.DAYS).build();
    private static final int MAX_WIDTH = 640;
    private static final int MAX_HEIGHT = 640;
    private final CloseableHttpClient httpClient;
    private final ListeningScheduledExecutorService executorService;
    private final String googleApiKey;

    @Inject
    public GoogleStaticGeoImageLoader(CloseableHttpClient httpClient, ListeningScheduledExecutorService executorService, @Nullable @GoogleApiKey String googleApiKey) {
        this.httpClient = httpClient;
        this.executorService = executorService;
        this.googleApiKey = googleApiKey;
    }

    public ListenableFuture<BufferedImage> asyncLoad(LatLongCoordinates coordinates, Dimension size, int zoomLevel) {
        final RequestKey requestKey = new RequestKey(coordinates, size, zoomLevel);
        BufferedImage ifPresent = cache.getIfPresent(requestKey);
        if (ifPresent != null) {
            return Futures.immediateFuture(ifPresent);
        }
        final AtomicReference<Future> reference = new AtomicReference<Future>();
        Future future = this.executorService.submit(new Callable<BufferedImage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BufferedImage call() throws Exception {
                this.checkCancelled();
                try (InputStream inputStream = GoogleStaticGeoImageLoader.this.load(requestKey);){
                    this.checkCancelled();
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    cache.put(requestKey, bufferedImage);
                    BufferedImage bufferedImage2 = bufferedImage;
                    return bufferedImage2;
                }
            }

            private void checkCancelled() throws Exception {
                ListenableFuture future = (ListenableFuture)reference.get();
                if (future != null && future.isCancelled()) {
                    throw new CancellationException();
                }
            }
        });
        reference.set(future);
        return future;
    }

    public Dimension allowedDimension(Dimension dimension) {
        return new Dimension(Math.min(dimension.width, 640), Math.min(dimension.height, 640));
    }

    private InputStream load(RequestKey requestKey) throws IOException {
        Object url = String.format("https://maps.googleapis.com/maps/api/staticmap?center=%s,%s&language=%s&size=%sx%s&zoom=%s&maptype=terrain&markers=color%%3ared%%7c%s,%s", requestKey.coordinates.latitudeAsCanonicalString(), requestKey.coordinates.longitudeAsCanonicalString(), Locale.getDefault().getLanguage(), requestKey.width, requestKey.height, requestKey.zoomLevel, requestKey.coordinates.latitudeAsCanonicalString(), requestKey.coordinates.longitudeAsCanonicalString());
        if (this.googleApiKey != null) {
            url = (String)url + "&key=" + this.googleApiKey;
        }
        try {
            HttpGet httpGet = new HttpGet((String)url);
            httpGet.setConfig(REQUEST_CONFIG);
            CloseableHttpResponse get = this.httpClient.execute(httpGet);
            HttpEntity entity = get.getEntity();
            return new BufferedInputStream(entity.getContent());
        }
        catch (ClientProtocolException e) {
            throw new IOException(e);
        }
    }

    static final class RequestKey {
        final LatLongCoordinates coordinates;
        final int width;
        final int height;
        final int zoomLevel;

        RequestKey(LatLongCoordinates coordinates, Dimension size, int zoomLevel) {
            this.coordinates = Preconditions.checkNotNull(coordinates);
            this.width = size.width;
            this.height = size.height;
            this.zoomLevel = zoomLevel;
        }

        public int hashCode() {
            int result = this.coordinates.hashCode();
            result = 31 * result + this.height;
            result = 31 * result + this.width;
            result = 31 * result + this.zoomLevel;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RequestKey)) {
                return false;
            }
            RequestKey that = (RequestKey)obj;
            return this.coordinates.equals(that.coordinates) && this.width == that.width && this.height == that.height && this.zoomLevel == that.zoomLevel;
        }
    }
}

