/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions.locationapi.google;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSets;
import com.scythebill.birdlist.model.taxa.TaxonomyImpl;
import com.scythebill.birdlist.ui.actions.locationapi.Geocoder;
import com.scythebill.birdlist.ui.actions.locationapi.GeocoderResults;
import com.scythebill.birdlist.ui.actions.locationapi.LocationApiPreferences;
import com.scythebill.birdlist.ui.actions.locationapi.ReverseGeocoder;
import com.scythebill.birdlist.ui.guice.GoogleApiKey;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class GoogleGeocoder
implements Geocoder,
ReverseGeocoder {
    private static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(10000).setSocketTimeout(10000).build();
    private static final Cache<URI, GoogleGeocodeResults> resultCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.DAYS).build();
    private final CloseableHttpClient httpClient;
    private final ListeningScheduledExecutorService executorService;
    private final Gson gson;
    private final PredefinedLocations predefinedLocations;
    private final LocationApiPreferences locationApiPreferences;
    private final String googleApiKey;
    private static final ImmutableSet<Location.Type> TYPES_TO_STOP_AT = ImmutableSet.of(Location.Type.city, Location.Type.town);
    private static final ImmutableSet<Location.Type> TYPES_TO_DROP_FROM_LOCATION = ImmutableSet.of(Location.Type.county, Location.Type.country);
    private static final ImmutableMap<String, String> INDONESIAN_PROVINCE_NAMES = ImmutableMap.builder().put("Special Region of Aceh", "Sumatera").put("Aceh", "Sumatera").put("Bali", "Nusa Tenggara").put("Bangka\u2013Belitung Islands", "Sumatera").put("Bangka Belitung Islands", "Sumatera").put("Banten", "Jawa").put("Bengkulu", "Sumatera").put("Central Java", "Jawa").put("Central Kalimantan", "Kalimantan").put("Central Sulawesi", "Sulawesi").put("East Java", "Jawa").put("East Kalimantan", "Kalimantan").put("East Nusa Tenggara", "Nusa Tenggara").put("Gorontalo", "Sulawesi").put("Jakarta Special Capital Region", "Jawa").put("Special Capital Region of Jakarta", "Jawa").put("Jambi", "Sumatera").put("Lampung", "Sumatera").put("Maluku", "Maluku").put("North Kalimantan", "Kalimantan").put("North Maluku", "Maluku").put("North Sulawesi", "Sulawesi").put("North Sumatra", "Sumatera").put("Papua", "Papua").put("Special Region of Papua", "Papua").put("Riau", "Sumatera").put("Riau Islands", "Sumatera").put("Southeast Sulawesi", "Sulawesi").put("South Kalimantan", "Kalimantan").put("South Sulawesi", "Sulawesi").put("South Sumatra", "Sumatera").put("West Java", "Jawa").put("West Kalimantan", "Kalimantan").put("West Nusa Tenggara", "Nusa Tenggara").put("Special Region of West Papua", "Papua").put("West Papua", "Papua").put("West Sulawesi", "Sulawesi").put("West Sumatra", "Sumatera").put("Special Region of Yogyakarta", "Jawa").put("Yogyakarta", "Jawa").build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CloseableHttpClient httpClient = HttpClients.custom().disableCookieManagement().setMaxConnPerRoute(3).setMaxConnTotal(20).setConnectionManager(new PoolingHttpClientConnectionManager()).build();
        ListeningScheduledExecutorService executorService = MoreExecutors.listeningDecorator(Executors.newScheduledThreadPool(3));
        try {
            Gson gson = new Gson();
            GoogleGeocoder geocoder = new GoogleGeocoder(httpClient, executorService, gson, PredefinedLocations.loadAndParse(), new LocationApiPreferences(), Resources.toString(Resources.getResource("googleapikey.txt"), StandardCharsets.UTF_8));
            LocationSet locations = ReportSets.newReportSet(new TaxonomyImpl()).getLocations();
            LatLongCoordinates latLong = LatLongCoordinates.withLatAndLong(-25.67602968, 28.95082986);
            ImmutableList results = (ImmutableList)geocoder.reverseGeocode(locations, latLong).get();
            System.err.println(Joiner.on('\n').join(results));
        }
        finally {
            executorService.shutdown();
        }
    }

    @Inject
    public GoogleGeocoder(CloseableHttpClient httpClient, ListeningScheduledExecutorService executorService, Gson gson, PredefinedLocations predefinedLocations, LocationApiPreferences locationApiPreferences, @Nullable @GoogleApiKey String googleApiKey) {
        this.httpClient = httpClient;
        this.executorService = executorService;
        this.gson = gson;
        this.predefinedLocations = predefinedLocations;
        this.locationApiPreferences = locationApiPreferences;
        this.googleApiKey = googleApiKey;
    }

    @Override
    public ListenableFuture<ImmutableList<GeocoderResults>> geocode(LocationSet locationSet, Location location) {
        URI uriWithAddress;
        URI uriWithoutAddress;
        if (!this.locationApiPreferences.enableGoogleApis) {
            return Futures.immediateFailedFuture(new UnsupportedOperationException("Google APIs disabled"));
        }
        try {
            URIBuilder uriBuilder = new URIBuilder("https://maps.googleapis.com/maps/api/geocode/json");
            if (this.googleApiKey != null) {
                uriBuilder.addParameter("key", this.googleApiKey);
            }
            LinkedHashMultimap<String, String> components = LinkedHashMultimap.create();
            this.buildComponents(location.getParent(), components);
            ArrayList<CallSite> parsedComponents = Lists.newArrayList();
            for (Map.Entry componentEntry : components.entries()) {
                parsedComponents.add((CallSite)((Object)((String)componentEntry.getKey() + ":" + (String)componentEntry.getValue())));
            }
            uriBuilder.addParameter("components", Joiner.on('|').join(parsedComponents));
            uriWithoutAddress = uriBuilder.build();
            String address = this.getAddress(location);
            uriBuilder.addParameter("address", address);
            uriWithAddress = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        GoogleGeocodeResults withAddressResults = resultCache.getIfPresent(uriWithAddress);
        GoogleGeocodeResults withoutAddressResults = resultCache.getIfPresent(uriWithoutAddress);
        if (withAddressResults != null && withoutAddressResults != null) {
            return Futures.immediateFuture(this.toGeocoderResults(locationSet, location, withAddressResults, withoutAddressResults));
        }
        ListenableFuture<GoogleGeocodeResults> withAddressFuture = withAddressResults == null ? this.fetchGeocodeResults(uriWithAddress) : Futures.immediateFuture(withAddressResults);
        ListenableFuture<GoogleGeocodeResults> withoutAddressFuture = withoutAddressResults == null ? this.fetchGeocodeResults(uriWithoutAddress) : Futures.immediateFuture(withoutAddressResults);
        return Futures.transform(Futures.allAsList(withAddressFuture, withoutAddressFuture), resultsList -> this.toGeocoderResults(locationSet, location, (GoogleGeocodeResults)resultsList.get(0), (GoogleGeocodeResults)resultsList.get(1)), this.executorService);
    }

    private ListenableFuture<GoogleGeocodeResults> fetchGeocodeResults(final URI uri) {
        Future future = this.executorService.submit(new Callable<GoogleGeocodeResults>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GoogleGeocodeResults call() throws Exception {
                if (Thread.interrupted()) {
                    throw new CancellationException("Thread was interrupted");
                }
                HttpGet httpGet = new HttpGet(uri);
                httpGet.setConfig(REQUEST_CONFIG);
                CloseableHttpResponse get = GoogleGeocoder.this.httpClient.execute(httpGet);
                HttpEntity entity = get.getEntity();
                try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(entity.getContent()), StandardCharsets.UTF_8);){
                    GoogleGeocodeResults googleGeocodeResults = GoogleGeocoder.this.gson.fromJson((Reader)reader, GoogleGeocodeResults.class);
                    return googleGeocodeResults;
                }
            }
        });
        Futures.addCallback(future, new FutureCallback<GoogleGeocodeResults>(){

            @Override
            public void onFailure(Throwable t) {
            }

            @Override
            public void onSuccess(GoogleGeocodeResults results) {
                resultCache.put(uri, results);
            }
        }, this.executorService);
        return future;
    }

    @Override
    public ListenableFuture<ImmutableList<GeocoderResults>> reverseGeocode(LocationSet locationSet, LatLongCoordinates latLong) {
        URI uri;
        if (!this.locationApiPreferences.enableGoogleApis) {
            return Futures.immediateFailedFuture(new UnsupportedOperationException("Google APIs disabled"));
        }
        try {
            URIBuilder uriBuilder = new URIBuilder("https://maps.googleapis.com/maps/api/geocode/json");
            if (this.googleApiKey != null) {
                uriBuilder.addParameter("key", this.googleApiKey);
            }
            uriBuilder.addParameter("latlng", String.format("%s,%s", latLong.latitudeAsCanonicalString(), latLong.longitudeAsCanonicalString()));
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        GoogleGeocodeResults ifPresent = resultCache.getIfPresent(uri);
        if (ifPresent != null) {
            return Futures.immediateFuture(this.toReverseGeocoderResults(locationSet, latLong, ifPresent));
        }
        ListenableFuture<GoogleGeocodeResults> future = this.fetchReverseGeocodeResults(uri);
        return Futures.transform(future, results -> this.toReverseGeocoderResults(locationSet, latLong, (GoogleGeocodeResults)results), this.executorService);
    }

    private ListenableFuture<GoogleGeocodeResults> fetchReverseGeocodeResults(final URI uri) {
        Future future = this.executorService.submit(new Callable<GoogleGeocodeResults>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GoogleGeocodeResults call() throws Exception {
                if (Thread.interrupted()) {
                    throw new CancellationException("Thread was interrupted");
                }
                HttpGet httpGet = new HttpGet(uri);
                httpGet.setConfig(REQUEST_CONFIG);
                CloseableHttpResponse get = GoogleGeocoder.this.httpClient.execute(httpGet);
                HttpEntity entity = get.getEntity();
                try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(entity.getContent()), StandardCharsets.UTF_8);){
                    GoogleGeocodeResults googleGeocodeResults = GoogleGeocoder.this.gson.fromJson((Reader)reader, GoogleGeocodeResults.class);
                    return googleGeocodeResults;
                }
            }
        });
        Futures.addCallback(future, new FutureCallback<GoogleGeocodeResults>(){

            @Override
            public void onFailure(Throwable t) {
            }

            @Override
            public void onSuccess(GoogleGeocodeResults results) {
                resultCache.put(uri, results);
            }
        }, this.executorService);
        return future;
    }

    private ImmutableList<GeocoderResults> toGeocoderResults(LocationSet locationSet, Location location, GoogleGeocodeResults results, GoogleGeocodeResults withoutAddressResults) {
        if (results.results.isEmpty()) {
            return ImmutableList.of();
        }
        GoogleGeocodeResult firstResult = results.results.get(0);
        if (firstResult.geometry != null && "APPROXIMATE".equalsIgnoreCase(firstResult.geometry.location_type) && (withoutAddressResults.results.isEmpty() || withoutAddressResults.results.get((int)0).geometry == null || firstResult.geometry == null || Objects.equals(firstResult.geometry.bounds, withoutAddressResults.results.get((int)0).geometry.bounds))) {
            return ImmutableList.of();
        }
        if (firstResult.geometry != null && firstResult.geometry.location != null) {
            String lat = firstResult.geometry.location.lat;
            String lng = firstResult.geometry.location.lng;
            if (!Strings.isNullOrEmpty(lat) && !Strings.isNullOrEmpty(lng)) {
                GeocodeComponent state = firstResult.findAddressComponent("administrative_area_level_1");
                GeocodeComponent county = firstResult.findAddressComponent("administrative_area_level_2");
                Location preferredParent = this.findPreferredParent(locationSet, location, state, county);
                return ImmutableList.of(new GeocoderResults(GeocoderResults.Source.GOOGLE, location.getDisplayName(), LatLongCoordinates.withLatAndLong(lat, lng), preferredParent));
            }
        }
        return ImmutableList.of();
    }

    private ImmutableList<GeocoderResults> toReverseGeocoderResults(LocationSet locationSet, final LatLongCoordinates latLong, GoogleGeocodeResults results) {
        if (results.results.isEmpty()) {
            return ImmutableList.of();
        }
        Ordering<GeocoderResults> ordering = new Ordering<GeocoderResults>(){

            @Override
            public int compare(GeocoderResults left, GeocoderResults right) {
                double rightDistance;
                double leftDistance = left.coordinates().kmDistance(latLong);
                if (leftDistance == (rightDistance = right.coordinates().kmDistance(latLong))) {
                    return 0;
                }
                if (leftDistance < rightDistance) {
                    return -1;
                }
                return 1;
            }
        };
        ImmutableSortedSet.Builder<GeocoderResults> builder = ImmutableSortedSet.orderedBy(ordering);
        for (GoogleGeocodeResult result : results.results) {
            boolean allowCounty;
            String name;
            GeocodeComponent county;
            GeocodeComponent state;
            GeocodeComponent country = result.findAddressComponent("country");
            Location parent = this.findPreferredParent(locationSet, country, state = result.findAddressComponent("administrative_area_level_1"), county = result.findAddressComponent("administrative_area_level_2"));
            if (parent == null || (name = result.extractLocationName(allowCounty = Locations.getAncestorOfType(parent, Location.Type.county) == null)).isEmpty()) continue;
            String lat = result.geometry.location.lat;
            String lng = result.geometry.location.lng;
            builder.add((Object)new GeocoderResults(GeocoderResults.Source.GOOGLE, name, LatLongCoordinates.withLatAndLong(lat, lng), parent));
        }
        ArrayList list = Lists.newArrayList(builder.build());
        for (int i = list.size() - 1; i > 0; --i) {
            Location previousPreferredParent;
            Location lastPreferredParent;
            GeocoderResults last = (GeocoderResults)list.get(i);
            GeocoderResults previous = (GeocoderResults)list.get(i);
            if (!last.name().isEmpty() || Locations.getCommonAncestor(lastPreferredParent = last.preferredParent().get(), previousPreferredParent = previous.preferredParent().get()) != lastPreferredParent) continue;
            list.remove(i);
        }
        return ImmutableList.copyOf(list);
    }

    private String getAddress(Location location) {
        Object name = location.getModelName();
        for (Location parent = location.getParent(); parent != null && !TYPES_TO_DROP_FROM_LOCATION.contains((Object)parent.getType()) && !TYPES_TO_STOP_AT.contains((Object)location.getType()); parent = parent.getParent()) {
            name = (String)name + ", " + parent.getModelName();
        }
        return name;
    }

    private void buildComponents(Location location, Multimap<String, String> components) {
        if (location == null) {
            return;
        }
        if (location.getType() != null) {
            switch (location.getType()) {
                case county: {
                    components.put("administrative_area", location.getModelName());
                    break;
                }
                case state: {
                    if (location.getEbirdCode() != null && location.getEbirdCode().startsWith("ID-")) break;
                    components.put("administrative_area", location.getModelName());
                    break;
                }
                case country: {
                    String locationCode = Locations.getLocationCode(location);
                    if (locationCode != null) {
                        if (!"XX".equals(locationCode)) {
                            if (locationCode.indexOf(45) > 0) {
                                locationCode = locationCode.substring(0, locationCode.indexOf(45));
                            }
                            components.put("country", locationCode);
                        }
                    } else {
                        components.put("country", location.getModelName());
                    }
                    return;
                }
            }
        }
        this.buildComponents(location.getParent(), components);
    }

    private Location findPreferredParent(LocationSet locationSet, Location location, GeocodeComponent state, GeocodeComponent county) {
        String countyName;
        Location child;
        Location currentParent = this.getFirstParentWithCode(location);
        if (currentParent == null || currentParent != location.getParent()) {
            return null;
        }
        if (currentParent.getType() == Location.Type.country && state != null && state.long_name != null) {
            String stateName = state.long_name;
            if ("ID".equals(currentParent.getEbirdCode()) && INDONESIAN_PROVINCE_NAMES.containsKey(stateName)) {
                stateName = INDONESIAN_PROVINCE_NAMES.get(stateName);
            }
            if ((child = this.findPredefinedChild(locationSet, currentParent, stateName)) != null) {
                currentParent = child;
            }
        }
        if (currentParent.getType() != Location.Type.county && county != null && county.long_name != null && (child = this.findPredefinedChild(locationSet, currentParent, countyName = county.long_name)) != null) {
            currentParent = child;
        }
        return currentParent;
    }

    private Location findPreferredParent(LocationSet locationSet, GeocodeComponent countryComponent, GeocodeComponent state, GeocodeComponent county) {
        String countyName;
        Location child;
        Object stateByCode;
        if (countryComponent == null || countryComponent.short_name == null) {
            return null;
        }
        Collection<Location> allCountries = locationSet.getLocationsByCode(countryComponent.short_name);
        if (allCountries.isEmpty()) {
            return null;
        }
        Object currentParent = null;
        String stateCode = null;
        if (state != null && state.short_name != null && (stateByCode = locationSet.getLocationByCode(stateCode = countryComponent.short_name + "-" + state.short_name)) != null) {
            currentParent = stateByCode;
        }
        if (currentParent == null) {
            for (Location country : allCountries) {
                PredefinedLocations.PredefinedLocation childByCode;
                if (country.getType() != Location.Type.country || state == null || state.long_name == null) continue;
                String stateName = state.long_name;
                if ("ID".equals(country.getEbirdCode()) && INDONESIAN_PROVINCE_NAMES.containsKey(stateName)) {
                    stateName = INDONESIAN_PROVINCE_NAMES.get(stateName);
                }
                if (stateCode != null && (childByCode = this.predefinedLocations.getPredefinedLocationChildByCode(country, stateCode)) != null) {
                    currentParent = childByCode.create(locationSet, country);
                    break;
                }
                Location child2 = this.findPredefinedChild(locationSet, country, stateName);
                if (child2 == null) continue;
                currentParent = child2;
                break;
            }
        }
        if (currentParent == null) {
            currentParent = allCountries.iterator().next();
        }
        if (((Location)currentParent).getType() != Location.Type.county && county != null && county.long_name != null && (child = this.findPredefinedChild(locationSet, (Location)currentParent, countyName = county.long_name)) != null) {
            currentParent = child;
        }
        return currentParent;
    }

    private Location findPredefinedChild(LocationSet locationSet, Location parent, String name) {
        Location content = parent.getContent(name);
        if (content != null && content.isBuiltInLocation()) {
            return content;
        }
        Location predefinedLocation = this.predefinedLocations.createPredefinedLocationChildRecursively(locationSet, parent, name);
        if (predefinedLocation != null) {
            return predefinedLocation;
        }
        int lastSpace = name.lastIndexOf(32);
        if (lastSpace > 0) {
            return this.findPredefinedChild(locationSet, parent, name.substring(0, lastSpace));
        }
        return null;
    }

    private Location getFirstParentWithCode(Location location) {
        while (location != null && location.getEbirdCode() == null) {
            location = location.getParent();
        }
        return location;
    }

    static class GoogleGeocodeResults {
        String status;
        List<GoogleGeocodeResult> results;

        GoogleGeocodeResults() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("status", this.status).add("results", this.results).omitNullValues().toString();
        }
    }

    static class GoogleGeocodeResult {
        String formatted_address;
        List<GeocodeComponent> address_components;
        GeocodeGeometry geometry;
        private static final ImmutableSet<String> EXCLUDED_ADDRESS_COMPONENT_TYPES = ImmutableSet.of("street_number");
        private static final ImmutableSet<String> TERMINATING_ADDRESS_COMPONENT_TYPES = ImmutableSet.of("administrative_area_level_2", "administrative_area_level_1", "country");
        private static final ImmutableSet<String> TERMINATING_ADDRESS_COMPONENT_TYPES_ALLOWING_COUNTY = ImmutableSet.of("administrative_area_level_1", "country");

        GoogleGeocodeResult() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("formatted_address", this.formatted_address).add("address_components", this.address_components).add("geometry", this.geometry).omitNullValues().toString();
        }

        public GeocodeComponent findAddressComponent(String type) {
            for (GeocodeComponent addressComponent : this.address_components) {
                if (!addressComponent.types.contains(type)) continue;
                return addressComponent;
            }
            return null;
        }

        public String extractLocationName(boolean allowingCounty) {
            ArrayList<String> components = Lists.newArrayList();
            for (GeocodeComponent addressComponent : this.address_components) {
                if (!Sets.intersection(addressComponent.types, EXCLUDED_ADDRESS_COMPONENT_TYPES).isEmpty()) continue;
                if (!Sets.intersection(addressComponent.types, allowingCounty ? TERMINATING_ADDRESS_COMPONENT_TYPES_ALLOWING_COUNTY : TERMINATING_ADDRESS_COMPONENT_TYPES).isEmpty()) break;
                components.add(addressComponent.long_name);
                allowingCounty = false;
            }
            return Joiner.on(' ').join(components);
        }
    }

    static class GeocodeGeometry {
        GeocodeBounds bounds;
        GeocodeLocation location;
        String location_type;

        GeocodeGeometry() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("location", this.location).add("location_type", this.location_type).add("bounds", this.bounds).omitNullValues().toString();
        }
    }

    static class GeocodeBounds {
        GeocodeLocation northeast;
        GeocodeLocation southwest;

        GeocodeBounds() {
        }

        public String toString() {
            return String.format("{northwest: %s, southeast: %s}", this.northeast, this.southwest);
        }

        public int hashCode() {
            return Objects.hash(this.northeast, this.southwest);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GeocodeBounds)) {
                return false;
            }
            GeocodeBounds other = (GeocodeBounds)obj;
            return Objects.equals(this.northeast, other.northeast) && Objects.equals(this.southwest, other.southwest);
        }
    }

    static class GeocodeLocation {
        String lat;
        String lng;

        GeocodeLocation() {
        }

        public String toString() {
            return String.format("{lat: %s, lng: %s}", this.lat, this.lng);
        }

        public int hashCode() {
            return Objects.hash(this.lat, this.lng);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GeocodeLocation)) {
                return false;
            }
            GeocodeLocation other = (GeocodeLocation)obj;
            return Objects.equals(this.lat, other.lat) && Objects.equals(this.lng, other.lng);
        }
    }

    static class GeocodeComponent {
        String long_name;
        String short_name;
        Set<String> types;

        GeocodeComponent() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("long_name", this.long_name).add("short_name", this.short_name).add("types", this.types).omitNullValues().toString();
        }
    }
}

