/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions.locationapi.ebird;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSets;
import com.scythebill.birdlist.model.taxa.TaxonomyImpl;
import com.scythebill.birdlist.ui.actions.locationapi.Geocoder;
import com.scythebill.birdlist.ui.actions.locationapi.GeocoderResults;
import com.scythebill.birdlist.ui.actions.locationapi.LocationApiPreferences;
import com.scythebill.birdlist.ui.actions.locationapi.ReverseGeocoder;
import com.scythebill.birdlist.ui.guice.EBirdApiKey;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.SequencedCollection;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

@Singleton
public class EBirdGeocoder
implements Geocoder,
ReverseGeocoder {
    private static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(30000).setSocketTimeout(30000).build();
    private static final Logger logger = Logger.getLogger(EBirdGeocoder.class.getName());
    private final Cache<URI, Optional<EBirdHotspots>> resultCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final LoadingCache<URI, ListenableFuture<EBirdHotspots>> loadingCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(1L, TimeUnit.MINUTES).build(new CacheLoader<URI, ListenableFuture<EBirdHotspots>>(){

        @Override
        public ListenableFuture<EBirdHotspots> load(URI uri) throws Exception {
            return EBirdGeocoder.this.loadHotspots(uri);
        }
    });
    private final CloseableHttpClient httpClient;
    private final ListeningScheduledExecutorService executorService;
    private final PredefinedLocations predefinedLocations;
    private final LocationApiPreferences locationApiPreferences;
    private static final ImmutableSet<String> LOCATIONS_WITH_TOO_MANY_EBIRD_ENTRIES = ImmutableSet.of("US");
    private static final int MAX_REVERSE_GEOCODE_RESULTS = 20;
    private String eBirdApikey;
    private static final CharMatcher REMOVE_FROM_NORMALIZER = CharMatcher.anyOf(".'\u02bb");
    private static final CharMatcher TREAT_AS_WHITESPACE = CharMatcher.whitespace().or(CharMatcher.anyOf("-"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CloseableHttpClient httpClient = HttpClients.custom().disableCookieManagement().setMaxConnPerRoute(3).setMaxConnTotal(20).setConnectionManager(new PoolingHttpClientConnectionManager()).build();
        ListeningScheduledExecutorService executorService = MoreExecutors.listeningDecorator(Executors.newScheduledThreadPool(3));
        try {
            Gson gson = new Gson();
            EBirdGeocoder geocoder = new EBirdGeocoder(httpClient, executorService, gson, PredefinedLocations.loadAndParse(), new LocationApiPreferences(), "");
            LocationSet locations = ReportSets.newReportSet(new TaxonomyImpl()).getLocations();
            ImmutableList results = (ImmutableList)geocoder.reverseGeocode(locations, LatLongCoordinates.withLatAndLong(-25.685979, -54.44107)).get();
            System.err.println(Joiner.on("\n").join(results));
        }
        finally {
            executorService.shutdown();
        }
    }

    @Inject
    public EBirdGeocoder(CloseableHttpClient httpClient, ListeningScheduledExecutorService executorService, Gson gson, PredefinedLocations predefinedLocations, LocationApiPreferences locationApiPreferences, @EBirdApiKey String eBirdApikey) {
        this.httpClient = httpClient;
        this.executorService = executorService;
        this.predefinedLocations = predefinedLocations;
        this.locationApiPreferences = locationApiPreferences;
        this.eBirdApikey = eBirdApikey;
    }

    @Override
    public ListenableFuture<ImmutableList<GeocoderResults>> geocode(LocationSet locationSet, Location location) {
        URI uri;
        if (!this.locationApiPreferences.enableEBirdApis) {
            return Futures.immediateFailedFuture(new UnsupportedOperationException("EBird APIs disabled"));
        }
        try {
            URIBuilder uriBuilder = new URIBuilder("http://ebird.org/ws2.0/ref/hotspot/region");
            Location locationWithCode = this.getFirstParentWithCode(location);
            if (locationWithCode == location || locationWithCode == null) {
                return Futures.immediateFuture(ImmutableList.of());
            }
            if (LOCATIONS_WITH_TOO_MANY_EBIRD_ENTRIES.contains(Locations.getLocationCode(locationWithCode))) {
                return Futures.immediateFuture(ImmutableList.of());
            }
            uriBuilder.addParameter("r", Locations.getLocationCode(locationWithCode));
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Optional<EBirdHotspots> ifPresent = this.resultCache.getIfPresent(uri);
        if (ifPresent != null) {
            if (ifPresent.isPresent()) {
                return Futures.immediateFuture(this.findGeocodedResults(locationSet, location, ifPresent.get()));
            }
            return Futures.immediateFuture(ImmutableList.of());
        }
        try {
            ListenableFuture<EBirdHotspots> loadingFuture = this.loadingCache.get(uri);
            return Futures.transform(loadingFuture, hotspots -> this.findGeocodedResults(locationSet, location, (EBirdHotspots)hotspots), this.executorService);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ListenableFuture<ImmutableList<GeocoderResults>> reverseGeocode(LocationSet locationSet, LatLongCoordinates latLong) {
        double roundedLat = (double)((int)(latLong.latitudeAsDouble() * 10.0)) / 10.0;
        double roundedLong = (double)((int)(latLong.longitudeAsDouble() * 10.0)) / 10.0;
        return this.reverseGeocode(locationSet, latLong, LatLongCoordinates.withLatAndLong(roundedLat, roundedLong), 25);
    }

    public ListenableFuture<ImmutableList<GeocoderResults>> reverseGeocode(LocationSet locationSet, LatLongCoordinates latLong, LatLongCoordinates searchCenter, int maxSearchKilometers) {
        URI uri;
        if (!this.locationApiPreferences.enableEBirdApis) {
            return Futures.immediateFailedFuture(new UnsupportedOperationException("EBird APIs disabled"));
        }
        try {
            URIBuilder uriBuilder = new URIBuilder("http://ebird.org/ws2.0/ref/hotspot/geo");
            uriBuilder.addParameter("lat", String.format(Locale.US, "%3.2f", searchCenter.latitudeAsDouble()));
            uriBuilder.addParameter("lng", String.format(Locale.US, "%3.2f", searchCenter.longitudeAsDouble()));
            uriBuilder.addParameter("dist", Integer.toString(maxSearchKilometers));
            uriBuilder.addParameter("fmt", "csv");
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Optional<EBirdHotspots> ifPresent = this.resultCache.getIfPresent(uri);
        if (ifPresent != null) {
            if (ifPresent.isPresent()) {
                return Futures.immediateFuture(this.findReverseGeocodedResults(locationSet, latLong, ifPresent.get()));
            }
            return Futures.immediateFuture(ImmutableList.of());
        }
        try {
            ListenableFuture<EBirdHotspots> loadingFuture = this.loadingCache.get(uri);
            return Futures.transform(loadingFuture, hotspots -> this.findReverseGeocodedResults(locationSet, latLong, (EBirdHotspots)hotspots), this.executorService);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private ListenableFuture<EBirdHotspots> loadHotspots(final URI uri) {
        Future future = this.executorService.submit(new Callable<EBirdHotspots>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EBirdHotspots call() throws Exception {
                if (Thread.interrupted()) {
                    throw new CancellationException("Thread was interrupted");
                }
                HttpGet httpGet = new HttpGet(uri);
                httpGet.setConfig(REQUEST_CONFIG);
                httpGet.addHeader("X-eBirdApiToken", EBirdGeocoder.this.eBirdApikey);
                CloseableHttpResponse get = EBirdGeocoder.this.httpClient.execute(httpGet);
                HttpEntity entity = get.getEntity();
                EBirdHotspots eBirdHotspots = new EBirdHotspots();
                try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(entity.getContent()), StandardCharsets.UTF_8);){
                    String[] line;
                    ImportLines importLines = CsvImportLines.fromReader(reader);
                    while ((line = importLines.nextLine()) != null) {
                        eBirdHotspots.hotspots.add(new EBirdHotspot(line));
                        if (!Thread.interrupted()) continue;
                        throw new CancellationException("Thread was interrupted");
                    }
                }
                return eBirdHotspots;
            }
        });
        Futures.addCallback(future, new FutureCallback<EBirdHotspots>(){

            @Override
            public void onFailure(Throwable t) {
            }

            @Override
            public void onSuccess(EBirdHotspots results) {
                EBirdGeocoder.this.resultCache.put(uri, Optional.fromNullable(results));
            }
        }, this.executorService);
        return future;
    }

    private ImmutableList<GeocoderResults> findGeocodedResults(LocationSet locationSet, Location location, EBirdHotspots hotspots) {
        if (hotspots == null) {
            return ImmutableList.of();
        }
        ImmutableList<EBirdHotspot> hotspotList = hotspots.findByName(location.getModelName());
        if (hotspotList.isEmpty()) {
            return ImmutableList.of();
        }
        return FluentIterable.from(hotspotList).transform(hotspot -> new GeocoderResults(GeocoderResults.Source.EBIRD, hotspot.name, hotspot.coordinates, this.findPreferredParent(locationSet, location, (EBirdHotspot)hotspot))).toList();
    }

    private ImmutableList<GeocoderResults> findReverseGeocodedResults(LocationSet locationSet, LatLongCoordinates coordinates, EBirdHotspots hotspots) {
        ImmutableCollection<EBirdHotspot> hotspotList = hotspots.findByDistance(coordinates, 20);
        if (hotspotList.isEmpty()) {
            return ImmutableList.of();
        }
        return FluentIterable.from(hotspotList).transform(hotspot -> new GeocoderResults(GeocoderResults.Source.EBIRD, hotspot.name, hotspot.coordinates, this.findPreferredParentWithoutLocation(locationSet, (EBirdHotspot)hotspot))).toList();
    }

    private Location findPreferredParent(LocationSet locationSet, Location location, EBirdHotspot hotspot) {
        Location child;
        Location currentParent = this.getFirstParentWithCode(location);
        if (currentParent == null || currentParent != location.getParent()) {
            return null;
        }
        if (currentParent.getType() == Location.Type.country && !Strings.isNullOrEmpty(hotspot.state) && (child = this.findChild(locationSet, currentParent, hotspot.state)) != null) {
            currentParent = child;
        }
        if (currentParent.getType() != Location.Type.county && !Strings.isNullOrEmpty(hotspot.county) && (child = this.findChild(locationSet, currentParent, hotspot.county)) != null) {
            currentParent = child;
        }
        return currentParent;
    }

    private Location findPreferredParentWithoutLocation(LocationSet locationSet, EBirdHotspot hotspot) {
        Location child;
        Location existingState;
        Location existingCounty;
        if (!Strings.isNullOrEmpty(hotspot.county) && (existingCounty = locationSet.getLocationByCode(hotspot.county)) != null) {
            return existingCounty;
        }
        Location currentParent = null;
        if (!Strings.isNullOrEmpty(hotspot.state) && (existingState = locationSet.getLocationByCode(hotspot.state)) != null) {
            currentParent = existingState;
        }
        if (currentParent == null) {
            Collection<Location> allCountries = locationSet.getLocationsByCode(hotspot.country);
            if (allCountries.isEmpty()) {
                return null;
            }
            for (Location country : allCountries) {
                Location child2;
                if (country.getType() != Location.Type.country || Strings.isNullOrEmpty(hotspot.state) || (child2 = this.findChild(locationSet, country, hotspot.state)) == null) continue;
                currentParent = child2;
                break;
            }
            if (currentParent == null) {
                currentParent = allCountries.iterator().next();
            }
        }
        if (currentParent.getType() != Location.Type.county && !Strings.isNullOrEmpty(hotspot.county) && (child = this.findChild(locationSet, currentParent, hotspot.county)) != null) {
            currentParent = child;
        }
        return currentParent;
    }

    private Location findChild(LocationSet locationSet, Location parent, String code) {
        PredefinedLocations.PredefinedLocation predefinedLocation = this.predefinedLocations.getPredefinedLocationChildByCode(parent, code);
        if (predefinedLocation != null) {
            return predefinedLocation.create(locationSet, parent);
        }
        return null;
    }

    private Location getFirstParentWithCode(Location location) {
        while (location != null && location.getEbirdCode() == null) {
            location = location.getParent();
        }
        return location;
    }

    private static String removeParentheses(String name) {
        int firstParenthesis;
        while ((firstParenthesis = ((String)name).indexOf(40)) >= 0) {
            int lastParenthesis = ((String)name).indexOf(41, firstParenthesis);
            name = lastParenthesis < 0 ? ((String)name).substring(0, firstParenthesis) : ((String)name).substring(0, firstParenthesis) + ((String)name).substring(lastParenthesis + 1);
            name = CharMatcher.whitespace().trimFrom((CharSequence)name);
        }
        return name;
    }

    private static String normalizeName(String name) {
        String normalized = StringUtils.stripAccents(name).toLowerCase();
        normalized = REMOVE_FROM_NORMALIZER.removeFrom(normalized);
        normalized = TREAT_AS_WHITESPACE.trimAndCollapseFrom(normalized, ' ');
        normalized = normalized.replace("road", "rd");
        normalized = normalized.replace("mountain", "mt");
        normalized = normalized.replace("mount", "mt");
        normalized = normalized.replace("saint", "st");
        return normalized;
    }

    private static boolean endsWith(String normalizedName, String normalized) {
        if (!normalizedName.endsWith(normalized)) {
            return false;
        }
        if (normalizedName.length() == normalized.length()) {
            return true;
        }
        int precedingCharacter = normalizedName.length() - normalized.length() - 1;
        return TREAT_AS_WHITESPACE.matches(normalizedName.charAt(precedingCharacter));
    }

    private static boolean startsWith(String normalizedName, String normalized) {
        if (!normalizedName.startsWith(normalized)) {
            return false;
        }
        if (normalizedName.length() == normalized.length()) {
            return true;
        }
        return TREAT_AS_WHITESPACE.matches(normalizedName.charAt(normalized.length()));
    }

    static class EBirdHotspots {
        final List<EBirdHotspot> hotspots = new ArrayList<EBirdHotspot>();

        EBirdHotspots() {
        }

        ImmutableList<EBirdHotspot> findByName(String name) {
            String normalized = EBirdGeocoder.normalizeName(name);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (EBirdHotspot hotspot : this.hotspots) {
                if (normalized.equals(hotspot.normalizedName) || normalized.equals(hotspot.alternateNormalizedName)) {
                    return ImmutableList.of(hotspot);
                }
                if (EBirdGeocoder.startsWith(hotspot.normalizedName, normalized) || EBirdGeocoder.endsWith(hotspot.normalizedName, normalized)) {
                    builder.add(hotspot);
                    continue;
                }
                if (hotspot.alternateNormalizedName == null || !EBirdGeocoder.startsWith(hotspot.alternateNormalizedName, normalized) && !EBirdGeocoder.endsWith(hotspot.alternateNormalizedName, normalized)) continue;
                builder.add(hotspot);
            }
            return builder.build();
        }

        public ImmutableCollection<EBirdHotspot> findByDistance(final LatLongCoordinates coordinates, int maxResults) {
            Ordering<EBirdHotspot> ordering = new Ordering<EBirdHotspot>(){

                @Override
                public int compare(EBirdHotspot left, EBirdHotspot right) {
                    double rightDistance;
                    double leftDistance = coordinates.kmDistance(left.coordinates);
                    if (leftDistance == (rightDistance = coordinates.kmDistance(right.coordinates))) {
                        return 0;
                    }
                    if (leftDistance < rightDistance) {
                        return -1;
                    }
                    return 1;
                }
            };
            SequencedCollection<EBirdHotspot> sortedResults = ImmutableSortedSet.copyOf(ordering, this.hotspots);
            if (sortedResults.size() > maxResults) {
                sortedResults = ImmutableList.copyOf(sortedResults).subList(0, maxResults);
            }
            return sortedResults;
        }
    }

    static class EBirdHotspot {
        final String locationId;
        final String country;
        final String state;
        final String county;
        final LatLongCoordinates coordinates;
        final String name;
        final String normalizedName;
        final String alternateNormalizedName;

        EBirdHotspot(String[] line) {
            this.locationId = line[0];
            this.country = line[1];
            this.state = line[2];
            this.county = line[3];
            this.coordinates = LatLongCoordinates.withLatAndLong(line[4], line[5]);
            this.name = line[6];
            this.normalizedName = EBirdGeocoder.normalizeName(this.name);
            this.alternateNormalizedName = EBirdGeocoder.removeParentheses(this.normalizedName);
        }
    }
}

